/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.common;

import org.jsoup.Jsoup;
import org.jsoup.internal.StringUtil;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.NodeTraversor;
import org.jsoup.select.NodeVisitor;

public final class HtmlHelper {
    public static String getHtmlFromPlainText(String text) {
        return "<html><body>" + text.replace("\n", "<br/>\n") + "</body></html>";
    }

    public static String strip(String html) {
        if (html == null) {
            return null;
        }
        String result = html;
        int htmlIndex = result.indexOf("<HTML>");
        if (htmlIndex == -1) {
            htmlIndex = result.indexOf("<html>");
        }
        result = htmlIndex == -1 ? HtmlHelper.getPlainTextFromBodyFragment(result) : HtmlHelper.getPlainTextFromHtml(result.substring(htmlIndex));
        if ((result = result.replaceAll("(^\\h*)|(\\h*$)", "").trim()).isEmpty()) {
            result = null;
        }
        return result;
    }

    public static String getPlainTextFromHtml(String html) {
        return HtmlHelper.getPlainText(Jsoup.parse((String)html));
    }

    public static String getPlainTextFromBodyFragment(String body) {
        return HtmlHelper.getPlainText(Jsoup.parseBodyFragment((String)body));
    }

    private static String getPlainText(Document document) {
        FormattingVisitor formatter = new FormattingVisitor();
        NodeTraversor.traverse((NodeVisitor)formatter, (Node)document);
        return formatter.toString();
    }

    private static class FormattingVisitor
    implements NodeVisitor {
        private final StringBuilder m_buffer = new StringBuilder();

        public void head(Node node, int depth) {
            String name = node.nodeName();
            if (node instanceof TextNode) {
                this.append(((TextNode)node).text());
            } else if (name.equals("li")) {
                this.append("\n * ");
            } else if (name.equals("dt")) {
                this.append("  ");
            } else if (StringUtil.in((String)name, (String[])new String[]{"p", "h1", "h2", "h3", "h4", "h5", "tr"})) {
                this.append("\n");
            }
        }

        public void tail(Node node, int depth) {
            String name = node.nodeName();
            if (StringUtil.in((String)name, (String[])new String[]{"br", "dd", "dt", "p", "h1", "h2", "h3", "h4", "h5"})) {
                this.append("\n");
            } else if (name.equals("a")) {
                this.append(String.format(" <%s>", node.absUrl("href")));
            }
        }

        private void append(String text) {
            if (!text.equals(" ") || this.m_buffer.length() != 0 && !StringUtil.in((String)this.m_buffer.substring(this.m_buffer.length() - 1), (String[])new String[]{" ", "\n"})) {
                this.m_buffer.append(text);
            }
        }

        public String toString() {
            return this.m_buffer.toString();
        }
    }
}

