/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.common;

import java.time.LocalDateTime;
import java.time.LocalTime;

public final class LocalTimeHelper {
    private static final long MS_PER_DAY = 86400000L;

    public static LocalTime getLocalTime(LocalDateTime date) {
        if (date == null) {
            return null;
        }
        return date.toLocalTime();
    }

    public static int compare(LocalTime d1, LocalTime d2) {
        int result = d1 == null || d2 == null ? (d1 == d2 ? 0 : (d1 == null ? 1 : -1)) : d1.compareTo(d2);
        return result;
    }

    public static LocalDateTime setTime(LocalDateTime date, LocalTime time) {
        if (time == null) {
            return date;
        }
        return LocalDateTime.of(date.toLocalDate(), time);
    }

    public static LocalDateTime setEndTime(LocalDateTime date, LocalTime time) {
        if (time == null) {
            return date;
        }
        date = LocalDateTime.of(date.toLocalDate(), time);
        if (time == LocalTime.MIDNIGHT) {
            date = date.plusDays(1L);
        }
        return date;
    }

    public static long getMillisecondsInRange(LocalTime rangeStart, LocalTime rangeEnd) {
        if (rangeStart == null || rangeEnd == null) {
            return 0L;
        }
        return rangeEnd == LocalTime.MIDNIGHT ? 86400000L - (long)rangeStart.toSecondOfDay() * 1000L : (long)(rangeEnd.toSecondOfDay() - rangeStart.toSecondOfDay()) * 1000L;
    }
}

