/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.common;

import java.math.BigInteger;
import java.util.Arrays;

public final class NumberHelper {
    public static final Double DOUBLE_ZERO = 0.0;

    public static final int getInt(Number value) {
        return value == null ? 0 : value.intValue();
    }

    public static final int getInt(String value) {
        return value == null || value.isEmpty() ? 0 : Integer.parseInt(value);
    }

    public static final double getDouble(String value) {
        return value == null || value.isEmpty() ? 0.0 : Double.parseDouble(value);
    }

    public static final Double getDoubleObject(String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        return Double.valueOf(value);
    }

    public static final Integer getInteger(Number value) {
        Integer result = null;
        if (value != null) {
            result = value instanceof Integer ? (Integer)value : Integer.valueOf((int)Math.round(value.doubleValue()));
        }
        return result;
    }

    public static final Integer getInteger(String value) {
        Integer result;
        try {
            result = value == null ? null : Integer.valueOf(Integer.parseInt(value));
        }
        catch (Exception ex) {
            result = null;
        }
        return result;
    }

    public static final BigInteger getBigInteger(Number value) {
        BigInteger result = null;
        if (value != null) {
            result = value instanceof BigInteger ? (BigInteger)value : BigInteger.valueOf(Math.round(value.doubleValue()));
        }
        return result;
    }

    public static final double getDouble(Number value) {
        return value == null ? 0.0 : value.doubleValue();
    }

    public static final Double getDouble(double value) {
        return value == 0.0 ? DOUBLE_ZERO : Double.valueOf(value);
    }

    public static final double round(double value, double precision) {
        precision = Math.pow(10.0, precision);
        return (double)Math.round(value * precision) / precision;
    }

    public static final Integer parseInteger(String value) {
        return value == null || value.isEmpty() ? null : Integer.valueOf(Integer.parseInt(value));
    }

    public static boolean equals(Number lhs, Number rhs) {
        boolean result = false;
        if (lhs == null && rhs == null) {
            result = true;
        } else if (lhs != null && rhs != null) {
            result = lhs.equals(rhs);
        }
        return result;
    }

    public static int compare(Integer n1, Integer n2) {
        int result = n1 == null || n2 == null ? (n1 == null && n2 == null ? 0 : (n1 == null ? 1 : -1)) : n1.compareTo(n2);
        return result;
    }

    public static boolean equals(double lhs, double rhs, double delta) {
        return Math.abs(lhs - rhs) < delta;
    }

    public static Double sumAsDouble(Number ... values) {
        return Arrays.stream(values).mapToDouble(NumberHelper::getDouble).sum();
    }
}

