/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.common;

import java.math.BigDecimal;
import org.mpxj.Rate;
import org.mpxj.TimeUnit;
import org.mpxj.TimeUnitDefaultsContainer;
import org.mpxj.common.NumberHelper;

public final class RateHelper {
    public static double convertToHours(TimeUnitDefaultsContainer defaults, Rate rate) {
        double amount = rate.getAmount();
        switch (rate.getUnits()) {
            case MINUTES: {
                amount *= 60.0;
                break;
            }
            case DAYS: {
                amount = amount * 60.0 / defaults.getMinutesPerDay().doubleValue();
                break;
            }
            case WEEKS: {
                amount = amount * 60.0 / defaults.getMinutesPerWeek().doubleValue();
                break;
            }
            case MONTHS: {
                amount = amount * 60.0 / defaults.getMinutesPerMonth().doubleValue();
                break;
            }
            case YEARS: {
                amount = amount * 60.0 / (double)(defaults.getMinutesPerWeek() * 52);
                break;
            }
        }
        return amount;
    }

    public static Rate convertFromHours(TimeUnitDefaultsContainer defaults, Rate rate, TimeUnit targetUnits) {
        return RateHelper.convertFromHours(defaults, rate.getAmount(), targetUnits);
    }

    public static Rate convertFromHours(TimeUnitDefaultsContainer defaults, BigDecimal value, TimeUnit targetUnits) {
        if (targetUnits == TimeUnit.YEARS) {
            double v = (double)((long)(value.doubleValue() * defaults.getMinutesPerWeek().doubleValue() * 52.0)) / 60.0;
            return new Rate(NumberHelper.round(v, 2.0), targetUnits);
        }
        return RateHelper.convertFromHours(defaults, value.doubleValue(), targetUnits);
    }

    public static Rate convertFromHours(TimeUnitDefaultsContainer defaults, double value, TimeUnit targetUnits) {
        switch (targetUnits) {
            case MINUTES: {
                value /= 60.0;
                break;
            }
            case DAYS: {
                value = value * defaults.getMinutesPerDay().doubleValue() / 60.0;
                break;
            }
            case WEEKS: {
                value = value * defaults.getMinutesPerWeek().doubleValue() / 60.0;
                break;
            }
            case MONTHS: {
                value = value * defaults.getMinutesPerMonth().doubleValue() / 60.0;
                break;
            }
            case YEARS: {
                value = value * defaults.getMinutesPerWeek().doubleValue() * 52.0 / 60.0;
                break;
            }
        }
        return new Rate(NumberHelper.round(value, 2.0), targetUnits);
    }
}

