/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.common;

import org.mpxj.common.JvmHelper;

class SQLiteLibHelper {
    private String m_originalLibName;
    private boolean m_libNameUpdated;
    private static final String SQLITE_LIB_NAME_PROPERTY = "org.sqlite.lib.name";

    SQLiteLibHelper() {
    }

    public void configure() {
        if (JvmHelper.isIkvm() && System.getProperty("os.name").contains("Mac")) {
            this.m_originalLibName = System.getProperty(SQLITE_LIB_NAME_PROPERTY);
            System.setProperty(SQLITE_LIB_NAME_PROPERTY, "libsqlitejdbc.jnilib");
            this.m_libNameUpdated = true;
        }
    }

    public void restore() {
        if (this.m_libNameUpdated) {
            if (this.m_originalLibName == null) {
                System.clearProperty(SQLITE_LIB_NAME_PROPERTY);
            } else {
                System.setProperty(SQLITE_LIB_NAME_PROPERTY, this.m_originalLibName);
            }
        }
    }
}

