/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.common;

public final class XmlHelper {
    public static final int REPLACEMENT_CHAR = 65533;

    public static boolean validXmlChar(int c) {
        return c == 9 || c == 10 || c == 13 || c >= 32 && c <= 55295 || c >= 57344 && c <= 65533 || c >= 65536 && c <= 0x10FFFF;
    }

    public static String replaceInvalidXmlChars(String value) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        for (int index = 0; index < value.length(); ++index) {
            if (XmlHelper.validXmlChar(value.charAt(index))) continue;
            return XmlHelper.replaceInvalidXmlChars(value, index);
        }
        return value;
    }

    private static String replaceInvalidXmlChars(String value, int firstInvalidIndex) {
        StringBuilder sb = firstInvalidIndex == 0 ? new StringBuilder() : new StringBuilder(value.substring(0, firstInvalidIndex));
        for (int index = firstInvalidIndex; index < value.length(); ++index) {
            char c = value.charAt(index);
            sb.append(XmlHelper.validXmlChar(c) ? c : (char)'\ufffd');
        }
        return sb.toString();
    }
}

