/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.cpm;

import java.time.LocalDateTime;

final class AnnotatedDateTime {
    private final LocalDateTime m_value;
    private final boolean m_actual;

    public static AnnotatedDateTime from(LocalDateTime value) {
        if (value == null) {
            return null;
        }
        return new AnnotatedDateTime(value, false);
    }

    public static AnnotatedDateTime fromActual(LocalDateTime value) {
        if (value == null) {
            return null;
        }
        return new AnnotatedDateTime(value, true);
    }

    private AnnotatedDateTime(LocalDateTime value, boolean actual) {
        this.m_value = value;
        this.m_actual = actual;
    }

    public LocalDateTime getValue() {
        return this.m_value;
    }

    public boolean isActual() {
        return this.m_actual;
    }

    public boolean isBefore(AnnotatedDateTime value) {
        return this.m_value.isBefore(value.m_value);
    }

    public boolean isAfter(AnnotatedDateTime value) {
        return this.m_value.isAfter(value.m_value);
    }

    public boolean isBefore(LocalDateTime value) {
        return this.m_value.isBefore(value);
    }

    public boolean isAfter(LocalDateTime value) {
        return this.m_value.isAfter(value);
    }

    public String toString() {
        return this.m_value + (this.m_actual ? "A" : "");
    }
}

