/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.cpm;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.mpxj.ProjectFile;
import org.mpxj.Relation;
import org.mpxj.Task;
import org.mpxj.cpm.CycleException;

class DepthFirstGraphSort {
    private final ProjectFile m_file;
    private final Function<Task, Boolean> m_includeTask;
    private final Deque<Task> m_tasks = new ArrayDeque<Task>();
    private final Set<Task> m_temporaryMark = new HashSet<Task>();
    private final Set<Task> m_permanentMark = new HashSet<Task>();

    public DepthFirstGraphSort(ProjectFile file, Function<Task, Boolean> filter) {
        this.m_file = file;
        this.m_includeTask = filter;
    }

    public List<Task> sort() throws CycleException {
        try {
            for (Task task : this.m_file.getTasks()) {
                if (!this.m_includeTask.apply(task).booleanValue()) continue;
                this.visit(task);
            }
            ArrayList<Task> arrayList = new ArrayList<Task>(this.m_tasks);
            return arrayList;
        }
        finally {
            this.m_tasks.clear();
            this.m_temporaryMark.clear();
            this.m_permanentMark.clear();
        }
    }

    public List<Relation> getSuccessors(Task task) {
        return task.getSuccessors();
    }

    private void visit(Task task) throws CycleException {
        if (this.m_permanentMark.contains(task)) {
            return;
        }
        if (this.m_temporaryMark.contains(task)) {
            throw new CycleException();
        }
        this.m_temporaryMark.add(task);
        for (Relation relation : this.getSuccessors(task)) {
            Task successorTask = relation.getSuccessorTask();
            if (!this.m_includeTask.apply(successorTask).booleanValue()) continue;
            this.visit(successorTask);
        }
        this.m_temporaryMark.remove(task);
        this.m_permanentMark.add(task);
        this.m_tasks.push(task);
    }
}

