/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.cpm;

import java.time.DayOfWeek;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mpxj.ActivityType;
import org.mpxj.ConstraintType;
import org.mpxj.DayType;
import org.mpxj.Duration;
import org.mpxj.FieldType;
import org.mpxj.LocalTimeRange;
import org.mpxj.PercentCompleteType;
import org.mpxj.ProjectCalendar;
import org.mpxj.ProjectCalendarHours;
import org.mpxj.ProjectFile;
import org.mpxj.Relation;
import org.mpxj.ResourceAssignment;
import org.mpxj.ResourceType;
import org.mpxj.Task;
import org.mpxj.TaskField;
import org.mpxj.TimeUnit;
import org.mpxj.common.LocalDateTimeHelper;
import org.mpxj.cpm.AnnotatedDateTime;
import org.mpxj.cpm.CpmException;
import org.mpxj.cpm.DepthFirstGraphSort;
import org.mpxj.cpm.Scheduler;

public class PrimaveraScheduler
implements Scheduler {
    private ProjectFile m_file;
    private ProjectCalendar m_twentyFourHourCalendar;
    private LocalDateTime m_dataDate;
    private LocalDateTime m_projectStartDate;
    private LocalDateTime m_projectFinishDate;

    @Override
    public void schedule(ProjectFile file, LocalDateTime startDate) throws CpmException {
        this.m_file = file;
        this.m_dataDate = file.getProjectProperties().getStatusDate();
        this.m_twentyFourHourCalendar = this.createTwentyFourHourCalendar();
        this.m_projectStartDate = startDate;
        List<Task> activities = new DepthFirstGraphSort(this.m_file, PrimaveraScheduler::isActivity).sort();
        if (activities.isEmpty()) {
            return;
        }
        this.validateActivities(activities);
        this.clearDates();
        if (this.m_dataDate == null) {
            this.m_dataDate = this.m_projectStartDate;
        } else if (startDate.isBefore(this.m_dataDate)) {
            this.m_projectStartDate = this.m_dataDate;
        }
        this.forwardPass(activities);
        LocalDateTime mustFinishBy = this.m_file.getProjectProperties().getMustFinishBy();
        LocalDateTime earlyFinish = activities.stream().map(Task::getEarlyFinish).max(Comparator.naturalOrder()).orElseThrow(() -> new CpmException("Missing early finish date"));
        this.m_projectFinishDate = mustFinishBy == null || earlyFinish.isAfter(mustFinishBy) ? earlyFinish : mustFinishBy;
        this.backwardPass(activities);
        for (Task activity : activities) {
            activity.setStart(activity.getActualStart() == null ? activity.getEarlyStart() : activity.getActualStart());
            activity.setFinish(activity.getActualFinish() == null ? activity.getEarlyFinish() : activity.getActualFinish());
        }
        this.levelOfEffortPass();
        this.m_file.getChildTasks().forEach(this::rollupDates);
        this.wbsSummaryPass();
    }

    private void validateActivities(List<Task> tasks) throws CpmException {
        for (Task task : tasks) {
            if (task.getActivityType() == null) {
                throw new CpmException("Task has no activity type: " + task);
            }
            if (task.getActivityType() == ActivityType.RESOURCE_DEPENDENT && this.getResourceAssignmentStream(task).findAny().isPresent()) {
                if (this.getResourceAssignmentStream(task).anyMatch(r -> r.getWork() == null)) {
                    throw new CpmException("Task has resource assignments without a work value: " + task);
                }
                if (!this.getResourceAssignmentStream(task).anyMatch(r -> r.getRemainingWork() == null)) continue;
                throw new CpmException("Task has resource assignments without a remaining work value: " + task);
            }
            if (task.getDuration() == null) {
                throw new CpmException("Task has no duration value: " + task);
            }
            if (task.getRemainingDuration() != null) continue;
            throw new CpmException("Task has no remaining duration value: " + task);
        }
    }

    private void forwardPass(List<Task> tasks) throws CpmException {
        for (Task task : tasks) {
            this.forwardPass(task);
        }
    }

    private void forwardPass(Task task) throws CpmException {
        LocalDateTime earlyStart;
        LocalDateTime earlyFinish;
        block30: {
            List predecessors;
            block27: {
                block29: {
                    block28: {
                        earlyFinish = null;
                        predecessors = task.getPredecessors().stream().filter(r -> PrimaveraScheduler.isActivity(r.getPredecessorTask())).collect(Collectors.toList());
                        if (task.getActualStart() != null) break block27;
                        if (!predecessors.isEmpty()) break block28;
                        switch (task.getConstraintType()) {
                            case START_NO_EARLIER_THAN: {
                                earlyStart = task.getConstraintDate();
                                if (earlyStart.isBefore(this.m_dataDate)) {
                                    earlyStart = this.m_dataDate;
                                    break;
                                }
                                break block29;
                            }
                            case FINISH_NO_EARLIER_THAN: {
                                earlyFinish = task.getConstraintDate();
                                earlyStart = this.getDateFromFinishAndDuration(task, earlyFinish);
                                break;
                            }
                            default: {
                                earlyStart = this.m_projectStartDate;
                                break;
                            }
                        }
                        break block29;
                    }
                    earlyStart = predecessors.stream().map(this::calculateEarlyStart).max(Comparator.naturalOrder()).orElseThrow(() -> new CpmException("Missing early start date"));
                }
                switch (task.getConstraintType()) {
                    case START_NO_EARLIER_THAN: {
                        LocalDateTime adjustedConstraintDate;
                        if (!earlyStart.isBefore(task.getConstraintDate()) && !earlyStart.toLocalDate().isEqual(task.getConstraintDate().toLocalDate())) break;
                        LocalDateTime constraintDate = task.getConstraintDate();
                        if (constraintDate.toLocalTime() == LocalTime.MIDNIGHT && earlyStart.toLocalTime() != LocalTime.MIDNIGHT && (adjustedConstraintDate = LocalDateTime.of(constraintDate.toLocalDate(), earlyStart.toLocalTime())).toLocalDate().isEqual(this.getNextWorkStart(task, adjustedConstraintDate).toLocalDate())) {
                            constraintDate = adjustedConstraintDate;
                        }
                        earlyStart = constraintDate;
                        break;
                    }
                    case FINISH_NO_EARLIER_THAN: {
                        LocalDateTime earliestStart = this.getDateFromFinishAndDuration(task, task.getConstraintDate());
                        if (!earlyStart.isBefore(earliestStart)) break;
                        earlyStart = earliestStart;
                        break;
                    }
                    case MUST_START_ON: {
                        earlyStart = task.getConstraintDate();
                        break;
                    }
                    case START_ON: {
                        if (!earlyStart.isBefore(task.getConstraintDate())) break;
                        earlyStart = this.getNextWorkStart(task, task.getConstraintDate());
                        break;
                    }
                    case MUST_FINISH_ON: {
                        earlyFinish = task.getConstraintDate();
                        earlyStart = this.getDateFromFinishAndDuration(task, earlyFinish);
                        break;
                    }
                    case FINISH_ON: {
                        LocalDateTime startOn = this.getDateFromFinishAndDuration(task, task.getConstraintDate());
                        if (!startOn.isAfter(earlyStart)) break;
                        earlyFinish = task.getConstraintDate();
                        earlyStart = startOn;
                        break;
                    }
                }
                if (task.getActivityType() != ActivityType.FINISH_MILESTONE) {
                    earlyStart = this.getNextWorkStart(task, earlyStart);
                }
                break block30;
            }
            if (task.getActualFinish() == null) {
                if (predecessors.isEmpty()) {
                    if (!this.hasActualDuration(task)) {
                        earlyStart = this.getNextWorkStart(task, this.m_dataDate);
                        earlyFinish = this.getDateFromStartAndDuration(task, earlyStart);
                    } else if (this.hasRemainingDuration(task)) {
                        earlyFinish = this.getDateFromStartAndDuration(task, task.getActualStart());
                        earlyStart = this.getDateFromFinishAndRemainingDuration(task, earlyFinish);
                    } else {
                        earlyFinish = earlyStart = this.getNextWorkStart(task, this.m_dataDate);
                    }
                } else {
                    earlyStart = this.getNextWorkStart(task, predecessors.stream().map(this::calculateEarlyStart).max(Comparator.naturalOrder()).orElseThrow(() -> new CpmException("Missing early start date")));
                    earlyFinish = this.getDateFromStartAndRemainingDuration(task, earlyStart);
                }
            } else if (predecessors.isEmpty()) {
                earlyStart = this.m_dataDate;
                earlyFinish = this.m_dataDate;
            } else {
                earlyStart = predecessors.stream().map(this::calculateEarlyStart).max(Comparator.naturalOrder()).orElseThrow(() -> new CpmException("Missing early start date"));
                earlyFinish = this.getDateFromStartAndRemainingDuration(task, earlyStart);
            }
        }
        if (task.getExternalEarlyStart() != null && task.getExternalEarlyStart().isAfter(earlyStart)) {
            earlyStart = task.getExternalEarlyStart();
            earlyFinish = null;
        }
        if (earlyFinish == null) {
            earlyFinish = task.getActualFinish() == null ? this.getDateFromStartAndDuration(task, earlyStart) : task.getActualFinish();
        }
        task.setEarlyStart(earlyStart);
        task.setEarlyFinish(earlyFinish);
        this.setRemainingEarlyDates(task);
    }

    private void backwardPass(List<Task> forwardPassTasks) throws CpmException {
        ArrayList<Task> tasks = new ArrayList<Task>(forwardPassTasks);
        Collections.reverse(tasks);
        for (Task task : tasks) {
            this.backwardPass(task);
        }
    }

    private void backwardPass(Task task) throws CpmException {
        LocalDateTime lateFinish;
        List successors = this.m_file.getRelations().getSuccessors(task).stream().filter(r -> PrimaveraScheduler.isActivity(r.getSuccessorTask())).collect(Collectors.toList());
        if (task.getActualFinish() == null) {
            LocalDateTime latestFinish;
            lateFinish = successors.isEmpty() ? (task.getExternalLateFinish() == null ? (this.m_file.getProjectProperties().getMustFinishBy() != null ? this.m_file.getProjectProperties().getMustFinishBy() : this.m_projectFinishDate) : task.getExternalLateFinish()) : successors.stream().map(this::calculateLateFinish).min(Comparator.naturalOrder()).orElseThrow(() -> new CpmException("Missing late start date"));
            switch (task.getConstraintType()) {
                case START_ON: {
                    if (task.getActualStart() != null || !lateFinish.isAfter(latestFinish = this.getDateFromStartAndDuration(task, task.getConstraintDate()))) break;
                    lateFinish = latestFinish;
                    break;
                }
                case MUST_START_ON: {
                    lateFinish = this.getDateFromStartAndDuration(task, task.getConstraintDate());
                    break;
                }
                case MUST_FINISH_ON: {
                    lateFinish = task.getConstraintDate();
                    break;
                }
                case START_NO_LATER_THAN: {
                    latestFinish = this.getDateFromStartAndDuration(task, task.getConstraintDate());
                    if (!lateFinish.isAfter(latestFinish)) break;
                    lateFinish = latestFinish;
                    break;
                }
                case FINISH_ON: 
                case FINISH_NO_LATER_THAN: {
                    if (!lateFinish.isAfter(task.getConstraintDate())) break;
                    lateFinish = task.getConstraintDate();
                    break;
                }
            }
            if (task.getSecondaryConstraintType() != null) {
                switch (task.getSecondaryConstraintType()) {
                    case START_NO_LATER_THAN: {
                        latestFinish = this.getDateFromStartAndDuration(task, task.getSecondaryConstraintDate());
                        if (!lateFinish.isAfter(latestFinish)) break;
                        lateFinish = latestFinish;
                        break;
                    }
                    case FINISH_NO_LATER_THAN: {
                        if (!lateFinish.isAfter(task.getSecondaryConstraintDate())) break;
                        lateFinish = task.getSecondaryConstraintDate();
                        break;
                    }
                }
            }
            lateFinish = this.getEquivalentPreviousWorkFinish(task, lateFinish);
        } else {
            lateFinish = successors.isEmpty() ? (this.m_file.getProjectProperties().getMustFinishBy() != null ? this.m_file.getProjectProperties().getMustFinishBy() : this.m_projectFinishDate) : successors.stream().map(this::calculateLateFinish).min(Comparator.naturalOrder()).orElseThrow(() -> new CpmException("Missing late start date"));
        }
        if (task.getExternalLateFinish() != null && task.getExternalLateFinish().isBefore(lateFinish)) {
            lateFinish = task.getExternalLateFinish();
        }
        LocalDateTime lateStart = this.getDateFromFinishAndRemainingDuration(task, lateFinish);
        if (task.getActivityType() == ActivityType.START_MILESTONE) {
            lateStart = this.getNextWorkStart(task, lateStart);
        } else if (task.getActivityType() != ActivityType.FINISH_MILESTONE && this.hasRemainingDuration(task)) {
            lateStart = this.getNextWorkStart(task, lateStart);
        }
        task.setLateStart(lateStart);
        task.setLateFinish(lateFinish);
        this.setRemainingLateDates(task);
        if (task.getConstraintType() == ConstraintType.AS_LATE_AS_POSSIBLE) {
            this.alapAdjust(task);
        }
    }

    private LocalDateTime calculateEarlyStart(Relation relation) {
        switch (relation.getType()) {
            case FINISH_START: {
                return this.calculateEarlyStartForFinishStart(relation);
            }
            case START_START: {
                return this.calculateEarlyStartForStartStart(relation);
            }
            case FINISH_FINISH: {
                return this.calculateEarlyStartForFinishFinish(relation);
            }
            case START_FINISH: {
                return this.calculateEarlyStartForStartFinish(relation);
            }
        }
        throw new UnsupportedOperationException();
    }

    private LocalDateTime calculateEarlyStartForFinishStart(Relation relation) {
        Task predecessorTask = relation.getPredecessorTask();
        Task successorTask = relation.getSuccessorTask();
        if (predecessorTask.getActualStart() == null) {
            if (successorTask.getActualStart() == null) {
                if (relation.getLag().getDuration() == 0.0) {
                    return predecessorTask.getEarlyFinish();
                }
                if (relation.getLag().getDuration() > 0.0) {
                    return this.addLag(relation, predecessorTask.getEarlyFinish());
                }
                return this.addLag(relation, predecessorTask.getEarlyFinish());
            }
            if (successorTask.getActualFinish() == null) {
                if (relation.getLag().getDuration() == 0.0) {
                    return this.addLag(relation, predecessorTask.getEarlyFinish());
                }
                if (relation.getLag().getDuration() > 0.0) {
                    return this.addLag(relation, predecessorTask.getEarlyFinish());
                }
                return this.addLag(relation, predecessorTask.getEarlyFinish());
            }
            if (relation.getLag().getDuration() == 0.0) {
                return this.addLag(relation, predecessorTask.getEarlyFinish());
            }
            if (relation.getLag().getDuration() > 0.0) {
                return this.addLag(relation, predecessorTask.getEarlyFinish());
            }
            return this.addLag(relation, predecessorTask.getEarlyFinish());
        }
        if (predecessorTask.getActualFinish() != null) {
            if (successorTask.getActualStart() == null) {
                if (relation.getLag().getDuration() == 0.0) {
                    return predecessorTask.getEarlyFinish();
                }
                if (relation.getLag().getDuration() > 0.0) {
                    double actualLagDurationInHours = predecessorTask.getActualFinish().isAfter(this.m_dataDate) ? 0.0 : this.getLagCalendar(relation).getWork(predecessorTask.getActualFinish(), this.m_dataDate, TimeUnit.HOURS).getDuration();
                    double lagDurationInHours = relation.getLag().convertUnits(TimeUnit.HOURS, this.m_file.getProjectProperties()).getDuration();
                    if (lagDurationInHours > actualLagDurationInHours) {
                        Duration remainingLag = Duration.getInstance(lagDurationInHours - actualLagDurationInHours, TimeUnit.HOURS);
                        return this.addLag(relation, predecessorTask.getEarlyFinish(), remainingLag);
                    }
                    return predecessorTask.getEarlyFinish();
                }
                return predecessorTask.getEarlyFinish();
            }
            if (successorTask.getActualFinish() == null) {
                if (relation.getLag().getDuration() == 0.0) {
                    return predecessorTask.getEarlyFinish();
                }
                if (relation.getLag().getDuration() > 0.0) {
                    return predecessorTask.getEarlyFinish();
                }
                return predecessorTask.getEarlyFinish();
            }
            if (relation.getLag().getDuration() == 0.0) {
                return predecessorTask.getEarlyFinish();
            }
            if (relation.getLag().getDuration() > 0.0) {
                return predecessorTask.getEarlyFinish();
            }
            return predecessorTask.getEarlyFinish();
        }
        if (successorTask.getActualStart() == null) {
            if (relation.getLag().getDuration() == 0.0) {
                this.getNextWorkStart(successorTask, predecessorTask.getEarlyFinish());
            }
            if (relation.getLag().getDuration() > 0.0) {
                return this.addLag(relation, predecessorTask.getEarlyFinish());
            }
            return this.addLag(relation, predecessorTask.getEarlyFinish());
        }
        if (successorTask.getActualFinish() == null) {
            if (relation.getLag().getDuration() == 0.0) {
                return this.addLag(relation, predecessorTask.getEarlyFinish());
            }
            if (relation.getLag().getDuration() > 0.0) {
                return this.addLag(relation, predecessorTask.getEarlyFinish());
            }
            return this.addLag(relation, predecessorTask.getEarlyFinish());
        }
        if (relation.getLag().getDuration() == 0.0) {
            return this.addLag(relation, predecessorTask.getEarlyFinish());
        }
        if (relation.getLag().getDuration() > 0.0) {
            return this.addLag(relation, predecessorTask.getEarlyFinish());
        }
        return this.addLag(relation, predecessorTask.getEarlyFinish());
    }

    private LocalDateTime calculateEarlyStartForStartStart(Relation relation) {
        Task predecessorTask = relation.getPredecessorTask();
        Task successorTask = relation.getSuccessorTask();
        if (predecessorTask.getActualStart() == null) {
            if (successorTask.getActualStart() == null) {
                if (relation.getLag().getDuration() == 0.0) {
                    return this.getLagCalendar(relation).getNextWorkStart(predecessorTask.getEarlyStart());
                }
                if (relation.getLag().getDuration() > 0.0) {
                    return this.addLag(relation, predecessorTask.getEarlyStart());
                }
                return this.addLag(relation, predecessorTask.getEarlyStart());
            }
            if (successorTask.getActualFinish() == null) {
                if (relation.getLag().getDuration() == 0.0) {
                    return this.addLag(relation, predecessorTask.getEarlyStart());
                }
                if (relation.getLag().getDuration() > 0.0) {
                    return this.addLag(relation, predecessorTask.getEarlyStart());
                }
                return this.addLag(relation, predecessorTask.getEarlyStart());
            }
            if (relation.getLag().getDuration() == 0.0) {
                return this.addLag(relation, predecessorTask.getEarlyStart());
            }
            if (relation.getLag().getDuration() > 0.0) {
                return this.addLag(relation, predecessorTask.getEarlyStart());
            }
            return this.addLag(relation, predecessorTask.getEarlyStart());
        }
        if (predecessorTask.getActualFinish() != null) {
            if (successorTask.getActualStart() == null) {
                if (relation.getLag().getDuration() == 0.0) {
                    LocalDateTime earlyStart = this.addLag(relation, predecessorTask.getActualStart());
                    if (earlyStart.isBefore(this.m_dataDate)) {
                        return predecessorTask.getEarlyStart();
                    }
                    return earlyStart;
                }
                if (relation.getLag().getDuration() > 0.0) {
                    LocalDateTime earlyStart = this.addLag(relation, predecessorTask.getActualStart());
                    if (earlyStart.isBefore(this.m_dataDate)) {
                        return predecessorTask.getEarlyStart();
                    }
                    return earlyStart;
                }
                return this.addLag(relation, predecessorTask.getActualStart());
            }
            if (successorTask.getActualFinish() == null) {
                if (relation.getLag().getDuration() == 0.0) {
                    return predecessorTask.getEarlyStart();
                }
                if (relation.getLag().getDuration() > 0.0) {
                    return predecessorTask.getEarlyStart();
                }
                return predecessorTask.getEarlyStart();
            }
            if (relation.getLag().getDuration() == 0.0) {
                return predecessorTask.getEarlyStart();
            }
            if (relation.getLag().getDuration() > 0.0) {
                return predecessorTask.getEarlyStart();
            }
            return predecessorTask.getEarlyStart();
        }
        if (successorTask.getActualStart() == null) {
            double lagDurationInHours = relation.getLag().convertUnits(TimeUnit.HOURS, this.m_file.getProjectProperties()).getDuration();
            double actualDurationInHours = predecessorTask.getActualDuration().convertUnits(TimeUnit.HOURS, this.m_file.getProjectProperties()).getDuration();
            if (actualDurationInHours == 0.0 || lagDurationInHours <= 0.0) {
                return predecessorTask.getEarlyStart();
            }
            if (actualDurationInHours >= lagDurationInHours) {
                return predecessorTask.getEarlyStart();
            }
            Duration remainingLag = Duration.getInstance(lagDurationInHours - actualDurationInHours, TimeUnit.HOURS);
            return this.addLag(relation, predecessorTask.getEarlyStart(), remainingLag);
        }
        if (successorTask.getActualFinish() == null) {
            double lagDurationInHours = relation.getLag().convertUnits(TimeUnit.HOURS, this.m_file.getProjectProperties()).getDuration();
            if (lagDurationInHours <= 0.0) {
                return predecessorTask.getEarlyStart();
            }
            double actualDurationInHours = predecessorTask.getActualDuration().convertUnits(TimeUnit.HOURS, this.m_file.getProjectProperties()).getDuration();
            if (actualDurationInHours >= lagDurationInHours) {
                return predecessorTask.getEarlyStart();
            }
            Duration remainingLag = Duration.getInstance(lagDurationInHours - actualDurationInHours, TimeUnit.HOURS);
            return this.addLag(relation, predecessorTask.getEarlyStart(), remainingLag);
        }
        if (relation.getLag().getDuration() == 0.0) {
            return predecessorTask.getEarlyStart();
        }
        if (relation.getLag().getDuration() > 0.0) {
            return predecessorTask.getEarlyStart();
        }
        return predecessorTask.getEarlyStart();
    }

    private LocalDateTime calculateEarlyStartForFinishFinish(Relation relation) {
        Task predecessorTask = relation.getPredecessorTask();
        Task successorTask = relation.getSuccessorTask();
        if (predecessorTask.getActualStart() == null) {
            if (successorTask.getActualStart() == null) {
                if (relation.getLag().getDuration() == 0.0) {
                    return this.getEarlyStartFromEarlyFinish(successorTask, predecessorTask.getEarlyFinish());
                }
                if (relation.getLag().getDuration() > 0.0) {
                    return this.getEarlyStartFromEarlyFinish(successorTask, this.addLag(relation, predecessorTask.getEarlyFinish()));
                }
                return this.getEarlyStartFromEarlyFinish(successorTask, this.addLag(relation, predecessorTask.getEarlyFinish()));
            }
            if (successorTask.getActualFinish() == null) {
                if (relation.getLag().getDuration() == 0.0) {
                    return this.getEarlyStartFromEarlyFinish(successorTask, predecessorTask.getEarlyFinish());
                }
                if (relation.getLag().getDuration() > 0.0) {
                    return this.getEarlyStartFromEarlyFinish(successorTask, this.addLag(relation, predecessorTask.getEarlyFinish()));
                }
                return this.getEarlyStartFromEarlyFinish(successorTask, this.addLag(relation, predecessorTask.getEarlyFinish()));
            }
            if (relation.getLag().getDuration() == 0.0) {
                return this.getEarlyStartFromEarlyFinish(successorTask, predecessorTask.getEarlyFinish());
            }
            if (relation.getLag().getDuration() > 0.0) {
                return this.getEarlyStartFromEarlyFinish(successorTask, this.addLag(relation, predecessorTask.getEarlyFinish()));
            }
            return this.getEarlyStartFromEarlyFinish(successorTask, this.addLag(relation, predecessorTask.getEarlyFinish()));
        }
        if (predecessorTask.getActualFinish() != null) {
            if (successorTask.getActualStart() == null) {
                if (relation.getLag().getDuration() == 0.0) {
                    return this.getEarlyStartFromEarlyFinish(successorTask, predecessorTask.getActualFinish());
                }
                if (relation.getLag().getDuration() > 0.0) {
                    double actualDurationInHours;
                    double lagDurationInHours = relation.getLag().convertUnits(TimeUnit.HOURS, this.m_file.getProjectProperties()).getDuration();
                    if (lagDurationInHours > (actualDurationInHours = predecessorTask.getActualDuration().convertUnits(TimeUnit.HOURS, this.m_file.getProjectProperties()).getDuration())) {
                        return this.getEarlyStartFromEarlyFinish(successorTask, this.addLag(relation, predecessorTask.getActualFinish()));
                    }
                    return this.getEarlyStartFromEarlyFinish(successorTask, this.addLag(relation, this.addLag(relation, predecessorTask.getEarlyFinish())));
                }
                return this.getEarlyStartFromEarlyFinish(successorTask, this.addLag(relation, this.addLag(relation, predecessorTask.getEarlyFinish())));
            }
            if (successorTask.getActualFinish() == null) {
                if (relation.getLag().getDuration() == 0.0) {
                    return this.getEarlyStartFromEarlyFinish(successorTask, predecessorTask.getActualFinish());
                }
                if (relation.getLag().getDuration() > 0.0) {
                    return this.getEarlyStartFromEarlyFinish(successorTask, this.addLag(relation, predecessorTask.getActualFinish()));
                }
                return this.getEarlyStartFromEarlyFinish(successorTask, this.addLag(relation, predecessorTask.getActualFinish()));
            }
            if (relation.getLag().getDuration() == 0.0) {
                return this.m_dataDate;
            }
            if (relation.getLag().getDuration() > 0.0) {
                return this.m_dataDate;
            }
            return this.m_dataDate;
        }
        if (successorTask.getActualStart() == null) {
            if (relation.getLag().getDuration() == 0.0) {
                return this.getEarlyStartFromEarlyFinish(successorTask, predecessorTask.getEarlyFinish());
            }
            if (relation.getLag().getDuration() > 0.0) {
                return this.getEarlyStartFromEarlyFinish(successorTask, this.addLag(relation, predecessorTask.getEarlyFinish()));
            }
            return this.getEarlyStartFromEarlyFinish(successorTask, this.addLag(relation, predecessorTask.getEarlyFinish()));
        }
        if (successorTask.getActualFinish() == null) {
            if (relation.getLag().getDuration() == 0.0) {
                return this.getEarlyStartFromEarlyFinish(successorTask, predecessorTask.getEarlyFinish());
            }
            if (relation.getLag().getDuration() > 0.0) {
                return this.getEarlyStartFromEarlyFinish(successorTask, this.addLag(relation, predecessorTask.getEarlyFinish()));
            }
            return this.getEarlyStartFromEarlyFinish(successorTask, this.addLag(relation, predecessorTask.getEarlyFinish()));
        }
        if (relation.getLag().getDuration() == 0.0) {
            return this.getEarlyStartFromEarlyFinish(successorTask, predecessorTask.getEarlyFinish());
        }
        if (relation.getLag().getDuration() > 0.0) {
            return this.getEarlyStartFromEarlyFinish(successorTask, this.addLag(relation, predecessorTask.getEarlyFinish()));
        }
        return this.getEarlyStartFromEarlyFinish(successorTask, this.addLag(relation, predecessorTask.getEarlyFinish()));
    }

    private LocalDateTime calculateEarlyStartForStartFinish(Relation relation) {
        LocalDateTime earlyStart;
        Task predecessorTask = relation.getPredecessorTask();
        Task successorTask = relation.getSuccessorTask();
        if (predecessorTask.getActualStart() == null) {
            if (successorTask.getActualStart() == null) {
                earlyStart = relation.getLag().getDuration() == 0.0 ? this.addLag(relation, this.getDateFromFinishAndDuration(successorTask, predecessorTask.getEarlyStart())) : this.addLag(relation, this.getDateFromFinishAndDuration(successorTask, predecessorTask.getEarlyStart()));
            } else if (successorTask.getActualFinish() == null) {
                if (relation.getLag().getDuration() <= 0.0) {
                    LocalDateTime earlyFinish = this.getDateFromStartAndDuration(successorTask, successorTask.getActualStart());
                    earlyStart = this.getDateFromFinishAndRemainingDuration(successorTask, earlyFinish);
                } else {
                    LocalDateTime earlyFinish = this.addLag(relation, predecessorTask.getEarlyStart());
                    earlyStart = this.getDateFromFinishAndRemainingDuration(successorTask, earlyFinish);
                }
            } else {
                earlyStart = relation.getLag().getDuration() == 0.0 ? predecessorTask.getEarlyStart() : this.addLag(relation, predecessorTask.getEarlyStart());
            }
        } else if (predecessorTask.getActualFinish() != null) {
            if (successorTask.getActualStart() == null) {
                earlyStart = relation.getLag().getDuration() == 0.0 ? this.addLag(relation, this.getDateFromFinishAndDuration(successorTask, predecessorTask.getEarlyStart())) : this.addLag(relation, this.getDateFromFinishAndDuration(successorTask, predecessorTask.getEarlyStart()));
            } else if (successorTask.getActualFinish() == null) {
                double actualLagDurationInHours = predecessorTask.getActualStart().isAfter(this.m_dataDate) ? 0.0 : this.getLagCalendar(relation).getWork(predecessorTask.getActualStart(), this.m_dataDate, TimeUnit.HOURS).getDuration();
                double lagDurationInHours = relation.getLag().convertUnits(TimeUnit.HOURS, this.m_file.getProjectProperties()).getDuration();
                if (lagDurationInHours > actualLagDurationInHours) {
                    Duration remainingLag = Duration.getInstance(lagDurationInHours - actualLagDurationInHours, TimeUnit.HOURS);
                    LocalDateTime earlyFinish = this.addLag(relation, predecessorTask.getEarlyStart(), remainingLag);
                    earlyStart = this.getDateFromFinishAndRemainingDuration(successorTask, earlyFinish);
                } else {
                    earlyStart = predecessorTask.getEarlyStart();
                }
            } else if (relation.getLag().getDuration() == 0.0) {
                earlyStart = predecessorTask.getEarlyStart();
            } else {
                earlyStart = this.addLag(relation, predecessorTask.getEarlyStart());
                if (earlyStart.isAfter(this.m_dataDate)) {
                    earlyStart = this.m_dataDate;
                }
            }
        } else if (successorTask.getActualStart() == null) {
            if (relation.getLag().getDuration() == 0.0) {
                earlyStart = this.addLag(relation, this.getDateFromFinishAndDuration(successorTask, predecessorTask.getEarlyStart()));
                if (earlyStart.isAfter(this.m_dataDate)) {
                    earlyStart = this.m_dataDate;
                }
            } else {
                earlyStart = this.addLag(relation, this.getDateFromFinishAndDuration(successorTask, predecessorTask.getEarlyStart()));
                if (earlyStart.isAfter(this.m_dataDate)) {
                    earlyStart = this.m_dataDate;
                }
            }
        } else if (successorTask.getActualFinish() == null) {
            double actualLagDurationInHours = predecessorTask.getActualStart().isAfter(this.m_dataDate) ? 0.0 : this.getLagCalendar(relation).getWork(predecessorTask.getActualStart(), this.m_dataDate, TimeUnit.HOURS).getDuration();
            double lagDurationInHours = relation.getLag().convertUnits(TimeUnit.HOURS, this.m_file.getProjectProperties()).getDuration();
            if (lagDurationInHours > actualLagDurationInHours) {
                Duration remainingLag = Duration.getInstance(lagDurationInHours - actualLagDurationInHours, TimeUnit.HOURS);
                LocalDateTime earlyFinish = this.addLag(relation, predecessorTask.getEarlyStart(), remainingLag);
                earlyStart = this.getDateFromFinishAndRemainingDuration(successorTask, earlyFinish);
            } else {
                earlyStart = predecessorTask.getEarlyStart();
            }
        } else {
            earlyStart = relation.getLag().getDuration() == 0.0 ? predecessorTask.getEarlyStart() : this.getEquivalentNextWorkStart(successorTask, this.m_dataDate);
        }
        return earlyStart;
    }

    private LocalDateTime getEarlyStartFromEarlyFinish(Task successorTask, LocalDateTime earlyFinish) {
        LocalDateTime earlyStart = this.getDateFromFinishAndRemainingDuration(successorTask, earlyFinish);
        if (earlyStart.isBefore(this.m_projectStartDate)) {
            return this.m_projectStartDate;
        }
        return earlyStart;
    }

    private LocalDateTime calculateLateFinish(Relation relation) {
        switch (relation.getType()) {
            case START_START: {
                return this.adjustLateFinish(relation, this.calculateLateFinishForStartStart(relation));
            }
            case FINISH_FINISH: {
                return this.adjustLateFinish(relation, this.calculateLateFinishForFinishFinish(relation));
            }
            case START_FINISH: {
                return this.adjustLateFinish(relation, this.calculateLateFinishForStartFinish(relation));
            }
            case FINISH_START: {
                return this.adjustLateFinish(relation, this.calculateLateFinishForFinishStart(relation));
            }
        }
        throw new UnsupportedOperationException();
    }

    private LocalDateTime adjustLateFinish(Relation relation, LocalDateTime lateFinish) {
        if (lateFinish.isAfter(this.m_projectFinishDate)) {
            lateFinish = this.getEquivalentPreviousWorkFinish(relation.getPredecessorTask(), this.m_projectFinishDate);
        }
        return lateFinish;
    }

    private LocalDateTime calculateLateFinishForStartStart(Relation relation) {
        LocalDateTime lateStart;
        Task predecessorTask = relation.getPredecessorTask();
        Task successorTask = relation.getSuccessorTask();
        LocalDateTime lateFinish = null;
        if (predecessorTask.getActualStart() == null) {
            if (successorTask.getActualStart() == null) {
                if (relation.getLag().getDuration() == 0.0) {
                    lateStart = this.getNextWorkStart(predecessorTask, successorTask.getLateStart());
                    lateFinish = this.getDateFromStartAndRemainingDuration(predecessorTask, lateStart);
                    if (successorTask.getSuccessors().isEmpty() && successorTask.getLateFinish().isBefore(lateFinish)) {
                        lateFinish = successorTask.getLateFinish();
                    }
                } else if (relation.getLag().getDuration() > 0.0) {
                    lateStart = this.getNextWorkStart(predecessorTask, this.removeLag(relation, successorTask.getLateStart()));
                    lateFinish = this.getDateFromStartAndRemainingDuration(predecessorTask, lateStart);
                } else {
                    lateStart = this.getNextWorkStart(predecessorTask, this.removeLag(relation, successorTask.getLateStart()));
                    lateFinish = this.getDateFromStartAndRemainingDuration(predecessorTask, lateStart);
                }
            } else {
                lateStart = successorTask.getActualFinish() == null ? (relation.getLag().getDuration() == 0.0 ? this.removeLag(relation, successorTask.getLateStart()) : (relation.getLag().getDuration() > 0.0 ? this.removeLag(relation, successorTask.getLateStart()) : this.removeLag(relation, successorTask.getLateStart()))) : (relation.getLag().getDuration() == 0.0 ? this.removeLag(relation, successorTask.getLateStart()) : (relation.getLag().getDuration() > 0.0 ? this.removeLag(relation, successorTask.getLateStart()) : this.removeLag(relation, successorTask.getLateStart())));
            }
        } else if (predecessorTask.getActualFinish() != null) {
            if (successorTask.getActualStart() == null) {
                if (relation.getLag().getDuration() == 0.0) {
                    lateStart = successorTask.getLateStart();
                } else if (relation.getLag().getDuration() > 0.0) {
                    double actualLagDurationInHours = predecessorTask.getActualStart().isAfter(this.m_dataDate) ? 0.0 : this.getLagCalendar(relation).getWork(predecessorTask.getActualStart(), this.m_dataDate, TimeUnit.HOURS).getDuration();
                    double lagDurationInHours = relation.getLag().convertUnits(TimeUnit.HOURS, this.m_file.getProjectProperties()).getDuration();
                    if (lagDurationInHours > actualLagDurationInHours) {
                        Duration remainingLag = Duration.getInstance(lagDurationInHours - actualLagDurationInHours, TimeUnit.HOURS);
                        lateStart = this.removeLag(relation, successorTask.getLateStart(), remainingLag);
                    } else {
                        lateStart = successorTask.getLateStart();
                    }
                } else {
                    lateStart = successorTask.getLateStart();
                }
            } else if (successorTask.getActualFinish() == null) {
                lateStart = relation.getLag().getDuration() == 0.0 ? successorTask.getLateStart() : (relation.getLag().getDuration() > 0.0 ? successorTask.getLateStart() : successorTask.getLateStart());
            } else if (relation.getLag().getDuration() == 0.0) {
                lateStart = successorTask.getLateStart();
            } else if (relation.getLag().getDuration() > 0.0) {
                double actualLagDurationInHours = predecessorTask.getActualStart().isAfter(this.m_dataDate) ? 0.0 : this.getLagCalendar(relation).getWork(predecessorTask.getActualStart(), this.m_dataDate, TimeUnit.HOURS).getDuration();
                double lagDurationInHours = relation.getLag().convertUnits(TimeUnit.HOURS, this.m_file.getProjectProperties()).getDuration();
                if (lagDurationInHours > actualLagDurationInHours) {
                    Duration remainingLag = Duration.getInstance(lagDurationInHours - actualLagDurationInHours, TimeUnit.HOURS);
                    lateStart = this.removeLag(relation, successorTask.getLateStart(), remainingLag);
                } else {
                    lateStart = successorTask.getLateStart();
                }
            } else {
                lateStart = successorTask.getLateStart();
            }
        } else if (successorTask.getActualStart() == null) {
            if (relation.getLag().getDuration() == 0.0) {
                lateStart = successorTask.getLateStart();
            } else if (relation.getLag().getDuration() > 0.0) {
                double lagDurationInHours;
                double actualDurationInHours = predecessorTask.getActualDuration().convertUnits(TimeUnit.HOURS, this.m_file.getProjectProperties()).getDuration();
                if (actualDurationInHours >= (lagDurationInHours = relation.getLag().convertUnits(TimeUnit.HOURS, this.m_file.getProjectProperties()).getDuration())) {
                    lateStart = successorTask.getLateStart();
                } else {
                    Duration remainingLag = Duration.getInstance(lagDurationInHours - actualDurationInHours, TimeUnit.HOURS);
                    lateStart = this.removeLag(relation, successorTask.getLateStart(), remainingLag);
                }
            } else {
                lateStart = successorTask.getLateStart();
            }
        } else if (successorTask.getActualFinish() == null) {
            if (relation.getLag().getDuration() == 0.0) {
                lateStart = successorTask.getLateStart();
            } else if (relation.getLag().getDuration() > 0.0) {
                double lagDurationInHours;
                double actualDurationInHours = predecessorTask.getActualDuration().convertUnits(TimeUnit.HOURS, this.m_file.getProjectProperties()).getDuration();
                if (actualDurationInHours >= (lagDurationInHours = relation.getLag().convertUnits(TimeUnit.HOURS, this.m_file.getProjectProperties()).getDuration())) {
                    lateStart = successorTask.getLateStart();
                } else {
                    Duration remainingLag = Duration.getInstance(lagDurationInHours - actualDurationInHours, TimeUnit.HOURS);
                    lateStart = this.removeLag(relation, successorTask.getLateStart(), remainingLag);
                }
            } else {
                lateStart = successorTask.getLateStart();
            }
        } else {
            lateStart = relation.getLag().getDuration() == 0.0 ? successorTask.getLateStart() : (relation.getLag().getDuration() > 0.0 ? successorTask.getLateStart() : successorTask.getLateStart());
        }
        if (lateFinish == null) {
            lateFinish = this.getDateFromStartAndRemainingDuration(predecessorTask, lateStart);
        }
        return lateFinish;
    }

    private LocalDateTime calculateLateFinishForFinishFinish(Relation relation) {
        Task predecessorTask = relation.getPredecessorTask();
        Task successorTask = relation.getSuccessorTask();
        if (predecessorTask.getActualStart() == null) {
            if (successorTask.getActualStart() == null) {
                if (relation.getLag().getDuration() == 0.0) {
                    return this.removeLag(relation, successorTask.getLateFinish());
                }
                if (relation.getLag().getDuration() > 0.0) {
                    return this.removeLag(relation, successorTask.getLateFinish());
                }
                return this.removeLag(relation, successorTask.getLateFinish());
            }
            if (successorTask.getActualFinish() == null) {
                if (relation.getLag().getDuration() == 0.0) {
                    return this.removeLag(relation, successorTask.getLateFinish());
                }
                if (relation.getLag().getDuration() > 0.0) {
                    return this.removeLag(relation, successorTask.getLateFinish());
                }
                return this.removeLag(relation, successorTask.getLateFinish());
            }
            if (relation.getLag().getDuration() == 0.0) {
                return this.removeLag(relation, successorTask.getLateFinish());
            }
            if (relation.getLag().getDuration() > 0.0) {
                return this.removeLag(relation, successorTask.getLateFinish());
            }
            return this.removeLag(relation, successorTask.getLateFinish());
        }
        if (predecessorTask.getActualFinish() != null) {
            if (successorTask.getActualStart() == null) {
                if (relation.getLag().getDuration() == 0.0) {
                    return successorTask.getLateFinish();
                }
                if (relation.getLag().getDuration() > 0.0) {
                    double actualLagDurationInHours = predecessorTask.getActualFinish().isAfter(this.m_dataDate) ? 0.0 : this.getLagCalendar(relation).getWork(predecessorTask.getActualFinish(), this.m_dataDate, TimeUnit.HOURS).getDuration();
                    double lagDurationInHours = relation.getLag().convertUnits(TimeUnit.HOURS, this.m_file.getProjectProperties()).getDuration();
                    if (lagDurationInHours > actualLagDurationInHours) {
                        Duration remainingLag = Duration.getInstance(lagDurationInHours - actualLagDurationInHours, TimeUnit.HOURS);
                        return this.removeLag(relation, successorTask.getLateFinish(), remainingLag);
                    }
                    return successorTask.getLateFinish();
                }
                return successorTask.getLateFinish();
            }
            if (successorTask.getActualFinish() == null) {
                if (relation.getLag().getDuration() == 0.0) {
                    return successorTask.getLateFinish();
                }
                if (relation.getLag().getDuration() > 0.0) {
                    return successorTask.getLateFinish();
                }
                return successorTask.getLateFinish();
            }
            if (relation.getLag().getDuration() == 0.0) {
                return successorTask.getLateFinish();
            }
            if (relation.getLag().getDuration() > 0.0) {
                double actualLagDurationInHours = predecessorTask.getActualFinish().isAfter(this.m_dataDate) ? 0.0 : this.getLagCalendar(relation).getWork(predecessorTask.getActualFinish(), this.m_dataDate, TimeUnit.HOURS).getDuration();
                double lagDurationInHours = relation.getLag().convertUnits(TimeUnit.HOURS, this.m_file.getProjectProperties()).getDuration();
                if (lagDurationInHours > actualLagDurationInHours) {
                    Duration remainingLag = Duration.getInstance(lagDurationInHours - actualLagDurationInHours, TimeUnit.HOURS);
                    return this.removeLag(relation, successorTask.getLateFinish(), remainingLag);
                }
                return successorTask.getLateFinish();
            }
            return successorTask.getLateFinish();
        }
        if (successorTask.getActualStart() == null) {
            if (relation.getLag().getDuration() == 0.0) {
                return this.removeLag(relation, successorTask.getLateFinish());
            }
            if (relation.getLag().getDuration() > 0.0) {
                return this.removeLag(relation, successorTask.getLateFinish());
            }
            return this.removeLag(relation, successorTask.getLateFinish());
        }
        if (successorTask.getActualFinish() == null) {
            if (relation.getLag().getDuration() == 0.0) {
                return this.removeLag(relation, successorTask.getLateFinish());
            }
            if (relation.getLag().getDuration() > 0.0) {
                return this.removeLag(relation, successorTask.getLateFinish());
            }
            return this.removeLag(relation, successorTask.getLateFinish());
        }
        if (relation.getLag().getDuration() == 0.0) {
            return this.removeLag(relation, successorTask.getLateFinish());
        }
        if (relation.getLag().getDuration() > 0.0) {
            return this.removeLag(relation, successorTask.getLateFinish());
        }
        return this.removeLag(relation, successorTask.getLateFinish());
    }

    private LocalDateTime calculateLateFinishForStartFinish(Relation relation) {
        Task predecessorTask = relation.getPredecessorTask();
        Task successorTask = relation.getSuccessorTask();
        if (predecessorTask.getActualStart() == null) {
            if (successorTask.getActualStart() == null) {
                if (relation.getLag().getDuration() == 0.0) {
                    return this.removeLag(relation, this.getDateFromStartAndDuration(predecessorTask, successorTask.getLateFinish()));
                }
                if (relation.getLag().getDuration() > 0.0) {
                    return this.removeLag(relation, this.getDateFromStartAndDuration(predecessorTask, successorTask.getLateFinish()));
                }
                return this.removeLag(relation, this.getDateFromStartAndDuration(predecessorTask, successorTask.getLateFinish()));
            }
            if (successorTask.getActualFinish() == null) {
                if (relation.getLag().getDuration() == 0.0) {
                    return this.removeLag(relation, this.getDateFromStartAndDuration(predecessorTask, successorTask.getLateFinish()));
                }
                if (relation.getLag().getDuration() > 0.0) {
                    return this.removeLag(relation, this.getDateFromStartAndDuration(predecessorTask, successorTask.getLateFinish()));
                }
                return this.removeLag(relation, this.getDateFromStartAndDuration(predecessorTask, successorTask.getLateFinish()));
            }
            if (relation.getLag().getDuration() == 0.0) {
                return this.removeLag(relation, this.getDateFromStartAndDuration(predecessorTask, successorTask.getLateFinish()));
            }
            if (relation.getLag().getDuration() > 0.0) {
                return this.removeLag(relation, this.getDateFromStartAndDuration(predecessorTask, successorTask.getLateFinish()));
            }
            return this.removeLag(relation, this.getDateFromStartAndDuration(predecessorTask, successorTask.getLateFinish()));
        }
        if (predecessorTask.getActualFinish() != null) {
            if (successorTask.getActualStart() == null) {
                if (relation.getLag().getDuration() == 0.0) {
                    return this.removeLag(relation, this.getDateFromStartAndDuration(predecessorTask, successorTask.getLateFinish()));
                }
                if (relation.getLag().getDuration() > 0.0) {
                    return this.removeLag(relation, this.getDateFromStartAndDuration(predecessorTask, successorTask.getLateFinish()));
                }
                return this.removeLag(relation, this.getDateFromStartAndDuration(predecessorTask, successorTask.getLateFinish()));
            }
            if (successorTask.getActualFinish() == null) {
                if (relation.getLag().getDuration() == 0.0) {
                    return this.removeLag(relation, this.getDateFromStartAndDuration(predecessorTask, successorTask.getLateFinish()));
                }
                if (relation.getLag().getDuration() > 0.0) {
                    return this.removeLag(relation, this.getDateFromStartAndDuration(predecessorTask, successorTask.getLateFinish()));
                }
                return this.removeLag(relation, this.getDateFromStartAndDuration(predecessorTask, successorTask.getLateFinish()));
            }
            if (relation.getLag().getDuration() == 0.0) {
                return successorTask.getLateFinish();
            }
            if (relation.getLag().getDuration() > 0.0) {
                return successorTask.getLateFinish();
            }
            return successorTask.getLateFinish();
        }
        if (successorTask.getActualStart() == null) {
            if (relation.getLag().getDuration() == 0.0) {
                return this.getDateFromStartAndRemainingDuration(predecessorTask, successorTask.getLateFinish());
            }
            if (relation.getLag().getDuration() > 0.0) {
                return this.getDateFromStartAndRemainingDuration(predecessorTask, successorTask.getLateFinish());
            }
            return this.getDateFromStartAndRemainingDuration(predecessorTask, successorTask.getLateFinish());
        }
        if (successorTask.getActualFinish() == null) {
            if (relation.getLag().getDuration() == 0.0) {
                return this.removeLag(relation, this.getDateFromStartAndDuration(predecessorTask, successorTask.getLateFinish()));
            }
            if (relation.getLag().getDuration() > 0.0) {
                return this.removeLag(relation, this.getDateFromStartAndDuration(predecessorTask, successorTask.getLateFinish()));
            }
            return this.removeLag(relation, this.getDateFromStartAndDuration(predecessorTask, successorTask.getLateFinish()));
        }
        if (relation.getLag().getDuration() == 0.0) {
            return this.getDateFromStartAndRemainingDuration(predecessorTask, successorTask.getLateFinish());
        }
        if (relation.getLag().getDuration() > 0.0) {
            double actualLagDurationInHours = predecessorTask.getActualStart().isAfter(this.m_dataDate) ? 0.0 : this.getLagCalendar(relation).getWork(predecessorTask.getActualStart(), this.m_dataDate, TimeUnit.HOURS).getDuration();
            double lagDurationInHours = relation.getLag().convertUnits(TimeUnit.HOURS, this.m_file.getProjectProperties()).getDuration();
            if (lagDurationInHours > actualLagDurationInHours) {
                Duration remainingLag = Duration.getInstance(lagDurationInHours - actualLagDurationInHours, TimeUnit.HOURS);
                return this.removeLag(relation, this.getDateFromStartAndDuration(predecessorTask, successorTask.getLateFinish()), remainingLag);
            }
            return this.getDateFromStartAndRemainingDuration(predecessorTask, successorTask.getLateFinish());
        }
        return this.getDateFromStartAndRemainingDuration(predecessorTask, successorTask.getLateFinish());
    }

    private LocalDateTime calculateLateFinishForFinishStart(Relation relation) {
        Task predecessorTask = relation.getPredecessorTask();
        Task successorTask = relation.getSuccessorTask();
        if (predecessorTask.getActualStart() == null) {
            if (successorTask.getActualStart() == null) {
                if (relation.getLag().getDuration() == 0.0) {
                    return this.removeLag(relation, successorTask.getLateStart());
                }
                if (relation.getLag().getDuration() > 0.0) {
                    return this.removeLag(relation, successorTask.getLateStart());
                }
                return this.removeLag(relation, successorTask.getLateStart());
            }
            if (successorTask.getActualFinish() == null) {
                if (relation.getLag().getDuration() == 0.0) {
                    return this.removeLag(relation, successorTask.getLateStart());
                }
                if (relation.getLag().getDuration() > 0.0) {
                    return this.removeLag(relation, successorTask.getLateStart());
                }
                return this.removeLag(relation, successorTask.getLateStart());
            }
            if (relation.getLag().getDuration() == 0.0) {
                return successorTask.getLateStart();
            }
            if (relation.getLag().getDuration() > 0.0) {
                return successorTask.getLateStart();
            }
            return successorTask.getLateStart();
        }
        if (predecessorTask.getActualFinish() != null) {
            if (successorTask.getActualStart() == null) {
                if (relation.getLag().getDuration() == 0.0) {
                    return successorTask.getLateStart();
                }
                if (relation.getLag().getDuration() > 0.0) {
                    double actualLagDurationInHours = predecessorTask.getActualFinish().isAfter(this.m_dataDate) ? 0.0 : this.getLagCalendar(relation).getWork(predecessorTask.getActualFinish(), this.m_dataDate, TimeUnit.HOURS).getDuration();
                    double lagDurationInHours = relation.getLag().convertUnits(TimeUnit.HOURS, this.m_file.getProjectProperties()).getDuration();
                    if (lagDurationInHours > actualLagDurationInHours) {
                        Duration remainingLag = Duration.getInstance(lagDurationInHours - actualLagDurationInHours, TimeUnit.HOURS);
                        return this.removeLag(relation, successorTask.getLateStart(), remainingLag);
                    }
                    return successorTask.getLateStart();
                }
                return successorTask.getLateStart();
            }
            if (successorTask.getActualFinish() == null) {
                if (relation.getLag().getDuration() == 0.0) {
                    return successorTask.getLateStart();
                }
                if (relation.getLag().getDuration() > 0.0) {
                    if (successorTask.getActualDuration().getDuration() == 0.0) {
                        return this.removeLag(relation, successorTask.getLateStart());
                    }
                    return successorTask.getLateStart();
                }
                if (successorTask.getActualDuration().getDuration() == 0.0) {
                    return this.removeLag(relation, successorTask.getLateStart());
                }
                return successorTask.getLateStart();
            }
            if (relation.getLag().getDuration() == 0.0) {
                return successorTask.getLateStart();
            }
            if (relation.getLag().getDuration() > 0.0) {
                double actualLagDurationInHours = predecessorTask.getActualFinish().isAfter(this.m_dataDate) ? 0.0 : this.getLagCalendar(relation).getWork(predecessorTask.getActualFinish(), this.m_dataDate, TimeUnit.HOURS).getDuration();
                double lagDurationInHours = relation.getLag().convertUnits(TimeUnit.HOURS, this.m_file.getProjectProperties()).getDuration();
                if (lagDurationInHours > actualLagDurationInHours) {
                    Duration remainingLag = Duration.getInstance(lagDurationInHours - actualLagDurationInHours, TimeUnit.HOURS);
                    return this.removeLag(relation, successorTask.getLateStart(), remainingLag);
                }
                return successorTask.getLateStart();
            }
            return successorTask.getLateStart();
        }
        if (successorTask.getActualStart() == null) {
            if (relation.getLag().getDuration() == 0.0) {
                return this.removeLag(relation, successorTask.getLateStart());
            }
            if (relation.getLag().getDuration() > 0.0) {
                return this.removeLag(relation, successorTask.getLateStart());
            }
            return this.removeLag(relation, successorTask.getLateStart());
        }
        if (successorTask.getActualFinish() == null) {
            if (relation.getLag().getDuration() == 0.0) {
                if (successorTask.getActualDuration().getDuration() == 0.0) {
                    return this.removeLag(relation, successorTask.getLateStart());
                }
                return successorTask.getLateStart();
            }
            if (relation.getLag().getDuration() > 0.0) {
                if (successorTask.getActualDuration().getDuration() == 0.0) {
                    return this.removeLag(relation, successorTask.getLateStart());
                }
                return successorTask.getLateStart();
            }
            if (successorTask.getActualDuration().getDuration() == 0.0) {
                return this.removeLag(relation, successorTask.getLateStart());
            }
            return successorTask.getLateStart();
        }
        if (relation.getLag().getDuration() == 0.0) {
            return successorTask.getLateStart();
        }
        if (relation.getLag().getDuration() > 0.0) {
            return successorTask.getLateStart();
        }
        return successorTask.getLateStart();
    }

    private ProjectCalendar getLagCalendar(Relation relation) {
        switch (this.m_file.getProjectProperties().getRelationshipLagCalendar()) {
            case PREDECESSOR: {
                return relation.getPredecessorTask().getEffectiveCalendar();
            }
            case SUCCESSOR: {
                return relation.getSuccessorTask().getEffectiveCalendar();
            }
            case PROJECT_DEFAULT: {
                return this.m_file.getProjectProperties().getDefaultCalendar();
            }
        }
        return this.m_twentyFourHourCalendar;
    }

    private LocalDateTime getDate(ProjectCalendar calendar, LocalDateTime date, Duration duration) {
        LocalDateTime result = calendar.getDate(date, duration);
        if (result.getSecond() != 0) {
            boolean negativeDuration = duration.getDuration() < 0.0;
            boolean roundUp = negativeDuration && result.getSecond() > 30 || !negativeDuration && result.getSecond() >= 30;
            LocalTime newTime = LocalTime.of(result.getHour(), result.getMinute());
            result = LocalDateTime.of(result.toLocalDate(), newTime);
            if (roundUp) {
                result = result.plusMinutes(1L);
            }
        }
        return result;
    }

    private boolean useTaskEffectiveCalendar(Task task) {
        return task.getActivityType() != ActivityType.RESOURCE_DEPENDENT || task.getResourceAssignments().stream().noneMatch(r -> r.getResource().getType() == ResourceType.WORK);
    }

    private LocalDateTime getDateFromStartAndDuration(Task task, LocalDateTime date) {
        if (this.useTaskEffectiveCalendar(task)) {
            return this.getDate(task.getEffectiveCalendar(), date, task.getDuration());
        }
        return this.getDateFromStartAndWork(task, date);
    }

    private LocalDateTime getDateFromStartAndWork(Task task, LocalDateTime date) {
        return this.getResourceAssignmentStream(task).map(r -> this.getDateFromWork((ResourceAssignment)r, date, r.getWork())).max(Comparator.naturalOrder()).orElseGet(null);
    }

    private LocalDateTime getDateFromFinishAndDuration(Task task, LocalDateTime date) {
        if (this.useTaskEffectiveCalendar(task)) {
            return this.getDate(task.getEffectiveCalendar(), date, task.getDuration().negate());
        }
        return this.getDateFromFinishAndWork(task, date);
    }

    private LocalDateTime getDateFromFinishAndWork(Task task, LocalDateTime date) {
        return this.getResourceAssignmentStream(task).map(r -> this.getDateFromWork((ResourceAssignment)r, date, r.getWork().negate())).min(Comparator.naturalOrder()).orElseGet(null);
    }

    private LocalDateTime getDateFromStartAndRemainingDuration(Task task, LocalDateTime date) {
        if (this.useTaskEffectiveCalendar(task)) {
            return this.getDate(task.getEffectiveCalendar(), date, task.getRemainingDuration());
        }
        return this.getDateFromStartAndRemainingWork(task, date);
    }

    private LocalDateTime getDateFromStartAndRemainingWork(Task task, LocalDateTime date) {
        return this.getResourceAssignmentStream(task).map(r -> this.getDateFromWork((ResourceAssignment)r, date, r.getRemainingWork())).max(Comparator.naturalOrder()).orElseGet(null);
    }

    private LocalDateTime getDateFromFinishAndRemainingDuration(Task task, LocalDateTime date) {
        if (this.useTaskEffectiveCalendar(task)) {
            return this.getDate(task.getEffectiveCalendar(), date, task.getRemainingDuration().negate());
        }
        return this.getDateFromFinishAndRemainingWork(task, date);
    }

    private LocalDateTime getDateFromFinishAndRemainingWork(Task task, LocalDateTime date) {
        return this.getResourceAssignmentStream(task).map(r -> this.getDateFromWork((ResourceAssignment)r, date, r.getRemainingWork().negate())).min(Comparator.naturalOrder()).orElseGet(null);
    }

    private LocalDateTime addLag(Relation relation, LocalDateTime date) {
        return this.addLag(relation, date, relation.getLag());
    }

    private LocalDateTime addLag(Relation relation, LocalDateTime date, Duration lag) {
        if (date == null) {
            return null;
        }
        LocalDateTime result = this.getDate(this.getLagCalendar(relation), date, lag);
        if (lag.getDuration() < 0.0 && result.isBefore(this.m_dataDate)) {
            result = this.m_dataDate;
        }
        return result;
    }

    private LocalDateTime removeLag(Relation relation, LocalDateTime date) {
        return this.removeLag(relation, date, relation.getLag());
    }

    private LocalDateTime removeLag(Relation relation, LocalDateTime date, Duration lag) {
        if (date == null) {
            return null;
        }
        return this.getDate(this.getLagCalendar(relation), date, lag.negate());
    }

    static boolean isActivity(Task task) {
        return !task.getSummary() && task.getActivityType() != ActivityType.LEVEL_OF_EFFORT && task.getActivityType() != ActivityType.WBS_SUMMARY;
    }

    static boolean isLevelOfEffortActivity(Task task) {
        return task.getActivityType() == ActivityType.LEVEL_OF_EFFORT;
    }

    static boolean isWbsSummary(Task task) {
        return task.getActivityType() == ActivityType.WBS_SUMMARY;
    }

    private void alapAdjust(Task task) throws CpmException {
        LocalDateTime earlyStart;
        LocalDateTime earlyFinish;
        List successors = task.getSuccessors().stream().filter(r -> PrimaveraScheduler.isActivity(r.getSuccessorTask())).collect(Collectors.toList());
        if (successors.isEmpty()) {
            earlyFinish = this.m_projectFinishDate;
            earlyStart = this.getDateFromFinishAndRemainingDuration(task, earlyFinish);
        } else {
            Relation relation = successors.stream().min(Comparator.comparing(this::getAlapEarlyStart)).orElseThrow(() -> new CpmException("Missing early start date"));
            earlyStart = this.getAlapEarlyStart(relation);
            earlyFinish = this.getDateFromStartAndRemainingDuration(task, earlyStart);
        }
        task.setEarlyStart(earlyStart);
        task.setEarlyFinish(earlyFinish);
        this.setRemainingEarlyDates(task);
    }

    private LocalDateTime getAlapEarlyStart(Relation relation) {
        Task predecessorTask = relation.getPredecessorTask();
        Task successorTask = relation.getSuccessorTask();
        switch (relation.getType()) {
            case START_START: {
                return this.removeLag(relation, successorTask.getEarlyStart());
            }
            case FINISH_START: {
                if (predecessorTask.getActualStart() == null) {
                    if (successorTask.getActualStart() == null) {
                        return this.removeLag(relation, this.getDateFromFinishAndRemainingDuration(predecessorTask, successorTask.getEarlyStart()));
                    }
                    if (successorTask.getActualFinish() == null) {
                        return this.removeLag(relation, this.getDateFromFinishAndRemainingDuration(predecessorTask, successorTask.getEarlyStart()));
                    }
                    return this.removeLag(relation, this.getDateFromFinishAndRemainingDuration(predecessorTask, successorTask.getEarlyStart()));
                }
                if (predecessorTask.getActualFinish() == null) {
                    if (successorTask.getActualStart() == null) {
                        return this.removeLag(relation, this.getDateFromFinishAndRemainingDuration(predecessorTask, successorTask.getEarlyStart()));
                    }
                    if (successorTask.getActualFinish() == null) {
                        return this.removeLag(relation, this.getDateFromFinishAndRemainingDuration(predecessorTask, successorTask.getEarlyStart()));
                    }
                    return this.removeLag(relation, this.getDateFromFinishAndRemainingDuration(predecessorTask, successorTask.getEarlyStart()));
                }
                if (successorTask.getActualStart() == null) {
                    return this.getEquivalentNextWorkStart(predecessorTask, this.m_dataDate);
                }
                if (successorTask.getActualFinish() == null) {
                    return this.getEquivalentNextWorkStart(predecessorTask, this.m_dataDate);
                }
                return this.m_dataDate;
            }
            case FINISH_FINISH: {
                LocalDateTime earlyFinish = this.removeLag(relation, successorTask.getEarlyFinish());
                return this.getDateFromFinishAndRemainingDuration(predecessorTask, earlyFinish);
            }
        }
        return LocalDateTime.MAX;
    }

    private void setRemainingEarlyDates(Task task) {
        if (task.getActualFinish() != null) {
            return;
        }
        LocalDateTime remainingEarlyStart = task.getActualStart() == null ? task.getEarlyStart() : (task.getActualDuration() != null && task.getActualDuration().getDuration() != 0.0 ? task.getEarlyStart() : (task.getActualDuration() == null || task.getActualDuration().getDuration() == 0.0 || task.getActualStart().isAfter(this.m_dataDate) ? task.getEarlyStart() : this.getNextWorkStart(task, this.m_dataDate)));
        task.setRemainingEarlyStart(remainingEarlyStart);
        task.setRemainingEarlyFinish(this.getDateFromStartAndRemainingDuration(task, remainingEarlyStart));
    }

    private void setRemainingLateDates(Task task) {
        if (task.getActualFinish() != null) {
            return;
        }
        task.setRemainingLateStart(task.getLateStart());
        task.setRemainingLateFinish(task.getLateFinish());
    }

    private ProjectCalendar createTwentyFourHourCalendar() {
        ProjectCalendar calendar = new ProjectCalendar(this.m_file);
        for (DayOfWeek day : DayOfWeek.values()) {
            calendar.setCalendarDayType(day, DayType.WORKING);
            ProjectCalendarHours hours = calendar.addCalendarHours(day);
            hours.add(new LocalTimeRange(LocalTime.MIDNIGHT, LocalTime.MIDNIGHT));
        }
        return calendar;
    }

    private void clearDates() {
        for (Task task : this.m_file.getTasks()) {
            task.setStart(null);
            task.setFinish(null);
            task.setEarlyStart(null);
            task.setEarlyFinish(null);
            task.setLateStart(null);
            task.setLateFinish(null);
            task.setRemainingEarlyStart(null);
            task.setRemainingEarlyFinish(null);
            task.setRemainingLateStart(null);
            task.setRemainingLateFinish(null);
            task.set((FieldType)TaskField.CRITICAL, null);
        }
    }

    private void rollupDates(Task parentTask) {
        if (!parentTask.hasChildTasks()) {
            return;
        }
        int finished = 0;
        LocalDateTime startDate = parentTask.getStart();
        LocalDateTime finishDate = parentTask.getFinish();
        LocalDateTime plannedStartDate = parentTask.getPlannedStart();
        LocalDateTime plannedFinishDate = parentTask.getPlannedFinish();
        LocalDateTime actualStartDate = parentTask.getActualStart();
        LocalDateTime actualFinishDate = parentTask.getActualFinish();
        LocalDateTime earlyStartDate = parentTask.getEarlyStart();
        LocalDateTime earlyFinishDate = parentTask.getEarlyFinish();
        LocalDateTime lateStartDate = parentTask.getLateStart();
        LocalDateTime lateFinishDate = parentTask.getLateFinish();
        LocalDateTime baselineStartDate = parentTask.getBaselineStart();
        LocalDateTime baselineFinishDate = parentTask.getBaselineFinish();
        LocalDateTime remainingEarlyStartDate = parentTask.getRemainingEarlyStart();
        LocalDateTime remainingEarlyFinishDate = parentTask.getRemainingEarlyFinish();
        LocalDateTime remainingLateStartDate = parentTask.getRemainingLateStart();
        LocalDateTime remainingLateFinishDate = parentTask.getRemainingLateFinish();
        boolean critical = false;
        for (Task task : parentTask.getChildTasks()) {
            this.rollupDates(task);
            startDate = LocalDateTimeHelper.min(startDate, task.getStart());
            finishDate = LocalDateTimeHelper.max(finishDate, task.getFinish());
            plannedStartDate = LocalDateTimeHelper.min(plannedStartDate, task.getPlannedStart());
            plannedFinishDate = LocalDateTimeHelper.max(plannedFinishDate, task.getPlannedFinish());
            actualStartDate = LocalDateTimeHelper.min(actualStartDate, task.getActualStart());
            actualFinishDate = LocalDateTimeHelper.max(actualFinishDate, task.getActualFinish());
            baselineStartDate = LocalDateTimeHelper.min(baselineStartDate, task.getBaselineStart());
            baselineFinishDate = LocalDateTimeHelper.max(baselineFinishDate, task.getBaselineFinish());
            if (task.getActivityType() != ActivityType.LEVEL_OF_EFFORT || task.getActualFinish() == null) {
                earlyStartDate = LocalDateTimeHelper.min(earlyStartDate, task.getEarlyStart());
                earlyFinishDate = LocalDateTimeHelper.max(earlyFinishDate, task.getEarlyFinish());
                remainingEarlyStartDate = LocalDateTimeHelper.min(remainingEarlyStartDate, task.getRemainingEarlyStart());
                remainingEarlyFinishDate = LocalDateTimeHelper.max(remainingEarlyFinishDate, task.getRemainingEarlyFinish());
                lateStartDate = LocalDateTimeHelper.min(lateStartDate, task.getLateStart());
                lateFinishDate = LocalDateTimeHelper.max(lateFinishDate, task.getLateFinish());
                remainingLateStartDate = LocalDateTimeHelper.min(remainingLateStartDate, task.getRemainingLateStart());
                remainingLateFinishDate = LocalDateTimeHelper.max(remainingLateFinishDate, task.getRemainingLateFinish());
            }
            if (task.getActualFinish() != null) {
                ++finished;
            }
            critical = critical || task.getCritical();
        }
        parentTask.setStart(startDate);
        parentTask.setFinish(finishDate);
        parentTask.setPlannedStart(plannedStartDate);
        parentTask.setPlannedFinish(plannedFinishDate);
        parentTask.setActualStart(actualStartDate);
        parentTask.setEarlyStart(earlyStartDate);
        parentTask.setEarlyFinish(earlyFinishDate);
        parentTask.setRemainingEarlyStart(remainingEarlyStartDate);
        parentTask.setRemainingEarlyFinish(remainingEarlyFinishDate);
        parentTask.setLateStart(lateStartDate);
        parentTask.setLateFinish(lateFinishDate);
        parentTask.setRemainingLateStart(remainingLateStartDate);
        parentTask.setRemainingLateFinish(remainingLateFinishDate);
        parentTask.setBaselineStart(baselineStartDate);
        parentTask.setBaselineFinish(baselineFinishDate);
        if (finished == parentTask.getChildTasks().size()) {
            parentTask.setActualFinish(actualFinishDate);
        }
        Duration plannedDuration = null;
        if (plannedStartDate != null && plannedFinishDate != null) {
            plannedDuration = parentTask.getEffectiveCalendar().getWork(plannedStartDate, plannedFinishDate, TimeUnit.HOURS);
            parentTask.setPlannedDuration(plannedDuration);
        }
        Duration actualDuration = null;
        Duration remainingDuration = null;
        if (parentTask.getActualFinish() == null) {
            LocalDateTime taskFinishDate;
            LocalDateTime taskStartDate = parentTask.getRemainingEarlyStart();
            if (taskStartDate == null && (taskStartDate = parentTask.getEarlyStart()) == null) {
                taskStartDate = plannedStartDate;
            }
            if ((taskFinishDate = parentTask.getRemainingEarlyFinish()) == null && (taskFinishDate = parentTask.getEarlyFinish()) == null) {
                taskFinishDate = plannedFinishDate;
            }
            if (taskStartDate != null) {
                if (parentTask.getActualStart() != null) {
                    actualDuration = parentTask.getEffectiveCalendar().getWork(parentTask.getActualStart(), taskStartDate, TimeUnit.HOURS);
                }
                if (taskFinishDate != null) {
                    remainingDuration = parentTask.getEffectiveCalendar().getWork(taskStartDate, taskFinishDate, TimeUnit.HOURS);
                }
            }
        } else {
            actualDuration = parentTask.getEffectiveCalendar().getWork(parentTask.getActualStart(), parentTask.getActualFinish(), TimeUnit.HOURS);
            remainingDuration = Duration.getInstance(0, TimeUnit.HOURS);
        }
        if (actualDuration != null && actualDuration.getDuration() < 0.0) {
            actualDuration = null;
        }
        if (remainingDuration != null && remainingDuration.getDuration() < 0.0) {
            remainingDuration = null;
        }
        parentTask.setActualDuration(actualDuration);
        parentTask.setRemainingDuration(remainingDuration);
        parentTask.setDuration(Duration.add(actualDuration, remainingDuration, parentTask.getEffectiveCalendar()));
        if (plannedDuration != null && remainingDuration != null && plannedDuration.getDuration() != 0.0) {
            double durationPercentComplete = (plannedDuration.getDuration() - remainingDuration.getDuration()) / plannedDuration.getDuration() * 100.0;
            if (durationPercentComplete < 0.0) {
                durationPercentComplete = 0.0;
            } else if (durationPercentComplete > 100.0) {
                durationPercentComplete = 100.0;
            }
            parentTask.setPercentageComplete(durationPercentComplete);
            parentTask.setPercentCompleteType(PercentCompleteType.DURATION);
        }
        parentTask.getTotalSlack();
        parentTask.setCritical(critical);
    }

    private void levelOfEffortPass() throws CpmException {
        List<Task> activities = new DepthFirstGraphSort(this.m_file, PrimaveraScheduler::isLevelOfEffortActivity).sort();
        if (activities.isEmpty()) {
            return;
        }
        for (Task activity : activities) {
            this.levelOfEffortPass(activity);
        }
    }

    private void levelOfEffortPass(Task task) {
        AnnotatedDateTime lateStart;
        AnnotatedDateTime lateFinish;
        AnnotatedDateTime earlyFinish;
        AnnotatedDateTime earlyStart;
        task.setActualStart(null);
        task.setActualFinish(null);
        AnnotatedDateTime earlyStartFromPredecessor = null;
        AnnotatedDateTime earlyFinishFromPredecessor = null;
        AnnotatedDateTime lateStartFromPredecessor = null;
        AnnotatedDateTime lateFinishFromPredecessor = null;
        for (Relation relation : task.getPredecessors()) {
            Task predecessor = relation.getPredecessorTask();
            switch (relation.getType()) {
                case START_START: {
                    if (predecessor.getActualStart() == null) {
                        earlyStartFromPredecessor = this.updateIfBefore(earlyStartFromPredecessor, AnnotatedDateTime.from(this.addLag(relation, predecessor.getEarlyStart())));
                        lateStartFromPredecessor = this.updateIfBefore(lateStartFromPredecessor, AnnotatedDateTime.from(this.addLag(relation, predecessor.getLateStart())));
                        break;
                    }
                    earlyStartFromPredecessor = this.updateIfBefore(earlyStartFromPredecessor, AnnotatedDateTime.fromActual(this.addLag(relation, predecessor.getActualStart())));
                    lateStartFromPredecessor = this.updateIfBefore(lateStartFromPredecessor, AnnotatedDateTime.from(this.addLag(relation, predecessor.getLateStart())));
                    break;
                }
                case FINISH_START: {
                    if (predecessor.getActualFinish() == null) {
                        earlyStartFromPredecessor = this.updateIfBefore(earlyStartFromPredecessor, AnnotatedDateTime.from(this.addLag(relation, predecessor.getEarlyFinish())));
                        lateStartFromPredecessor = this.updateIfBefore(lateStartFromPredecessor, AnnotatedDateTime.from(this.addLag(relation, predecessor.getLateFinish())));
                        break;
                    }
                    earlyStartFromPredecessor = this.updateIfBefore(earlyStartFromPredecessor, AnnotatedDateTime.fromActual(this.addLag(relation, predecessor.getActualFinish())));
                    lateStartFromPredecessor = this.updateIfBefore(lateStartFromPredecessor, AnnotatedDateTime.fromActual(this.addLag(relation, predecessor.getActualFinish())));
                    break;
                }
                case START_FINISH: {
                    if (predecessor.getActualStart() == null) {
                        earlyFinishFromPredecessor = this.updateIfAfter(earlyFinishFromPredecessor, AnnotatedDateTime.from(this.adjustFinish(task, this.addLag(relation, predecessor.getEarlyStart()))));
                        lateFinishFromPredecessor = this.updateIfAfter(lateFinishFromPredecessor, AnnotatedDateTime.from(this.adjustFinish(task, this.addLag(relation, predecessor.getLateStart()))));
                        break;
                    }
                    earlyFinishFromPredecessor = this.updateIfAfter(earlyFinishFromPredecessor, AnnotatedDateTime.fromActual(this.addLag(relation, predecessor.getActualStart())));
                    lateFinishFromPredecessor = this.updateIfAfter(lateFinishFromPredecessor, AnnotatedDateTime.fromActual(this.addLag(relation, predecessor.getActualStart())));
                    break;
                }
                case FINISH_FINISH: {
                    if (predecessor.getActualFinish() == null) {
                        earlyFinishFromPredecessor = this.updateIfAfter(earlyFinishFromPredecessor, AnnotatedDateTime.from(this.adjustFinish(task, this.addLag(relation, predecessor.getEarlyFinish()))));
                        lateFinishFromPredecessor = this.updateIfAfter(lateFinishFromPredecessor, AnnotatedDateTime.from(this.adjustFinish(task, this.addLag(relation, predecessor.getLateFinish()))));
                        break;
                    }
                    earlyFinishFromPredecessor = this.updateIfAfter(earlyFinishFromPredecessor, AnnotatedDateTime.fromActual(this.addLag(relation, predecessor.getActualFinish())));
                    lateFinishFromPredecessor = this.updateIfAfter(lateFinishFromPredecessor, AnnotatedDateTime.fromActual(this.addLag(relation, predecessor.getActualFinish())));
                }
            }
        }
        AnnotatedDateTime earlyStartFromSuccessor = null;
        AnnotatedDateTime earlyFinishFromSuccessor = null;
        AnnotatedDateTime lateStartFromSuccessor = null;
        AnnotatedDateTime lateFinishFromSuccessor = null;
        for (Relation relation : task.getSuccessors()) {
            Task successor = relation.getSuccessorTask();
            switch (relation.getType()) {
                case START_START: {
                    if (successor.getActualStart() == null) {
                        earlyStartFromSuccessor = this.updateIfBefore(earlyStartFromSuccessor, AnnotatedDateTime.from(this.removeLag(relation, successor.getEarlyStart())));
                        lateStartFromSuccessor = this.updateIfBefore(lateStartFromSuccessor, AnnotatedDateTime.from(this.removeLag(relation, successor.getLateStart())));
                        break;
                    }
                    earlyStartFromSuccessor = this.updateIfBefore(earlyStartFromSuccessor, AnnotatedDateTime.fromActual(this.removeLag(relation, successor.getActualStart())));
                    lateStartFromSuccessor = this.updateIfBefore(lateStartFromSuccessor, AnnotatedDateTime.fromActual(this.removeLag(relation, successor.getActualStart())));
                    break;
                }
                case FINISH_START: {
                    if (successor.getActualStart() == null) {
                        earlyFinishFromSuccessor = this.updateIfAfter(earlyFinishFromSuccessor, AnnotatedDateTime.from(this.adjustFinish(task, this.removeLag(relation, successor.getEarlyStart()))));
                        lateFinishFromSuccessor = this.updateIfAfter(lateFinishFromSuccessor, AnnotatedDateTime.from(this.adjustFinish(task, this.removeLag(relation, successor.getLateStart()))));
                        break;
                    }
                    earlyFinishFromSuccessor = this.updateIfAfter(earlyFinishFromSuccessor, AnnotatedDateTime.fromActual(this.removeLag(relation, successor.getActualStart())));
                    lateFinishFromSuccessor = this.updateIfAfter(lateFinishFromSuccessor, AnnotatedDateTime.fromActual(this.removeLag(relation, successor.getActualStart())));
                    break;
                }
                case START_FINISH: {
                    if (successor.getActualFinish() == null) {
                        earlyStartFromSuccessor = this.updateIfBefore(earlyStartFromSuccessor, AnnotatedDateTime.from(this.removeLag(relation, successor.getEarlyFinish())));
                        lateStartFromSuccessor = this.updateIfBefore(lateStartFromSuccessor, AnnotatedDateTime.from(this.removeLag(relation, successor.getLateFinish())));
                        break;
                    }
                    earlyStartFromSuccessor = this.updateIfBefore(earlyStartFromSuccessor, AnnotatedDateTime.fromActual(this.removeLag(relation, successor.getActualFinish())));
                    lateStartFromSuccessor = this.updateIfBefore(lateStartFromSuccessor, AnnotatedDateTime.fromActual(this.removeLag(relation, successor.getActualFinish())));
                    break;
                }
                case FINISH_FINISH: {
                    if (successor.getActualFinish() == null) {
                        earlyFinishFromSuccessor = this.updateIfAfter(earlyFinishFromSuccessor, AnnotatedDateTime.from(this.adjustFinish(task, this.removeLag(relation, successor.getEarlyFinish()))));
                        lateFinishFromSuccessor = this.updateIfAfter(lateFinishFromSuccessor, AnnotatedDateTime.from(this.adjustFinish(task, this.removeLag(relation, successor.getLateFinish()))));
                        break;
                    }
                    earlyFinishFromSuccessor = this.updateIfAfter(earlyFinishFromSuccessor, AnnotatedDateTime.fromActual(this.removeLag(relation, successor.getActualFinish())));
                    lateFinishFromSuccessor = this.updateIfAfter(lateFinishFromSuccessor, AnnotatedDateTime.fromActual(this.removeLag(relation, successor.getActualFinish())));
                }
            }
        }
        if (earlyStartFromPredecessor == null && earlyStartFromSuccessor == null) {
            earlyStart = AnnotatedDateTime.from(this.getNextWorkStart(task, this.m_dataDate));
        } else if (earlyStartFromPredecessor != null && earlyStartFromSuccessor != null) {
            earlyStart = earlyStartFromPredecessor.isBefore(earlyStartFromSuccessor) ? earlyStartFromPredecessor : earlyStartFromSuccessor;
        } else {
            AnnotatedDateTime annotatedDateTime = earlyStart = earlyStartFromPredecessor == null ? earlyStartFromSuccessor : earlyStartFromPredecessor;
        }
        if (earlyFinishFromPredecessor == null && earlyFinishFromSuccessor == null) {
            earlyFinish = earlyStart;
        } else if (earlyFinishFromPredecessor != null && earlyFinishFromSuccessor != null) {
            earlyFinish = earlyFinishFromSuccessor.isAfter(earlyFinishFromPredecessor) ? earlyFinishFromSuccessor : earlyFinishFromPredecessor;
        } else {
            AnnotatedDateTime annotatedDateTime = earlyFinish = earlyFinishFromPredecessor == null ? earlyFinishFromSuccessor : earlyFinishFromPredecessor;
        }
        if (lateFinishFromPredecessor == null && lateFinishFromSuccessor == null) {
            lateFinish = AnnotatedDateTime.from(this.m_projectFinishDate);
        } else if (lateFinishFromPredecessor != null && lateFinishFromSuccessor != null) {
            lateFinish = lateFinishFromSuccessor.isAfter(lateFinishFromPredecessor) ? lateFinishFromSuccessor : lateFinishFromPredecessor;
        } else {
            AnnotatedDateTime annotatedDateTime = lateFinish = lateFinishFromPredecessor == null ? lateFinishFromSuccessor : lateFinishFromPredecessor;
        }
        if (lateStartFromPredecessor == null && lateStartFromSuccessor == null) {
            lateStart = lateFinish;
        } else if (lateStartFromPredecessor != null && lateStartFromSuccessor != null) {
            lateStart = lateStartFromPredecessor.isBefore(lateStartFromSuccessor) ? lateStartFromPredecessor : lateStartFromSuccessor;
        } else {
            AnnotatedDateTime annotatedDateTime = lateStart = lateStartFromPredecessor == null ? lateStartFromSuccessor : lateStartFromPredecessor;
        }
        if (earlyStart == null || earlyFinish == null || lateStart == null || lateFinish == null) {
            return;
        }
        AnnotatedDateTime start = earlyStart;
        if (earlyStart.isBefore(this.m_dataDate)) {
            if (earlyStart.isActual()) {
                earlyStart = AnnotatedDateTime.fromActual(this.m_dataDate);
            } else {
                earlyStart = AnnotatedDateTime.from(this.getNextWorkStart(task, this.m_dataDate));
                start = AnnotatedDateTime.fromActual(start.getValue());
                task.setActualStart(start.getValue());
            }
        }
        if (!earlyFinish.isActual()) {
            if (earlyFinish.isBefore(this.m_dataDate)) {
                earlyFinish = AnnotatedDateTime.from(this.m_dataDate);
            }
            if (earlyFinish.isBefore(earlyStart)) {
                earlyFinish = earlyFinish.isActual() ? AnnotatedDateTime.fromActual(earlyStart.getValue()) : earlyStart;
            }
        }
        if (lateStart.isAfter(lateFinish)) {
            lateStart = lateFinish;
        }
        task.setStart(start.isActual() ? start.getValue() : earlyStart.getValue());
        task.setFinish(earlyFinish.getValue());
        if (earlyStart.isActual() && task.getCalendar().getWork(this.m_dataDate, task.getStart(), TimeUnit.HOURS).getDuration() <= 0.0) {
            task.setActualStart(task.getStart());
        }
        if ((earlyFinish.isActual() || lateFinish.isActual()) && task.getCalendar().getWork(this.m_dataDate, task.getFinish(), TimeUnit.HOURS).getDuration() <= 0.0) {
            task.setActualStart(task.getStart());
            task.setActualFinish(task.getFinish());
        }
        task.setEarlyStart(earlyStart.getValue());
        task.setEarlyFinish(earlyFinish.getValue());
        task.setLateStart(lateStart.getValue());
        task.setLateFinish(lateFinish.getValue());
        if (task.getActualStart() == null || task.getActualFinish() == null) {
            task.setRemainingEarlyStart(earlyStart.getValue());
            task.setRemainingEarlyFinish(earlyFinish.getValue());
            task.setRemainingLateStart(lateStart.getValue());
            task.setRemainingLateFinish(lateFinish.getValue());
        }
    }

    private AnnotatedDateTime updateIfBefore(AnnotatedDateTime currentDate, AnnotatedDateTime newDate) {
        if (currentDate == null) {
            return newDate;
        }
        return newDate.isBefore(currentDate) ? newDate : currentDate;
    }

    private AnnotatedDateTime updateIfAfter(AnnotatedDateTime currentDate, AnnotatedDateTime newDate) {
        if (currentDate == null) {
            return newDate;
        }
        return newDate.isAfter(currentDate) ? newDate : currentDate;
    }

    private LocalDateTime adjustFinish(Task task, LocalDateTime finish) {
        LocalDateTime previousWorkFinish;
        if (finish == null) {
            return null;
        }
        ProjectCalendar calendar = task.getEffectiveCalendar();
        if (calendar.getWork(previousWorkFinish = calendar.getPreviousWorkFinish(finish), finish, TimeUnit.HOURS).getDuration() == 0.0) {
            return previousWorkFinish;
        }
        return finish;
    }

    private void wbsSummaryPass() {
        List activities = this.m_file.getTasks().stream().filter(PrimaveraScheduler::isWbsSummary).collect(Collectors.toList());
        if (activities.isEmpty()) {
            return;
        }
        for (Task activity : activities) {
            this.wbsSummaryPass(activity);
        }
    }

    private void wbsSummaryPass(Task task) {
        Task wbs = task.getParentTask();
        if (wbs == null) {
            return;
        }
        task.setStart(wbs.getStart());
        task.setFinish(wbs.getFinish());
        task.setActualStart(wbs.getActualStart());
        task.setActualFinish(wbs.getActualFinish());
        List<Task> childTasks = this.allWbsChildTasks(wbs, new ArrayList<Task>());
        task.setEarlyStart(childTasks.stream().map(Task::getEarlyStart).filter(Objects::nonNull).min(Comparator.naturalOrder()).orElse(null));
        task.setEarlyFinish(childTasks.stream().map(Task::getEarlyFinish).filter(Objects::nonNull).max(Comparator.naturalOrder()).orElse(null));
        task.setRemainingEarlyStart(childTasks.stream().map(Task::getRemainingEarlyStart).filter(Objects::nonNull).min(Comparator.naturalOrder()).orElse(null));
        task.setRemainingEarlyFinish(childTasks.stream().map(Task::getRemainingEarlyFinish).filter(Objects::nonNull).max(Comparator.naturalOrder()).orElse(null));
        task.setLateStart(childTasks.stream().map(Task::getLateStart).filter(Objects::nonNull).min(Comparator.naturalOrder()).orElse(null));
        task.setLateFinish(childTasks.stream().map(Task::getLateFinish).filter(Objects::nonNull).max(Comparator.naturalOrder()).orElse(null));
        task.setRemainingLateStart(childTasks.stream().map(Task::getRemainingLateStart).filter(Objects::nonNull).min(Comparator.naturalOrder()).orElse(null));
        task.setRemainingLateFinish(childTasks.stream().map(Task::getRemainingLateFinish).filter(Objects::nonNull).max(Comparator.naturalOrder()).orElse(null));
    }

    private List<Task> allWbsChildTasks(Task wbs, List<Task> childTasks) {
        childTasks.addAll(wbs.getChildTasks().stream().filter(t -> !t.getSummary() && t.getActivityType() != ActivityType.WBS_SUMMARY && t.getActualFinish() == null).collect(Collectors.toList()));
        wbs.getChildTasks().stream().filter(Task::getSummary).forEach(t -> this.allWbsChildTasks((Task)t, childTasks));
        return childTasks;
    }

    private LocalDateTime getEquivalentPreviousWorkFinish(Task task, LocalDateTime date) {
        if (this.useTaskEffectiveCalendar(task)) {
            return this.getEquivalentPreviousWorkFinish(task.getEffectiveCalendar(), date);
        }
        return this.getResourceAssignmentStream(task).map(r -> this.getEquivalentPreviousWorkFinish(r.getEffectiveCalendar(), date)).max(Comparator.naturalOrder()).orElse(null);
    }

    private LocalDateTime getEquivalentPreviousWorkFinish(ProjectCalendar calendar, LocalDateTime date) {
        LocalDateTime previousWorkFinish = calendar.getPreviousWorkFinish(date);
        if (calendar.getWork(previousWorkFinish, date, TimeUnit.HOURS).getDuration() == 0.0) {
            return previousWorkFinish;
        }
        return date;
    }

    private LocalDateTime getEquivalentNextWorkStart(Task task, LocalDateTime date) {
        if (this.useTaskEffectiveCalendar(task)) {
            return this.getEquivalentNextWorkStart(task.getEffectiveCalendar(), date);
        }
        return this.getResourceAssignmentStream(task).map(r -> this.getEquivalentNextWorkStart(r.getEffectiveCalendar(), date)).min(Comparator.naturalOrder()).orElse(null);
    }

    private LocalDateTime getEquivalentNextWorkStart(ProjectCalendar calendar, LocalDateTime date) {
        LocalDateTime adjustedDate = calendar.getNextWorkStart(date);
        if (calendar.getWork(date, adjustedDate, TimeUnit.MINUTES).getDuration() == 0.0) {
            return adjustedDate;
        }
        return date;
    }

    private Stream<ResourceAssignment> getResourceAssignmentStream(Task task) {
        return task.getResourceAssignments().stream().filter(r -> r.getResource() != null && r.getResource().getType() == ResourceType.WORK && r.getUnits().doubleValue() > 0.0);
    }

    private LocalDateTime getDateFromWork(ResourceAssignment assignment, LocalDateTime date, Duration work) {
        double units = assignment.getUnits().doubleValue();
        if (units != 100.0) {
            work = Duration.getInstance(work.getDuration() * 100.0 / units, work.getUnits());
        }
        return assignment.getResource().getCalendar().getDate(date, work);
    }

    private LocalDateTime getNextWorkStart(Task task, LocalDateTime date) {
        if (this.useTaskEffectiveCalendar(task)) {
            return task.getEffectiveCalendar().getNextWorkStart(date);
        }
        return this.getResourceAssignmentStream(task).map(r -> r.getEffectiveCalendar().getNextWorkStart(date)).min(Comparator.naturalOrder()).orElse(null);
    }

    private boolean hasRemainingDuration(Task task) {
        Duration remaining = this.useTaskEffectiveCalendar(task) ? task.getRemainingDuration() : (Duration)this.getResourceAssignmentStream(task).map(ResourceAssignment::getRemainingWork).max(Comparator.naturalOrder()).orElse(null);
        return remaining.getDuration() != 0.0;
    }

    private boolean hasActualDuration(Task task) {
        Duration actual = this.useTaskEffectiveCalendar(task) ? task.getActualDuration() : (Duration)this.getResourceAssignmentStream(task).map(ResourceAssignment::getActualWork).max(Comparator.naturalOrder()).orElse(null);
        return actual.getDuration() != 0.0;
    }
}

