/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.explorer;

import com.jgoodies.binding.beans.PropertyAdapter;
import java.awt.Component;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.mpxj.explorer.FileChooserModel;

public class FileChooserView {
    protected final JFileChooser m_fileChooser = new JFileChooser();
    private final Component m_parent;
    private final FileChooserModel m_model;

    public FileChooserView(Component parent, FileChooserModel model) {
        this.m_fileChooser.setFileSelectionMode(2);
        this.m_parent = parent;
        this.m_model = model;
        PropertyAdapter adapter = new PropertyAdapter((Object)this.m_model, "showDialog", true);
        adapter.addValueChangeListener(evt -> this.openFileChooser());
        PropertyAdapter extensionsAdaptor = new PropertyAdapter((Object)this.m_model, "extensions", true);
        extensionsAdaptor.addValueChangeListener(evt -> this.setFileFilter());
    }

    protected void openFileChooser() {
        if (this.m_model.getShowDialog()) {
            this.m_fileChooser.setCurrentDirectory(this.m_model.getCurrentDirectory());
            if (this.m_fileChooser.showOpenDialog(this.m_parent) == 0) {
                this.m_model.setFile(this.m_fileChooser.getSelectedFile());
            }
            this.m_model.setCurrentDirectory(this.m_fileChooser.getCurrentDirectory());
            this.m_model.setShowDialog(false);
        }
    }

    protected void setFileFilter() {
        String[] extensions;
        for (String extension : extensions = this.m_model.getExtensions()) {
            this.m_fileChooser.setFileFilter(new FileNameExtensionFilter(extension.toUpperCase() + " Files", extension));
        }
        this.m_fileChooser.setFileFilter(new FileNameExtensionFilter("Project Files", this.m_model.getExtensions()));
    }
}

