/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.explorer;

import java.lang.reflect.Method;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.mpxj.Duration;
import org.mpxj.explorer.ObjectPropertiesModel;

public class ObjectPropertiesController {
    private final DateTimeFormatter m_dateFormat;
    private final ObjectPropertiesModel m_model;

    public ObjectPropertiesController(ObjectPropertiesModel model) {
        this.m_model = model;
        this.m_dateFormat = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm");
    }

    public void loadObject(Object object, Set<String> excludedMethods) {
        this.m_model.setTableModel(this.createTableModel(object, excludedMethods));
    }

    private TableModel createTableModel(Object object, Set<String> excludedMethods) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : object.getClass().getMethods()) {
            String name;
            if (method.getParameterTypes().length != 0 && (method.getParameterTypes().length != 1 || method.getParameterTypes()[0] != Integer.TYPE) || excludedMethods.contains(name = method.getName()) || !name.startsWith("get") && !name.startsWith("is")) continue;
            methods.add(method);
        }
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (Method method : methods) {
            if (method.getParameterTypes().length == 0) {
                this.getSingleValue(method, object, map);
                continue;
            }
            this.getMultipleValues(method, object, map);
        }
        Object[] headings = new String[]{"Property", "Value"};
        Object[][] data = new String[map.size()][2];
        int rowIndex = 0;
        for (Map.Entry entry : map.entrySet()) {
            data[rowIndex][0] = (String)entry.getKey();
            data[rowIndex][1] = (String)entry.getValue();
            ++rowIndex;
        }
        return new DefaultTableModel(data, headings){

            @Override
            public boolean isCellEditable(int r, int c) {
                return false;
            }
        };
    }

    private Object filterValue(Object value) {
        if (value instanceof Boolean && !((Boolean)value).booleanValue()) {
            value = null;
        }
        if (value instanceof String && ((String)value).isEmpty()) {
            value = null;
        }
        if (value instanceof Double && (Double)value == 0.0) {
            value = null;
        }
        if (value instanceof Integer && (Integer)value == 0) {
            value = null;
        }
        if (value instanceof Duration && ((Duration)value).getDuration() == 0.0) {
            value = null;
        }
        return value;
    }

    private void getSingleValue(Method method, Object object, Map<String, String> map) {
        Object value;
        try {
            value = this.filterValue(method.invoke(object, new Object[0]));
        }
        catch (Exception ex) {
            value = ex.toString();
        }
        if (value != null) {
            map.put(this.getPropertyName(method), this.formatValue(value));
        }
    }

    private void getMultipleValues(Method method, Object object, Map<String, String> map) {
        try {
            for (int index = 1; index < 1000; ++index) {
                Object value = this.filterValue(method.invoke(object, index));
                if (value == null) continue;
                map.put(this.getPropertyName(method, index), this.formatValue(value));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String formatValue(Object value) {
        String result = value instanceof LocalDateTime ? this.m_dateFormat.format((LocalDateTime)value) : String.valueOf(value);
        return result;
    }

    private String getPropertyName(Method method) {
        String result = method.getName();
        if (result.startsWith("get")) {
            result = result.substring(3);
        }
        return result;
    }

    private String getPropertyName(Method method, int index) {
        return method.getName().substring(3) + index;
    }
}

