/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.explorer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.mpxj.common.AutoCloseableHelper;
import org.mpxj.explorer.PoiTreeModel;

public class PoiTreeController {
    private final PoiTreeModel m_model;

    public PoiTreeController(PoiTreeModel model) {
        this.m_model = model;
    }

    public void loadFile(File file) {
        InputStream is = null;
        try {
            is = Files.newInputStream(file.toPath(), new OpenOption[0]);
            POIFSFileSystem fs = new POIFSFileSystem(is);
            this.m_model.setFile(fs);
        }
        catch (IOException ex) {
            try {
                throw new RuntimeException(ex);
            }
            catch (Throwable throwable) {
                AutoCloseableHelper.closeQuietly(is);
                throw throwable;
            }
        }
        AutoCloseableHelper.closeQuietly(is);
    }
}

