/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.explorer;

import com.jgoodies.binding.beans.PropertyAdapter;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.io.File;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import org.mpxj.ProjectFile;
import org.mpxj.explorer.FileChooserController;
import org.mpxj.explorer.FileChooserModel;
import org.mpxj.explorer.FileChooserView;
import org.mpxj.explorer.FileCleanerController;
import org.mpxj.explorer.FileCleanerModel;
import org.mpxj.explorer.FileCleanerView;
import org.mpxj.explorer.FileSaverController;
import org.mpxj.explorer.FileSaverModel;
import org.mpxj.explorer.FileSaverView;
import org.mpxj.explorer.ProjectFilePanel;
import org.mpxj.explorer.ReadOptions;
import org.mpxj.explorer.WriteOptions;
import org.mpxj.primavera.PrimaveraPMFileReader;
import org.mpxj.primavera.PrimaveraXERFileReader;
import org.mpxj.reader.ProjectReader;
import org.mpxj.reader.UniversalProjectReader;

public class ProjectExplorer {
    private static final int MAX_RECENTS = 5;
    private static final String RECENT_FILES = "RECENT_FILES";
    private static final String RECENT_FOLDERS = "RECENT_FOLDERS";
    protected JFrame m_frame;
    private final ReadOptions m_readOptions = new ReadOptions();
    private final WriteOptions m_writeOptions = new WriteOptions();
    private final JMenuItem m_saveMenu = new JMenuItem("Save As...");
    private final JMenuItem m_cleanMenu = new JMenuItem("Clean...");
    private final JMenu m_recentMenu = new JMenu("Open Recent");
    private final JTabbedPane m_tabbedPane = new JTabbedPane(1);
    private final Deque<String> m_recentFiles = new ArrayDeque<String>();
    private final Deque<String> m_recentFolders = new ArrayDeque<String>();
    private final FileChooserModel m_fileChooserModel = new FileChooserModel();
    private final FileChooserController m_fileChooserController = new FileChooserController(this.m_fileChooserModel);
    private final FileChooserModel m_openAllFileChooserModel = new FileChooserModel();
    private final FileChooserController m_openAllFileChooserController = new FileChooserController(this.m_openAllFileChooserModel);
    private static final String[] READ_EXTENSIONS = new String[]{"bk3", "cdpx", "cdpz", "edpx", "exe", "fts", "gan", "gnt", "mdb", "mpd", "mpp", "mpx", "pc", "pep", "planner", "pmxml", "pod", "pp", "ppx", "prx", "schedule_grid", "sdef", "sp", "stx", "xer", "xml", "zip"};
    private static final String[] WRITE_EXTENSIONS = new String[]{"sdef", "sdef", "mpx", "mpx", "planner", "xml", "pmxml", "xml", "json", "json", "mspdi", "xml", "xer", "xer"};

    public static void main(String[] args) {
        EventQueue.invokeLater(() -> {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                ProjectExplorer window = new ProjectExplorer();
                window.m_frame.setVisible(true);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        });
    }

    public ProjectExplorer() {
        this.initialize();
    }

    private void initialize() {
        this.m_frame = new JFrame();
        this.m_frame.setBounds(100, 100, 900, 451);
        this.m_frame.setDefaultCloseOperation(3);
        this.m_frame.getContentPane().setLayout(new GridLayout(1, 0, 0, 0));
        FileChooserView fileChooserView = new FileChooserView(this.m_frame, this.m_fileChooserModel);
        this.m_fileChooserModel.setExtensions(READ_EXTENSIONS);
        FileChooserView openAllFileChooserView = new FileChooserView(this.m_frame, this.m_openAllFileChooserModel);
        this.m_openAllFileChooserModel.setExtensions(READ_EXTENSIONS);
        FileSaverModel fileSaverModel = new FileSaverModel();
        FileSaverController fileSaverController = new FileSaverController(fileSaverModel);
        FileSaverView fileSaverView = new FileSaverView(this.m_frame, fileSaverModel);
        fileSaverModel.setExtensions(WRITE_EXTENSIONS);
        FileCleanerModel fileCleanerModel = new FileCleanerModel();
        FileCleanerController fileCleanerController = new FileCleanerController(fileCleanerModel);
        FileCleanerView fileCleanerView = new FileCleanerView(this.m_frame, fileCleanerModel);
        JMenuBar menuBar = new JMenuBar();
        this.m_frame.setJMenuBar(menuBar);
        JMenu mnFile = new JMenu("File");
        menuBar.add(mnFile);
        JMenuItem mntmOpen = new JMenuItem("Open...");
        mnFile.add(mntmOpen);
        mnFile.add(this.m_recentMenu);
        this.m_saveMenu.setEnabled(false);
        mnFile.add(this.m_saveMenu);
        this.m_cleanMenu.setEnabled(false);
        mnFile.add(this.m_cleanMenu);
        mnFile.addSeparator();
        JCheckBoxMenuItem mntmOpenAll = new JCheckBoxMenuItem("Open All");
        mnFile.add(mntmOpenAll);
        JCheckBoxMenuItem mntmLinkCrossProjectRelations = new JCheckBoxMenuItem("Link Cross Project Relations", this.m_readOptions.getLinkCrossProjectRelations());
        mnFile.add(mntmLinkCrossProjectRelations);
        JCheckBoxMenuItem mntmExpandSubprojects = new JCheckBoxMenuItem("Expand Subprojects", this.m_readOptions.getExpandSubprojects());
        mnFile.add(mntmExpandSubprojects);
        JCheckBoxMenuItem mntmRemoveExternalTasks = new JCheckBoxMenuItem("Remove External Tasks", this.m_readOptions.getRemoveExternalTasks());
        mntmRemoveExternalTasks.setEnabled(this.m_readOptions.getExpandSubprojects());
        mnFile.add(mntmRemoveExternalTasks);
        mnFile.addSeparator();
        JCheckBoxMenuItem mntmWriteTimephasedData = new JCheckBoxMenuItem("Write Timephased Data", this.m_writeOptions.getWriteTimephasedData());
        mnFile.add(mntmWriteTimephasedData);
        JCheckBoxMenuItem mntmSplitTimephasedAsDays = new JCheckBoxMenuItem("Split Timephased Data as Days", this.m_writeOptions.getSplitTimephasedDataAsDays());
        mnFile.add(mntmSplitTimephasedAsDays);
        mntmOpen.addActionListener(e -> {
            if (this.m_readOptions.getOpenAll()) {
                this.m_openAllFileChooserController.openFileChooser();
            } else {
                this.m_fileChooserController.openFileChooser();
            }
        });
        this.m_saveMenu.addActionListener(e -> fileSaverController.openFileSaver());
        this.m_cleanMenu.addActionListener(e -> fileCleanerController.openFileCleaner());
        mntmOpenAll.addActionListener(e -> this.m_readOptions.toggleOpenAll());
        mntmLinkCrossProjectRelations.addActionListener(e -> this.m_readOptions.toggleLinkCrossProjectRelations());
        mntmExpandSubprojects.addActionListener(e -> {
            this.m_readOptions.toggleExpandSubprojects();
            mntmRemoveExternalTasks.setEnabled(this.m_readOptions.getExpandSubprojects());
        });
        mntmRemoveExternalTasks.addActionListener(e -> this.m_readOptions.toggleRemoveExternalTasks());
        mntmWriteTimephasedData.addActionListener(e -> this.m_writeOptions.toggleWriteTimephasedData());
        mntmSplitTimephasedAsDays.addActionListener(e -> this.m_writeOptions.toggleSplitTimephasedDataAsDays());
        this.m_frame.getContentPane().add(this.m_tabbedPane);
        PropertyAdapter openAdapter = new PropertyAdapter((Object)this.m_fileChooserModel, "file", true);
        openAdapter.addValueChangeListener(evt -> this.openFile(this.m_fileChooserModel.getFile()));
        PropertyAdapter openAllAdapter = new PropertyAdapter((Object)this.m_openAllFileChooserModel, "file", true);
        openAllAdapter.addValueChangeListener(evt -> this.openAll(this.m_openAllFileChooserModel.getFile()));
        PropertyAdapter saveAdapter = new PropertyAdapter((Object)fileSaverModel, "file", true);
        saveAdapter.addValueChangeListener(evt -> {
            ProjectFilePanel panel = (ProjectFilePanel)this.m_tabbedPane.getSelectedComponent();
            panel.saveFile(fileSaverModel.getFile(), fileSaverModel.getType());
        });
        PropertyAdapter cleanAdapter = new PropertyAdapter((Object)fileCleanerModel, "file", true);
        cleanAdapter.addValueChangeListener(evt -> {
            ProjectFilePanel panel = (ProjectFilePanel)this.m_tabbedPane.getSelectedComponent();
            panel.cleanFile(fileCleanerModel.getFile());
        });
        this.loadRecents();
    }

    private void openFile(File file) {
        this.updateAndSaveRecents(file);
        try (UniversalProjectReader.ProjectReaderProxy proxy = new UniversalProjectReader().getProjectReaderProxy(file);){
            if (proxy == null) {
                JOptionPane.showMessageDialog(this.m_frame, "Unsupported file type");
                return;
            }
            this.configureReader(proxy);
            ProjectFile projectFile = proxy.read();
            if (projectFile == null) {
                JOptionPane.showMessageDialog(this.m_frame, "Failed to read file");
                return;
            }
            this.expandSubprojects(file, projectFile);
            this.m_tabbedPane.add(file.getName(), new ProjectFilePanel(file, projectFile, this.m_writeOptions));
            this.m_saveMenu.setEnabled(true);
            this.m_cleanMenu.setEnabled(true);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Failed to read file", ex);
        }
    }

    private void openAll(File file) {
        this.updateAndSaveRecents(file);
        try (UniversalProjectReader.ProjectReaderProxy proxy = new UniversalProjectReader().getProjectReaderProxy(file);){
            if (proxy == null) {
                JOptionPane.showMessageDialog(this.m_frame, "Unsupported file type");
                return;
            }
            this.configureReader(proxy);
            List<ProjectFile> projectFiles = proxy.readAll();
            int index = 1;
            for (ProjectFile projectFile : projectFiles) {
                String name = projectFiles.size() == 1 ? file.getName() : file.getName() + " (" + index++ + ")";
                this.expandSubprojects(file, projectFile);
                this.m_tabbedPane.add(name, new ProjectFilePanel(file, projectFile, this.m_writeOptions));
            }
            this.m_saveMenu.setEnabled(true);
            this.m_cleanMenu.setEnabled(true);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Failed to read file", ex);
        }
    }

    private void loadRecents() {
        String recentFoldersString;
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        this.m_recentFiles.clear();
        this.m_recentFolders.clear();
        String recentFilesString = prefs.get(RECENT_FILES, "");
        if (!recentFilesString.isEmpty()) {
            this.m_recentFiles.addAll(Arrays.asList(recentFilesString.split("\\|")));
        }
        if (!(recentFoldersString = prefs.get(RECENT_FOLDERS, "")).isEmpty()) {
            this.m_recentFolders.addAll(Arrays.asList(recentFoldersString.split("\\|")));
        }
        this.updateRecentsMenu();
    }

    private void saveRecents() {
        try {
            Preferences prefs = Preferences.userNodeForPackage(this.getClass());
            prefs.put(RECENT_FILES, String.join((CharSequence)"|", this.m_recentFiles));
            prefs.put(RECENT_FOLDERS, String.join((CharSequence)"|", this.m_recentFolders));
            prefs.flush();
        }
        catch (BackingStoreException e) {
            throw new RuntimeException(e);
        }
    }

    private void updateAndSaveRecents(File file) {
        this.updateRecents(file.getAbsolutePath(), this.m_recentFiles);
        this.updateRecents(file.getParentFile().getAbsolutePath(), this.m_recentFolders);
        this.updateRecentsMenu();
        this.saveRecents();
    }

    private void updateRecents(String name, Deque<String> recents) {
        if (recents.isEmpty()) {
            recents.add(name);
        } else if (!recents.peekFirst().equals(name)) {
            recents.remove(name);
            recents.addFirst(name);
            if (recents.size() > 5) {
                recents.removeLast();
            }
        }
    }

    private void updateRecentsMenu() {
        JMenuItem item;
        this.m_recentMenu.removeAll();
        for (String path : this.m_recentFiles) {
            item = new JMenuItem(path);
            item.addActionListener(l -> this.openRecentFile(path));
            this.m_recentMenu.add(item);
        }
        if (this.m_recentMenu.getItemCount() != 0 && !this.m_recentFolders.isEmpty()) {
            this.m_recentMenu.addSeparator();
        }
        for (String path : this.m_recentFolders) {
            item = new JMenuItem(path);
            item.addActionListener(l -> this.openRecentFolder(path));
            this.m_recentMenu.add(item);
        }
        if (!(this.m_recentMenu.getItemCount() == 0 || this.m_recentFolders.isEmpty() && this.m_recentFiles.isEmpty())) {
            this.m_recentMenu.addSeparator();
        }
        if (!this.m_recentFiles.isEmpty()) {
            JMenuItem clearFiles = new JMenuItem("Clear Recent Files");
            this.m_recentMenu.add(clearFiles);
            clearFiles.addActionListener(l -> {
                this.m_recentFiles.clear();
                this.updateRecentsMenu();
            });
        }
        if (!this.m_recentFolders.isEmpty()) {
            JMenuItem clearFolders = new JMenuItem("Clear Recent Folders");
            this.m_recentMenu.add(clearFolders);
            clearFolders.addActionListener(l -> {
                this.m_recentFolders.clear();
                this.updateRecentsMenu();
            });
        }
        this.m_recentMenu.setEnabled(this.m_recentMenu.getItemCount() != 0);
    }

    private void openRecentFile(String path) {
        File file = new File(path);
        if (this.m_readOptions.getOpenAll()) {
            this.openAll(file);
        } else {
            this.openFile(file);
        }
    }

    private void openRecentFolder(String path) {
        File file = new File(path);
        if (this.m_readOptions.getOpenAll()) {
            this.m_openAllFileChooserModel.setCurrentDirectory(file);
            this.m_openAllFileChooserController.openFileChooser();
        } else {
            this.m_fileChooserModel.setCurrentDirectory(file);
            this.m_fileChooserController.openFileChooser();
        }
    }

    private void expandSubprojects(File file, ProjectFile projectFile) {
        if (this.m_readOptions.getExpandSubprojects()) {
            projectFile.getProjectConfig().setSubprojectWorkingDirectory(file.getParentFile());
            projectFile.expandSubprojects(this.m_readOptions.getRemoveExternalTasks());
        }
    }

    private void configureReader(UniversalProjectReader.ProjectReaderProxy proxy) {
        ProjectReader reader = proxy.getProjectReader();
        if (reader instanceof PrimaveraXERFileReader) {
            ((PrimaveraXERFileReader)reader).setLinkCrossProjectRelations(this.m_readOptions.getLinkCrossProjectRelations());
        }
        if (reader instanceof PrimaveraPMFileReader) {
            ((PrimaveraPMFileReader)reader).setLinkCrossProjectRelations(this.m_readOptions.getLinkCrossProjectRelations());
        }
    }
}

