/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.explorer;

import java.io.File;
import java.time.DayOfWeek;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.mpxj.ActivityCode;
import org.mpxj.ActivityCodeValue;
import org.mpxj.ChildResourceContainer;
import org.mpxj.ChildTaskContainer;
import org.mpxj.Code;
import org.mpxj.CodeValue;
import org.mpxj.Column;
import org.mpxj.CustomField;
import org.mpxj.DataLink;
import org.mpxj.FieldType;
import org.mpxj.Filter;
import org.mpxj.Group;
import org.mpxj.LocalTimeRange;
import org.mpxj.ProjectCalendar;
import org.mpxj.ProjectCalendarDays;
import org.mpxj.ProjectCalendarException;
import org.mpxj.ProjectCalendarHours;
import org.mpxj.ProjectCalendarWeek;
import org.mpxj.ProjectFile;
import org.mpxj.Relation;
import org.mpxj.Resource;
import org.mpxj.ResourceAssignment;
import org.mpxj.Table;
import org.mpxj.Task;
import org.mpxj.UserDefinedField;
import org.mpxj.View;
import org.mpxj.explorer.MpxjTreeNode;
import org.mpxj.explorer.ProjectTreeModel;
import org.mpxj.json.JsonWriter;
import org.mpxj.mpx.MPXWriter;
import org.mpxj.mspdi.MSPDIWriter;
import org.mpxj.planner.PlannerWriter;
import org.mpxj.primavera.PrimaveraPMFileWriter;
import org.mpxj.primavera.PrimaveraXERFileWriter;
import org.mpxj.sdef.SDEFWriter;
import org.mpxj.utility.ProjectCleanUtility;
import org.mpxj.writer.ProjectWriter;

public class ProjectTreeController {
    private static final Map<String, Class<? extends ProjectWriter>> WRITER_MAP = new HashMap<String, Class<? extends ProjectWriter>>();
    final DateTimeFormatter m_timeFormat = DateTimeFormatter.ofPattern("HH:mm");
    final DateTimeFormatter m_dateFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final Set<String> FILE_EXCLUDED_METHODS;
    private static final Set<String> CALENDAR_EXCLUDED_METHODS;
    private static final Set<String> CALENDAR_WEEK_EXCLUDED_METHODS;
    private static final Set<String> TASK_EXCLUDED_METHODS;
    private static final Set<String> CALENDAR_EXCEPTION_EXCLUDED_METHODS;
    private static final Set<String> TABLE_EXCLUDED_METHODS;
    private static final Set<String> CODE_EXCLUDED_METHODS;
    private static final Set<String> CODE_VALUE_EXCLUDED_METHODS;
    private final ProjectTreeModel m_model;
    private ProjectFile m_projectFile;
    private File m_file;

    public ProjectTreeController(ProjectTreeModel model) {
        this.m_model = model;
    }

    public void loadFile(File file, ProjectFile projectFile) {
        this.m_file = file;
        this.m_projectFile = projectFile;
        MpxjTreeNode projectNode = new MpxjTreeNode(this.m_projectFile, FILE_EXCLUDED_METHODS){

            @Override
            public String toString() {
                return "Project";
            }
        };
        MpxjTreeNode configNode = new MpxjTreeNode(this.m_projectFile.getProjectConfig()){

            @Override
            public String toString() {
                return "MPXJ Configuration";
            }
        };
        projectNode.add(configNode);
        MpxjTreeNode propertiesNode = new MpxjTreeNode(this.m_projectFile.getProjectProperties()){

            @Override
            public String toString() {
                return "Properties";
            }
        };
        projectNode.add(propertiesNode);
        MpxjTreeNode tasksFolder = new MpxjTreeNode("Tasks");
        projectNode.add(tasksFolder);
        this.addTasks(tasksFolder, this.m_projectFile);
        MpxjTreeNode resourcesFolder = new MpxjTreeNode("Resources");
        projectNode.add(resourcesFolder);
        this.addResources(resourcesFolder, this.m_projectFile);
        MpxjTreeNode rolesFolder = new MpxjTreeNode("Roles");
        projectNode.add(rolesFolder);
        this.addRoles(rolesFolder, this.m_projectFile);
        MpxjTreeNode assignmentsFolder = new MpxjTreeNode("Assignments");
        projectNode.add(assignmentsFolder);
        this.addAssignments(assignmentsFolder, this.m_projectFile);
        MpxjTreeNode relationsFolder = new MpxjTreeNode("Predecessors");
        projectNode.add(relationsFolder);
        this.addRelations(relationsFolder, this.m_projectFile);
        MpxjTreeNode calendarsFolder = new MpxjTreeNode("Calendars");
        projectNode.add(calendarsFolder);
        this.addCalendars(calendarsFolder, this.m_projectFile);
        MpxjTreeNode groupsFolder = new MpxjTreeNode("Groups");
        projectNode.add(groupsFolder);
        this.addGroups(groupsFolder, this.m_projectFile);
        MpxjTreeNode userDefinedFields = new MpxjTreeNode("User Defined Fields");
        projectNode.add(userDefinedFields);
        this.addUserDefinedFields(userDefinedFields, this.m_projectFile);
        MpxjTreeNode customFields = new MpxjTreeNode("Custom Fields");
        projectNode.add(customFields);
        this.addCustomFields(customFields, this.m_projectFile);
        MpxjTreeNode filtersFolder = new MpxjTreeNode("Filters");
        projectNode.add(filtersFolder);
        MpxjTreeNode taskFiltersFolder = new MpxjTreeNode("Task Filters");
        filtersFolder.add(taskFiltersFolder);
        this.addFilters(taskFiltersFolder, this.m_projectFile.getFilters().getTaskFilters());
        MpxjTreeNode resourceFiltersFolder = new MpxjTreeNode("Resource Filters");
        filtersFolder.add(resourceFiltersFolder);
        this.addFilters(resourceFiltersFolder, this.m_projectFile.getFilters().getResourceFilters());
        MpxjTreeNode viewsFolder = new MpxjTreeNode("Views");
        projectNode.add(viewsFolder);
        this.addViews(viewsFolder, this.m_projectFile);
        MpxjTreeNode tablesFolder = new MpxjTreeNode("Tables");
        projectNode.add(tablesFolder);
        this.addTables(tablesFolder, this.m_projectFile);
        MpxjTreeNode dataLinksFolder = new MpxjTreeNode("Data Links");
        projectNode.add(dataLinksFolder);
        this.addDataLinks(dataLinksFolder, this.m_projectFile);
        MpxjTreeNode activityCodesFolder = new MpxjTreeNode("Activity Codes");
        projectNode.add(activityCodesFolder);
        this.addActivityCodes(activityCodesFolder);
        MpxjTreeNode projectCodesFolder = new MpxjTreeNode("Project Codes");
        projectNode.add(projectCodesFolder);
        this.addCodes(projectCodesFolder, this.m_projectFile.getProjectCodes());
        MpxjTreeNode resourceCodesFolder = new MpxjTreeNode("Resource Codes");
        projectNode.add(resourceCodesFolder);
        this.addCodes(resourceCodesFolder, this.m_projectFile.getResourceCodes());
        MpxjTreeNode roleCodesFolder = new MpxjTreeNode("Role Codes");
        projectNode.add(roleCodesFolder);
        this.addCodes(roleCodesFolder, this.m_projectFile.getRoleCodes());
        MpxjTreeNode resourceAssignmentCodesFolder = new MpxjTreeNode("Resource Assignment Codes");
        projectNode.add(resourceAssignmentCodesFolder);
        this.addCodes(resourceAssignmentCodesFolder, this.m_projectFile.getResourceAssignmentCodes());
        this.m_model.setRoot(projectNode);
    }

    private void addTasks(MpxjTreeNode parentNode, ChildTaskContainer parent) {
        Iterator<Task> iterator = parent.getChildTasks().iterator();
        while (iterator.hasNext()) {
            Task task;
            final Task t = task = iterator.next();
            MpxjTreeNode childNode = new MpxjTreeNode(task, TASK_EXCLUDED_METHODS){

                @Override
                public String toString() {
                    return ProjectTreeController.this.getTaskName(t);
                }
            };
            parentNode.add(childNode);
            this.addTasks(childNode, task);
        }
    }

    private void addResources(MpxjTreeNode parentNode, ChildResourceContainer file) {
        for (Resource resource : file.getChildResources()) {
            if (resource.getRole()) continue;
            final Resource r = resource;
            MpxjTreeNode childNode = new MpxjTreeNode(resource){

                @Override
                public String toString() {
                    return r.getName();
                }
            };
            parentNode.add(childNode);
            this.addResources(childNode, resource);
        }
    }

    private void addRoles(MpxjTreeNode parentNode, ChildResourceContainer file) {
        for (Resource role : file.getChildResources()) {
            if (!role.getRole()) continue;
            final Resource r = role;
            MpxjTreeNode childNode = new MpxjTreeNode(role){

                @Override
                public String toString() {
                    return r.getName();
                }
            };
            parentNode.add(childNode);
            this.addRoles(childNode, role);
        }
    }

    private void addCalendars(MpxjTreeNode parentNode, ProjectFile file) {
        this.addCalendars(parentNode, file.getCalendars().stream().filter(c -> c.getParent() == null).collect(Collectors.toList()));
    }

    private void addCalendars(MpxjTreeNode parentNode, List<ProjectCalendar> calendars) {
        calendars.forEach(c -> this.addCalendar(parentNode, (ProjectCalendar)c));
    }

    private void addCalendar(MpxjTreeNode parentNode, final ProjectCalendar calendar) {
        List<ProjectCalendar> derivedCalendars;
        List<ProjectCalendarWeek> weeks;
        MpxjTreeNode calendarNode = new MpxjTreeNode(calendar, CALENDAR_EXCLUDED_METHODS){

            @Override
            public String toString() {
                return calendar.getName();
            }
        };
        parentNode.add(calendarNode);
        MpxjTreeNode daysFolder = new MpxjTreeNode("Days");
        calendarNode.add(daysFolder);
        for (DayOfWeek day : DayOfWeek.values()) {
            this.addCalendarDay(daysFolder, calendar, day);
        }
        List<ProjectCalendarException> exceptions = calendar.getCalendarExceptions();
        if (!exceptions.isEmpty()) {
            MpxjTreeNode exceptionsFolder = new MpxjTreeNode("Exceptions");
            calendarNode.add(exceptionsFolder);
            for (ProjectCalendarException exception : exceptions) {
                this.addCalendarException(exceptionsFolder, exception);
            }
        }
        if (!(weeks = calendar.getWorkWeeks()).isEmpty()) {
            MpxjTreeNode workingWeeksFolder = new MpxjTreeNode("Working Weeks");
            calendarNode.add(workingWeeksFolder);
            this.addWorkingWeeks(workingWeeksFolder, weeks);
        }
        if (!(derivedCalendars = calendar.getDerivedCalendars()).isEmpty()) {
            MpxjTreeNode derivedCalendarsFolder = new MpxjTreeNode("Derived Calendars");
            calendarNode.add(derivedCalendarsFolder);
            this.addCalendars(derivedCalendarsFolder, derivedCalendars);
        }
    }

    private void addWorkingWeeks(MpxjTreeNode parentNode, List<ProjectCalendarWeek> weeks) {
        weeks.forEach(w -> this.addWorkingWeek(parentNode, (ProjectCalendarWeek)w));
    }

    private void addWorkingWeek(MpxjTreeNode parentNode, final ProjectCalendarWeek week) {
        MpxjTreeNode weekNode = new MpxjTreeNode(week, CALENDAR_WEEK_EXCLUDED_METHODS){

            @Override
            public String toString() {
                String name = week.getName();
                return name == null || name.isEmpty() ? "Unnamed Week" : name;
            }
        };
        parentNode.add(weekNode);
        MpxjTreeNode daysFolder = new MpxjTreeNode("Days");
        weekNode.add(daysFolder);
        for (DayOfWeek day : DayOfWeek.values()) {
            this.addCalendarDay(daysFolder, week, day);
        }
    }

    private void addCalendarDay(MpxjTreeNode parentNode, final ProjectCalendarDays calendar, final DayOfWeek day) {
        MpxjTreeNode dayNode = new MpxjTreeNode(day){

            @Override
            public String toString() {
                return day.name() + " (" + calendar.getCalendarDayType(day) + ")";
            }
        };
        parentNode.add(dayNode);
        this.addHours(dayNode, calendar.getCalendarHours(day));
    }

    private void addHours(MpxjTreeNode parentNode, ProjectCalendarHours hours) {
        if (hours == null) {
            return;
        }
        Iterator<LocalTimeRange> iterator = hours.iterator();
        while (iterator.hasNext()) {
            LocalTimeRange range;
            final LocalTimeRange r = range = iterator.next();
            MpxjTreeNode rangeNode = new MpxjTreeNode(range){

                @Override
                public String toString() {
                    return ProjectTreeController.this.m_timeFormat.format(r.getStart()) + " - " + ProjectTreeController.this.m_timeFormat.format(r.getEnd());
                }
            };
            parentNode.add(rangeNode);
        }
    }

    private void addCalendarException(MpxjTreeNode parentNode, final ProjectCalendarException exception) {
        MpxjTreeNode exceptionNode = new MpxjTreeNode(exception, CALENDAR_EXCEPTION_EXCLUDED_METHODS){

            @Override
            public String toString() {
                return ProjectTreeController.this.m_dateFormat.format(exception.getFromDate());
            }
        };
        parentNode.add(exceptionNode);
        this.addHours(exceptionNode, exception);
    }

    private void addGroups(MpxjTreeNode parentNode, ProjectFile file) {
        Iterator iterator = file.getGroups().iterator();
        while (iterator.hasNext()) {
            Group group;
            final Group g = group = (Group)iterator.next();
            MpxjTreeNode childNode = new MpxjTreeNode(group){

                @Override
                public String toString() {
                    return g.getName();
                }
            };
            parentNode.add(childNode);
        }
    }

    private void addCustomFields(MpxjTreeNode parentNode, ProjectFile file) {
        Function<CustomField, String> name = f -> {
            FieldType type = f.getFieldType();
            String result = type == null ? "(unknown)" : (Object)((Object)type.getFieldTypeClass()) + "." + type;
            result = f.getAlias() == null || f.getAlias().isEmpty() ? result : result + " (" + f.getAlias() + ")";
            return result;
        };
        Map map = file.getCustomFields().stream().collect(Collectors.toMap(name, Function.identity(), (u, v) -> u, TreeMap::new));
        for (final Map.Entry entry : map.entrySet()) {
            MpxjTreeNode childNode = new MpxjTreeNode(entry.getValue()){

                @Override
                public String toString() {
                    return (String)entry.getKey();
                }
            };
            parentNode.add(childNode);
        }
    }

    private void addUserDefinedFields(MpxjTreeNode parentNode, ProjectFile file) {
        Function<UserDefinedField, String> name = f -> f.getFieldTypeClass().name() + " " + f.getName() + " (" + f.name() + " " + f.getDataType().name() + ")";
        Map map = file.getUserDefinedFields().stream().collect(Collectors.toMap(name, Function.identity(), (u, v) -> u, TreeMap::new));
        for (final Map.Entry entry : map.entrySet()) {
            MpxjTreeNode childNode = new MpxjTreeNode(entry.getValue()){

                @Override
                public String toString() {
                    return (String)entry.getKey();
                }
            };
            parentNode.add(childNode);
        }
    }

    private void addViews(MpxjTreeNode parentNode, ProjectFile file) {
        Iterator iterator = file.getViews().iterator();
        while (iterator.hasNext()) {
            View view;
            final View v = view = (View)iterator.next();
            MpxjTreeNode childNode = new MpxjTreeNode(view){

                @Override
                public String toString() {
                    return v.getName();
                }
            };
            parentNode.add(childNode);
        }
    }

    private void addTables(MpxjTreeNode parentNode, ProjectFile file) {
        Iterator iterator = file.getTables().iterator();
        while (iterator.hasNext()) {
            Table table;
            final Table t = table = (Table)iterator.next();
            MpxjTreeNode childNode = new MpxjTreeNode(table, TABLE_EXCLUDED_METHODS){

                @Override
                public String toString() {
                    return t.getName();
                }
            };
            parentNode.add(childNode);
            this.addColumns(childNode, table);
        }
    }

    private void addColumns(MpxjTreeNode parentNode, Table table) {
        Iterator<Column> iterator = table.getColumns().iterator();
        while (iterator.hasNext()) {
            Column column;
            final Column c = column = iterator.next();
            MpxjTreeNode childNode = new MpxjTreeNode(column){

                @Override
                public String toString() {
                    return c.getTitle();
                }
            };
            parentNode.add(childNode);
        }
    }

    private void addFilters(MpxjTreeNode parentNode, List<Filter> filters) {
        Iterator<Filter> iterator = filters.iterator();
        while (iterator.hasNext()) {
            Filter field;
            final Filter f = field = iterator.next();
            MpxjTreeNode childNode = new MpxjTreeNode(field){

                @Override
                public String toString() {
                    return f.getName();
                }
            };
            parentNode.add(childNode);
        }
    }

    private void addAssignments(MpxjTreeNode parentNode, ProjectFile file) {
        Iterator iterator = file.getResourceAssignments().iterator();
        while (iterator.hasNext()) {
            ResourceAssignment assignment;
            final ResourceAssignment a = assignment = (ResourceAssignment)iterator.next();
            MpxjTreeNode childNode = new MpxjTreeNode(a){

                @Override
                public String toString() {
                    Resource resource = a.getResource();
                    String resourceName = resource == null ? "(unknown resource)" : resource.getName();
                    Task task = a.getTask();
                    return resourceName + "->" + ProjectTreeController.this.getTaskName(task);
                }
            };
            parentNode.add(childNode);
        }
    }

    private void addRelations(MpxjTreeNode parentNode, ProjectFile file) {
        Iterator iterator = file.getRelations().iterator();
        while (iterator.hasNext()) {
            Relation relation;
            final Relation r = relation = (Relation)iterator.next();
            MpxjTreeNode childNode = new MpxjTreeNode(r){

                @Override
                public String toString() {
                    return ProjectTreeController.this.getTaskName(r.getPredecessorTask()) + "->" + ProjectTreeController.this.getTaskName(r.getSuccessorTask()) + " " + r.getType() + " " + r.getLag();
                }
            };
            parentNode.add(childNode);
        }
    }

    private void addDataLinks(MpxjTreeNode parentNode, ProjectFile file) {
        Iterator iterator = file.getDataLinks().iterator();
        while (iterator.hasNext()) {
            DataLink dataLink;
            final DataLink d = dataLink = (DataLink)iterator.next();
            MpxjTreeNode childNode = new MpxjTreeNode(dataLink, TABLE_EXCLUDED_METHODS){

                @Override
                public String toString() {
                    int index;
                    String name = d.getID();
                    if (name == null) {
                        name = "";
                    }
                    if ((index = name.lastIndexOf(33)) == -1 || index == name.length() - 1) {
                        return "(none)";
                    }
                    return name.substring(index + 1);
                }
            };
            parentNode.add(childNode);
        }
    }

    private void addActivityCodes(MpxjTreeNode parentNode) {
        Iterator iterator = this.m_projectFile.getActivityCodes().iterator();
        while (iterator.hasNext()) {
            ActivityCode code;
            final ActivityCode c = code = (ActivityCode)iterator.next();
            MpxjTreeNode childNode = new MpxjTreeNode(code, CODE_EXCLUDED_METHODS){

                @Override
                public String toString() {
                    return c.getName();
                }
            };
            parentNode.add(childNode);
            this.addActivityCodeValues(childNode, code);
        }
    }

    private void addCodes(MpxjTreeNode parentNode, List<? extends Code> codes) {
        Iterator<? extends Code> iterator = codes.iterator();
        while (iterator.hasNext()) {
            Code code;
            final Code c = code = iterator.next();
            MpxjTreeNode childNode = new MpxjTreeNode(code, CODE_EXCLUDED_METHODS){

                @Override
                public String toString() {
                    return c.getName();
                }
            };
            parentNode.add(childNode);
            this.addCodeValues(childNode, code);
        }
    }

    private void addActivityCodeValues(MpxjTreeNode parentNode, ActivityCode code) {
        code.getChildValues().forEach(v -> this.addActivityCodeValues(parentNode, (ActivityCodeValue)v));
    }

    private void addCodeValues(MpxjTreeNode parentNode, Code code) {
        code.getChildValues().forEach(v -> this.addCodeValues(parentNode, (CodeValue)v));
    }

    private void addActivityCodeValues(MpxjTreeNode parentNode, ActivityCodeValue value) {
        MpxjTreeNode node = new MpxjTreeNode((Object)value, CODE_VALUE_EXCLUDED_METHODS);
        parentNode.add(node);
        value.getChildValues().forEach(v -> this.addActivityCodeValues(node, (ActivityCodeValue)v));
    }

    private void addCodeValues(MpxjTreeNode parentNode, CodeValue value) {
        MpxjTreeNode node = new MpxjTreeNode((Object)value, CODE_VALUE_EXCLUDED_METHODS);
        parentNode.add(node);
        value.getChildValues().forEach(v -> this.addCodeValues(node, (CodeValue)v));
    }

    public void saveFile(File file, String type) {
        try {
            Class<? extends ProjectWriter> fileClass = WRITER_MAP.get(type);
            if (fileClass == null) {
                throw new IllegalArgumentException("Cannot write files of type: " + type);
            }
            ProjectWriter writer = fileClass.newInstance();
            if (fileClass == JsonWriter.class) {
                ((JsonWriter)writer).setPretty(true);
            }
            if (fileClass == MSPDIWriter.class) {
                ((MSPDIWriter)writer).setWriteTimephasedData(this.m_model.getWriteOptions().getWriteTimephasedData());
                ((MSPDIWriter)writer).setSplitTimephasedAsDays(this.m_model.getWriteOptions().getSplitTimephasedDataAsDays());
            }
            writer.write(this.m_projectFile, file);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void cleanFile(File file) {
        try {
            new ProjectCleanUtility().process(this.m_file.getCanonicalPath(), file.getCanonicalPath());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private String getTaskName(Task task) {
        if (task == null) {
            return "(unknown task)";
        }
        String externalTaskLabel = task.getExternalTask() ? " [EXTERNAL TASK]" : "";
        String externalProjectLabel = task.getExternalProject() ? " [EXTERNAL PROJECT]" : "";
        return task.getName() + externalTaskLabel + externalProjectLabel;
    }

    private static Set<String> excludedMethods(String ... methodNames) {
        HashSet<String> set = new HashSet<String>(MpxjTreeNode.DEFAULT_EXCLUDED_METHODS);
        set.addAll(Arrays.asList(methodNames));
        return set;
    }

    static {
        WRITER_MAP.put("MPX", MPXWriter.class);
        WRITER_MAP.put("MSPDI", MSPDIWriter.class);
        WRITER_MAP.put("PMXML", PrimaveraPMFileWriter.class);
        WRITER_MAP.put("PLANNER", PlannerWriter.class);
        WRITER_MAP.put("JSON", JsonWriter.class);
        WRITER_MAP.put("SDEF", SDEFWriter.class);
        WRITER_MAP.put("XER", PrimaveraXERFileWriter.class);
        FILE_EXCLUDED_METHODS = ProjectTreeController.excludedMethods("getAllResourceAssignments", "getAllResources", "getAllTasks", "getChildTasks", "getCalendars", "getCustomFields", "getEventManager", "getFilters", "getGroups", "getProjectProperties", "getProjectConfig", "getViews", "getTables");
        CALENDAR_EXCLUDED_METHODS = ProjectTreeController.excludedMethods("getCalendarExceptions", "getExpandedCalendarExceptions", "getDerivedCalendars", "getHours", "getDays", "getParent", "getCalendar", "getWorkWeeks");
        CALENDAR_WEEK_EXCLUDED_METHODS = ProjectTreeController.excludedMethods("getCalendar", "getDays", "getHours");
        TASK_EXCLUDED_METHODS = ProjectTreeController.excludedMethods("getChildTasks", "getEffectiveCalendar", "getParentTask", "getResourceAssignments", "getSubprojectObject");
        CALENDAR_EXCEPTION_EXCLUDED_METHODS = ProjectTreeController.excludedMethods("get", "getRange");
        TABLE_EXCLUDED_METHODS = ProjectTreeController.excludedMethods("getColumns");
        CODE_EXCLUDED_METHODS = ProjectTreeController.excludedMethods("getValues");
        CODE_VALUE_EXCLUDED_METHODS = ProjectTreeController.excludedMethods("getParent", "getType");
    }
}

