/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.fasttrack;

import java.io.PrintWriter;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import org.mpxj.fasttrack.AbstractColumn;
import org.mpxj.fasttrack.FastTrackUtility;
import org.mpxj.fasttrack.FixedSizeItemsBlock;

class DateColumn
extends AbstractColumn {
    private static final LocalDate DATE_EPOCH = LocalDate.of(1979, 12, 31);

    DateColumn() {
    }

    @Override
    protected int postHeaderSkipBytes() {
        return 0;
    }

    @Override
    protected int readData(byte[] buffer, int offset) {
        offset += 6;
        offset += 4;
        offset = FastTrackUtility.skipToNextMatchingShort(buffer, offset, 10) - 2;
        FixedSizeItemsBlock data = new FixedSizeItemsBlock().read(buffer, offset);
        offset = data.getOffset();
        byte[][] rawData = data.getData();
        this.m_data = new LocalDate[rawData.length];
        for (int index = 0; index < rawData.length; ++index) {
            LocalDate date;
            int year;
            int value;
            byte[] rawValue = rawData[index];
            if (rawValue == null || rawValue.length < 4 || (value = FastTrackUtility.getInt(rawValue, 0)) <= 0 || (year = (date = DATE_EPOCH.plusDays(value)).getYear()) <= 1980 || year >= 2100) continue;
            this.m_data[index] = date;
        }
        return offset;
    }

    @Override
    protected void dumpData(PrintWriter pw) {
        DateTimeFormatter df = DateTimeFormatter.ofPattern("dd/MM/yyyy");
        pw.println("  [Data");
        for (Object item : this.m_data) {
            String value = item == null ? "" : df.format((LocalDate)item);
            pw.println("    " + value);
        }
        pw.println("  ]");
    }
}

