/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.fasttrack;

import java.io.PrintWriter;
import org.mpxj.fasttrack.AbstractColumn;
import org.mpxj.fasttrack.FastTrackUtility;
import org.mpxj.fasttrack.FixedSizeItemsBlock;
import org.mpxj.fasttrack.StringsWithLengthBlock;

class EnumColumn
extends AbstractColumn {
    private String[] m_options;

    EnumColumn() {
    }

    @Override
    protected int postHeaderSkipBytes() {
        return 34;
    }

    @Override
    protected int readData(byte[] buffer, int offset) {
        StringsWithLengthBlock options = new StringsWithLengthBlock().read(buffer, offset, false);
        this.m_options = options.getData();
        offset = options.getOffset();
        FixedSizeItemsBlock data = new FixedSizeItemsBlock().read(buffer, offset += 4);
        offset = data.getOffset();
        byte[][] rawData = data.getData();
        this.m_data = new String[rawData.length];
        for (int index = 0; index < rawData.length; ++index) {
            int optionIndex = FastTrackUtility.getShort(rawData[index], 0) - 1;
            if (optionIndex < 0 || optionIndex >= this.m_options.length) continue;
            this.m_data[index] = this.m_options[optionIndex];
        }
        return offset;
    }

    @Override
    protected void dumpData(PrintWriter pw) {
        pw.println("  [Options");
        for (String string : this.m_options) {
            pw.println("    " + string);
        }
        pw.println("  ]");
        pw.println("  [Data");
        for (Object object : this.m_data) {
            pw.println("    " + object);
        }
        pw.println("  ]");
    }
}

