/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.fasttrack;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.mpxj.TimeUnit;
import org.mpxj.common.CharsetHelper;
import org.mpxj.common.DebugLogPrintWriter;
import org.mpxj.common.InputStreamHelper;
import org.mpxj.fasttrack.AssignmentColumn1;
import org.mpxj.fasttrack.AssignmentColumn2;
import org.mpxj.fasttrack.BooleanColumn;
import org.mpxj.fasttrack.CalendarColumn1;
import org.mpxj.fasttrack.CalendarColumn2;
import org.mpxj.fasttrack.DateColumn;
import org.mpxj.fasttrack.DoubleColumn1;
import org.mpxj.fasttrack.DoubleColumn2;
import org.mpxj.fasttrack.DurationColumn;
import org.mpxj.fasttrack.DurationColumn1;
import org.mpxj.fasttrack.DurationColumn2;
import org.mpxj.fasttrack.EnumColumn;
import org.mpxj.fasttrack.FastTrackColumn;
import org.mpxj.fasttrack.FastTrackField;
import org.mpxj.fasttrack.FastTrackTable;
import org.mpxj.fasttrack.FastTrackTableType;
import org.mpxj.fasttrack.FastTrackUtility;
import org.mpxj.fasttrack.IdentifierColumn1;
import org.mpxj.fasttrack.IdentifierColumn2;
import org.mpxj.fasttrack.IntegerColumn;
import org.mpxj.fasttrack.NumberColumn1;
import org.mpxj.fasttrack.NumberColumn2;
import org.mpxj.fasttrack.PercentColumn;
import org.mpxj.fasttrack.RelationColumn1;
import org.mpxj.fasttrack.RelationColumn2;
import org.mpxj.fasttrack.ShortColumn1;
import org.mpxj.fasttrack.ShortColumn2;
import org.mpxj.fasttrack.StringColumn1;
import org.mpxj.fasttrack.StringColumn2;
import org.mpxj.fasttrack.TimeColumn;
import org.mpxj.fasttrack.UnexpectedStructureException;
import org.mpxj.fasttrack.UnknownColumn;

class FastTrackData {
    private byte[] m_buffer;
    private PrintWriter m_log;
    private final Map<FastTrackTableType, FastTrackTable> m_tables = new EnumMap<FastTrackTableType, FastTrackTable>(FastTrackTableType.class);
    private FastTrackTable m_currentTable;
    private FastTrackColumn m_currentColumn;
    private final Set<FastTrackField> m_currentFields = new HashSet<FastTrackField>();
    private TimeUnit m_durationTimeUnit;
    private TimeUnit m_workTimeUnit;
    private boolean m_supported;
    private Charset m_charset;
    private Class<?>[] m_columnMap;
    private static final ThreadLocal<FastTrackData> INSTANCE = ThreadLocal.withInitial(FastTrackData::new);
    private static final byte[][] PARENT_BLOCK_PATTERNS = new byte[][]{{-5, 1, 2, 0, 2, 0, -1, -1, 0, 0, 0}, {-4, 1, 2, 0, 2, 0, -1, -1, 0, 0, 0}, {-3, 1, 2, 0, 2, 0, -1, -1, 0, 0, 0}, {0, 0, 2, 0, 2, 0, -1, -1, 0, 0, 0}};
    private static final byte[][] CHILD_BLOCK_PATTERNS = new byte[][]{{5, 0, 0, 0, 1, 0}, {5, 0, 0, 0, 2, 0}, {6, 0, 0, 0, 2, 0}};
    private static final byte[][] TABLE_BLOCK_PATTERNS = new byte[][]{{0, 0, 0, 101, 0, 1, 0}, {0, 0, 0, 101, 0, 2, 0}};
    private static final Class<?>[] COLUMN_MAP1 = new Class[256];
    private static final Class<?>[] COLUMN_MAP2;
    private static final Map<String, FastTrackTableType> REQUIRED_TABLES;
    private static final FastTrackTable EMPTY_TABLE;

    FastTrackData() {
    }

    public void process(File file) throws Exception {
        this.openLogFile();
        int blockIndex = 0;
        int length = (int)file.length();
        try (FileInputStream is = new FileInputStream(file);){
            this.m_buffer = InputStreamHelper.read((InputStream)is, length);
        }
        this.configureVersion();
        if (this.getSupported()) {
            ArrayList<Integer> blocks = new ArrayList<Integer>();
            for (int index = 64; index < this.m_buffer.length - 11; ++index) {
                if (!this.matchPattern(PARENT_BLOCK_PATTERNS, index)) continue;
                blocks.add(index);
            }
            int startIndex = 0;
            Iterator iterator = blocks.iterator();
            while (iterator.hasNext()) {
                int endIndex = (Integer)iterator.next();
                int blockLength = endIndex - startIndex;
                this.readBlock(blockIndex, startIndex, blockLength);
                startIndex = endIndex;
                ++blockIndex;
            }
            int blockLength = this.m_buffer.length - startIndex;
            this.readBlock(blockIndex, startIndex, blockLength);
        }
        this.closeLogFile();
    }

    private void configureVersion() {
        int version = FastTrackUtility.getInt(this.m_buffer, 4);
        switch (version) {
            case 139: {
                this.m_supported = true;
                this.m_charset = CharsetHelper.UTF16LE;
                this.m_columnMap = COLUMN_MAP1;
                break;
            }
            case 144: 
            case 145: {
                this.m_supported = true;
                this.m_charset = CharsetHelper.UTF8;
                this.m_columnMap = COLUMN_MAP1;
                break;
            }
            case 146: {
                this.m_supported = true;
                this.m_charset = CharsetHelper.UTF8;
                this.m_columnMap = COLUMN_MAP2;
                break;
            }
            default: {
                this.m_supported = false;
            }
        }
    }

    public boolean getSupported() {
        return this.m_supported;
    }

    public Charset getCharset() {
        return this.m_charset;
    }

    public FastTrackTable getTable(FastTrackTableType type) {
        return this.m_tables.getOrDefault((Object)type, EMPTY_TABLE);
    }

    TimeUnit getDurationTimeUnit() {
        return this.m_durationTimeUnit == null ? TimeUnit.DAYS : this.m_durationTimeUnit;
    }

    TimeUnit getWorkTimeUnit() {
        return this.m_workTimeUnit == null ? TimeUnit.HOURS : this.m_workTimeUnit;
    }

    private void readBlock(int blockIndex, int startIndex, int blockLength) throws Exception {
        this.logBlock(blockIndex, startIndex, blockLength);
        if (blockLength < 128) {
            this.readTableBlock(startIndex, blockLength);
        } else {
            this.readColumnBlock(startIndex, blockLength);
        }
    }

    private void readTableBlock(int startIndex, int blockLength) {
        for (int index = startIndex; index < startIndex + blockLength - 11; ++index) {
            int nameLength;
            String name;
            FastTrackTableType type;
            if (!this.matchPattern(TABLE_BLOCK_PATTERNS, index)) continue;
            int offset = index + 7;
            if ((type = REQUIRED_TABLES.get(name = FastTrackUtility.getString(this.m_buffer, offset += 4, nameLength = FastTrackUtility.getInt(this.m_buffer, offset)).toUpperCase())) != null) {
                this.m_currentTable = new FastTrackTable(type, this);
                this.m_tables.put(type, this.m_currentTable);
            } else {
                this.m_currentTable = null;
            }
            this.m_currentFields.clear();
            break;
        }
    }

    private void readColumnBlock(int startIndex, int blockLength) throws Exception {
        int endIndex = startIndex + blockLength;
        ArrayList<Integer> blocks = new ArrayList<Integer>();
        for (int index = startIndex; index < endIndex - 11; ++index) {
            if (!this.matchChildBlock(index)) continue;
            int childBlockStart = index - 2;
            blocks.add(childBlockStart);
        }
        blocks.add(endIndex);
        int childBlockStart = -1;
        Iterator iterator = blocks.iterator();
        while (iterator.hasNext()) {
            int childBlockEnd = (Integer)iterator.next();
            if (childBlockStart != -1) {
                int childblockLength = childBlockEnd - childBlockStart;
                try {
                    this.readColumn(childBlockStart, childblockLength);
                }
                catch (UnexpectedStructureException ex) {
                    this.logUnexpectedStructure();
                }
            }
            childBlockStart = childBlockEnd;
        }
    }

    private void readColumn(int startIndex, int length) throws Exception {
        if (this.m_currentTable != null) {
            FastTrackColumn column;
            int value = FastTrackUtility.getByte(this.m_buffer, startIndex);
            Class<Object> klass = this.m_columnMap[value];
            if (klass == null) {
                klass = UnknownColumn.class;
            }
            this.m_currentColumn = column = (FastTrackColumn)klass.newInstance();
            this.logColumnData(startIndex, length);
            column.read(this.m_currentTable.getType(), this.m_buffer, startIndex, length);
            FastTrackField type = column.getType();
            if (type != null && !this.m_currentFields.contains(type)) {
                this.m_currentFields.add(type);
                this.m_currentTable.addColumn(column);
                this.updateDurationTimeUnit(column);
                this.updateWorkTimeUnit(column);
                this.logColumn(column);
            }
        }
    }

    private boolean matchPattern(byte[][] patterns, int bufferIndex) {
        boolean match = false;
        for (byte[] pattern : patterns) {
            int index = 0;
            match = true;
            for (byte b : pattern) {
                if (b != this.m_buffer[bufferIndex + index]) {
                    match = false;
                    break;
                }
                ++index;
            }
            if (match) break;
        }
        return match;
    }

    private boolean matchChildBlock(int bufferIndex) {
        if (!this.matchPattern(CHILD_BLOCK_PATTERNS, bufferIndex)) {
            return false;
        }
        int index = 6;
        int nameLength = FastTrackUtility.getInt(this.m_buffer, bufferIndex + index);
        return nameLength > 0 && nameLength < 100;
    }

    private void updateDurationTimeUnit(FastTrackColumn column) {
        int value;
        if (this.m_durationTimeUnit == null && this.isDurationColumn(column) && (value = ((DurationColumn)column).getTimeUnitValue()) != 1) {
            this.m_durationTimeUnit = FastTrackUtility.getTimeUnit(value);
        }
    }

    private void updateWorkTimeUnit(FastTrackColumn column) {
        int value;
        if (this.m_workTimeUnit == null && this.isWorkColumn(column) && (value = ((DurationColumn)column).getTimeUnitValue()) != 1) {
            this.m_workTimeUnit = FastTrackUtility.getTimeUnit(value);
        }
    }

    private boolean isDurationColumn(FastTrackColumn column) {
        return column instanceof DurationColumn && column.getName().contains("Duration");
    }

    private boolean isWorkColumn(FastTrackColumn column) {
        return column instanceof DurationColumn && column.getName().contains("Work");
    }

    private void openLogFile() {
        this.m_log = DebugLogPrintWriter.getInstance();
    }

    private void closeLogFile() {
        if (this.m_log != null) {
            this.m_log.flush();
            this.m_log.close();
        }
    }

    private void logBlock(int blockIndex, int startIndex, int blockLength) {
        if (this.m_log != null) {
            this.m_log.println("Block Index: " + blockIndex);
            this.m_log.println("Length: " + blockLength + " (" + Integer.toHexString(blockLength) + ")");
            this.m_log.println();
            this.m_log.println(FastTrackUtility.hexdump(this.m_buffer, startIndex, true, blockLength, true, 16, ""));
            this.m_log.flush();
        }
    }

    private void logColumnData(int startIndex, int length) {
        if (this.m_log != null) {
            this.m_log.println();
            this.m_log.println(FastTrackUtility.hexdump(this.m_buffer, startIndex, true, length, true, 16, ""));
            this.m_log.println();
            this.m_log.flush();
        }
    }

    private void logUnexpectedStructure() {
        if (this.m_log != null) {
            this.m_log.println("ABORTED COLUMN - unexpected structure: " + this.m_currentColumn.getClass().getSimpleName() + " " + this.m_currentColumn.getName());
        }
    }

    private void logColumn(FastTrackColumn column) {
        if (this.m_log != null) {
            this.m_log.println("TABLE: " + (Object)((Object)this.m_currentTable.getType()));
            this.m_log.println(column.toString());
            this.m_log.flush();
        }
    }

    public static FastTrackData getInstance() {
        return INSTANCE.get();
    }

    public static void clearInstance() {
        INSTANCE.remove();
    }

    static {
        FastTrackData.COLUMN_MAP1[110] = DateColumn.class;
        FastTrackData.COLUMN_MAP1[111] = TimeColumn.class;
        FastTrackData.COLUMN_MAP1[113] = DurationColumn1.class;
        FastTrackData.COLUMN_MAP1[70] = PercentColumn.class;
        FastTrackData.COLUMN_MAP1[108] = ShortColumn1.class;
        FastTrackData.COLUMN_MAP1[115] = ShortColumn1.class;
        FastTrackData.COLUMN_MAP1[109] = IdentifierColumn1.class;
        FastTrackData.COLUMN_MAP1[112] = NumberColumn1.class;
        FastTrackData.COLUMN_MAP1[92] = CalendarColumn1.class;
        FastTrackData.COLUMN_MAP1[75] = IntegerColumn.class;
        FastTrackData.COLUMN_MAP1[73] = AssignmentColumn1.class;
        FastTrackData.COLUMN_MAP1[89] = EnumColumn.class;
        FastTrackData.COLUMN_MAP1[83] = BooleanColumn.class;
        FastTrackData.COLUMN_MAP1[91] = DoubleColumn1.class;
        FastTrackData.COLUMN_MAP1[74] = DoubleColumn1.class;
        FastTrackData.COLUMN_MAP1[84] = DoubleColumn1.class;
        FastTrackData.COLUMN_MAP1[87] = RelationColumn1.class;
        FastTrackData.COLUMN_MAP1[88] = RelationColumn1.class;
        FastTrackData.COLUMN_MAP1[104] = StringColumn1.class;
        FastTrackData.COLUMN_MAP1[105] = StringColumn1.class;
        COLUMN_MAP2 = new Class[256];
        FastTrackData.COLUMN_MAP2[110] = DateColumn.class;
        FastTrackData.COLUMN_MAP2[111] = TimeColumn.class;
        FastTrackData.COLUMN_MAP2[113] = DurationColumn2.class;
        FastTrackData.COLUMN_MAP2[70] = PercentColumn.class;
        FastTrackData.COLUMN_MAP2[108] = ShortColumn2.class;
        FastTrackData.COLUMN_MAP2[115] = ShortColumn2.class;
        FastTrackData.COLUMN_MAP2[109] = IdentifierColumn2.class;
        FastTrackData.COLUMN_MAP2[112] = NumberColumn2.class;
        FastTrackData.COLUMN_MAP2[92] = CalendarColumn2.class;
        FastTrackData.COLUMN_MAP2[75] = IntegerColumn.class;
        FastTrackData.COLUMN_MAP2[73] = AssignmentColumn2.class;
        FastTrackData.COLUMN_MAP2[89] = EnumColumn.class;
        FastTrackData.COLUMN_MAP2[83] = BooleanColumn.class;
        FastTrackData.COLUMN_MAP2[91] = DoubleColumn2.class;
        FastTrackData.COLUMN_MAP2[74] = DoubleColumn2.class;
        FastTrackData.COLUMN_MAP2[84] = DoubleColumn2.class;
        FastTrackData.COLUMN_MAP2[87] = RelationColumn2.class;
        FastTrackData.COLUMN_MAP2[88] = RelationColumn2.class;
        FastTrackData.COLUMN_MAP2[104] = StringColumn2.class;
        FastTrackData.COLUMN_MAP2[105] = StringColumn2.class;
        REQUIRED_TABLES = new HashMap<String, FastTrackTableType>();
        REQUIRED_TABLES.put("ACTBARS", FastTrackTableType.ACTBARS);
        REQUIRED_TABLES.put("ACTIVITIES", FastTrackTableType.ACTIVITIES);
        REQUIRED_TABLES.put("RESOURCES", FastTrackTableType.RESOURCES);
        EMPTY_TABLE = new FastTrackTable(null, null);
    }
}

