/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.ganttdesigner;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import org.mpxj.Duration;
import org.mpxj.TimeUnit;
import org.mpxj.common.DayOfWeekHelper;

public final class DatatypeConverter {
    private static final DateTimeFormatter TIMESTAMP_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    public static final LocalDateTime parseTimestamp(String value) {
        LocalDateTime result = null;
        if (value != null && !value.isEmpty()) {
            try {
                result = LocalDateTime.parse(value, TIMESTAMP_FORMAT);
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
        }
        return result;
    }

    public static final String printTimestamp(LocalDateTime value) {
        return value == null ? null : TIMESTAMP_FORMAT.format(value);
    }

    public static final Duration parseDuration(String value) {
        return value == null ? null : Duration.getInstance(Double.parseDouble(value), TimeUnit.DAYS);
    }

    public static final String printDuration(Duration value) {
        return value == null ? null : Double.toString(value.getDuration());
    }

    public static final LocalDate parseDate(String value) {
        LocalDate result = null;
        if (value != null && !value.isEmpty()) {
            try {
                result = LocalDate.parse(value, DATE_FORMAT);
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
        }
        return result;
    }

    public static final String printDate(LocalDate value) {
        return value == null ? null : DATE_FORMAT.format(value);
    }

    public static final Double parsePercent(String value) {
        return value == null ? null : Double.valueOf(Double.parseDouble(value) * 100.0);
    }

    public static final String printPercent(Double value) {
        return value == null ? null : Double.toString(value / 100.0);
    }

    public static final DayOfWeek parseDay(String value) {
        return DayOfWeekHelper.getInstance(Integer.parseInt(value) + 1);
    }

    public static final String printDay(DayOfWeek value) {
        return Integer.toString(DayOfWeekHelper.getValue(value) - 1);
    }
}

