/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.ganttproject;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import java.io.InputStream;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.FormatStyle;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import org.mpxj.ChildTaskContainer;
import org.mpxj.ConstraintType;
import org.mpxj.CostRateTable;
import org.mpxj.CostRateTableEntry;
import org.mpxj.DataType;
import org.mpxj.Duration;
import org.mpxj.EventManager;
import org.mpxj.FieldType;
import org.mpxj.FieldTypeClass;
import org.mpxj.MPXJException;
import org.mpxj.Priority;
import org.mpxj.ProjectCalendar;
import org.mpxj.ProjectCalendarDays;
import org.mpxj.ProjectCalendarException;
import org.mpxj.ProjectCalendarHours;
import org.mpxj.ProjectConfig;
import org.mpxj.ProjectFile;
import org.mpxj.ProjectProperties;
import org.mpxj.Relation;
import org.mpxj.RelationType;
import org.mpxj.Resource;
import org.mpxj.ResourceAssignment;
import org.mpxj.TimeUnit;
import org.mpxj.UserDefinedField;
import org.mpxj.UserDefinedFieldContainer;
import org.mpxj.common.LocalDateTimeHelper;
import org.mpxj.common.NumberHelper;
import org.mpxj.common.Pair;
import org.mpxj.common.UnmarshalHelper;
import org.mpxj.ganttproject.schema.Allocation;
import org.mpxj.ganttproject.schema.Allocations;
import org.mpxj.ganttproject.schema.Calendars;
import org.mpxj.ganttproject.schema.CustomPropertyDefinition;
import org.mpxj.ganttproject.schema.CustomResourceProperty;
import org.mpxj.ganttproject.schema.CustomTaskProperty;
import org.mpxj.ganttproject.schema.Date;
import org.mpxj.ganttproject.schema.DayTypes;
import org.mpxj.ganttproject.schema.DefaultWeek;
import org.mpxj.ganttproject.schema.Depend;
import org.mpxj.ganttproject.schema.Project;
import org.mpxj.ganttproject.schema.Rate;
import org.mpxj.ganttproject.schema.Resources;
import org.mpxj.ganttproject.schema.Role;
import org.mpxj.ganttproject.schema.Roles;
import org.mpxj.ganttproject.schema.Task;
import org.mpxj.ganttproject.schema.Taskproperty;
import org.mpxj.ganttproject.schema.Tasks;
import org.mpxj.reader.AbstractProjectStreamReader;
import org.xml.sax.SAXException;

public final class GanttProjectReader
extends AbstractProjectStreamReader {
    private ProjectFile m_projectFile;
    private ProjectCalendar m_mpxjCalendar;
    private EventManager m_eventManager;
    private DateTimeFormatter m_localeDateFormat;
    private DateTimeFormatter m_dateFormat;
    private Map<String, Pair<FieldType, Object>> m_resourcePropertyDefinitions;
    private Map<String, Pair<FieldType, Object>> m_taskPropertyDefinitions;
    private Map<String, String> m_roleDefinitions;
    private static final int[] PRIORITY = new int[]{400, 500, 600, 100, 900};
    private static final RelationType[] RELATION = new RelationType[]{null, RelationType.START_START, RelationType.FINISH_START, RelationType.FINISH_FINISH, RelationType.START_FINISH};
    private static final Map<String, DataType> DATA_TYPE_MAP = new HashMap<String, DataType>();
    private static final Pattern YEAR_PATTERN;
    private static JAXBContext CONTEXT;
    private static JAXBException CONTEXT_EXCEPTION;

    @Override
    public ProjectFile read(InputStream stream) throws MPXJException {
        try {
            if (CONTEXT == null) {
                throw CONTEXT_EXCEPTION;
            }
            this.m_projectFile = new ProjectFile();
            this.m_eventManager = this.m_projectFile.getEventManager();
            this.m_resourcePropertyDefinitions = new HashMap<String, Pair<FieldType, Object>>();
            this.m_taskPropertyDefinitions = new HashMap<String, Pair<FieldType, Object>>();
            this.m_roleDefinitions = new HashMap<String, String>();
            this.m_dateFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SS'Z'");
            ProjectConfig config = this.m_projectFile.getProjectConfig();
            config.setAutoResourceUniqueID(false);
            config.setAutoTaskUniqueID(false);
            config.setAutoOutlineLevel(true);
            config.setAutoOutlineNumber(true);
            config.setAutoWBS(true);
            this.m_projectFile.getProjectProperties().setFileApplication("GanttProject");
            this.m_projectFile.getProjectProperties().setFileType("GAN");
            this.addListenersToProject(this.m_projectFile);
            Project ganttProject = (Project)UnmarshalHelper.unmarshal(CONTEXT, stream);
            this.readProjectProperties(ganttProject);
            this.readCalendars(ganttProject);
            this.readResources(ganttProject);
            this.readTasks(ganttProject);
            this.readRelationships(ganttProject);
            this.readResourceAssignments(ganttProject);
            this.m_projectFile.readComplete();
            ProjectFile projectFile = this.m_projectFile;
            return projectFile;
        }
        catch (JAXBException | ParserConfigurationException | SAXException ex) {
            throw new MPXJException("Failed to parse file", (Exception)ex);
        }
        finally {
            this.m_projectFile = null;
            this.m_mpxjCalendar = null;
            this.m_eventManager = null;
            this.m_localeDateFormat = null;
            this.m_resourcePropertyDefinitions = null;
            this.m_taskPropertyDefinitions = null;
            this.m_roleDefinitions = null;
        }
    }

    private void readProjectProperties(Project ganttProject) {
        ProjectProperties mpxjProperties = this.m_projectFile.getProjectProperties();
        mpxjProperties.setName(ganttProject.getName());
        mpxjProperties.setCompany(ganttProject.getCompany());
        mpxjProperties.setDefaultDurationUnits(TimeUnit.DAYS);
        String locale = ganttProject.getLocale();
        locale = locale == null ? "en-US" : locale.replace('_', '-');
        String shortPattern = DateTimeFormatterBuilder.getLocalizedDateTimePattern(FormatStyle.SHORT, null, IsoChronology.INSTANCE, Locale.forLanguageTag(locale));
        Matcher matcher = YEAR_PATTERN.matcher(shortPattern);
        if (matcher.matches()) {
            shortPattern = shortPattern.replace(matcher.group(1), "[yyyy][yy]");
        }
        this.m_localeDateFormat = DateTimeFormatter.ofPattern(shortPattern);
    }

    private void readCalendars(Project ganttProject) {
        this.m_mpxjCalendar = this.m_projectFile.addCalendar();
        this.m_mpxjCalendar.setName("Standard");
        this.m_projectFile.getProjectProperties().setDefaultCalendar(this.m_mpxjCalendar);
        Calendars gpCalendar = ganttProject.getCalendars();
        this.setWorkingDays(this.m_mpxjCalendar, gpCalendar);
        this.setExceptions(this.m_mpxjCalendar, gpCalendar);
        this.m_eventManager.fireCalendarReadEvent(this.m_mpxjCalendar);
    }

    private void setWorkingDays(ProjectCalendar mpxjCalendar, Calendars gpCalendar) {
        DayTypes dayTypes = gpCalendar.getDayTypes();
        DefaultWeek defaultWeek = dayTypes.getDefaultWeek();
        if (defaultWeek == null) {
            mpxjCalendar.setWorkingDay(DayOfWeek.SUNDAY, false);
            mpxjCalendar.setWorkingDay(DayOfWeek.MONDAY, true);
            mpxjCalendar.setWorkingDay(DayOfWeek.TUESDAY, true);
            mpxjCalendar.setWorkingDay(DayOfWeek.WEDNESDAY, true);
            mpxjCalendar.setWorkingDay(DayOfWeek.THURSDAY, true);
            mpxjCalendar.setWorkingDay(DayOfWeek.FRIDAY, true);
            mpxjCalendar.setWorkingDay(DayOfWeek.SATURDAY, false);
        } else {
            mpxjCalendar.setWorkingDay(DayOfWeek.MONDAY, this.isWorkingDay(defaultWeek.getMon()));
            mpxjCalendar.setWorkingDay(DayOfWeek.TUESDAY, this.isWorkingDay(defaultWeek.getTue()));
            mpxjCalendar.setWorkingDay(DayOfWeek.WEDNESDAY, this.isWorkingDay(defaultWeek.getWed()));
            mpxjCalendar.setWorkingDay(DayOfWeek.THURSDAY, this.isWorkingDay(defaultWeek.getThu()));
            mpxjCalendar.setWorkingDay(DayOfWeek.FRIDAY, this.isWorkingDay(defaultWeek.getFri()));
            mpxjCalendar.setWorkingDay(DayOfWeek.SATURDAY, this.isWorkingDay(defaultWeek.getSat()));
            mpxjCalendar.setWorkingDay(DayOfWeek.SUNDAY, this.isWorkingDay(defaultWeek.getSun()));
        }
        for (DayOfWeek day : DayOfWeek.values()) {
            ProjectCalendarHours hours = mpxjCalendar.addCalendarHours(day);
            if (!mpxjCalendar.isWorkingDay(day)) continue;
            hours.add(ProjectCalendarDays.DEFAULT_WORKING_MORNING);
            hours.add(ProjectCalendarDays.DEFAULT_WORKING_AFTERNOON);
        }
    }

    private boolean isWorkingDay(Integer value) {
        return NumberHelper.getInt(value) == 0;
    }

    private void setExceptions(ProjectCalendar mpxjCalendar, Calendars gpCalendar) {
        List<Date> dates = gpCalendar.getDate();
        for (Date date : dates) {
            this.addException(mpxjCalendar, date);
        }
    }

    private void addException(ProjectCalendar mpxjCalendar, Date date) {
        String year = date.getYear();
        if (year != null && !year.isEmpty()) {
            LocalDate exceptionDate = LocalDate.of(Integer.parseInt(year), date.getMonth(), (int)date.getDate());
            ProjectCalendarException exception = mpxjCalendar.addCalendarException(exceptionDate);
            if ("WORKING_DAY".equals(date.getType())) {
                exception.add(ProjectCalendarDays.DEFAULT_WORKING_MORNING);
                exception.add(ProjectCalendarDays.DEFAULT_WORKING_AFTERNOON);
            }
        }
    }

    private void readResources(Project ganttProject) {
        Resources resources = ganttProject.getResources();
        this.readResourceCustomPropertyDefinitions(resources);
        this.readRoleDefinitions(ganttProject);
        for (org.mpxj.ganttproject.schema.Resource gpResource : resources.getResource()) {
            this.readResource(gpResource);
        }
    }

    private void readResourceCustomPropertyDefinitions(Resources gpResources) {
        UserDefinedFieldContainer container = this.m_projectFile.getUserDefinedFields();
        for (CustomPropertyDefinition definition : gpResources.getCustomPropertyDefinition()) {
            DataType type = DATA_TYPE_MAP.get(definition.getType());
            if (type == null) continue;
            UserDefinedField fieldType = new UserDefinedField.Builder(this.m_projectFile).externalName(definition.getName()).fieldTypeClass(FieldTypeClass.RESOURCE).dataType(type).build();
            container.add(fieldType);
            this.m_projectFile.getCustomFields().add(fieldType).setAlias(definition.getName());
            String defaultValue = definition.getDefaultValue();
            if (defaultValue != null && defaultValue.isEmpty()) {
                defaultValue = null;
            }
            this.m_resourcePropertyDefinitions.put(definition.getId(), new Pair<UserDefinedField, Object>(fieldType, this.parseValue(fieldType.getDataType(), this.m_localeDateFormat, defaultValue)));
        }
    }

    private void readTaskCustomPropertyDefinitions(Tasks gpTasks) {
        UserDefinedFieldContainer container = this.m_projectFile.getUserDefinedFields();
        for (Taskproperty definition : gpTasks.getTaskproperties().getTaskproperty()) {
            DataType type;
            if (!"custom".equals(definition.getType()) || (type = DATA_TYPE_MAP.get(definition.getValuetype())) == null) continue;
            UserDefinedField fieldType = new UserDefinedField.Builder(this.m_projectFile).externalName(definition.getName()).fieldTypeClass(FieldTypeClass.TASK).dataType(type).build();
            container.add(fieldType);
            this.m_projectFile.getCustomFields().add(fieldType).setAlias(definition.getName());
            String defaultValue = definition.getDefaultvalue();
            if (defaultValue != null && defaultValue.isEmpty()) {
                defaultValue = null;
            }
            this.m_taskPropertyDefinitions.put(definition.getId(), new Pair<UserDefinedField, Object>(fieldType, this.parseValue(fieldType.getDataType(), this.m_dateFormat, defaultValue)));
        }
    }

    private void readRoleDefinitions(Project gpProject) {
        this.m_roleDefinitions.put("Default:1", "project manager");
        for (Roles roles : gpProject.getRoles()) {
            if ("Default".equals(roles.getRolesetName())) continue;
            for (Role role : roles.getRole()) {
                this.m_roleDefinitions.put(role.getId(), role.getName());
            }
        }
    }

    private void readResource(org.mpxj.ganttproject.schema.Resource gpResource) {
        Resource mpxjResource = this.m_projectFile.addResource();
        mpxjResource.setUniqueID(NumberHelper.getInt(gpResource.getId()) + 1);
        mpxjResource.setName(gpResource.getName());
        mpxjResource.setEmailAddress(gpResource.getContacts());
        mpxjResource.setPhone(gpResource.getPhone());
        mpxjResource.setGroup(this.m_roleDefinitions.get(gpResource.getFunction()));
        this.readResourceCustomFields(gpResource, mpxjResource);
        Rate gpRate = gpResource.getRate();
        if (gpRate != null) {
            CostRateTable table = new CostRateTable();
            table.add(new CostRateTableEntry(LocalDateTimeHelper.START_DATE_NA, LocalDateTimeHelper.END_DATE_NA, (Number)NumberHelper.DOUBLE_ZERO, new org.mpxj.Rate(gpRate.getValueAttribute(), TimeUnit.DAYS)));
            mpxjResource.setCostRateTable(0, table);
        }
        this.m_eventManager.fireResourceReadEvent(mpxjResource);
    }

    private void readResourceCustomFields(org.mpxj.ganttproject.schema.Resource gpResource, Resource mpxjResource) {
        HashMap<FieldType, Object> customFields = new HashMap<FieldType, Object>();
        for (Pair<FieldType, Object> pair : this.m_resourcePropertyDefinitions.values()) {
            customFields.put(pair.getFirst(), pair.getSecond());
        }
        for (CustomResourceProperty customResourceProperty : gpResource.getCustomProperty()) {
            Object result;
            Pair<FieldType, Object> definition = this.m_resourcePropertyDefinitions.get(customResourceProperty.getDefinitionId());
            if (definition == null) continue;
            String value = customResourceProperty.getValueAttribute();
            if (value.isEmpty()) {
                value = null;
            }
            if ((result = this.parseValue(definition.getFirst().getDataType(), this.m_localeDateFormat, value)) == null) continue;
            customFields.put(definition.getFirst(), result);
        }
        for (Map.Entry entry : customFields.entrySet()) {
            if (entry.getValue() == null) continue;
            mpxjResource.set((FieldType)entry.getKey(), entry.getValue());
        }
    }

    private void readTaskCustomFields(Task gpTask, org.mpxj.Task mpxjTask) {
        HashMap<FieldType, Object> customFields = new HashMap<FieldType, Object>();
        for (Pair<FieldType, Object> pair : this.m_taskPropertyDefinitions.values()) {
            customFields.put(pair.getFirst(), pair.getSecond());
        }
        for (CustomTaskProperty customTaskProperty : gpTask.getCustomproperty()) {
            Object result;
            Pair<FieldType, Object> definition = this.m_taskPropertyDefinitions.get(customTaskProperty.getTaskpropertyId());
            if (definition == null) continue;
            String value = customTaskProperty.getValueAttribute();
            if (value.isEmpty()) {
                value = null;
            }
            if ((result = this.parseValue(definition.getFirst().getDataType(), this.m_dateFormat, value)) == null) continue;
            customFields.put(definition.getFirst(), result);
        }
        for (Map.Entry entry : customFields.entrySet()) {
            if (entry.getValue() == null) continue;
            mpxjTask.set((FieldType)entry.getKey(), entry.getValue());
        }
    }

    private Object parseValue(DataType type, DateTimeFormatter dateFormat, String value) {
        Object result = null;
        if (value != null) {
            switch (type) {
                case NUMERIC: {
                    if (value.indexOf(46) == -1) {
                        result = Integer.valueOf(value);
                        break;
                    }
                    result = Double.valueOf(value);
                    break;
                }
                case DATE: {
                    try {
                        result = LocalDateTimeHelper.parseBest(dateFormat, value);
                    }
                    catch (DateTimeParseException dateTimeParseException) {}
                    break;
                }
                case BOOLEAN: {
                    result = value.equals("true");
                    break;
                }
                default: {
                    result = value;
                }
            }
        }
        return result;
    }

    private void readTasks(Project gpProject) {
        Tasks tasks = gpProject.getTasks();
        this.readTaskCustomPropertyDefinitions(tasks);
        for (Task task : tasks.getTask()) {
            this.readTask(this.m_projectFile, task);
        }
    }

    private void readTask(ChildTaskContainer mpxjParent, Task gpTask) {
        org.mpxj.Task mpxjTask = mpxjParent.addTask();
        mpxjTask.setUniqueID(NumberHelper.getInt(gpTask.getId()) + 1);
        mpxjTask.setName(gpTask.getName());
        mpxjTask.setPercentageComplete(gpTask.getComplete());
        mpxjTask.setPriority(this.getPriority(gpTask.getPriority()));
        mpxjTask.setHyperlink(gpTask.getWebLink());
        Duration duration = Duration.getInstance(NumberHelper.getDouble(gpTask.getDuration()), TimeUnit.DAYS);
        mpxjTask.setDuration(duration);
        if (duration.getDuration() == 0.0) {
            mpxjTask.setMilestone(true);
            mpxjTask.setStart(gpTask.getStart());
            mpxjTask.setFinish(gpTask.getStart());
        } else {
            mpxjTask.setStart(gpTask.getStart());
            mpxjTask.setFinish(this.m_mpxjCalendar.getDate(gpTask.getStart(), mpxjTask.getDuration()));
        }
        mpxjTask.setConstraintDate(gpTask.getThirdDate());
        if (mpxjTask.getConstraintDate() != null) {
            mpxjTask.setConstraintType(ConstraintType.START_NO_EARLIER_THAN);
        }
        this.readTaskCustomFields(gpTask, mpxjTask);
        this.m_eventManager.fireTaskReadEvent(mpxjTask);
        for (Task childTask : gpTask.getTask()) {
            this.readTask(mpxjTask, childTask);
        }
    }

    private Priority getPriority(Integer gpPriority) {
        int index;
        int result = gpPriority == null ? 500 : ((index = gpPriority.intValue()) < 0 || index >= PRIORITY.length ? 500 : PRIORITY[index]);
        return Priority.getInstance(result);
    }

    private void readRelationships(Project gpProject) {
        for (Task gpTask : gpProject.getTasks().getTask()) {
            this.readRelationships(gpTask);
        }
    }

    private void readRelationships(Task gpTask) {
        for (Depend depend : gpTask.getDepend()) {
            org.mpxj.Task task1 = this.m_projectFile.getTaskByUniqueID(NumberHelper.getInt(gpTask.getId()) + 1);
            org.mpxj.Task task2 = this.m_projectFile.getTaskByUniqueID(NumberHelper.getInt(depend.getId()) + 1);
            if (task1 == null || task2 == null) continue;
            Relation relation = task2.addPredecessor(new Relation.Builder().predecessorTask(task1).type(this.getRelationType(depend.getType())).lag(Duration.getInstance(NumberHelper.getInt(depend.getDifference()), TimeUnit.DAYS)));
            this.m_eventManager.fireRelationReadEvent(relation);
        }
    }

    private RelationType getRelationType(Integer gpType) {
        int index;
        RelationType result = null;
        if (gpType != null && (index = NumberHelper.getInt(gpType)) > 0 && index < RELATION.length) {
            result = RELATION[index];
        }
        if (result == null) {
            result = RelationType.FINISH_START;
        }
        return result;
    }

    private void readResourceAssignments(Project gpProject) {
        Allocations allocations = gpProject.getAllocations();
        if (allocations != null) {
            for (Allocation allocation : allocations.getAllocation()) {
                this.readResourceAssignment(allocation);
            }
        }
    }

    private void readResourceAssignment(Allocation gpAllocation) {
        Integer taskID = NumberHelper.getInt(gpAllocation.getTaskId()) + 1;
        Integer resourceID = NumberHelper.getInt(gpAllocation.getResourceId()) + 1;
        org.mpxj.Task task = this.m_projectFile.getTaskByUniqueID(taskID);
        Resource resource = this.m_projectFile.getResourceByUniqueID(resourceID);
        if (task != null && resource != null) {
            ResourceAssignment mpxjAssignment = task.addResourceAssignment(resource);
            mpxjAssignment.setUnits(gpAllocation.getLoad());
            this.m_eventManager.fireAssignmentReadEvent(mpxjAssignment);
        }
    }

    static {
        DATA_TYPE_MAP.put("int", DataType.NUMERIC);
        DATA_TYPE_MAP.put("double", DataType.NUMERIC);
        DATA_TYPE_MAP.put("text", DataType.STRING);
        DATA_TYPE_MAP.put("date", DataType.DATE);
        DATA_TYPE_MAP.put("boolean", DataType.BOOLEAN);
        YEAR_PATTERN = Pattern.compile("[^y]*(y+)[^y]*");
        try {
            System.setProperty("com.sun.xml.bind.v2.runtime.JAXBContextImpl.fastBoot", "true");
            CONTEXT = JAXBContext.newInstance((String)"org.mpxj.ganttproject.schema", (ClassLoader)GanttProjectReader.class.getClassLoader());
        }
        catch (JAXBException ex) {
            CONTEXT_EXCEPTION = ex;
            CONTEXT = null;
        }
    }
}

