/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.ikvm;

import java.io.File;
import java.nio.file.Files;
import java.util.stream.Stream;
import org.mpxj.common.JvmHelper;

public final class OperatingSystem {
    private String m_originalOsName;
    private static final String[] KNOWN_OS_NAMES;
    private static final String REPLACEMENT_OS_NAME;

    public void configure() {
        if (REPLACEMENT_OS_NAME != null) {
            this.m_originalOsName = System.getProperty("os.name");
            System.setProperty("os.name", REPLACEMENT_OS_NAME);
        }
    }

    public void restore() {
        if (REPLACEMENT_OS_NAME != null) {
            System.setProperty("os.name", this.m_originalOsName);
        }
    }

    static {
        boolean osNotKnown;
        KNOWN_OS_NAMES = new String[]{"Windows", "Mac", "Darwin", "Linux"};
        String replacementOsName = null;
        String osname = System.getProperty("os.name");
        boolean bl = osNotKnown = !Stream.of(KNOWN_OS_NAMES).anyMatch(name -> osname.contains((CharSequence)name));
        if (JvmHelper.isIkvm() && osNotKnown) {
            File ostype = new File("/proc/sys/kernel/ostype");
            if (ostype.exists()) {
                try {
                    if (Files.readAllLines(ostype.toPath()).get(0).startsWith("Linux")) {
                        replacementOsName = "Linux";
                    }
                }
                catch (Exception exception) {}
            } else {
                File systemVersion = new File("/System/Library/CoreServices/SystemVersion.plist");
                if (systemVersion.exists()) {
                    replacementOsName = "Mac OS X";
                }
            }
        }
        REPLACEMENT_OS_NAME = replacementOsName;
    }
}

