/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.mpxj.ActivityCode;
import org.mpxj.ActivityCodeValue;
import org.mpxj.AssignmentField;
import org.mpxj.Availability;
import org.mpxj.AvailabilityTable;
import org.mpxj.Code;
import org.mpxj.CodeValue;
import org.mpxj.Column;
import org.mpxj.CostRateTable;
import org.mpxj.CostRateTableEntry;
import org.mpxj.Currency;
import org.mpxj.CustomField;
import org.mpxj.CustomFieldLookupTable;
import org.mpxj.CustomFieldValueMask;
import org.mpxj.DataType;
import org.mpxj.DayType;
import org.mpxj.Duration;
import org.mpxj.EarnedValueMethod;
import org.mpxj.ExpenseItem;
import org.mpxj.FieldContainer;
import org.mpxj.FieldType;
import org.mpxj.GenericCriteria;
import org.mpxj.GraphicalIndicator;
import org.mpxj.GraphicalIndicatorCriteria;
import org.mpxj.LocalDateTimeRange;
import org.mpxj.LocalTimeRange;
import org.mpxj.Priority;
import org.mpxj.ProjectCalendar;
import org.mpxj.ProjectCalendarDays;
import org.mpxj.ProjectCalendarException;
import org.mpxj.ProjectCalendarHours;
import org.mpxj.ProjectCalendarWeek;
import org.mpxj.ProjectField;
import org.mpxj.ProjectFile;
import org.mpxj.ProjectProperties;
import org.mpxj.Rate;
import org.mpxj.RecurringData;
import org.mpxj.Relation;
import org.mpxj.Resource;
import org.mpxj.ResourceAssignment;
import org.mpxj.ResourceField;
import org.mpxj.ResourceRequestType;
import org.mpxj.SkillLevel;
import org.mpxj.Step;
import org.mpxj.Table;
import org.mpxj.Task;
import org.mpxj.TaskField;
import org.mpxj.TaskMode;
import org.mpxj.TaskType;
import org.mpxj.TimeUnit;
import org.mpxj.TimeUnitDefaultsContainer;
import org.mpxj.UnitOfMeasure;
import org.mpxj.UserDefinedField;
import org.mpxj.View;
import org.mpxj.WorkContour;
import org.mpxj.common.CharsetHelper;
import org.mpxj.common.ColorHelper;
import org.mpxj.common.DayOfWeekHelper;
import org.mpxj.common.FieldTypeHelper;
import org.mpxj.common.LocalDateTimeHelper;
import org.mpxj.mpp.CustomFieldValueItem;
import org.mpxj.mpp.GanttBarStyle;
import org.mpxj.mpp.GanttBarStyleException;
import org.mpxj.mpp.GanttChartView;
import org.mpxj.mpp.TableFontStyle;
import org.mpxj.writer.AbstractProjectWriter;

public final class JsonWriter
extends AbstractProjectWriter {
    private ProjectFile m_projectFile;
    private JsonGenerator m_writer;
    private boolean m_pretty;
    private boolean m_includeLayoutData;
    private Charset m_charset = DEFAULT_CHARSET;
    private boolean m_writeAttributeTypes;
    private TimeUnit m_timeUnits;
    private final StringBuilder m_buffer = new StringBuilder();
    private static final Charset DEFAULT_CHARSET = CharsetHelper.UTF8;
    private static final Map<String, DataType> TYPE_MAP = new HashMap<String, DataType>();
    private static final Map<TimeUnit, TimeUnit> ELAPSED_TIME_UNIT_MAP;
    private static final Set<FieldType> IGNORED_FIELDS;
    private static final Set<FieldType> MANDATORY_FIELDS;
    private static final DateTimeFormatter TIMESTAMP_FORMAT;
    private static final DateTimeFormatter DATE_FORMAT;
    private static final DateTimeFormatter TIME_FORMAT;

    public boolean getPretty() {
        return this.m_pretty;
    }

    public void setPretty(boolean pretty) {
        this.m_pretty = pretty;
    }

    public boolean getIncludeLayoutData() {
        return this.m_includeLayoutData;
    }

    public void setIncludeLayoutData(boolean includeLayoutData) {
        this.m_includeLayoutData = includeLayoutData;
    }

    public Charset getCharset() {
        return this.m_charset;
    }

    public void setCharset(Charset charset) {
        this.m_charset = charset;
    }

    public boolean getWriteAttributeTypes() {
        return this.m_writeAttributeTypes;
    }

    public void setWriteAttributeTypes(boolean writeAttributeTypes) {
        this.m_writeAttributeTypes = writeAttributeTypes;
    }

    public void setTimeUnits(TimeUnit value) {
        this.m_timeUnits = value;
    }

    public TimeUnit getTimeUnits() {
        return this.m_timeUnits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(ProjectFile projectFile, OutputStream stream) throws IOException {
        try {
            this.m_projectFile = projectFile;
            JsonFactory factory = new JsonFactory();
            this.m_writer = factory.createGenerator(stream);
            if (this.m_pretty) {
                this.m_writer.setPrettyPrinter((PrettyPrinter)new DefaultPrettyPrinter());
            }
            this.m_writer.writeStartObject();
            this.writeProperties();
            this.writeCurrencies();
            this.writeUserDefinedFields();
            this.writeCustomFields();
            this.writeWorkContours();
            this.writeCodes("project_codes", this.m_projectFile.getProjectCodes());
            this.writeCodes("resource_codes", this.m_projectFile.getResourceCodes());
            this.writeCodes("role_codes", this.m_projectFile.getRoleCodes());
            this.writeCodes("resource_assignment_codes", this.m_projectFile.getResourceAssignmentCodes());
            this.writeActivityCodes();
            this.writeUnitsOfMeasure();
            this.writeCalendars();
            this.writeResources();
            this.writeTasks();
            this.writeAssignments();
            if (this.m_includeLayoutData) {
                this.writeTables();
                this.writeViews();
            }
            this.m_writer.writeEndObject();
            this.m_writer.flush();
        }
        finally {
            this.m_projectFile = null;
        }
    }

    private void writeUserDefinedFields() throws IOException {
        List sortedFieldsList = this.m_projectFile.getUserDefinedFields().stream().sorted(Comparator.comparing(FieldTypeHelper::getFieldID)).collect(Collectors.toList());
        if (sortedFieldsList.isEmpty()) {
            return;
        }
        this.m_writer.writeArrayFieldStart("user_defined_fields");
        for (UserDefinedField field : sortedFieldsList) {
            this.writeUserDefinedField(field);
        }
        this.m_writer.writeEndArray();
    }

    private void writeCustomFields() throws IOException {
        List sortedFieldsList = this.m_projectFile.getCustomFields().stream().filter(f -> f.getFieldType() != null).sorted().collect(Collectors.toList());
        if (sortedFieldsList.isEmpty()) {
            return;
        }
        this.m_writer.writeArrayFieldStart("custom_fields");
        for (CustomField field : sortedFieldsList) {
            this.writeCustomField(field);
        }
        this.m_writer.writeEndArray();
    }

    private void writeWorkContours() throws IOException {
        List contours = this.m_projectFile.getWorkContours().stream().filter(w -> !w.isContourFlat()).sorted(Comparator.comparing(WorkContour::getUniqueID)).collect(Collectors.toList());
        if (contours.isEmpty()) {
            return;
        }
        this.m_writer.writeArrayFieldStart("work_contours");
        for (WorkContour contour : contours) {
            this.m_writer.writeStartObject();
            this.writeIntegerField("unique_id", contour.getUniqueID());
            this.writeOptionalStringField("name", contour.getName());
            this.writeBooleanField("default", contour.isContourDefault());
            if (contour.getCurveValues() != null) {
                this.writeDoubleList("curve_values", Arrays.stream(contour.getCurveValues()).boxed().collect(Collectors.toList()));
            }
            this.m_writer.writeEndObject();
        }
        this.m_writer.writeEndArray();
    }

    private void writeActivityCodes() throws IOException {
        if (this.m_projectFile.getActivityCodes().isEmpty()) {
            return;
        }
        ArrayList<ActivityCode> sortedActivityCodeList = new ArrayList<ActivityCode>(this.m_projectFile.getActivityCodes());
        sortedActivityCodeList.sort(Comparator.comparing(ActivityCode::getName));
        this.m_writer.writeArrayFieldStart("activity_codes");
        for (ActivityCode code : sortedActivityCodeList) {
            this.writeActivityCode(code);
        }
        this.m_writer.writeEndArray();
    }

    private void writeCodes(String attributeName, List<? extends Code> codes) throws IOException {
        if (codes.isEmpty()) {
            return;
        }
        ArrayList<? extends Code> sortedCodeList = new ArrayList<Code>(codes);
        sortedCodeList.sort(Comparator.comparing(Code::getName));
        this.m_writer.writeArrayFieldStart(attributeName);
        for (Code code : sortedCodeList) {
            this.writeCode(code);
        }
        this.m_writer.writeEndArray();
    }

    private void writeCustomField(CustomField field) throws IOException {
        if (field.getAlias() == null) {
            return;
        }
        this.m_writer.writeStartObject();
        Integer uniqueID = field.getUniqueID();
        if (uniqueID != FieldTypeHelper.getFieldID(field.getFieldType())) {
            this.m_writer.writeNumberField("unique_id", field.getUniqueID().intValue());
        }
        this.writeFieldType("", field.getFieldType());
        this.writeStringField("field_alias", field.getAlias());
        this.writeGraphicalIndicator(field.getGraphicalIndicator());
        this.writeLookupTable(field);
        this.writeCustomFieldValueMasks(field);
        this.m_writer.writeEndObject();
    }

    private void writeLookupTable(CustomField field) throws IOException {
        CustomFieldLookupTable table = field.getLookupTable();
        if (table.isEmpty()) {
            return;
        }
        this.m_writer.writeObjectFieldStart("lookup_table");
        this.writeOptionalStringField("guid", table.getGUID());
        this.writeBooleanField("enterprise", table.getEnterprise());
        this.writeBooleanField("show_indent", table.getShowIndent());
        this.writeBooleanField("resource_substitution_enabled", table.getResourceSubstitutionEnabled());
        this.writeBooleanField("leaf_only", table.getLeafOnly());
        this.writeBooleanField("all_levels_required", table.getAllLevelsRequired());
        this.writeBooleanField("only_table_values_allowed", table.getOnlyTableValuesAllowed());
        this.m_writer.writeArrayFieldStart("values");
        for (CustomFieldValueItem item : table) {
            this.writeCustomFieldValueItem(item);
        }
        this.m_writer.writeEndArray();
        this.m_writer.writeEndObject();
    }

    private void writeCustomFieldValueItem(CustomFieldValueItem item) throws IOException {
        this.m_writer.writeStartObject();
        this.writeIntegerField("unique_id", item.getUniqueID());
        this.writeOptionalStringField("guid", item.getGUID());
        this.writeOptionalStringField("value", item.getValue());
        this.writeOptionalStringField("description", item.getDescription());
        this.writeIntegerField("parent_unique_id", item.getParentUniqueID());
        this.writeOptionalStringField("type", item.getType() == null ? null : item.getType().name());
        this.writeBooleanField("collapsed", item.getCollapsed());
        this.m_writer.writeEndObject();
    }

    private void writeGraphicalIndicator(GraphicalIndicator indicator) throws IOException {
        if (!indicator.getDisplayGraphicalIndicators()) {
            return;
        }
        this.m_writer.writeObjectFieldStart("graphical_indicator");
        this.writeBooleanField("summary_rows_inherit_from_non_summary_rows", indicator.getSummaryRowsInheritFromNonSummaryRows());
        this.writeBooleanField("project_summary_inherits_from_summary_rows", indicator.getProjectSummaryInheritsFromSummaryRows());
        this.writeBooleanField("show_data_values_in_tooltips", indicator.getShowDataValuesInToolTips());
        this.writeGraphicalIndicatorCriteria("project_summary_criteria", indicator.getProjectSummaryCriteria());
        this.writeGraphicalIndicatorCriteria("summary_row_criteria", indicator.getSummaryRowCriteria());
        this.writeGraphicalIndicatorCriteria("non_sumary_row_criteria", indicator.getNonSummaryRowCriteria());
        this.m_writer.writeEndObject();
    }

    private void writeGraphicalIndicatorCriteria(String name, List<GraphicalIndicatorCriteria> list) throws IOException {
        if (list.isEmpty()) {
            return;
        }
        this.m_writer.writeArrayFieldStart(name);
        for (GraphicalIndicatorCriteria criteria : list) {
            this.m_writer.writeStartObject();
            this.writeIntegerField("indicator", criteria.getIndicator());
            this.writeGenericCriteriaAttributes(criteria);
            this.m_writer.writeEndObject();
        }
        this.m_writer.writeEndArray();
    }

    private void writeGenericCriteriaAttributes(GenericCriteria criteria) throws IOException {
        this.writeOptionalStringField("left_value", criteria.getLeftValue().name());
        this.writeOptionalStringField("operator", criteria.getOperator().name());
        this.writeOptionalStringField("right_value_1", criteria.getValue(0));
        this.writeOptionalStringField("right_value_2", criteria.getValue(1));
        List<GenericCriteria> list = criteria.getCriteriaList();
        if (list.isEmpty()) {
            return;
        }
        this.m_writer.writeArrayFieldStart("criteria_list");
        for (GenericCriteria child : list) {
            this.m_writer.writeStartObject();
            this.writeGenericCriteriaAttributes(child);
            this.m_writer.writeEndObject();
        }
        this.m_writer.writeEndArray();
    }

    private void writeCustomFieldValueMasks(CustomField field) throws IOException {
        if (field.getMasks().isEmpty()) {
            return;
        }
        this.m_writer.writeArrayFieldStart("masks");
        for (CustomFieldValueMask mask : field.getMasks()) {
            this.m_writer.writeStartObject();
            this.writeIntegerField("length", mask.getLength());
            this.writeIntegerField("level", mask.getLevel());
            this.writeOptionalStringField("separator", mask.getSeparator());
            this.writeOptionalStringField("type", mask.getType().name());
            this.m_writer.writeEndObject();
        }
        this.m_writer.writeEndArray();
    }

    private void writeUserDefinedField(UserDefinedField field) throws IOException {
        this.m_writer.writeStartObject();
        this.writeIntegerField("unique_id", FieldTypeHelper.getFieldID(field));
        this.writeOptionalStringField("field_type_class", field.getFieldTypeClass().toString().toLowerCase());
        this.writeBooleanField("summary_task_only", field.getSummaryTaskOnly());
        this.writeOptionalStringField("data_type", field.getDataType().toString().toLowerCase());
        this.writeOptionalStringField("internal_name", field.name().toLowerCase());
        this.writeOptionalStringField("external_name", field.getName());
        this.m_writer.writeEndObject();
    }

    private void writeUnitsOfMeasure() throws IOException {
        if (this.m_projectFile.getUnitsOfMeasure().isEmpty()) {
            return;
        }
        this.m_writer.writeArrayFieldStart("units_of_measure");
        for (UnitOfMeasure uom : this.m_projectFile.getUnitsOfMeasure()) {
            this.writeUnitOfMeasure(uom);
        }
        this.m_writer.writeEndArray();
    }

    private void writeUnitOfMeasure(UnitOfMeasure uom) throws IOException {
        this.m_writer.writeStartObject();
        this.writeMandatoryIntegerField("unique_id", uom.getUniqueID());
        this.writeOptionalStringField("abbreviation", uom.getAbbreviation());
        this.writeOptionalStringField("name", uom.getName());
        this.writeMandatoryIntegerField("sequence_number", uom.getSequenceNumber());
        this.m_writer.writeEndObject();
    }

    private void writeCurrencies() throws IOException {
        if (this.m_projectFile.getCurrencies().isEmpty()) {
            return;
        }
        this.m_writer.writeArrayFieldStart("currencies");
        for (Currency currency : this.m_projectFile.getCurrencies()) {
            this.writeCurrency(currency);
        }
        this.m_writer.writeEndArray();
    }

    private void writeCurrency(Currency currency) throws IOException {
        this.m_writer.writeStartObject();
        this.writeMandatoryIntegerField("unique_id", currency.getUniqueID());
        this.writeOptionalStringField("currency_id", currency.getCurrencyID());
        this.writeOptionalStringField("name", currency.getName());
        this.writeOptionalStringField("symbol", currency.getSymbol());
        this.writeDoubleField("exchange_rate", currency.getExchangeRate());
        this.writeOptionalStringField("decimal_symbol", currency.getDecimalSymbol());
        this.writeMandatoryIntegerField("number_of_decimal_places", currency.getNumberOfDecimalPlaces());
        this.writeOptionalStringField("digit_grouping_symbol", currency.getDigitGroupingSymbol());
        this.writeOptionalStringField("positive_currency_format", currency.getPositiveCurrencyFormat());
        this.writeOptionalStringField("negative_currency_format", currency.getNegativeCurrencyFormat());
        this.m_writer.writeEndObject();
    }

    private void writeProperties() throws IOException {
        this.writeAttributeTypes("property_types", ProjectField.values());
        this.m_writer.writeObjectFieldStart("property_values");
        this.writeFields(this.m_projectFile.getProjectProperties(), ProjectField.values());
        this.writeFields(this.m_projectFile.getProjectProperties(), this.m_projectFile.getUserDefinedFields().getProjectFields().toArray(new FieldType[0]));
        this.m_writer.writeEndObject();
    }

    private void writeResources() throws IOException {
        this.writeAttributeTypes("resource_types", ResourceField.values());
        this.m_writer.writeArrayFieldStart("resources");
        for (Resource resource : this.m_projectFile.getResources()) {
            this.m_writer.writeStartObject();
            this.writeFields(resource, ResourceField.values());
            this.writeFields(resource, this.m_projectFile.getUserDefinedFields().getResourceFields().toArray(new FieldType[0]));
            this.writeCostRateTables(resource);
            this.writeAvailabilityTable(resource);
            this.writeRoleAssignments(resource);
            this.m_writer.writeEndObject();
        }
        this.m_writer.writeEndArray();
    }

    private void writeCalendars() throws IOException {
        this.m_writer.writeArrayFieldStart("calendars");
        for (ProjectCalendar calendar : this.m_projectFile.getCalendars()) {
            this.writeCalendar(calendar);
        }
        this.m_writer.writeEndArray();
    }

    private void writeCalendar(ProjectCalendar calendar) throws IOException {
        this.m_writer.writeStartObject();
        this.writeMandatoryIntegerField("unique_id", calendar.getUniqueID());
        this.writeOptionalStringField("guid", calendar.getGUID());
        this.writeMandatoryIntegerField("parent_unique_id", calendar.getParentUniqueID());
        this.writeOptionalStringField("name", calendar.getName());
        this.writeOptionalStringField("type", calendar.getType().toString());
        this.writeBooleanField("personal", calendar.getPersonal());
        this.writeIntegerField("minutes_per_day", calendar.getCalendarMinutesPerDay());
        this.writeIntegerField("minutes_per_week", calendar.getCalendarMinutesPerWeek());
        this.writeIntegerField("minutes_per_month", calendar.getCalendarMinutesPerMonth());
        this.writeIntegerField("minutes_per_year", calendar.getCalendarMinutesPerYear());
        this.writeCalendarDays(calendar);
        this.writeCalendarWeeks(calendar);
        this.writeCalendarExceptions(calendar);
        this.m_writer.writeEndObject();
    }

    private void writeCalendarWeeks(ProjectCalendar calendar) throws IOException {
        if (!calendar.getWorkWeeks().isEmpty()) {
            this.m_writer.writeArrayFieldStart("working_weeks");
            for (ProjectCalendarWeek week : calendar.getWorkWeeks()) {
                this.writeCalendarWeek(week);
            }
            this.m_writer.writeEndArray();
        }
    }

    private void writeCalendarWeek(ProjectCalendarWeek week) throws IOException {
        this.m_writer.writeStartObject();
        this.writeOptionalStringField("name", week.getName());
        this.writeDateField("effective_from", week.getDateRange().getStart());
        this.writeDateField("effective_to", week.getDateRange().getEnd());
        this.writeCalendarDays(week);
        this.m_writer.writeEndObject();
    }

    private void writeCalendarDays(ProjectCalendarDays week) throws IOException {
        for (DayOfWeek day : DayOfWeekHelper.ORDERED_DAYS) {
            this.m_writer.writeObjectFieldStart(day.name().toLowerCase());
            this.writeOptionalStringField("type", week.getCalendarDayType(day).toString().toLowerCase());
            this.writeCalendarHours(week.getCalendarHours(day));
            this.m_writer.writeEndObject();
        }
    }

    private void writeCalendarHours(ProjectCalendarHours hours) throws IOException {
        if (hours != null && !hours.isEmpty()) {
            this.m_writer.writeArrayFieldStart("hours");
            for (LocalTimeRange range : hours) {
                this.m_writer.writeStartObject();
                this.writeTimeField("from", range.getStart());
                this.writeTimeField("to", range.getEnd());
                this.m_writer.writeEndObject();
            }
            this.m_writer.writeEndArray();
        }
    }

    private void writeCalendarExceptions(ProjectCalendar calendar) throws IOException {
        if (!calendar.getCalendarExceptions().isEmpty()) {
            this.m_writer.writeArrayFieldStart("exceptions");
            for (ProjectCalendarException ex : calendar.getCalendarExceptions()) {
                this.writeCalendarException(ex);
            }
            this.m_writer.writeEndArray();
        }
    }

    private void writeCalendarException(ProjectCalendarException ex) throws IOException {
        this.m_writer.writeStartObject();
        this.writeCalendarExceptionDetails(ex);
        this.writeCalendarHours(ex);
        this.writeRecurringData(ex.getRecurring());
        this.m_writer.writeEndObject();
    }

    private void writeCalendarExceptionDetails(ProjectCalendarException ex) throws IOException {
        DayType type = ex.getWorking() ? DayType.WORKING : DayType.NON_WORKING;
        this.writeOptionalStringField("name", ex.getName());
        if (ex.getRecurring() == null) {
            this.writeDateField("from", ex.getFromDate());
            this.writeDateField("to", ex.getToDate());
        }
        this.writeOptionalStringField("type", type.toString().toLowerCase());
    }

    private void writeRecurringData(RecurringData data) throws IOException {
        if (data != null) {
            this.m_writer.writeObjectFieldStart("recurrence");
            this.writeOptionalStringField("type", data.getRecurrenceType().toString().toLowerCase());
            this.writeDateField("start_date", data.getStartDate());
            this.writeDateField("finish_date", data.getFinishDate());
            this.writeIntegerField("occurrences", data.getOccurrences());
            this.writeIntegerField("frequency", data.getFrequency());
            this.writeBooleanField("relative", data.getRelative());
            this.writeIntegerField("day_number", data.getDayNumber());
            this.writeIntegerField("month_number", data.getMonthNumber());
            this.writeBooleanField("use_end_date", data.getUseEndDate());
            List<String> weeklyDays = Arrays.stream(DayOfWeekHelper.ORDERED_DAYS).filter(data::getWeeklyDay).map(d -> d.toString().toLowerCase()).collect(Collectors.toList());
            if (!weeklyDays.isEmpty()) {
                this.writeStringList("weekly_days", weeklyDays);
            }
            this.m_writer.writeEndObject();
        }
    }

    private void writeTasks() throws IOException {
        this.writeAttributeTypes("task_types", TaskField.values());
        this.m_writer.writeArrayFieldStart("tasks");
        for (Task task : this.m_projectFile.getChildTasks()) {
            this.writeTask(task);
        }
        this.m_writer.writeEndArray();
    }

    private void writeTask(Task task) throws IOException {
        this.m_writer.writeStartObject();
        this.writeFields(task, TaskField.values());
        this.writeFields(task, this.m_projectFile.getUserDefinedFields().getTaskFields().toArray(new FieldType[0]));
        this.m_writer.writeEndObject();
        for (Task child : task.getChildTasks()) {
            this.writeTask(child);
        }
    }

    private void writeAssignments() throws IOException {
        this.writeAttributeTypes("assignment_types", AssignmentField.values());
        this.m_writer.writeArrayFieldStart("assignments");
        for (ResourceAssignment assignment : this.m_projectFile.getResourceAssignments()) {
            this.m_writer.writeStartObject();
            this.writeFields(assignment, AssignmentField.values());
            this.writeFields(assignment, this.m_projectFile.getUserDefinedFields().getAssignmentFields().toArray(new FieldType[0]));
            this.m_writer.writeEndObject();
        }
        this.m_writer.writeEndArray();
    }

    private void writeAttributeTypes(String name, FieldType[] types) throws IOException {
        if (this.m_writeAttributeTypes) {
            this.m_writer.writeObjectFieldStart(name);
            this.m_writer.writeStartObject();
            for (FieldType field : types) {
                this.m_writer.writeNumberField(field.name().toLowerCase(), field.getDataType().getValue());
            }
            this.m_writer.writeEndObject();
        }
    }

    private void writeCostRateTables(Resource resource) throws IOException {
        int index;
        boolean tablesArePopulated = false;
        for (index = 0; index < 5 && !(tablesArePopulated = resource.getCostRateTable(index).tableIsPopulated()); ++index) {
        }
        if (tablesArePopulated) {
            this.m_writer.writeObjectFieldStart("cost_rate_tables");
            for (index = 0; index < 5; ++index) {
                this.writeCostRateTable(index, resource.getCostRateTable(index));
            }
            this.m_writer.writeEndObject();
        }
    }

    private void writeAvailabilityTable(Resource resource) throws IOException {
        AvailabilityTable availability = resource.getAvailability();
        if (availability.isEmpty()) {
            return;
        }
        this.m_writer.writeArrayFieldStart("availability_table");
        for (Availability entry : availability) {
            this.m_writer.writeStartObject();
            this.writeTimestampField("start", entry.getRange().getStart());
            this.writeTimestampField("end", entry.getRange().getEnd());
            this.writeDoubleField("units", entry.getUnits());
            this.m_writer.writeEndObject();
        }
        this.m_writer.writeEndArray();
    }

    private void writeRoleAssignments(Resource resource) throws IOException {
        Map<Resource, SkillLevel> map = resource.getRoleAssignments();
        if (map.isEmpty()) {
            return;
        }
        this.m_writer.writeArrayFieldStart("role_assignments");
        for (Map.Entry entry : map.entrySet().stream().sorted(Comparator.comparing(o -> ((Resource)o.getKey()).getUniqueID())).collect(Collectors.toList())) {
            this.m_writer.writeStartObject();
            this.writeIntegerField("resource_id", ((Resource)entry.getKey()).getUniqueID());
            this.writeOptionalStringField("skill_level", entry.getValue());
            this.m_writer.writeEndObject();
        }
        this.m_writer.writeEndArray();
    }

    private void writeCostRateTable(int index, CostRateTable table) throws IOException {
        if (table.tableIsPopulated()) {
            this.m_writer.writeArrayFieldStart(Integer.toString(index));
            for (CostRateTableEntry entry : table) {
                LocalDateTime endDate;
                LocalDateTime startDate = entry.getStartDate();
                if (startDate != null && LocalDateTimeHelper.compare(startDate, LocalDateTimeHelper.START_DATE_NA) <= 0) {
                    startDate = null;
                }
                if ((endDate = entry.getEndDate()) != null && LocalDateTimeHelper.compare(LocalDateTimeHelper.END_DATE_NA, endDate) <= 0) {
                    endDate = null;
                }
                this.m_writer.writeStartObject();
                this.writeTimestampField("start_date", startDate);
                this.writeTimestampField("end_date", endDate);
                this.writeDoubleField("cost_per_use", entry.getCostPerUse());
                this.m_writer.writeObjectFieldStart("rates");
                for (int rateIndex = 0; rateIndex < 5; ++rateIndex) {
                    this.writeCostRate(rateIndex, entry.getRate(rateIndex));
                }
                this.m_writer.writeEndObject();
                this.m_writer.writeEndObject();
            }
            this.m_writer.writeEndArray();
        }
    }

    private void writeCostRate(int index, Rate rate) throws IOException {
        if (rate != null && rate.getAmount() != 0.0) {
            this.writeRateField(Integer.toString(index), rate);
        }
    }

    private void writeFields(FieldContainer container, FieldType[] fields) throws IOException {
        for (FieldType field : fields) {
            Object value = container.get(field);
            if (value == null) continue;
            this.writeField(container, field, value);
        }
    }

    private void writeField(FieldContainer container, FieldType field, Object value) throws IOException {
        if (!IGNORED_FIELDS.contains(field)) {
            this.writeField(container, field, field.name().toLowerCase(), field.getDataType(), value);
        }
    }

    private void writeField(FieldContainer container, FieldType fieldType, String fieldName, DataType dataType, Object value) throws IOException {
        switch (dataType) {
            case SHORT: 
            case INTEGER: {
                this.writeIntegerField(fieldType, fieldName, value);
                break;
            }
            case PERCENTAGE: 
            case CURRENCY: 
            case NUMERIC: 
            case UNITS: {
                this.writeDoubleField(fieldName, value);
                break;
            }
            case BOOLEAN: {
                this.writeBooleanField(fieldName, value);
                break;
            }
            case DELAY: 
            case WORK: 
            case DURATION: {
                this.writeDurationField(container, fieldName, value);
                break;
            }
            case DATE: {
                this.writeTimestampField(fieldName, value);
                break;
            }
            case TIME: {
                this.writeTimeField(fieldName, value);
                break;
            }
            case RATE_UNITS: 
            case TIME_UNITS: {
                this.writeTimeUnitsField(fieldName, value);
                break;
            }
            case PRIORITY: {
                this.writePriorityField(fieldName, value);
                break;
            }
            case RELATION_LIST: {
                this.writeRelationList(fieldName, value);
                break;
            }
            case MAP: {
                this.writeMap(fieldName, value);
                break;
            }
            case DATE_RANGE_LIST: {
                this.writeDateRangeList(fieldName, value);
                break;
            }
            case RATE: {
                this.writeRateField(fieldName, value);
                break;
            }
            case RESOURCE_REQUEST_TYPE: {
                this.writeResourceRequestTypeField(fieldName, value);
                break;
            }
            case WORK_CONTOUR: {
                this.writeWorkContourField(fieldName, value);
                break;
            }
            case EARNED_VALUE_METHOD: {
                this.writeEarnedValueMethodField(container, fieldName, value);
                break;
            }
            case TASK_TYPE: {
                this.writeTaskTypeField(container, fieldName, value);
                break;
            }
            case ACTIVITY_CODE_VALUES: 
            case CODE_VALUES: {
                this.writeCodeValues(fieldName, value);
                break;
            }
            case TASK_MODE: {
                this.writeTaskModeField(fieldName, value);
                break;
            }
            case BINARY: {
                break;
            }
            case EXPENSE_ITEM_LIST: {
                this.writeExpenseItemList(fieldName, value);
                break;
            }
            case STEP_LIST: {
                this.writeStepList(fieldName, value);
                break;
            }
            default: {
                if (value instanceof Enum) {
                    value = ((Enum)value).name();
                }
                this.writeOptionalStringField(fieldName, value);
            }
        }
    }

    private void writeIntegerField(String fieldName, Object value) throws IOException {
        this.writeIntegerField(null, fieldName, value);
    }

    private void writeMandatoryIntegerField(String fieldName, Number value) throws IOException {
        if (value != null) {
            this.m_writer.writeNumberField(fieldName, value.intValue());
        }
    }

    private void writeIntegerField(FieldType fieldType, String fieldName, Object value) throws IOException {
        if (!(value instanceof Number)) {
            return;
        }
        int val = ((Number)value).intValue();
        if (val != 0 || MANDATORY_FIELDS.contains(fieldType)) {
            this.m_writer.writeNumberField(fieldName, val);
        }
    }

    private void writeDoubleField(String fieldName, Object value) throws IOException {
        if (!(value instanceof Number)) {
            return;
        }
        double val = ((Number)value).doubleValue();
        if (val != 0.0) {
            val = (double)Math.round(val * 10000.0) / 10000.0;
            this.m_writer.writeNumberField(fieldName, val);
        }
    }

    private void writeBooleanField(String fieldName, Object value) throws IOException {
        if (!(value instanceof Boolean)) {
            return;
        }
        boolean val = (Boolean)value;
        if (val) {
            this.m_writer.writeBooleanField(fieldName, val);
        }
    }

    private void writeDurationField(FieldContainer container, String fieldName, Object value) throws IOException {
        if (value == null) {
            return;
        }
        if (value instanceof String) {
            this.writeStringField(fieldName + "_text", (String)value);
            return;
        }
        if (!(value instanceof Duration)) {
            return;
        }
        Duration val = (Duration)value;
        if (val.getDuration() != 0.0) {
            TimeUnitDefaultsContainer defaults = null;
            if (container instanceof Task) {
                defaults = ((Task)container).getEffectiveCalendar();
            } else if (container instanceof Resource) {
                defaults = ((Resource)container).getCalendar();
            }
            if (defaults == null) {
                defaults = this.m_projectFile.getProjectProperties();
            }
            if (this.m_timeUnits == null) {
                Duration minutes = val.convertUnits(TimeUnit.MINUTES, defaults);
                long seconds = (long)(minutes.getDuration() * 60.0);
                this.m_writer.writeNumberField(fieldName, seconds);
            } else {
                TimeUnit targetUnits = this.m_timeUnits;
                if (val.getUnits().isElapsed()) {
                    targetUnits = ELAPSED_TIME_UNIT_MAP.getOrDefault(targetUnits, targetUnits);
                }
                Duration duration = val.convertUnits(targetUnits, defaults);
                this.m_writer.writeNumberField(fieldName, duration.getDuration());
            }
        }
    }

    private void writeTimestampField(String fieldName, Object value) throws IOException {
        if (value == null) {
            return;
        }
        if (value instanceof String) {
            this.writeStringField(fieldName + "_text", (String)value);
            return;
        }
        if (!(value instanceof LocalDateTime)) {
            return;
        }
        this.writeStringField(fieldName, TIMESTAMP_FORMAT.format((LocalDateTime)value));
    }

    private void writeDateField(String fieldName, Object value) throws IOException {
        if (value instanceof LocalDate) {
            this.writeStringField(fieldName, DATE_FORMAT.format((LocalDate)value));
        }
    }

    private void writeTimeField(String fieldName, Object value) throws IOException {
        if (value instanceof LocalTime) {
            this.writeStringField(fieldName, TIME_FORMAT.format((LocalTime)value));
        }
    }

    private void writeTimeUnitsField(String fieldName, Object value) throws IOException {
        if (!(value instanceof TimeUnit)) {
            return;
        }
        TimeUnit val = (TimeUnit)value;
        if (val != this.m_projectFile.getProjectProperties().getDefaultDurationUnits()) {
            this.writeStringField(fieldName, val.toString());
        }
    }

    private void writePriorityField(String fieldName, Object value) throws IOException {
        if (value instanceof Priority) {
            this.m_writer.writeNumberField(fieldName, ((Priority)value).getValue());
        }
    }

    private void writeRateField(String fieldName, Object value) throws IOException {
        if (!(value instanceof Rate)) {
            return;
        }
        Rate val = (Rate)value;
        if (val.getAmount() != 0.0) {
            this.writeStringField(fieldName, val.getAmount() + "/" + val.getUnits());
        }
    }

    private void writeMap(String fieldName, Object value) throws IOException {
        if (!(value instanceof Map)) {
            return;
        }
        Map map = (Map)value;
        if (map.isEmpty()) {
            return;
        }
        this.m_writer.writeObjectFieldStart(fieldName);
        for (Map.Entry entry : map.entrySet()) {
            Object entryValue = entry.getValue();
            if (entryValue == null || entryValue instanceof byte[]) continue;
            DataType type = TYPE_MAP.get(entryValue.getClass().getName());
            if (type == null) {
                type = DataType.STRING;
                entryValue = entryValue.toString();
            }
            this.writeField(null, null, (String)entry.getKey(), type, entryValue);
        }
        this.m_writer.writeEndObject();
    }

    private void writeDateRangeList(String fieldName, Object value) throws IOException {
        if (!(value instanceof List)) {
            return;
        }
        List list = (List)value;
        this.m_writer.writeArrayFieldStart(fieldName);
        for (LocalDateTimeRange entry : list) {
            this.m_writer.writeStartObject();
            this.writeTimestampField("start", entry.getStart());
            this.writeTimestampField("end", entry.getEnd());
            this.m_writer.writeEndObject();
        }
        this.m_writer.writeEndArray();
    }

    private void writeActivityCode(ActivityCode code) throws IOException {
        this.m_writer.writeStartObject();
        this.writeMandatoryIntegerField("unique_id", code.getUniqueID());
        this.writeOptionalStringField("scope", (Object)code.getScope());
        this.writeIntegerField("scope_eps_unique_id", code.getScopeEpsUniqueID());
        this.writeIntegerField("scope_project_unique_id", code.getScopeProjectUniqueID());
        this.writeMandatoryIntegerField("sequence_number", code.getSequenceNumber());
        this.writeOptionalStringField("name", code.getName());
        if (!code.getValues().isEmpty()) {
            this.m_writer.writeArrayFieldStart("values");
            for (ActivityCodeValue value : code.getValues().stream().sorted(Comparator.comparing(ActivityCodeValue::getUniqueID)).collect(Collectors.toList())) {
                this.writeActivityCodeValue(value);
            }
            this.m_writer.writeEndArray();
        }
        this.m_writer.writeEndObject();
    }

    private void writeCode(Code code) throws IOException {
        this.m_writer.writeStartObject();
        this.writeMandatoryIntegerField("unique_id", code.getUniqueID());
        this.writeMandatoryIntegerField("sequence_number", code.getSequenceNumber());
        this.writeOptionalStringField("name", code.getName());
        if (!code.getValues().isEmpty()) {
            this.m_writer.writeArrayFieldStart("values");
            for (CodeValue value : code.getValues().stream().sorted(Comparator.comparing(CodeValue::getUniqueID)).collect(Collectors.toList())) {
                this.writeCodeValue(value);
            }
            this.m_writer.writeEndArray();
        }
        this.m_writer.writeEndObject();
    }

    private void writeActivityCodeValue(ActivityCodeValue value) throws IOException {
        this.m_writer.writeStartObject();
        this.writeMandatoryIntegerField("unique_id", value.getUniqueID());
        this.writeMandatoryIntegerField("sequence_number", value.getSequenceNumber());
        this.writeOptionalStringField("name", value.getName());
        this.writeOptionalStringField("description", value.getDescription());
        this.writeColorField("color", value.getColor());
        this.writeIntegerField("parent_value_unique_id", value.getParentValueUniqueID());
        this.m_writer.writeEndObject();
    }

    private void writeCodeValue(CodeValue value) throws IOException {
        this.m_writer.writeStartObject();
        this.writeMandatoryIntegerField("unique_id", value.getUniqueID());
        this.writeMandatoryIntegerField("sequence_number", value.getSequenceNumber());
        this.writeOptionalStringField("name", value.getName());
        this.writeOptionalStringField("description", value.getDescription());
        this.writeIntegerField("parent_value_unique_id", value.getParentValueUniqueID());
        this.m_writer.writeEndObject();
    }

    private void writeOptionalStringField(String fieldName, Object value) throws IOException {
        String val;
        if (value != null && !(val = value.toString()).isEmpty()) {
            this.writeStringField(fieldName, val);
        }
    }

    private void writeStringField(String fieldName, String val) throws IOException {
        this.m_writer.writeStringField(fieldName, this.stripControlCharacters(val));
    }

    private String stripControlCharacters(String value) {
        this.m_buffer.setLength(0);
        block3: for (int index = 0; index < value.length(); ++index) {
            char c = value.charAt(index);
            switch (c) {
                case '\b': 
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': {
                    this.m_buffer.append(c);
                    continue block3;
                }
                default: {
                    if (c <= '\u001f') continue block3;
                    this.m_buffer.append(c);
                }
            }
        }
        return this.m_buffer.toString();
    }

    private void writeRelationList(String fieldName, Object value) throws IOException {
        if (!(value instanceof List)) {
            return;
        }
        List list = (List)value;
        if (!list.isEmpty()) {
            this.m_writer.writeArrayFieldStart(fieldName);
            for (Relation relation : list) {
                this.m_writer.writeStartObject();
                this.writeIntegerField("unique_id", relation.getUniqueID());
                this.writeIntegerField("predecessor_task_unique_id", relation.getPredecessorTask().getUniqueID());
                this.writeIntegerField("successor_task_unique_id", relation.getSuccessorTask().getUniqueID());
                this.writeDurationField(this.m_projectFile.getProjectProperties(), "lag", relation.getLag());
                if (relation.getLag().getDuration() != 0.0) {
                    this.writeTimeUnitsField("lag_units", relation.getLag().getUnits());
                }
                this.writeOptionalStringField("type", relation.getType());
                this.writeOptionalStringField("notes", relation.getNotes());
                this.m_writer.writeEndObject();
            }
            this.m_writer.writeEndArray();
        }
    }

    private void writeResourceRequestTypeField(String fieldName, Object value) throws IOException {
        if (!(value instanceof ResourceRequestType)) {
            return;
        }
        ResourceRequestType type = (ResourceRequestType)value;
        if (type != ResourceRequestType.NONE) {
            this.writeStringField(fieldName, type.name());
        }
    }

    private void writeWorkContourField(String fieldName, Object value) throws IOException {
        if (!(value instanceof WorkContour)) {
            return;
        }
        WorkContour type = (WorkContour)value;
        if (!type.isContourFlat()) {
            this.writeStringField(fieldName, type.toString());
        }
    }

    private void writeEarnedValueMethodField(FieldContainer container, String fieldName, Object value) throws IOException {
        if (!(value instanceof EarnedValueMethod)) {
            return;
        }
        EarnedValueMethod method = (EarnedValueMethod)value;
        if (container instanceof ProjectProperties || method != this.m_projectFile.getProjectProperties().getDefaultTaskEarnedValueMethod()) {
            this.writeStringField(fieldName, method.name());
        }
    }

    private void writeTaskTypeField(FieldContainer container, String fieldName, Object value) throws IOException {
        if (!(value instanceof TaskType)) {
            return;
        }
        TaskType type = (TaskType)((Object)value);
        if (container instanceof ProjectProperties || type != this.m_projectFile.getProjectProperties().getDefaultTaskType()) {
            this.writeStringField(fieldName, type.name());
        }
    }

    private void writeColorField(String name, Color value) throws IOException {
        if (value != null) {
            this.writeStringField(name, ColorHelper.getHtmlColor(value));
        }
    }

    private void writeCodeValues(String fieldName, Object value) throws IOException {
        if (!(value instanceof Map)) {
            return;
        }
        Map map = (Map)value;
        if (!map.isEmpty()) {
            this.writeIntegerList(fieldName, map.values().stream().map(CodeValue::getUniqueID).sorted().collect(Collectors.toList()));
        }
    }

    private void writeExpenseItemList(String fieldName, Object value) throws IOException {
        if (!(value instanceof List)) {
            return;
        }
        List list = (List)value;
        if (list.isEmpty()) {
            return;
        }
        this.m_writer.writeArrayFieldStart(fieldName);
        for (ExpenseItem item : list) {
            this.m_writer.writeStartObject();
            this.writeIntegerField("unique_id", item.getUniqueID());
            this.writeOptionalStringField("name", item.getName());
            this.writeOptionalStringField("description", item.getDescription());
            this.writeIntegerField("account_unique_id", item.getAccountUniqueID());
            this.writeIntegerField("category_unique_id", item.getCategoryUniqueID());
            this.writeOptionalStringField("document_number", item.getDocumentNumber());
            this.writeOptionalStringField("vendor", item.getVendor());
            this.writeDoubleField("at_completion_cost", item.getAtCompletionCost());
            this.writeDoubleField("at_completion_units", item.getAtCompletionUnits());
            this.writeDoubleField("actual_cost", item.getActualCost());
            this.writeDoubleField("actual_units", item.getActualUnits());
            this.writeDoubleField("price_per_unit", item.getPricePerUnit());
            this.writeDoubleField("remaining_cost", item.getRemainingCost());
            this.writeDoubleField("remaining_units", item.getRemainingUnits());
            this.writeDoubleField("planned_cost", item.getPlannedCost());
            this.writeDoubleField("planned_units", item.getPlannedUnits());
            this.writeOptionalStringField("accrue_type", item.getAccrueType().name().toLowerCase());
            this.writeBooleanField("auto_compute_actuals", item.getAutoComputeActuals());
            this.writeOptionalStringField("unit_of_measure", item.getUnitOfMeasure());
            this.m_writer.writeEndObject();
        }
        this.m_writer.writeEndArray();
    }

    private void writeStepList(String fieldName, Object value) throws IOException {
        if (!(value instanceof List)) {
            return;
        }
        List list = (List)value;
        if (list.isEmpty()) {
            return;
        }
        this.m_writer.writeArrayFieldStart(fieldName);
        for (Step item : list) {
            this.m_writer.writeStartObject();
            this.writeIntegerField("unique_id", item.getUniqueID());
            this.writeOptionalStringField("name", item.getName());
            this.writeIntegerField("sequence_number", item.getSequenceNumber());
            this.writeDoubleField("percent_complete", item.getPercentComplete());
            this.writeDoubleField("weight", item.getWeight());
            this.writeOptionalStringField("description", item.getDescription());
            this.m_writer.writeEndObject();
        }
        this.m_writer.writeEndArray();
    }

    private void writeTables() throws IOException {
        if (this.m_projectFile.getTables().isEmpty()) {
            return;
        }
        this.m_writer.writeArrayFieldStart("tables");
        for (Table table : this.m_projectFile.getTables()) {
            this.m_writer.writeStartObject();
            this.writeIntegerField("id", table.getID());
            this.writeOptionalStringField("name", table.getName());
            this.writeBooleanField("resource", table.getResourceFlag());
            this.writeTableColumns(table);
            this.m_writer.writeEndObject();
        }
        this.m_writer.writeEndArray();
    }

    private void writeTableColumns(Table table) throws IOException {
        if (table.getColumns().isEmpty()) {
            return;
        }
        this.m_writer.writeArrayFieldStart("columns");
        for (Column column : table.getColumns()) {
            this.m_writer.writeStartObject();
            this.writeFieldType("", column.getFieldType());
            this.writeOptionalStringField("title", column.getTitle());
            this.writeIntegerField("width", column.getWidth());
            this.writeIntegerField("align_data", column.getAlignData());
            this.writeIntegerField("align_title", column.getAlignTitle());
            this.m_writer.writeEndObject();
        }
        this.m_writer.writeEndArray();
    }

    private void writeViews() throws IOException {
        if (this.m_projectFile.getViews().isEmpty()) {
            return;
        }
        this.m_writer.writeArrayFieldStart("views");
        for (View view : this.m_projectFile.getViews()) {
            this.m_writer.writeStartObject();
            this.writeIntegerField("id", view.getID());
            this.writeOptionalStringField("name", view.getName());
            this.writeOptionalStringField("type", view.getType().name().toLowerCase());
            this.writeOptionalStringField("table_name", view.getTableName());
            this.writeViewTableFontStyles(view);
            this.writeBarStyles(view);
            this.writeBarStyleExceptions(view);
            this.m_writer.writeEndObject();
        }
        this.m_writer.writeEndArray();
    }

    private void writeViewTableFontStyles(View view) throws IOException {
        if (!(view instanceof GanttChartView)) {
            return;
        }
        GanttChartView ganttChartView = (GanttChartView)view;
        if (ganttChartView.getTableFontStyles() == null) {
            return;
        }
        this.m_writer.writeArrayFieldStart("table_font_styles");
        for (TableFontStyle style : ganttChartView.getTableFontStyles()) {
            this.m_writer.writeStartObject();
            this.writeIntegerField("row_unique_id", style.getRowUniqueID());
            this.writeFieldType("", style.getFieldType());
            this.m_writer.writeEndObject();
        }
        this.m_writer.writeEndArray();
    }

    private void writeBarStyles(View view) throws IOException {
        if (!(view instanceof GanttChartView)) {
            return;
        }
        GanttBarStyle[] styles = ((GanttChartView)view).getBarStyles();
        if (styles == null || styles.length == 0) {
            return;
        }
        this.m_writer.writeArrayFieldStart("bar_styles");
        for (GanttBarStyle style : styles) {
            this.m_writer.writeStartObject();
            this.writeIntegerField("id", style.getID());
            this.writeOptionalStringField("name", style.getName());
            this.writeIntegerField("row", style.getRow());
            this.writeFieldType("from_", style.getFromField());
            this.writeFieldType("to_", style.getToField());
            this.writeFieldType("top_", style.getTopText());
            this.writeFieldType("bottom_", style.getBottomText());
            this.writeFieldType("left_", style.getLeftText());
            this.writeFieldType("right_", style.getRightText());
            this.writeFieldType("inside_", style.getInsideText());
            this.m_writer.writeEndObject();
        }
        this.m_writer.writeEndArray();
    }

    private void writeBarStyleExceptions(View view) throws IOException {
        if (!(view instanceof GanttChartView)) {
            return;
        }
        GanttBarStyleException[] exceptions = ((GanttChartView)view).getBarStyleExceptions();
        if (exceptions == null || exceptions.length == 0) {
            return;
        }
        this.m_writer.writeArrayFieldStart("bar_style_exceptions");
        for (GanttBarStyleException style : exceptions) {
            this.m_writer.writeStartObject();
            this.writeIntegerField("task_unique_id", style.getTaskUniqueID());
            this.writeIntegerField("bar_style_id", style.getGanttBarStyleID());
            this.writeFieldType("top_", style.getTopText());
            this.writeFieldType("bottom_", style.getBottomText());
            this.writeFieldType("left_", style.getLeftText());
            this.writeFieldType("right_", style.getRightText());
            this.writeFieldType("inside_", style.getInsideText());
            this.m_writer.writeEndObject();
        }
        this.m_writer.writeEndArray();
    }

    private void writeTaskModeField(String fieldName, Object value) throws IOException {
        if (!(value instanceof TaskMode)) {
            return;
        }
        TaskMode type = (TaskMode)value;
        if (type != TaskMode.AUTO_SCHEDULED) {
            this.writeStringField(fieldName, type.name());
        }
    }

    private void writeFieldType(String prefix, FieldType fieldType) throws IOException {
        if (fieldType != null) {
            this.writeOptionalStringField(prefix + "field_type_class", fieldType.getFieldTypeClass().name().toLowerCase());
            this.writeOptionalStringField(prefix + "field_type", fieldType.name().toLowerCase());
        }
    }

    private void writeStringList(String name, List<String> list) throws IOException {
        this.m_writer.writeArrayFieldStart(name);
        for (String value : list) {
            this.m_writer.writeObject((Object)value);
        }
        this.m_writer.writeEndArray();
    }

    private void writeDoubleList(String name, List<Double> list) throws IOException {
        this.m_writer.writeArrayFieldStart(name);
        for (Double value : list) {
            this.m_writer.writeObject((Object)value);
        }
        this.m_writer.writeEndArray();
    }

    private void writeIntegerList(String name, List<Integer> list) throws IOException {
        this.m_writer.writeArrayFieldStart(name);
        for (Integer value : list) {
            this.m_writer.writeObject((Object)value);
        }
        this.m_writer.writeEndArray();
    }

    static {
        TYPE_MAP.put(Boolean.class.getName(), DataType.BOOLEAN);
        TYPE_MAP.put(LocalDateTime.class.getName(), DataType.DATE);
        TYPE_MAP.put(Double.class.getName(), DataType.NUMERIC);
        TYPE_MAP.put(Duration.class.getName(), DataType.DURATION);
        TYPE_MAP.put(Integer.class.getName(), DataType.INTEGER);
        ELAPSED_TIME_UNIT_MAP = new HashMap<TimeUnit, TimeUnit>();
        ELAPSED_TIME_UNIT_MAP.put(TimeUnit.MINUTES, TimeUnit.ELAPSED_MINUTES);
        ELAPSED_TIME_UNIT_MAP.put(TimeUnit.HOURS, TimeUnit.ELAPSED_HOURS);
        ELAPSED_TIME_UNIT_MAP.put(TimeUnit.DAYS, TimeUnit.ELAPSED_DAYS);
        ELAPSED_TIME_UNIT_MAP.put(TimeUnit.WEEKS, TimeUnit.ELAPSED_WEEKS);
        ELAPSED_TIME_UNIT_MAP.put(TimeUnit.MONTHS, TimeUnit.ELAPSED_MONTHS);
        IGNORED_FIELDS = new HashSet<Enum>(Arrays.asList(AssignmentField.ASSIGNMENT_TASK_GUID, AssignmentField.ASSIGNMENT_RESOURCE_GUID, ResourceField.CALENDAR_GUID, ResourceField.STANDARD_RATE_UNITS, ResourceField.OVERTIME_RATE_UNITS));
        MANDATORY_FIELDS = new HashSet<Enum>(Arrays.asList(TaskField.UNIQUE_ID, TaskField.PARENT_TASK_UNIQUE_ID, ProjectField.DEFAULT_CALENDAR_UNIQUE_ID));
        TIMESTAMP_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.S");
        DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        TIME_FORMAT = DateTimeFormatter.ofPattern("HH:mm");
    }
}

