/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.merlin;

import jakarta.xml.bind.DatatypeConverter;
import java.time.DayOfWeek;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.UUID;
import org.mpxj.Duration;
import org.mpxj.RelationType;
import org.mpxj.ResourceType;
import org.mpxj.TimeUnit;
import org.mpxj.common.BooleanHelper;
import org.mpxj.common.DayOfWeekHelper;
import org.mpxj.common.NumberHelper;
import org.mpxj.merlin.Row;

class MapRow
implements Row {
    protected final Map<String, Object> m_map;
    private static final LocalDateTime DATE_EPOCH = LocalDateTime.of(2001, 1, 7, 0, 0);

    public MapRow(Map<String, Object> map) {
        this.m_map = map;
    }

    @Override
    public String getString(String name) {
        Object value = this.getObject(name);
        String result = value instanceof byte[] ? new String((byte[])value) : (String)value;
        return result;
    }

    @Override
    public Integer getInteger(String name) {
        Object result = this.getObject(name);
        if (result != null && !(result instanceof Integer)) {
            result = ((Number)result).intValue();
        }
        return (Integer)result;
    }

    @Override
    public Double getDouble(String name) {
        Object result = this.getObject(name);
        if (result != null && !(result instanceof Double)) {
            result = result instanceof byte[] ? Double.valueOf(new String((byte[])result)) : Double.valueOf(((Number)result).doubleValue());
        }
        return (Double)result;
    }

    @Override
    public Double getCurrency(String name) {
        Double value = this.getDouble(name);
        if (value != null) {
            value = value / 100.0;
        }
        return value;
    }

    @Override
    public boolean getBoolean(String name) {
        boolean result = false;
        Object value = this.getObject(name);
        if (value != null) {
            result = value instanceof Boolean ? BooleanHelper.getBoolean((Boolean)value) : ((Number)value).intValue() == 1;
        }
        return result;
    }

    @Override
    public int getInt(String name) {
        return NumberHelper.getInt((Number)this.getObject(name));
    }

    @Override
    public LocalDateTime getTimestamp(String name) {
        return (LocalDateTime)this.getObject(name);
    }

    @Override
    public LocalDateTime getDate(String name) {
        Integer value = this.getInteger(name);
        LocalDateTime result = value == null ? null : DATE_EPOCH.plusDays(value.intValue());
        return result;
    }

    @Override
    public Duration getDuration(String name) {
        String value = this.getString(name);
        Duration result = value == null ? null : this.parseDuration(value);
        return result;
    }

    @Override
    public Duration getWork(String name) {
        String value = this.getString(name);
        Duration result = value == null ? null : this.parseDuration(value);
        return result;
    }

    public Object getObject(String name) {
        return this.m_map.get(name);
    }

    @Override
    public UUID getUUID(String name) {
        int i;
        String value = this.getString(name);
        value = value.replace("-", "+").replace("_", "/");
        byte[] data = DatatypeConverter.parseBase64Binary((String)(value + "=="));
        long msb = 0L;
        long lsb = 0L;
        for (i = 0; i < 8; ++i) {
            msb = msb << 8 | (long)(data[i] & 0xFF);
        }
        for (i = 8; i < 16; ++i) {
            lsb = lsb << 8 | (long)(data[i] & 0xFF);
        }
        return new UUID(msb, lsb);
    }

    @Override
    public RelationType getRelationType(String name) {
        RelationType result;
        int type = this.getInt(name);
        switch (type) {
            case 1: {
                result = RelationType.START_START;
                break;
            }
            case 2: {
                result = RelationType.FINISH_FINISH;
                break;
            }
            case 3: {
                result = RelationType.START_FINISH;
                break;
            }
            default: {
                result = RelationType.FINISH_START;
            }
        }
        return result;
    }

    @Override
    public ResourceType getResourceType(String name) {
        Integer value = this.getInteger(name);
        ResourceType result = value == null ? ResourceType.WORK : (value == 1 ? ResourceType.MATERIAL : ResourceType.WORK);
        return result;
    }

    public Map<String, Object> getMap() {
        return this.m_map;
    }

    private Duration parseDuration(String value) {
        TimeUnit durationUnits;
        int unitsLength = 1;
        char unitsChar = value.charAt(value.length() - unitsLength);
        if (unitsChar == '?') {
            unitsLength = 2;
            unitsChar = value.charAt(value.length() - unitsLength);
        }
        double durationValue = Double.parseDouble(value.substring(0, value.length() - unitsLength));
        switch (unitsChar) {
            case 's': {
                durationUnits = TimeUnit.MINUTES;
                durationValue /= 60.0;
                break;
            }
            case 'm': {
                durationUnits = TimeUnit.MINUTES;
                break;
            }
            case 'h': {
                durationUnits = TimeUnit.HOURS;
                break;
            }
            case 'w': {
                durationUnits = TimeUnit.WEEKS;
                break;
            }
            case 'M': {
                durationUnits = TimeUnit.MONTHS;
                break;
            }
            case 'q': {
                durationUnits = TimeUnit.MONTHS;
                durationValue *= 3.0;
                break;
            }
            case 'y': {
                durationUnits = TimeUnit.YEARS;
                break;
            }
            case 'f': {
                durationUnits = TimeUnit.PERCENT;
                break;
            }
            default: {
                durationUnits = TimeUnit.DAYS;
            }
        }
        return Duration.getInstance(durationValue, durationUnits);
    }

    @Override
    public DayOfWeek getDay(String name) {
        DayOfWeek result = null;
        Integer value = this.getInteger(name);
        if (value != null) {
            result = DayOfWeekHelper.getInstance(value + 1);
        }
        return result;
    }
}

