/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.mpd;

import java.time.LocalDateTime;
import java.util.Map;
import org.mpxj.Duration;
import org.mpxj.TimeUnit;
import org.mpxj.common.BooleanHelper;
import org.mpxj.common.NumberHelper;
import org.mpxj.mpd.Row;

class MapRow
implements Row {
    protected final Map<String, Object> m_map;

    public MapRow(Map<String, Object> map) {
        this.m_map = map;
    }

    @Override
    public final String getString(String name) {
        Object value = this.getObject(name);
        String result = value instanceof byte[] ? new String((byte[])value) : (String)value;
        return result;
    }

    @Override
    public final Integer getInteger(String name) {
        Object result = this.getObject(name);
        if (result != null && !(result instanceof Integer)) {
            result = ((Number)result).intValue();
        }
        return (Integer)result;
    }

    @Override
    public final Double getDouble(String name) {
        Object result = this.getObject(name);
        if (result != null && !(result instanceof Double)) {
            result = ((Number)result).doubleValue();
        }
        return (Double)result;
    }

    @Override
    public final Double getCurrency(String name) {
        Double value = this.getDouble(name);
        if (value != null) {
            value = value / 100.0;
        }
        return value;
    }

    @Override
    public final boolean getBoolean(String name) {
        boolean result = false;
        Object value = this.getObject(name);
        if (value != null) {
            result = value instanceof Boolean ? BooleanHelper.getBoolean((Boolean)value) : ((Number)value).intValue() == 1;
        }
        return result;
    }

    @Override
    public final int getInt(String name) {
        return NumberHelper.getInt((Number)this.getObject(name));
    }

    @Override
    public final LocalDateTime getDate(String name) {
        return (LocalDateTime)this.getObject(name);
    }

    @Override
    public final Duration getDuration(String name) {
        return Duration.getInstance(NumberHelper.getDouble(this.getDouble(name)) / 60000.0, TimeUnit.HOURS);
    }

    private Object getObject(String name) {
        if (!this.m_map.containsKey(name)) {
            throw new IllegalArgumentException("Invalid column name " + name);
        }
        return this.m_map.get(name);
    }
}

