/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.mpp;

import java.io.IOException;
import java.io.InputStream;
import java.time.DayOfWeek;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Stream;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.mpxj.DayType;
import org.mpxj.EventManager;
import org.mpxj.LocalTimeRange;
import org.mpxj.ProjectCalendar;
import org.mpxj.ProjectCalendarDays;
import org.mpxj.ProjectCalendarHours;
import org.mpxj.ProjectFile;
import org.mpxj.common.ByteArrayHelper;
import org.mpxj.common.DayOfWeekHelper;
import org.mpxj.common.Pair;
import org.mpxj.mpp.CalendarFactory;
import org.mpxj.mpp.DocumentInputStreamFactory;
import org.mpxj.mpp.FixedData;
import org.mpxj.mpp.FixedMeta;
import org.mpxj.mpp.MPPUtility;
import org.mpxj.mpp.Props;
import org.mpxj.mpp.Var2Data;
import org.mpxj.mpp.VarMeta;

abstract class AbstractCalendarFactory
implements CalendarFactory {
    private static final boolean[] DEFAULT_WORKING_WEEK = new boolean[]{false, true, true, true, true, true, false};
    private final ProjectFile m_file;

    public AbstractCalendarFactory(ProjectFile file) {
        this.m_file = file;
    }

    @Override
    public void processCalendarData(DirectoryEntry projectDir, Props projectProps, DocumentInputStreamFactory inputStreamFactory, HashMap<Integer, ProjectCalendar> resourceMap) throws IOException {
        DirectoryEntry calDir = (DirectoryEntry)projectDir.getEntry("TBkndCal");
        VarMeta calVarMeta = this.getCalendarVarMeta(calDir);
        Var2Data calVarData = new Var2Data(this.m_file, calVarMeta, (InputStream)new DocumentInputStream((DocumentEntry)calDir.getEntry("Var2Data")));
        FixedMeta calFixedMeta = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)calDir.getEntry("FixedMeta")), 10);
        FixedData calFixedData = new FixedData(calFixedMeta, inputStreamFactory.getInstance(calDir, "FixedData"), 12);
        FixedData calFixed2Data = null;
        if (calDir.hasEntry("Fixed2Meta")) {
            FixedMeta calFixed2Meta = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)calDir.getEntry("Fixed2Meta")), 9);
            calFixed2Data = new FixedData(calFixed2Meta, inputStreamFactory.getInstance(calDir, "Fixed2Data"), 48);
        }
        HashMap<Integer, ProjectCalendar> calendarMap = new HashMap<Integer, ProjectCalendar>();
        int items = calFixedData.getItemCount();
        ArrayList<Pair<ProjectCalendar, Integer>> baseCalendars = new ArrayList<Pair<ProjectCalendar, Integer>>();
        byte[] defaultCalendarData = projectProps.getByteArray(Props.DEFAULT_CALENDAR_HOURS);
        ProjectCalendar defaultCalendar = new ProjectCalendar(this.m_file);
        this.processCalendarHours(defaultCalendarData, null, defaultCalendar, true);
        EventManager eventManager = this.m_file.getEventManager();
        for (int loop = 0; loop < items; ++loop) {
            byte[] fixedData2;
            byte[] fixedData = calFixedData.getByteArrayValue(loop);
            byte[] byArray = fixedData2 = calFixed2Data == null ? null : calFixed2Data.getByteArrayValue(loop);
            if (fixedData == null || fixedData.length < 8) continue;
            int offset = 0;
            while (offset + 12 <= fixedData.length) {
                Integer calendarID = ByteArrayHelper.getInt(fixedData, offset + this.getCalendarIDOffset());
                int baseCalendarID = ByteArrayHelper.getInt(fixedData, offset + this.getBaseIDOffset());
                if (calendarID > 0 && !calendarMap.containsKey(calendarID)) {
                    Integer resourceID;
                    ProjectCalendar cal;
                    byte[] varData = calVarData.getByteArray(calendarID, this.getCalendarDataVarDataType());
                    if (baseCalendarID <= 0 || baseCalendarID == calendarID) {
                        if (varData != null || defaultCalendarData != null) {
                            cal = this.m_file.addCalendar();
                            if (varData == null) {
                                varData = defaultCalendarData;
                            }
                        } else {
                            cal = this.m_file.addDefaultBaseCalendar();
                        }
                        cal.setName(calVarData.getUnicodeString(calendarID, this.getCalendarNameVarDataType()));
                        resourceID = ByteArrayHelper.getInt(fixedData, offset + this.getResourceIDOffset());
                        if (resourceID > 0 && !resourceMap.containsKey(resourceID)) {
                            resourceMap.put(resourceID, cal);
                        }
                    } else {
                        cal = varData != null ? this.m_file.addCalendar() : this.m_file.addDefaultDerivedCalendar();
                        baseCalendars.add(new Pair<ProjectCalendar, Integer>(cal, baseCalendarID));
                        resourceID = ByteArrayHelper.getInt(fixedData, offset + this.getResourceIDOffset());
                        resourceMap.put(resourceID, cal);
                    }
                    cal.setUniqueID(calendarID);
                    cal.setGUID(MPPUtility.getGUID(fixedData2, 0));
                    if (varData == null) {
                        if (baseCalendarID <= 0) {
                            Stream.of(DayOfWeek.values()).forEach(cal::addCalendarHours);
                        }
                    } else {
                        this.processCalendarHours(varData, defaultCalendar, cal, baseCalendarID <= 0);
                        this.processCalendarExceptions(varData, cal);
                    }
                    calendarMap.put(calendarID, cal);
                    eventManager.fireCalendarReadEvent(cal);
                }
                offset += 12;
            }
        }
        this.updateBaseCalendarNames(baseCalendars, calendarMap);
        ProjectCalendar projectDefaultCalendar = this.m_file.getCalendars().getByName(projectProps.getUnicodeString(Props.DEFAULT_CALENDAR_NAME));
        if (projectDefaultCalendar == null) {
            projectDefaultCalendar = this.m_file.getCalendars().findOrCreateDefaultCalendar();
        }
        this.m_file.getProjectProperties().setDefaultCalendar(projectDefaultCalendar);
    }

    private void processCalendarHours(byte[] data, ProjectCalendar defaultCalendar, ProjectCalendar cal, boolean isBaseCalendar) {
        ArrayList<LocalTimeRange> dateRanges = new ArrayList<LocalTimeRange>(5);
        for (int index = 0; index < 7; ++index) {
            ProjectCalendarHours hours;
            int offset = this.getCalendarHoursOffset() + 60 * index;
            int defaultFlag = data == null ? 1 : ByteArrayHelper.getShort(data, offset);
            DayOfWeek day = DayOfWeekHelper.getInstance(index + 1);
            if (defaultFlag == 1) {
                if (isBaseCalendar) {
                    hours = cal.addCalendarHours(day);
                    if (defaultCalendar == null) {
                        cal.setWorkingDay(day, DEFAULT_WORKING_WEEK[index]);
                        if (!cal.isWorkingDay(day)) continue;
                        hours.add(ProjectCalendarDays.DEFAULT_WORKING_MORNING);
                        hours.add(ProjectCalendarDays.DEFAULT_WORKING_AFTERNOON);
                        continue;
                    }
                    boolean workingDay = defaultCalendar.isWorkingDay(day);
                    cal.setWorkingDay(day, workingDay);
                    if (!workingDay) continue;
                    hours.addAll(defaultCalendar.getHours(day));
                    continue;
                }
                cal.setCalendarDayType(day, DayType.DEFAULT);
                continue;
            }
            dateRanges.clear();
            int periodCount = ByteArrayHelper.getShort(data, offset + 2);
            for (int periodIndex = 0; periodIndex < periodCount; ++periodIndex) {
                int startOffset = offset + 8 + periodIndex * 2;
                LocalTime start = MPPUtility.getTime(data, startOffset);
                int durationOffset = offset + 20 + periodIndex * 4;
                long duration = MPPUtility.getDuration(data, durationOffset);
                LocalTime end = start.plus(duration, ChronoUnit.MILLIS);
                dateRanges.add(new LocalTimeRange(start, end));
            }
            if (dateRanges.isEmpty()) {
                if (isBaseCalendar) {
                    cal.addCalendarHours(DayOfWeekHelper.getInstance(index + 1));
                }
                cal.setWorkingDay(day, false);
                continue;
            }
            cal.setWorkingDay(day, true);
            hours = cal.addCalendarHours(DayOfWeekHelper.getInstance(index + 1));
            hours.addAll(dateRanges);
        }
    }

    private void updateBaseCalendarNames(List<Pair<ProjectCalendar, Integer>> baseCalendars, HashMap<Integer, ProjectCalendar> map) {
        for (Pair<ProjectCalendar, Integer> pair : baseCalendars) {
            ProjectCalendar cal = pair.getFirst();
            Integer baseCalendarID = pair.getSecond();
            ProjectCalendar baseCal = map.get(baseCalendarID);
            if (baseCal != null && baseCal.getName() != null) {
                cal.setParent(baseCal);
                continue;
            }
            this.m_file.removeCalendar(cal);
        }
    }

    protected abstract int getCalendarIDOffset();

    protected abstract int getBaseIDOffset();

    protected abstract int getResourceIDOffset();

    protected abstract VarMeta getCalendarVarMeta(DirectoryEntry var1) throws IOException;

    protected abstract int getCalendarHoursOffset();

    protected abstract Integer getCalendarNameVarDataType();

    protected abstract Integer getCalendarDataVarDataType();

    protected abstract void processCalendarExceptions(byte[] var1, ProjectCalendar var2);
}

