/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.mpp;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.mpxj.FieldType;
import org.mpxj.mpp.FieldMap;
import org.mpxj.mpp.MPPComponent;
import org.mpxj.mpp.VarMeta;

abstract class AbstractVarMeta
extends MPPComponent
implements VarMeta {
    protected int m_itemCount;
    protected int m_dataSize;
    private int[] m_offsets;
    protected final Map<Integer, Map<Integer, Integer>> m_table = new TreeMap<Integer, Map<Integer, Integer>>();

    AbstractVarMeta() {
    }

    @Override
    public int getItemCount() {
        return this.m_itemCount;
    }

    @Override
    public int getDataSize() {
        return this.m_dataSize;
    }

    @Override
    public Integer[] getUniqueIdentifierArray() {
        Integer[] result = new Integer[this.m_table.size()];
        int index = 0;
        Iterator<Integer> iterator = this.m_table.keySet().iterator();
        while (iterator.hasNext()) {
            Integer value;
            result[index] = value = iterator.next();
            ++index;
        }
        return result;
    }

    @Override
    public Set<Integer> getUniqueIdentifierSet() {
        return this.m_table.keySet();
    }

    @Override
    public Integer getOffset(Integer id, Integer type) {
        Integer result = null;
        Map<Integer, Integer> map = this.m_table.get(id);
        if (map != null && type != null) {
            result = map.get(type);
        }
        return result;
    }

    protected void setOffsets(int[] offsets) {
        this.m_offsets = offsets;
    }

    @Override
    public int[] getOffsets() {
        return this.m_offsets;
    }

    @Override
    public Set<Integer> getTypes(Integer id) {
        Map<Integer, Integer> map = this.m_table.get(id);
        Set<Integer> result = map != null ? map.keySet() : new HashSet<Integer>();
        return result;
    }

    @Override
    public boolean containsKey(Integer key) {
        return this.m_table.containsKey(key);
    }

    public String toString() {
        return this.toString(null);
    }

    @Override
    public String toString(FieldMap fieldMap) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("BEGIN: VarMeta");
        pw.println("   Item count: " + this.m_itemCount);
        pw.println("   Data size: " + this.m_dataSize);
        for (Map.Entry<Integer, Map<Integer, Integer>> tableEntry : this.m_table.entrySet()) {
            Integer uniqueID = tableEntry.getKey();
            pw.println("   Entries for Unique ID: " + uniqueID);
            Map<Integer, Integer> map = tableEntry.getValue();
            for (Map.Entry<Integer, Integer> entry : map.entrySet()) {
                FieldType fieldType = fieldMap == null ? null : fieldMap.getFieldTypeFromVarDataKey(entry.getKey());
                pw.println("      Type=" + (fieldType == null ? entry.getKey() : fieldType) + " Offset=" + entry.getValue());
            }
        }
        pw.println("END: VarMeta");
        pw.println();
        pw.close();
        return sw.toString();
    }
}

