/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.mpp;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.mpxj.EventManager;
import org.mpxj.ProjectFile;
import org.mpxj.ProjectProperties;
import org.mpxj.Relation;
import org.mpxj.RelationType;
import org.mpxj.Task;
import org.mpxj.common.ByteArrayHelper;
import org.mpxj.common.NumberHelper;
import org.mpxj.mpp.DocumentInputStreamFactory;
import org.mpxj.mpp.FixedData;
import org.mpxj.mpp.FixedMeta;
import org.mpxj.mpp.MPPUtility;

public class ConstraintFactory {
    public void process(DirectoryEntry projectDir, ProjectFile file, DocumentInputStreamFactory inputStreamFactory) throws IOException {
        DirectoryEntry consDir;
        try {
            consDir = (DirectoryEntry)projectDir.getEntry("TBkndCons");
        }
        catch (FileNotFoundException ex) {
            file.addIgnoredError(ex);
            consDir = null;
        }
        if (consDir != null) {
            FixedMeta consFixedMeta = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)consDir.getEntry("FixedMeta")), 10);
            FixedData consFixedData = new FixedData(consFixedMeta, 20, inputStreamFactory.getInstance(consDir, "FixedData"));
            int count = consFixedMeta.getAdjustedItemCount();
            int lastConstraintID = -1;
            ProjectProperties properties = file.getProjectProperties();
            EventManager eventManager = file.getEventManager();
            boolean project15 = NumberHelper.getInt(properties.getMppFileType()) == 14 && NumberHelper.getInt(properties.getApplicationVersion()) > 14;
            int durationUnitsOffset = project15 ? 18 : 14;
            int durationOffset = project15 ? 14 : 16;
            for (int loop = 0; loop < count; ++loop) {
                int taskID2;
                int constraintID;
                byte[] data;
                int index;
                byte[] metaData = consFixedMeta.getByteArrayValue(loop);
                if (ByteArrayHelper.getShort(metaData, 0) != 0 || (index = consFixedData.getIndexFromOffset(ByteArrayHelper.getInt(metaData, 4))) == -1 || (data = consFixedData.getByteArrayValue(index)).length < 14 || (constraintID = ByteArrayHelper.getInt(data, 0)) <= lastConstraintID) continue;
                lastConstraintID = constraintID;
                int taskID1 = ByteArrayHelper.getInt(data, 4);
                if (taskID1 == (taskID2 = ByteArrayHelper.getInt(data, 8))) continue;
                Task task1 = file.getTaskByUniqueID(taskID1);
                Task task2 = file.getTaskByUniqueID(taskID2);
                if (task1 == null || task2 == null) continue;
                Relation relation = task2.addPredecessor(new Relation.Builder().predecessorTask(task1).type(RelationType.getInstance(ByteArrayHelper.getShort(data, 12))).lag(MPPUtility.getAdjustedDuration(properties, ByteArrayHelper.getInt(data, durationOffset), MPPUtility.getDurationTimeUnits(ByteArrayHelper.getShort(data, durationUnitsOffset)))).uniqueID(constraintID));
                eventManager.fireRelationReadEvent(relation);
            }
        }
    }
}

