/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.mpp;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import org.mpxj.CostRateTable;
import org.mpxj.CostRateTableEntry;
import org.mpxj.ProjectFile;
import org.mpxj.Rate;
import org.mpxj.Resource;
import org.mpxj.ResourceField;
import org.mpxj.TimeUnit;
import org.mpxj.TimeUnitDefaultsContainer;
import org.mpxj.common.ByteArrayHelper;
import org.mpxj.common.LocalDateTimeHelper;
import org.mpxj.common.NumberHelper;
import org.mpxj.common.RateHelper;
import org.mpxj.mpp.MPPUtility;

final class CostRateTableFactory {
    private final ProjectFile m_file;

    public CostRateTableFactory(ProjectFile file) {
        this.m_file = file;
    }

    public void process(Resource resource, int index, byte[] data) {
        ArrayList<CostRateTableEntry> entries = new ArrayList<CostRateTableEntry>();
        if (data == null) {
            if (index == 0) {
                Rate standardRate = resource.getStandardRate() == null ? Rate.ZERO : (Rate)resource.getCachedValue(ResourceField.STANDARD_RATE);
                Rate overtimeRate = resource.getOvertimeRate() == null ? Rate.ZERO : (Rate)resource.getCachedValue(ResourceField.OVERTIME_RATE);
                Double costPerUse = resource.getCostPerUse() == null ? (Number)NumberHelper.DOUBLE_ZERO : (Number)((Number)resource.getCachedValue(ResourceField.COST_PER_USE));
                LocalDateTime endDate = CostRateTableEntry.DEFAULT_ENTRY.getEndDate();
                entries.add(new CostRateTableEntry(null, endDate, (Number)costPerUse, standardRate, overtimeRate));
            } else {
                entries.add(CostRateTableEntry.DEFAULT_ENTRY);
            }
        } else {
            int i = 16;
            while (i + 44 <= data.length) {
                TimeUnit standardRateFormat = this.getFormat(ByteArrayHelper.getShort(data, i + 8));
                Rate standardRate = RateHelper.convertFromHours((TimeUnitDefaultsContainer)this.m_file.getProjectProperties(), MPPUtility.getDouble(data, i), standardRateFormat);
                TimeUnit overtimeRateFormat = this.getFormat(ByteArrayHelper.getShort(data, i + 24));
                Rate overtimeRate = RateHelper.convertFromHours((TimeUnitDefaultsContainer)this.m_file.getProjectProperties(), MPPUtility.getDouble(data, i + 16), overtimeRateFormat);
                Double costPerUse = NumberHelper.getDouble(MPPUtility.getDouble(data, i + 32) / 100.0);
                LocalDateTime endDate = MPPUtility.getTimestampFromTenths(data, i + 40);
                if (endDate.isAfter(LocalDateTimeHelper.END_DATE_NA)) {
                    endDate = LocalDateTimeHelper.END_DATE_NA;
                } else {
                    int minutes = endDate.getMinute();
                    if (minutes % 5 == 0) {
                        endDate = endDate.minusMinutes(1L);
                    }
                }
                if (endDate.getSecond() == 0) {
                    entries.add(new CostRateTableEntry(null, endDate, (Number)costPerUse, standardRate, overtimeRate));
                }
                i += 44;
            }
        }
        Collections.sort(entries);
        CostRateTable result = new CostRateTable();
        for (int i = 0; i < entries.size(); ++i) {
            LocalDateTime startDate = i == 0 ? LocalDateTimeHelper.START_DATE_NA : ((CostRateTableEntry)entries.get(i - 1)).getEndDate().plusMinutes(1L);
            CostRateTableEntry entry = (CostRateTableEntry)entries.get(i);
            result.add(new CostRateTableEntry(startDate, entry.getEndDate(), entry.getCostPerUse(), entry.getStandardRate(), entry.getOvertimeRate()));
        }
        resource.setCostRateTable(index, result);
    }

    private TimeUnit getFormat(int format) {
        TimeUnit result;
        if (format == 65535) {
            result = TimeUnit.HOURS;
        } else {
            result = MPPUtility.getWorkTimeUnits(format);
            if (result == TimeUnit.ELAPSED_MINUTES) {
                result = TimeUnit.HOURS;
            }
        }
        return result;
    }
}

