/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.mpp;

import java.util.Map;
import java.util.UUID;
import org.mpxj.CustomFieldContainer;
import org.mpxj.CustomFieldLookupTable;
import org.mpxj.CustomFieldValueDataType;
import org.mpxj.FieldType;
import org.mpxj.ProjectFile;
import org.mpxj.ProjectProperties;
import org.mpxj.TimeUnit;
import org.mpxj.common.ByteArrayHelper;
import org.mpxj.mpp.CustomFieldValueItem;
import org.mpxj.mpp.FixedData;
import org.mpxj.mpp.MPPUtility;
import org.mpxj.mpp.Var2Data;
import org.mpxj.mpp.VarMeta;

abstract class CustomFieldValueReader {
    protected final Map<UUID, FieldType> m_lookupTableMap;
    protected final ProjectProperties m_properties;
    protected final CustomFieldContainer m_container;
    protected final VarMeta m_outlineCodeVarMeta;
    protected final Var2Data m_outlineCodeVarData;
    protected final FixedData m_outlineCodeFixedData;
    protected final FixedData m_outlineCodeFixedData2;
    protected int m_parentOffset;
    protected int m_typeOffset;
    protected int m_fieldOffset;
    public static final int UNJQUE_ID_OFFSET = 4;
    public static final Integer VALUE_LIST_VALUE = 22;
    public static final Integer VALUE_LIST_DESCRIPTION = 8;
    public static final Integer VALUE_LIST_UNKNOWN = 23;

    public CustomFieldValueReader(ProjectFile file, Map<UUID, FieldType> lookupTableMap, VarMeta outlineCodeVarMeta, Var2Data outlineCodeVarData, FixedData outlineCodeFixedData, FixedData outlineCodeFixedData2) {
        this.m_lookupTableMap = lookupTableMap;
        this.m_properties = file.getProjectProperties();
        this.m_container = file.getCustomFields();
        this.m_outlineCodeVarMeta = outlineCodeVarMeta;
        this.m_outlineCodeVarData = outlineCodeVarData;
        this.m_outlineCodeFixedData = outlineCodeFixedData;
        this.m_outlineCodeFixedData2 = outlineCodeFixedData2;
    }

    public void process() {
        block0: for (int loop = 0; loop < this.m_outlineCodeFixedData.getItemCount(); ++loop) {
            byte[] value;
            Integer id;
            byte[] fixedData = this.m_outlineCodeFixedData.getByteArrayValue(loop);
            if (fixedData == null || !this.m_outlineCodeVarMeta.containsKey(id = Integer.valueOf(ByteArrayHelper.getShort(fixedData, 4))) || (value = this.m_outlineCodeVarData.getByteArray(id, VALUE_LIST_VALUE)) == null) continue;
            CustomFieldValueItem item = new CustomFieldValueItem(id);
            item.setDescription(this.m_outlineCodeVarData.getUnicodeString(id, VALUE_LIST_DESCRIPTION));
            item.setUnknown(this.m_outlineCodeVarData.getByteArray(id, VALUE_LIST_UNKNOWN));
            item.setParentUniqueID(ByteArrayHelper.getShort(fixedData, this.m_parentOffset));
            byte[] fixedData2 = this.m_outlineCodeFixedData2.getByteArrayValue(loop);
            item.setGUID(MPPUtility.getGUID(fixedData2, 0));
            UUID lookupTableGuid = MPPUtility.getGUID(fixedData2, this.m_fieldOffset);
            item.setType(CustomFieldValueDataType.getInstance(ByteArrayHelper.getShort(fixedData2, this.m_typeOffset)));
            item.setValue(this.getTypedValue(item.getType(), value));
            this.m_container.registerValue(item);
            FieldType field = this.m_lookupTableMap.get(lookupTableGuid);
            if (field == null) continue;
            CustomFieldLookupTable table = this.m_container.getOrCreate(field).getLookupTable();
            if (table.stream().noneMatch(i -> i.getUniqueID().equals(item.getUniqueID()))) {
                table.add(item);
                table.setGUID(lookupTableGuid);
                continue;
            }
            for (int index = 0; index < table.size(); ++index) {
                if (!((CustomFieldValueItem)table.get(index)).getUniqueID().equals(item.getUniqueID())) continue;
                table.set(index, item);
                continue block0;
            }
        }
    }

    protected Object getTypedValue(CustomFieldValueDataType type, byte[] value) {
        Object result;
        if (type == null) {
            result = this.valueAsString(value);
        } else {
            switch (type) {
                case DATE: 
                case FINISH_DATE: {
                    result = MPPUtility.getTimestamp(value, 0);
                    break;
                }
                case DURATION: {
                    TimeUnit units = MPPUtility.getDurationTimeUnits(ByteArrayHelper.getShort(value, 4), this.m_properties.getDefaultDurationUnits());
                    result = MPPUtility.getAdjustedDuration(this.m_properties, ByteArrayHelper.getInt(value, 0), units);
                    break;
                }
                case COST: {
                    result = MPPUtility.getDouble(value, 0) / 100.0;
                    break;
                }
                case NUMBER: {
                    result = MPPUtility.getDouble(value, 0);
                    break;
                }
                case TEXT: {
                    result = MPPUtility.getUnicodeString(value, 0);
                    break;
                }
                default: {
                    result = this.valueAsString(value);
                }
            }
        }
        return result;
    }

    private String valueAsString(byte[] value) {
        String result;
        try {
            result = MPPUtility.getUnicodeString(value, 0);
        }
        catch (Exception ex) {
            result = ByteArrayHelper.hexdump(value, false);
        }
        return result;
    }
}

