/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.mpp;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.TreeSet;
import org.mpxj.common.ByteArrayHelper;
import org.mpxj.common.InputStreamHelper;
import org.mpxj.mpp.MPPComponent;
import org.mpxj.mpp.MPPUtility;

final class FixDeferFix
extends MPPComponent {
    private final byte[] m_data;

    FixDeferFix(InputStream is) throws IOException {
        this.m_data = InputStreamHelper.readAvailable(is);
    }

    public byte[] getByteArray(int offset) {
        byte[] result = null;
        if (offset > 0 && offset < this.m_data.length) {
            int nextBlockOffset = ByteArrayHelper.getInt(this.m_data, offset);
            int itemSize = ByteArrayHelper.getInt(this.m_data, offset += 4);
            offset += 4;
            if (itemSize > 0 && itemSize < this.m_data.length) {
                int blockRemainingSize = 28;
                if (nextBlockOffset != -1 || itemSize <= blockRemainingSize) {
                    int itemRemainingSize = itemSize;
                    result = new byte[itemSize];
                    int resultOffset = 0;
                    while (nextBlockOffset != -1) {
                        MPPUtility.getByteArray(this.m_data, offset, blockRemainingSize, result, resultOffset);
                        resultOffset += blockRemainingSize;
                        itemRemainingSize -= blockRemainingSize;
                        if ((offset += blockRemainingSize) != nextBlockOffset) {
                            offset = nextBlockOffset;
                        }
                        nextBlockOffset = ByteArrayHelper.getInt(this.m_data, offset);
                        offset += 4;
                        blockRemainingSize = 32;
                    }
                    MPPUtility.getByteArray(this.m_data, offset, itemRemainingSize, result, resultOffset);
                }
            }
        }
        return result;
    }

    public String getString(int offset) {
        String result = null;
        byte[] data = this.getByteArray(offset);
        if (data != null) {
            result = new String(data);
        }
        return result;
    }

    public String getUnicodeString(int offset) {
        String result = null;
        byte[] data = this.getByteArray(offset);
        if (data != null) {
            result = MPPUtility.getUnicodeString(data, 0);
        }
        return result;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("BEGIN FixDeferFix");
        int available = this.m_data.length;
        int fileOffset = 4;
        TreeSet<Integer> skipped = new TreeSet<Integer>();
        TreeSet<Integer> read = new TreeSet<Integer>();
        while (fileOffset < available || !skipped.isEmpty()) {
            Integer temp;
            if (fileOffset >= available) {
                temp = (Integer)skipped.first();
                skipped.remove(temp);
                fileOffset = temp;
            }
            if (!read.add(temp = Integer.valueOf(fileOffset))) {
                fileOffset = available;
                continue;
            }
            int startOffset = fileOffset;
            int nextBlockOffset = ByteArrayHelper.getInt(this.m_data, fileOffset);
            int itemSize = ByteArrayHelper.getInt(this.m_data, fileOffset += 4);
            fileOffset += 4;
            int blockRemainingSize = 28;
            if (nextBlockOffset == -1 && itemSize > blockRemainingSize) {
                fileOffset += blockRemainingSize;
                continue;
            }
            int itemRemainingSize = itemSize;
            byte[] buffer = new byte[itemSize];
            int bufferOffset = 0;
            while (nextBlockOffset != -1) {
                MPPUtility.getByteArray(this.m_data, fileOffset, blockRemainingSize, buffer, bufferOffset);
                bufferOffset += blockRemainingSize;
                itemRemainingSize -= blockRemainingSize;
                if ((fileOffset += blockRemainingSize) != nextBlockOffset) {
                    skipped.add(fileOffset);
                    fileOffset = nextBlockOffset;
                }
                if (!read.add(temp = Integer.valueOf(fileOffset))) {
                    fileOffset = available;
                    continue;
                }
                nextBlockOffset = ByteArrayHelper.getInt(this.m_data, fileOffset);
                fileOffset += 4;
                blockRemainingSize = 32;
            }
            MPPUtility.getByteArray(this.m_data, fileOffset, itemRemainingSize, buffer, bufferOffset);
            fileOffset += itemRemainingSize;
            if (itemRemainingSize < blockRemainingSize) {
                int skip = blockRemainingSize - itemRemainingSize;
                fileOffset += skip;
            }
            pw.println("   Data: offset: " + startOffset + " size: " + buffer.length);
            pw.println("  " + ByteArrayHelper.hexdump(buffer, true));
        }
        pw.println("END FixDeferFix");
        pw.println();
        pw.close();
        return sw.toString();
    }
}

