/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.mpp;

import java.time.LocalDateTime;
import org.mpxj.CustomFieldContainer;
import org.mpxj.Duration;
import org.mpxj.FieldType;
import org.mpxj.GraphicalIndicator;
import org.mpxj.GraphicalIndicatorCriteria;
import org.mpxj.ProjectFile;
import org.mpxj.ProjectProperties;
import org.mpxj.TestOperator;
import org.mpxj.common.ByteArrayHelper;
import org.mpxj.common.FieldTypeHelper;
import org.mpxj.mpp.MPPUtility;
import org.mpxj.mpp.Props;

public final class GraphicalIndicatorReader {
    private byte[] m_data;
    private int m_headerOffset;
    private int m_dataOffset;
    private CustomFieldContainer m_container;
    private ProjectFile m_file;
    private ProjectProperties m_properties;

    public void process(ProjectFile file, Props props) {
        this.m_file = file;
        this.m_container = file.getCustomFields();
        this.m_properties = file.getProjectProperties();
        this.m_data = props.getByteArray(Props.TASK_FIELD_ATTRIBUTES);
        if (this.m_data != null) {
            int columnsCount = ByteArrayHelper.getInt(this.m_data, 4);
            this.m_headerOffset = 8;
            for (int loop = 0; loop < columnsCount; ++loop) {
                this.processColumns();
            }
        }
    }

    private void processColumns() {
        int fieldID = ByteArrayHelper.getInt(this.m_data, this.m_headerOffset);
        this.m_headerOffset += 4;
        this.m_dataOffset = ByteArrayHelper.getInt(this.m_data, this.m_headerOffset);
        this.m_headerOffset += 4;
        FieldType type = FieldTypeHelper.getInstance(this.m_file, fieldID);
        if (type.getDataType() != null) {
            this.processKnownType(type);
        }
    }

    private void processKnownType(FieldType type) {
        byte flags = this.m_data[this.m_dataOffset];
        if ((flags & 2) == 0) {
            return;
        }
        GraphicalIndicator indicator = this.m_container.getOrCreate(type).getGraphicalIndicator();
        indicator.setProjectSummaryInheritsFromSummaryRows((flags & 8) != 0);
        indicator.setSummaryRowsInheritFromNonSummaryRows((flags & 4) != 0);
        indicator.setDisplayGraphicalIndicators((flags & 2) != 0);
        indicator.setShowDataValuesInToolTips((flags & 1) != 0);
        this.m_dataOffset += 20;
        int nonSummaryRowOffset = ByteArrayHelper.getInt(this.m_data, this.m_dataOffset) - 36;
        this.m_dataOffset += 4;
        int summaryRowOffset = ByteArrayHelper.getInt(this.m_data, this.m_dataOffset) - 36;
        this.m_dataOffset += 4;
        int projectSummaryOffset = ByteArrayHelper.getInt(this.m_data, this.m_dataOffset) - 36;
        this.m_dataOffset += 4;
        int dataSize = ByteArrayHelper.getInt(this.m_data, this.m_dataOffset) - 36;
        this.m_dataOffset += 4;
        int maxNonSummaryRowOffset = this.m_dataOffset + summaryRowOffset;
        int maxSummaryRowOffset = this.m_dataOffset + projectSummaryOffset;
        int maxProjectSummaryOffset = this.m_dataOffset + dataSize;
        this.m_dataOffset += nonSummaryRowOffset;
        while (this.m_dataOffset + 2 < maxNonSummaryRowOffset) {
            indicator.addNonSummaryRowCriteria(this.processCriteria(type));
        }
        while (this.m_dataOffset + 2 < maxSummaryRowOffset) {
            indicator.addSummaryRowCriteria(this.processCriteria(type));
        }
        while (this.m_dataOffset + 2 < maxProjectSummaryOffset) {
            indicator.addProjectSummaryCriteria(this.processCriteria(type));
        }
    }

    private GraphicalIndicatorCriteria processCriteria(FieldType type) {
        GraphicalIndicatorCriteria criteria = new GraphicalIndicatorCriteria(this.m_properties);
        criteria.setLeftValue(type);
        int indicatorType = ByteArrayHelper.getInt(this.m_data, this.m_dataOffset);
        this.m_dataOffset += 4;
        criteria.setIndicator(indicatorType);
        if (this.m_dataOffset + 4 < this.m_data.length) {
            int operatorValue = ByteArrayHelper.getInt(this.m_data, this.m_dataOffset);
            this.m_dataOffset += 4;
            TestOperator operator = operatorValue == 0 ? TestOperator.IS_ANY_VALUE : TestOperator.getInstance(operatorValue - 999);
            criteria.setOperator(operator);
            if (operator != TestOperator.IS_ANY_VALUE) {
                this.processOperandValue(0, type, criteria);
                if (operator == TestOperator.IS_WITHIN || operator == TestOperator.IS_NOT_WITHIN) {
                    this.processOperandValue(1, type, criteria);
                }
            }
        }
        return criteria;
    }

    private void processOperandValue(int index, FieldType type, GraphicalIndicatorCriteria criteria) {
        boolean valueFlag = ByteArrayHelper.getInt(this.m_data, this.m_dataOffset) == 1;
        this.m_dataOffset += 4;
        if (!valueFlag) {
            int fieldID = ByteArrayHelper.getInt(this.m_data, this.m_dataOffset);
            criteria.setRightValue(index, FieldTypeHelper.getInstance(this.m_file, fieldID));
            this.m_dataOffset += 4;
        } else {
            this.m_dataOffset += 2;
            switch (type.getDataType()) {
                case DURATION: {
                    Duration value = MPPUtility.getAdjustedDuration(this.m_properties, ByteArrayHelper.getInt(this.m_data, this.m_dataOffset), MPPUtility.getDurationTimeUnits(ByteArrayHelper.getShort(this.m_data, this.m_dataOffset + 4)));
                    this.m_dataOffset += 6;
                    criteria.setRightValue(index, value);
                    break;
                }
                case NUMERIC: {
                    Double value = MPPUtility.getDouble(this.m_data, this.m_dataOffset);
                    this.m_dataOffset += 8;
                    criteria.setRightValue(index, value);
                    break;
                }
                case CURRENCY: {
                    Double value = MPPUtility.getDouble(this.m_data, this.m_dataOffset) / 100.0;
                    this.m_dataOffset += 8;
                    criteria.setRightValue(index, value);
                    break;
                }
                case STRING: {
                    String value = MPPUtility.getUnicodeString(this.m_data, this.m_dataOffset);
                    this.m_dataOffset += (value.length() + 1) * 2;
                    criteria.setRightValue(index, value);
                    break;
                }
                case BOOLEAN: {
                    int value = ByteArrayHelper.getShort(this.m_data, this.m_dataOffset);
                    this.m_dataOffset += 2;
                    criteria.setRightValue(index, value == 1 ? Boolean.TRUE : Boolean.FALSE);
                    break;
                }
                case DATE: {
                    LocalDateTime value = MPPUtility.getTimestamp(this.m_data, this.m_dataOffset);
                    this.m_dataOffset += 4;
                    criteria.setRightValue(index, value);
                    break;
                }
            }
        }
    }
}

