/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.mpp;

import java.util.HashMap;
import java.util.Map;
import org.mpxj.AssignmentField;
import org.mpxj.FieldContainer;
import org.mpxj.FieldType;
import org.mpxj.Resource;
import org.mpxj.ResourceAssignment;
import org.mpxj.ResourceField;
import org.mpxj.Task;
import org.mpxj.TaskField;
import org.mpxj.mpp.MPPUtility;

final class HyperlinkReader {
    private boolean m_hasScreenTip = true;
    private static final Map<Class<?>, FieldType[]> FIELDS = new HashMap();

    HyperlinkReader() {
    }

    public void setHasScreenTip(boolean hasScreenTip) {
        this.m_hasScreenTip = hasScreenTip;
    }

    public void read(FieldContainer container, byte[] data) {
        if (data != null) {
            int offset = 12;
            String hyperlink = MPPUtility.getUnicodeString(data, offset += 12);
            offset += (hyperlink.length() + 1) * 2;
            String address = MPPUtility.getUnicodeString(data, offset += 12);
            offset += (address.length() + 1) * 2;
            String subaddress = MPPUtility.getUnicodeString(data, offset += 12);
            offset += (subaddress.length() + 1) * 2;
            String screentip = this.m_hasScreenTip ? MPPUtility.getUnicodeString(data, offset += 12) : null;
            FieldType[] fields = FIELDS.get(container.getClass());
            container.set(fields[0], hyperlink);
            container.set(fields[1], address);
            container.set(fields[2], subaddress);
            container.set(fields[3], screentip);
        }
    }

    static {
        FIELDS.put(Task.class, new FieldType[]{TaskField.HYPERLINK, TaskField.HYPERLINK_ADDRESS, TaskField.HYPERLINK_SUBADDRESS, TaskField.HYPERLINK_SCREEN_TIP});
        FIELDS.put(Resource.class, new FieldType[]{ResourceField.HYPERLINK, ResourceField.HYPERLINK_ADDRESS, ResourceField.HYPERLINK_SUBADDRESS, ResourceField.HYPERLINK_SCREEN_TIP});
        FIELDS.put(ResourceAssignment.class, new FieldType[]{AssignmentField.HYPERLINK, AssignmentField.HYPERLINK_ADDRESS, AssignmentField.HYPERLINK_SUBADDRESS, AssignmentField.HYPERLINK_SCREEN_TIP});
    }
}

