/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.mpp;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.mpxj.Duration;
import org.mpxj.ProjectCalendar;
import org.mpxj.TimePeriodEntity;
import org.mpxj.TimeUnit;
import org.mpxj.TimephasedWork;
import org.mpxj.common.AbstractTimephasedWorkNormaliser;
import org.mpxj.common.LocalDateHelper;
import org.mpxj.common.LocalDateTimeHelper;
import org.mpxj.common.LocalTimeHelper;

public abstract class MPPAbstractTimephasedWorkNormaliser
extends AbstractTimephasedWorkNormaliser {
    private static final double EQUALITY_DELTA = 0.2;

    @Override
    public void normalise(ProjectCalendar calendar, TimePeriodEntity parent, List<TimephasedWork> list) {
        if (list.isEmpty()) {
            return;
        }
        this.splitDays(calendar, list);
        this.mergeSameDay(calendar, list);
        this.mergeSameWork(calendar, parent, list);
        this.convertToHours(list);
    }

    private void splitDays(ProjectCalendar calendar, List<TimephasedWork> list) {
        ArrayList<TimephasedWork> result = new ArrayList<TimephasedWork>();
        boolean remainderInserted = false;
        block0: for (TimephasedWork item : list) {
            if (remainderInserted) {
                item.setStart(item.getStart().plusDays(1L));
                remainderInserted = false;
            }
            Duration calendarWork = calendar.getWork(item.getStart(), item.getFinish(), TimeUnit.MINUTES);
            while (item != null) {
                LocalDateTime startDay = LocalDateTimeHelper.getDayStartDate(item.getStart());
                LocalDateTime finishDay = LocalDateTimeHelper.getDayStartDate(item.getFinish());
                if (item.getFinish().equals(finishDay)) {
                    finishDay = finishDay.minusDays(1L);
                }
                if (startDay.equals(finishDay)) {
                    Duration totalWork = (Duration)item.getTotalAmount();
                    Duration itemWork = this.getItemWork(calendar, item);
                    if (totalWork.getDuration() - itemWork.getDuration() > 0.2) {
                        item.setTotalAmount(itemWork);
                        result.add(item);
                        Duration remainingWork = Duration.getInstance(totalWork.getDuration() - itemWork.getDuration(), TimeUnit.MINUTES);
                        LocalDateTime remainderStart = finishDay.plusDays(1L);
                        LocalDateTime remainderFinish = remainderStart.plusDays(1L);
                        TimephasedWork remainder = new TimephasedWork();
                        remainder.setStart(remainderStart);
                        remainder.setFinish(remainderFinish);
                        remainder.setTotalAmount(remainingWork);
                        result.add(remainder);
                        remainderInserted = true;
                        continue block0;
                    }
                    result.add(item);
                    continue block0;
                }
                TimephasedWork[] split = this.splitFirstDay(calendar, item, calendarWork);
                if (split[0] != null) {
                    TimephasedWork firstDayItem = split[0];
                    result.add(firstDayItem);
                    Duration firstDayCalendarWork = calendar.getWork(firstDayItem.getStart(), firstDayItem.getFinish(), TimeUnit.MINUTES);
                    calendarWork = Duration.getInstance(calendarWork.getDuration() - firstDayCalendarWork.getDuration(), TimeUnit.MINUTES);
                }
                if (item.equals(split[1])) continue block0;
                item = split[1];
            }
        }
        list.clear();
        list.addAll(result);
    }

    private TimephasedWork[] splitFirstDay(ProjectCalendar calendar, TimephasedWork item, Duration calendarWork) {
        TimephasedWork[] result = new TimephasedWork[2];
        LocalDateTime itemStart = item.getStart();
        LocalDateTime itemFinish = item.getFinish();
        Duration itemWork = (Duration)item.getTotalAmount();
        if (calendarWork.getDuration() != 0.0) {
            TimephasedWork split;
            Duration splitWork;
            double splitMinutes;
            LocalDateTime splitFinish;
            LocalDate itemStartAsLocalDate = LocalDateHelper.getLocalDate(itemStart);
            if (calendar.isWorkingDate(itemStartAsLocalDate)) {
                splitFinish = LocalTimeHelper.setEndTime(itemStart, calendar.getFinishTime(itemStartAsLocalDate));
                Duration calendarSplitWork = calendar.getWork(itemStart, splitFinish, TimeUnit.MINUTES);
                Duration itemWorkPerDay = (Duration)item.getAmountPerDay();
                splitMinutes = itemWorkPerDay.getDuration();
                splitMinutes *= calendarSplitWork.getDuration();
                splitWork = Duration.getInstance(splitMinutes /= 480.0, TimeUnit.MINUTES);
                TimephasedWork split2 = new TimephasedWork();
                split2.setStart(itemStart);
                split2.setFinish(splitFinish);
                split2.setTotalAmount(splitWork);
                result[0] = split2;
            } else {
                splitFinish = itemStart;
                splitMinutes = 0.0;
            }
            LocalDateTime splitStart = calendar.getNextWorkStart(splitFinish);
            splitFinish = itemFinish;
            if (splitStart.isAfter(splitFinish)) {
                split = null;
            } else {
                splitMinutes = itemWork.getDuration() - splitMinutes;
                splitWork = Duration.getInstance(splitMinutes, TimeUnit.MINUTES);
                split = new TimephasedWork();
                split.setStart(splitStart);
                split.setFinish(splitFinish);
                split.setTotalAmount(splitWork);
                split.setAmountPerDay(item.getAmountPerDay());
            }
            result[1] = split;
        }
        return result;
    }

    protected abstract void mergeSameDay(ProjectCalendar var1, List<TimephasedWork> var2);

    private Duration getItemWork(ProjectCalendar calendar, TimephasedWork item) {
        LocalDateTime splitFinish = LocalTimeHelper.setEndTime(item.getStart(), calendar.getFinishTime(LocalDateHelper.getLocalDate(item.getStart())));
        Duration calendarSplitWork = calendar.getWork(item.getStart(), splitFinish, TimeUnit.MINUTES);
        Duration itemWorkPerDay = (Duration)item.getAmountPerDay();
        double splitMinutes = itemWorkPerDay.getDuration();
        splitMinutes *= calendarSplitWork.getDuration();
        Duration splitWork = Duration.getInstance(splitMinutes /= 480.0, TimeUnit.MINUTES);
        return splitWork;
    }
}

