/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.mpp;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.mpxj.CalendarType;
import org.mpxj.FieldType;
import org.mpxj.LocalDateTimeRange;
import org.mpxj.MPXJException;
import org.mpxj.ProjectCalendar;
import org.mpxj.ProjectConfig;
import org.mpxj.ProjectFile;
import org.mpxj.ProjectProperties;
import org.mpxj.Relation;
import org.mpxj.Resource;
import org.mpxj.Task;
import org.mpxj.TaskField;
import org.mpxj.UnitOfMeasure;
import org.mpxj.UnitOfMeasureContainer;
import org.mpxj.common.AutoCloseableHelper;
import org.mpxj.mpp.CompObj;
import org.mpxj.mpp.MPP12Reader;
import org.mpxj.mpp.MPP14Reader;
import org.mpxj.mpp.MPP8Reader;
import org.mpxj.mpp.MPP9Reader;
import org.mpxj.mpp.MPPVariantReader;
import org.mpxj.reader.AbstractProjectStreamReader;

public final class MPPReader
extends AbstractProjectStreamReader {
    private boolean m_useRawTimephasedData;
    private boolean m_readPresentationData = true;
    private boolean m_readPropertiesOnly;
    private boolean m_respectPasswordProtection = true;
    private String m_readPassword;
    private static final Map<String, Class<? extends MPPVariantReader>> FILE_CLASS_MAP = new HashMap<String, Class<? extends MPPVariantReader>>();
    private static final Map<TaskField, TaskField> TASK_ESTIMATED_BASELINE_FIELDS;

    @Override
    public ProjectFile read(InputStream is) throws MPXJException {
        try {
            return this.read(new POIFSFileSystem(is));
        }
        catch (IOException ex) {
            throw new MPXJException("Error reading file", ex);
        }
    }

    @Override
    public ProjectFile read(File file) throws MPXJException {
        ProjectFile projectFile;
        POIFSFileSystem fs = null;
        try {
            fs = new POIFSFileSystem(file);
            projectFile = this.read(fs);
        }
        catch (IOException ex) {
            try {
                throw new MPXJException("Error reading file", ex);
            }
            catch (Throwable throwable) {
                AutoCloseableHelper.closeQuietly(fs);
                throw throwable;
            }
        }
        AutoCloseableHelper.closeQuietly((AutoCloseable)fs);
        return projectFile;
    }

    public static String getFileFormat(POIFSFileSystem fs) throws IOException {
        String fileFormat = "";
        DirectoryNode root = fs.getRoot();
        if (root.getEntryNames().contains("\u0001CompObj")) {
            CompObj compObj = new CompObj((InputStream)new DocumentInputStream((DocumentEntry)root.getEntry("\u0001CompObj")));
            fileFormat = compObj.getFileFormat();
        }
        return fileFormat;
    }

    public ProjectFile read(POIFSFileSystem fs) throws MPXJException {
        try {
            ProjectFile projectFile = new ProjectFile();
            ProjectConfig config = projectFile.getProjectConfig();
            config.setAutoTaskID(false);
            config.setAutoTaskUniqueID(false);
            config.setAutoResourceID(false);
            config.setAutoResourceUniqueID(false);
            config.setAutoOutlineLevel(false);
            config.setAutoOutlineNumber(false);
            config.setAutoWBS(false);
            config.setAutoCalendarUniqueID(false);
            config.setAutoAssignmentUniqueID(false);
            config.setAutoRelationUniqueID(false);
            this.addListenersToProject(projectFile);
            DirectoryNode root = fs.getRoot();
            CompObj compObj = new CompObj((InputStream)new DocumentInputStream((DocumentEntry)root.getEntry("\u0001CompObj")));
            ProjectProperties projectProperties = projectFile.getProjectProperties();
            projectProperties.setFullApplicationName(compObj.getApplicationName());
            projectProperties.setApplicationVersion(compObj.getApplicationVersion());
            String format = compObj.getFileFormat();
            Class<? extends MPPVariantReader> readerClass = FILE_CLASS_MAP.get(format);
            if (readerClass == null) {
                throw new MPXJException("Invalid file format: " + format);
            }
            MPPVariantReader reader = readerClass.newInstance();
            reader.process(this, projectFile, (DirectoryEntry)root);
            config.setAutoOutlineNumber(true);
            projectFile.updateStructure();
            config.setAutoOutlineNumber(false);
            Iterator iterator = projectFile.getTasks().iterator();
            while (iterator.hasNext()) {
                Task task;
                task.setSummary((task = (Task)iterator.next()).hasChildTasks() || task.getExternalProject());
                List<LocalDateTimeRange> splits = task.getSplits();
                if (splits != null && splits.isEmpty()) {
                    task.setSplits(null);
                }
                this.validationRelations(task);
                this.copyEstimatedBaselineFields(task);
            }
            Map<Integer, List<Resource>> resourceCalendarMap = projectFile.getResources().stream().filter(r -> r.getCalendarUniqueID() != null).collect(Collectors.groupingBy(Resource::getCalendarUniqueID));
            projectFile.getCalendars().removeIf(c -> c.isDerived() && !resourceCalendarMap.containsKey(c.getUniqueID()));
            UnitOfMeasureContainer unitsOfMeasure = projectFile.getUnitsOfMeasure();
            for (Resource resource : projectFile.getResources()) {
                UnitOfMeasure uom;
                ProjectCalendar calendar = resource.getCalendar();
                if (calendar != null) {
                    if (calendar.isDerived()) {
                        calendar.setType(CalendarType.RESOURCE);
                        calendar.setPersonal(resourceCalendarMap.computeIfAbsent(calendar.getUniqueID(), k -> Collections.emptyList()).size() == 1);
                    }
                    if (calendar.getName() == null || calendar.getName().isEmpty()) {
                        String name = resource.getName();
                        if (name == null || name.isEmpty()) {
                            name = "Unnamed Resource";
                        }
                        calendar.setName(name);
                    }
                }
                if ((uom = unitsOfMeasure.getOrCreateByAbbreviation(resource.getMaterialLabel())) == null) continue;
                resource.setUnitOfMeasure(uom);
            }
            String projectFilePath = projectFile.getProjectProperties().getProjectFilePath();
            if (projectFilePath != null && projectFilePath.startsWith("<>\\")) {
                projectProperties.setFileApplication("Microsoft Project Server");
            } else {
                projectProperties.setFileApplication("Microsoft");
            }
            projectProperties.setFileType("MPP");
            projectFile.readComplete();
            return projectFile;
        }
        catch (IOException | IllegalAccessException | InstantiationException ex) {
            throw new MPXJException("Error reading file", ex);
        }
    }

    private void validationRelations(Task task) {
        List<Relation> predecessors = task.getPredecessors();
        if (!predecessors.isEmpty()) {
            ArrayList<Relation> invalid = new ArrayList<Relation>();
            for (Relation relation : predecessors) {
                Task sourceTask = relation.getSuccessorTask();
                Task targetTask = relation.getPredecessorTask();
                String sourceOutlineNumber = sourceTask.getOutlineNumber();
                String targetOutlineNumber = targetTask.getOutlineNumber();
                if (sourceOutlineNumber == null || targetOutlineNumber == null || !sourceOutlineNumber.startsWith(targetOutlineNumber + '.')) continue;
                invalid.add(relation);
            }
            for (Relation relation : invalid) {
                relation.getSuccessorTask().removePredecessor(relation.getPredecessorTask(), relation.getType(), relation.getLag());
            }
        }
    }

    private void copyEstimatedBaselineFields(Task task) {
        for (Map.Entry<TaskField, TaskField> entry : TASK_ESTIMATED_BASELINE_FIELDS.entrySet()) {
            Object value = task.getCachedValue(entry.getKey());
            if (value != null || (value = task.getCachedValue(entry.getValue())) == null) continue;
            task.set((FieldType)entry.getKey(), value);
        }
    }

    public boolean getUseRawTimephasedData() {
        return this.m_useRawTimephasedData;
    }

    public void setUseRawTimephasedData(boolean useRawTimephasedData) {
        this.m_useRawTimephasedData = useRawTimephasedData;
    }

    public boolean getReadPresentationData() {
        return this.m_readPresentationData;
    }

    public void setReadPresentationData(boolean readPresentationData) {
        this.m_readPresentationData = readPresentationData;
    }

    public boolean getReadPropertiesOnly() {
        return this.m_readPropertiesOnly;
    }

    public void setReadPropertiesOnly(boolean readPropertiesOnly) {
        this.m_readPropertiesOnly = readPropertiesOnly;
    }

    public void setReadPassword(String password) {
        this.m_readPassword = password;
    }

    public String getReadPassword() {
        return this.m_readPassword;
    }

    public void setRespectPasswordProtection(boolean respectPasswordProtection) {
        this.m_respectPasswordProtection = respectPasswordProtection;
    }

    public boolean getRespectPasswordProtection() {
        return this.m_respectPasswordProtection;
    }

    static {
        FILE_CLASS_MAP.put("MSProject.MPP9", MPP9Reader.class);
        FILE_CLASS_MAP.put("MSProject.MPT9", MPP9Reader.class);
        FILE_CLASS_MAP.put("MSProject.GLOBAL9", MPP9Reader.class);
        FILE_CLASS_MAP.put("MSProject.MPP8", MPP8Reader.class);
        FILE_CLASS_MAP.put("MSProject.MPT8", MPP8Reader.class);
        FILE_CLASS_MAP.put("MSProject.MPP12", MPP12Reader.class);
        FILE_CLASS_MAP.put("MSProject.MPT12", MPP12Reader.class);
        FILE_CLASS_MAP.put("MSProject.GLOBAL12", MPP12Reader.class);
        FILE_CLASS_MAP.put("MSProject.MPP14", MPP14Reader.class);
        FILE_CLASS_MAP.put("MSProject.MPT14", MPP14Reader.class);
        FILE_CLASS_MAP.put("MSProject.GLOBAL14", MPP14Reader.class);
        TASK_ESTIMATED_BASELINE_FIELDS = new HashMap<TaskField, TaskField>();
        TASK_ESTIMATED_BASELINE_FIELDS.put(TaskField.BASELINE_DURATION, TaskField.BASELINE_ESTIMATED_DURATION);
        TASK_ESTIMATED_BASELINE_FIELDS.put(TaskField.BASELINE_START, TaskField.BASELINE_ESTIMATED_START);
        TASK_ESTIMATED_BASELINE_FIELDS.put(TaskField.BASELINE_FINISH, TaskField.BASELINE_ESTIMATED_FINISH);
        TASK_ESTIMATED_BASELINE_FIELDS.put(TaskField.BASELINE1_DURATION, TaskField.BASELINE1_ESTIMATED_DURATION);
        TASK_ESTIMATED_BASELINE_FIELDS.put(TaskField.BASELINE1_START, TaskField.BASELINE1_ESTIMATED_START);
        TASK_ESTIMATED_BASELINE_FIELDS.put(TaskField.BASELINE1_FINISH, TaskField.BASELINE1_ESTIMATED_FINISH);
        TASK_ESTIMATED_BASELINE_FIELDS.put(TaskField.BASELINE2_DURATION, TaskField.BASELINE2_ESTIMATED_DURATION);
        TASK_ESTIMATED_BASELINE_FIELDS.put(TaskField.BASELINE2_START, TaskField.BASELINE2_ESTIMATED_START);
        TASK_ESTIMATED_BASELINE_FIELDS.put(TaskField.BASELINE2_FINISH, TaskField.BASELINE2_ESTIMATED_FINISH);
        TASK_ESTIMATED_BASELINE_FIELDS.put(TaskField.BASELINE3_DURATION, TaskField.BASELINE3_ESTIMATED_DURATION);
        TASK_ESTIMATED_BASELINE_FIELDS.put(TaskField.BASELINE3_START, TaskField.BASELINE3_ESTIMATED_START);
        TASK_ESTIMATED_BASELINE_FIELDS.put(TaskField.BASELINE3_FINISH, TaskField.BASELINE3_ESTIMATED_FINISH);
        TASK_ESTIMATED_BASELINE_FIELDS.put(TaskField.BASELINE4_DURATION, TaskField.BASELINE4_ESTIMATED_DURATION);
        TASK_ESTIMATED_BASELINE_FIELDS.put(TaskField.BASELINE4_START, TaskField.BASELINE4_ESTIMATED_START);
        TASK_ESTIMATED_BASELINE_FIELDS.put(TaskField.BASELINE4_FINISH, TaskField.BASELINE4_ESTIMATED_FINISH);
        TASK_ESTIMATED_BASELINE_FIELDS.put(TaskField.BASELINE5_DURATION, TaskField.BASELINE5_ESTIMATED_DURATION);
        TASK_ESTIMATED_BASELINE_FIELDS.put(TaskField.BASELINE5_START, TaskField.BASELINE5_ESTIMATED_START);
        TASK_ESTIMATED_BASELINE_FIELDS.put(TaskField.BASELINE5_FINISH, TaskField.BASELINE5_ESTIMATED_FINISH);
        TASK_ESTIMATED_BASELINE_FIELDS.put(TaskField.BASELINE6_DURATION, TaskField.BASELINE6_ESTIMATED_DURATION);
        TASK_ESTIMATED_BASELINE_FIELDS.put(TaskField.BASELINE6_START, TaskField.BASELINE6_ESTIMATED_START);
        TASK_ESTIMATED_BASELINE_FIELDS.put(TaskField.BASELINE6_FINISH, TaskField.BASELINE6_ESTIMATED_FINISH);
        TASK_ESTIMATED_BASELINE_FIELDS.put(TaskField.BASELINE7_DURATION, TaskField.BASELINE7_ESTIMATED_DURATION);
        TASK_ESTIMATED_BASELINE_FIELDS.put(TaskField.BASELINE7_START, TaskField.BASELINE7_ESTIMATED_START);
        TASK_ESTIMATED_BASELINE_FIELDS.put(TaskField.BASELINE7_FINISH, TaskField.BASELINE7_ESTIMATED_FINISH);
        TASK_ESTIMATED_BASELINE_FIELDS.put(TaskField.BASELINE8_DURATION, TaskField.BASELINE8_ESTIMATED_DURATION);
        TASK_ESTIMATED_BASELINE_FIELDS.put(TaskField.BASELINE8_START, TaskField.BASELINE8_ESTIMATED_START);
        TASK_ESTIMATED_BASELINE_FIELDS.put(TaskField.BASELINE8_FINISH, TaskField.BASELINE8_ESTIMATED_FINISH);
        TASK_ESTIMATED_BASELINE_FIELDS.put(TaskField.BASELINE9_DURATION, TaskField.BASELINE9_ESTIMATED_DURATION);
        TASK_ESTIMATED_BASELINE_FIELDS.put(TaskField.BASELINE9_START, TaskField.BASELINE9_ESTIMATED_START);
        TASK_ESTIMATED_BASELINE_FIELDS.put(TaskField.BASELINE9_FINISH, TaskField.BASELINE9_ESTIMATED_FINISH);
        TASK_ESTIMATED_BASELINE_FIELDS.put(TaskField.BASELINE10_DURATION, TaskField.BASELINE10_ESTIMATED_DURATION);
        TASK_ESTIMATED_BASELINE_FIELDS.put(TaskField.BASELINE10_START, TaskField.BASELINE10_ESTIMATED_START);
        TASK_ESTIMATED_BASELINE_FIELDS.put(TaskField.BASELINE10_FINISH, TaskField.BASELINE10_ESTIMATED_FINISH);
    }
}

