/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.mpp;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.mpxj.Duration;
import org.mpxj.ProjectCalendar;
import org.mpxj.TimePeriodEntity;
import org.mpxj.TimeUnit;
import org.mpxj.TimephasedCost;
import org.mpxj.TimephasedItem;
import org.mpxj.common.LocalDateHelper;
import org.mpxj.common.LocalDateTimeHelper;
import org.mpxj.common.LocalTimeHelper;
import org.mpxj.common.NumberHelper;
import org.mpxj.common.TimephasedNormaliser;

public final class MPPTimephasedBaselineCostNormaliser
implements TimephasedNormaliser<TimephasedCost> {
    public static final MPPTimephasedBaselineCostNormaliser INSTANCE = new MPPTimephasedBaselineCostNormaliser();

    private MPPTimephasedBaselineCostNormaliser() {
    }

    @Override
    public void normalise(ProjectCalendar calendar, TimePeriodEntity parent, List<TimephasedCost> list) {
        if (!list.isEmpty()) {
            this.splitDays(calendar, list);
            this.mergeSameDay(list);
            this.mergeSameCost(list);
        }
    }

    private void splitDays(ProjectCalendar calendar, List<TimephasedCost> list) {
        ArrayList<TimephasedCost> result = new ArrayList<TimephasedCost>();
        block0: for (TimephasedCost item : list) {
            while (item != null) {
                LocalDateTime startDay = LocalDateTimeHelper.getDayStartDate(item.getStart());
                LocalDateTime finishDay = LocalDateTimeHelper.getDayStartDate(item.getFinish());
                if (item.getFinish().equals(finishDay)) {
                    finishDay = finishDay.minusDays(1L);
                }
                if (startDay.equals(finishDay)) {
                    result.add(item);
                    continue block0;
                }
                TimephasedCost[] split = this.splitFirstDay(calendar, item);
                if (split[0] != null) {
                    result.add(split[0]);
                }
                if (item.equals(split[1])) continue block0;
                item = split[1];
            }
        }
        list.clear();
        list.addAll(result);
    }

    private TimephasedCost[] splitFirstDay(ProjectCalendar calendar, TimephasedCost item) {
        LocalDateTime itemFinish;
        TimephasedCost[] result = new TimephasedCost[2];
        LocalDateTime itemStart = item.getStart();
        Duration calendarWork = calendar.getWork(itemStart, itemFinish = item.getFinish(), TimeUnit.MINUTES);
        if (calendarWork.getDuration() != 0.0) {
            TimephasedCost split;
            double splitCost;
            LocalDateTime splitFinish;
            LocalDate itemStartAsLocalDate = LocalDateHelper.getLocalDate(itemStart);
            if (calendar.isWorkingDate(itemStartAsLocalDate)) {
                splitFinish = LocalTimeHelper.setEndTime(itemStart, calendar.getFinishTime(itemStartAsLocalDate));
                Duration calendarSplitWork = calendar.getWork(itemStart, splitFinish, TimeUnit.MINUTES);
                splitCost = ((Number)item.getTotalAmount()).doubleValue() * calendarSplitWork.getDuration() / calendarWork.getDuration();
                split = new TimephasedCost();
                split.setStart(itemStart);
                split.setFinish(splitFinish);
                split.setTotalAmount(splitCost);
                result[0] = split;
            } else {
                splitFinish = itemStart;
                splitCost = 0.0;
            }
            LocalDateTime splitStart = calendar.getNextWorkStart(splitFinish);
            splitFinish = itemFinish;
            if (splitStart.isAfter(splitFinish)) {
                split = null;
            } else {
                splitCost = ((Number)item.getTotalAmount()).doubleValue() - splitCost;
                split = new TimephasedCost();
                split.setStart(splitStart);
                split.setFinish(splitFinish);
                split.setTotalAmount(splitCost);
                split.setAmountPerDay(item.getAmountPerDay());
            }
            result[1] = split;
        }
        return result;
    }

    private void mergeSameDay(List<TimephasedCost> list) {
        ArrayList<TimephasedCost> result = new ArrayList<TimephasedCost>();
        TimephasedItem previousAssignment = null;
        for (TimephasedCost assignment : list) {
            LocalDateTime assignmentStart;
            LocalDateTime assignmentStartDay;
            LocalDateTime previousAssignmentStart;
            LocalDateTime previousAssignmentStartDay;
            if (previousAssignment != null && (previousAssignmentStartDay = LocalDateTimeHelper.getDayStartDate(previousAssignmentStart = previousAssignment.getStart())).equals(assignmentStartDay = LocalDateTimeHelper.getDayStartDate(assignmentStart = assignment.getStart()))) {
                result.remove(result.size() - 1);
                double cost = ((Number)previousAssignment.getTotalAmount()).doubleValue();
                TimephasedCost merged = new TimephasedCost();
                merged.setStart(previousAssignment.getStart());
                merged.setFinish(assignment.getFinish());
                merged.setTotalAmount(cost += ((Number)assignment.getTotalAmount()).doubleValue());
                assignment = merged;
            }
            assignment.setAmountPerDay(assignment.getTotalAmount());
            result.add(assignment);
            previousAssignment = assignment;
        }
        list.clear();
        list.addAll(result);
    }

    private void mergeSameCost(List<TimephasedCost> list) {
        ArrayList<TimephasedCost> result = new ArrayList<TimephasedCost>();
        TimephasedItem previousAssignment = null;
        for (TimephasedCost assignment : list) {
            if (previousAssignment == null) {
                assignment.setAmountPerDay(assignment.getTotalAmount());
                result.add(assignment);
            } else {
                Number previousAssignmentCost = (Number)previousAssignment.getAmountPerDay();
                Number assignmentCost = (Number)assignment.getTotalAmount();
                if (NumberHelper.equals(previousAssignmentCost.doubleValue(), assignmentCost.doubleValue(), 0.01)) {
                    LocalDateTime assignmentStart = previousAssignment.getStart();
                    LocalDateTime assignmentFinish = assignment.getFinish();
                    double total = ((Number)previousAssignment.getTotalAmount()).doubleValue();
                    TimephasedCost merged = new TimephasedCost();
                    merged.setStart(assignmentStart);
                    merged.setFinish(assignmentFinish);
                    merged.setAmountPerDay(assignmentCost);
                    merged.setTotalAmount(total += assignmentCost.doubleValue());
                    result.remove(result.size() - 1);
                    assignment = merged;
                } else {
                    assignment.setAmountPerDay(assignment.getTotalAmount());
                }
                result.add(assignment);
            }
            previousAssignment = assignment;
        }
        list.clear();
        list.addAll(result);
    }
}

