/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.mpp;

import java.time.DayOfWeek;
import org.mpxj.MpxjEnum;
import org.mpxj.common.EnumHelper;

public enum ProgressLineDay implements MpxjEnum
{
    SUNDAY(1, DayOfWeek.SUNDAY),
    MONDAY(2, DayOfWeek.MONDAY),
    TUESDAY(3, DayOfWeek.TUESDAY),
    WEDNESDAY(4, DayOfWeek.WEDNESDAY),
    THURSDAY(5, DayOfWeek.THURSDAY),
    FRIDAY(6, DayOfWeek.FRIDAY),
    SATURDAY(7, DayOfWeek.SATURDAY),
    DAY(8, null),
    WORKINGDAY(9, null),
    NONWORKINGDAY(10, null);

    private static final ProgressLineDay[] TYPE_VALUES;
    private final int m_value;
    private final DayOfWeek m_day;

    private ProgressLineDay(int value, DayOfWeek day) {
        this.m_value = value;
        this.m_day = day;
    }

    @Override
    public int getValue() {
        return this.m_value;
    }

    public DayOfWeek getDay() {
        return this.m_day;
    }

    public ProgressLineDay getNextDay() {
        int value = this.m_value + 1;
        if (value > 7) {
            value = 1;
        }
        return ProgressLineDay.getInstance(value);
    }

    public static ProgressLineDay getInstance(int type) {
        ProgressLineDay result = type < 0 || type >= TYPE_VALUES.length ? null : TYPE_VALUES[type];
        return result;
    }

    static {
        TYPE_VALUES = (ProgressLineDay[])EnumHelper.createTypeArray(ProgressLineDay.class, (int)1);
    }
}

