/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.mpp;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.mpxj.RtfNotes;
import org.mpxj.common.ByteArrayHelper;

public final class RTFEmbeddedObject {
    private int m_typeFlag1;
    private int m_typeFlag2;
    private byte[] m_data;
    private static final String OBJDATA = "\\objdata";

    private RTFEmbeddedObject(List<byte[]> blocks, int type) {
        switch (type) {
            case 2: 
            case 5: {
                this.m_typeFlag1 = this.getInt(blocks);
                this.m_typeFlag2 = this.getInt(blocks);
                int length = this.getInt(blocks);
                this.m_data = this.getData(blocks, length);
                break;
            }
            case 1: {
                int length = this.getInt(blocks);
                this.m_data = this.getData(blocks, length);
                break;
            }
        }
    }

    public int getTypeFlag1() {
        return this.m_typeFlag1;
    }

    public int getTypeFlag2() {
        return this.m_typeFlag2;
    }

    public byte[] getData() {
        return this.m_data;
    }

    public String getDataString() {
        return this.m_data == null ? "" : new String(this.m_data);
    }

    public static List<List<RTFEmbeddedObject>> getEmbeddedObjects(RtfNotes notes) {
        ArrayList<ArrayList<RTFEmbeddedObject>> objects = null;
        String rtf = notes.getRtf();
        int offset = rtf.indexOf(OBJDATA);
        if (offset != -1) {
            objects = new ArrayList<ArrayList<RTFEmbeddedObject>>();
            while (offset != -1) {
                ArrayList<RTFEmbeddedObject> objectData = new ArrayList<RTFEmbeddedObject>();
                objects.add(objectData);
                offset = RTFEmbeddedObject.readObjectData(offset, rtf, objectData);
                offset = rtf.indexOf(OBJDATA, offset);
            }
        }
        return objects;
    }

    private int getInt(List<byte[]> blocks) {
        int result;
        if (!blocks.isEmpty()) {
            byte[] data = blocks.remove(0);
            result = ByteArrayHelper.getInt(data, 0);
        } else {
            result = 0;
        }
        return result;
    }

    private byte[] getData(List<byte[]> blocks, int length) {
        byte[] result;
        if (!blocks.isEmpty()) {
            byte[] data;
            if (length < 4) {
                length = 4;
            }
            result = new byte[length];
            for (int offset = 0; offset < length; offset += data.length) {
                data = blocks.remove(0);
                System.arraycopy(data, 0, result, offset, data.length);
            }
        } else {
            result = null;
        }
        return result;
    }

    private static int readObjectData(int offset, String text, List<RTFEmbeddedObject> objects) {
        ArrayList<byte[]> blocks = new ArrayList<byte[]>();
        offset += OBJDATA.length();
        int lastOffset = offset = RTFEmbeddedObject.skipEndOfLine(text, offset);
        while (offset != -1) {
            int length = RTFEmbeddedObject.getBlockLength(text, offset);
            lastOffset = RTFEmbeddedObject.readDataBlock(text, offset, length, blocks);
            offset = RTFEmbeddedObject.skipEndOfLine(text, lastOffset);
        }
        while (!blocks.isEmpty()) {
            RTFEmbeddedObject headerObject = new RTFEmbeddedObject(blocks, 2);
            objects.add(headerObject);
            if (blocks.isEmpty()) continue;
            RTFEmbeddedObject dataObject = new RTFEmbeddedObject(blocks, headerObject.getTypeFlag2());
            objects.add(dataObject);
        }
        return lastOffset;
    }

    private static int skipEndOfLine(String text, int offset) {
        boolean finished = false;
        block4: while (!finished) {
            char c = text.charAt(offset);
            switch (c) {
                case '\n': 
                case '\r': 
                case ' ': {
                    ++offset;
                    continue block4;
                }
                case '}': {
                    offset = -1;
                    finished = true;
                    continue block4;
                }
            }
            finished = true;
        }
        return offset;
    }

    private static int getBlockLength(String text, int offset) {
        int startIndex = offset;
        boolean finished = false;
        block3: while (!finished) {
            char c = text.charAt(offset);
            switch (c) {
                case '\n': 
                case '\r': 
                case '}': {
                    finished = true;
                    continue block3;
                }
            }
            ++offset;
        }
        return offset - startIndex;
    }

    private static int readDataBlock(String text, int offset, int length, List<byte[]> blocks) {
        int bytes = length / 2;
        byte[] data = new byte[bytes];
        for (int index = 0; index < bytes; ++index) {
            data[index] = (byte)Integer.parseInt(text.substring(offset, offset + 2), 16);
            offset += 2;
        }
        blocks.add(data);
        return offset;
    }

    public String toString() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(os);
        pw.println("[RTFObject");
        pw.println("   Flag1=" + this.m_typeFlag1);
        pw.println("   Flag2=" + this.m_typeFlag2);
        pw.println("   Data=");
        pw.println(ByteArrayHelper.hexdump(this.m_data, true, 16, "  "));
        pw.println("]");
        pw.flush();
        return os.toString();
    }
}

