/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.mpp;

import java.util.HashMap;
import java.util.Map;
import org.mpxj.TaskType;

public final class TaskTypeHelper {
    private static final TaskType[] TYPE_VALUES = new TaskType[]{TaskType.FIXED_UNITS, TaskType.FIXED_DURATION, TaskType.FIXED_WORK};
    private static final Map<TaskType, Integer> TYPE_MAP = new HashMap<TaskType, Integer>();

    public static TaskType getInstance(int type) {
        if (type < 0 || type >= TYPE_VALUES.length) {
            return TaskType.FIXED_WORK;
        }
        return TYPE_VALUES[type];
    }

    public static int getValue(TaskType type) {
        if (type == null) {
            type = TaskType.FIXED_UNITS;
        }
        return TYPE_MAP.get((Object)type);
    }

    static {
        TYPE_MAP.put(TaskType.FIXED_UNITS, 0);
        TYPE_MAP.put(TaskType.FIXED_DURATION, 1);
        TYPE_MAP.put(TaskType.FIXED_WORK, 2);
        TYPE_MAP.put(TaskType.FIXED_DURATION_AND_UNITS, 1);
    }
}

