/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.mpp;

import java.time.LocalDateTime;
import org.mpxj.CustomFieldContainer;
import org.mpxj.mpp.MPPUtility;
import org.mpxj.mpp.Var2Data;
import org.mpxj.mpp.VarDataFieldReader;

class TimestampVarDataFieldReader
extends VarDataFieldReader {
    public TimestampVarDataFieldReader(CustomFieldContainer customFields) {
        super(customFields);
    }

    @Override
    protected Object readValue(Var2Data varData, Integer id, Integer type) {
        return this.getRawTimestampValue(varData, id, type);
    }

    @Override
    protected Object coerceValue(Object value) {
        if (value instanceof LocalDateTime) {
            return value;
        }
        return null;
    }

    private Object getRawTimestampValue(Var2Data varData, Integer id, Integer type) {
        Object result = null;
        byte[] data = varData.getByteArray(id, type);
        if (data != null) {
            if (data.length == 512) {
                result = MPPUtility.getUnicodeString(data, 0);
            } else if (data.length >= 4) {
                result = MPPUtility.getTimestamp(data, 0);
            }
        }
        return result;
    }
}

