/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.mpp;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.TreeMap;
import org.mpxj.ProjectFile;
import org.mpxj.common.ByteArrayHelper;
import org.mpxj.common.InputStreamHelper;
import org.mpxj.mpp.MPPComponent;
import org.mpxj.mpp.MPPUtility;
import org.mpxj.mpp.VarMeta;

final class Var2Data
extends MPPComponent {
    private final TreeMap<Integer, byte[]> m_map = new TreeMap();
    private final VarMeta m_meta;

    Var2Data(ProjectFile file, VarMeta meta, InputStream is) throws IOException {
        this.m_meta = meta;
        int currentOffset = 0;
        int available = is.available();
        for (int itemOffset : meta.getOffsets()) {
            byte[] data;
            if (itemOffset >= available) continue;
            if (currentOffset > itemOffset) {
                is.reset();
                InputStreamHelper.skip(is, itemOffset);
            } else if (currentOffset < itemOffset) {
                InputStreamHelper.skip(is, itemOffset - currentOffset);
            }
            int size = this.readInt(is);
            if (size < 0 || size > is.available()) continue;
            try {
                data = this.readByteArray(is, size);
            }
            catch (IndexOutOfBoundsException ex) {
                file.addIgnoredError(ex);
                break;
            }
            this.m_map.put(itemOffset, data);
            currentOffset = itemOffset + 4 + size;
        }
    }

    public byte[] getByteArray(Integer offset) {
        byte[] result = null;
        if (offset != null) {
            result = this.m_map.get(offset);
        }
        return result;
    }

    public byte[] getByteArray(Integer id, Integer type) {
        return this.getByteArray(this.m_meta.getOffset(id, type));
    }

    public String getUnicodeString(Integer offset) {
        byte[] value;
        String result = null;
        if (offset != null && (value = this.m_map.get(offset)) != null) {
            result = MPPUtility.getUnicodeString(value, 0);
        }
        return result;
    }

    public String getUnicodeString(Integer id, Integer type) {
        return this.getUnicodeString(this.m_meta.getOffset(id, type));
    }

    public LocalDateTime getTimestamp(Integer id, Integer type) {
        byte[] value;
        LocalDateTime result = null;
        Integer offset = this.m_meta.getOffset(id, type);
        if (offset != null && (value = this.m_map.get(offset)) != null && value.length >= 4) {
            result = MPPUtility.getTimestamp(value, 0);
        }
        return result;
    }

    public String getString(Integer offset) {
        byte[] value;
        String result = null;
        if (offset != null && (value = this.m_map.get(offset)) != null) {
            result = MPPUtility.getString(value, 0);
        }
        return result;
    }

    public String getString(Integer id, Integer type) {
        return this.getString(this.m_meta.getOffset(id, type));
    }

    public int getShort(Integer id, Integer type) {
        byte[] value;
        int result = 0;
        Integer offset = this.m_meta.getOffset(id, type);
        if (offset != null && (value = this.m_map.get(offset)) != null && value.length >= 2) {
            result = ByteArrayHelper.getShort(value, 0);
        }
        return result;
    }

    public int getByte(Integer id, Integer type) {
        byte[] value;
        int result = 0;
        Integer offset = this.m_meta.getOffset(id, type);
        if (offset != null && (value = this.m_map.get(offset)) != null) {
            result = MPPUtility.getByte(value, 0);
        }
        return result;
    }

    public int getInt(Integer id, Integer type) {
        byte[] value;
        int result = 0;
        Integer offset = this.m_meta.getOffset(id, type);
        if (offset != null && (value = this.m_map.get(offset)) != null && value.length >= 4) {
            result = ByteArrayHelper.getInt(value, 0);
        }
        return result;
    }

    public int getInt(Integer id, int offset, Integer type) {
        byte[] value;
        int result = 0;
        Integer metaOffset = this.m_meta.getOffset(id, type);
        if (metaOffset != null && (value = this.m_map.get(metaOffset)) != null && value.length >= offset + 4) {
            result = ByteArrayHelper.getInt(value, offset);
        }
        return result;
    }

    public long getLong(Integer id, Integer type) {
        byte[] value;
        long result = 0L;
        Integer offset = this.m_meta.getOffset(id, type);
        if (offset != null && (value = this.m_map.get(offset)) != null && value.length >= 8) {
            result = ByteArrayHelper.getLong(value, 0);
        }
        return result;
    }

    public double getDouble(Integer id, Integer type) {
        double result = Double.longBitsToDouble(this.getLong(id, type));
        if (Double.isNaN(result)) {
            result = 0.0;
        }
        return result;
    }

    public VarMeta getVarMeta() {
        return this.m_meta;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("BEGIN Var2Data");
        for (Map.Entry<Integer, byte[]> entry : this.m_map.entrySet()) {
            pw.println("   Data at offset: " + entry.getKey() + " size: " + entry.getValue().length);
            pw.println(ByteArrayHelper.hexdump(entry.getValue(), true, 16, "   "));
        }
        pw.println("END Var2Data");
        pw.println();
        pw.close();
        return sw.toString();
    }

    public String toString(Integer id) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("BEGIN Var2Data for " + id);
        for (Integer type : this.m_meta.getTypes(id)) {
            Integer offset = this.m_meta.getOffset(id, type);
            byte[] data = this.m_map.get(offset);
            pw.println("   Data at offset: " + offset + " size: " + data.length);
            pw.println(ByteArrayHelper.hexdump(data, true, 16, "   "));
        }
        pw.println("END Var2Data for " + id);
        pw.println();
        pw.close();
        return sw.toString();
    }
}

