/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.mpp;

import java.io.IOException;
import java.util.ArrayList;
import org.mpxj.ProjectFile;
import org.mpxj.ViewState;
import org.mpxj.common.ByteArrayHelper;
import org.mpxj.mpp.MPPUtility;
import org.mpxj.mpp.Props;
import org.mpxj.mpp.Var2Data;

public abstract class ViewStateReader {
    private static final Integer VIEW_NAME = 641728536;
    private static final Integer VIEW_CONTENTS = 641728565;

    protected abstract Props getProps(Var2Data var1) throws IOException;

    public void process(ProjectFile file, Var2Data varData, byte[] fixedData) throws IOException {
        Props props = this.getProps(varData);
        if (props != null) {
            String viewName = MPPUtility.removeAmpersands(props.getUnicodeString(VIEW_NAME));
            byte[] listData = props.getByteArray(VIEW_CONTENTS);
            ArrayList<Integer> uniqueIdList = new ArrayList<Integer>();
            if (listData != null) {
                for (int index = 0; index < listData.length; index += 4) {
                    Integer uniqueID = ByteArrayHelper.getInt(listData, index);
                    if (file.getTaskByUniqueID(uniqueID) == null || uniqueID == 0 && index != 0) continue;
                    uniqueIdList.add(uniqueID);
                }
            }
            int filterID = ByteArrayHelper.getShort(fixedData, 128);
            ViewState state = new ViewState(file, viewName, uniqueIdList, filterID);
            file.getViews().setViewState(state);
        }
    }
}

