/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.mpp;

import java.util.HashMap;
import java.util.Map;
import org.mpxj.ProjectFile;
import org.mpxj.WorkContour;
import org.mpxj.WorkContourContainer;

public class WorkContourHelper {
    private static final WorkContour[] TYPE_VALUES = new WorkContour[]{WorkContour.FLAT, WorkContour.BACK_LOADED, WorkContour.FRONT_LOADED, WorkContour.DOUBLE_PEAK, WorkContour.EARLY_PEAK, WorkContour.LATE_PEAK, WorkContour.BELL, WorkContour.TURTLE, WorkContour.CONTOURED};
    private static final Map<WorkContour, Integer> WORK_CONTOUR_MAP = new HashMap<WorkContour, Integer>();

    public static WorkContour getInstance(ProjectFile file, int type) {
        WorkContour result = type < 0 || type >= TYPE_VALUES.length ? WorkContour.FLAT : TYPE_VALUES[type];
        WorkContourContainer contours = file.getWorkContours();
        if (contours.getByUniqueID(result.getUniqueID()) == null) {
            contours.add(result);
        }
        return result;
    }

    public static Integer getID(WorkContour contour) {
        return WORK_CONTOUR_MAP.get(contour);
    }

    static {
        for (int index = 0; index < TYPE_VALUES.length; ++index) {
            WORK_CONTOUR_MAP.put(TYPE_VALUES[index], index);
        }
    }
}

