/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.mpx;

import java.time.LocalTime;
import java.util.Locale;
import org.mpxj.CodePage;
import org.mpxj.CurrencySymbolPosition;
import org.mpxj.DateOrder;
import org.mpxj.ProjectDateFormat;
import org.mpxj.ProjectProperties;
import org.mpxj.ProjectTimeFormat;
import org.mpxj.mpx.LocaleData;

final class LocaleUtility {
    private static final Locale[] SUPPORTED_LOCALES = new Locale[]{new Locale("EN"), new Locale("DE"), new Locale("FR"), new Locale("IT"), new Locale("PT"), new Locale("SV"), new Locale("ZH"), new Locale("ES"), new Locale("RU")};

    private LocaleUtility() {
    }

    public static void setLocale(ProjectProperties properties, Locale locale) {
        properties.setMpxDelimiter(LocaleData.getChar(locale, "FILE_DELIMITER"));
        properties.setMpxProgramName(LocaleData.getString(locale, "PROGRAM_NAME"));
        properties.setMpxCodePage((CodePage)((Object)LocaleData.getObject(locale, "CODE_PAGE")));
        properties.setDateSeparator(LocaleData.getChar(locale, "DATE_SEPARATOR"));
        properties.setTimeSeparator(LocaleData.getChar(locale, "TIME_SEPARATOR"));
        properties.setTimeFormat((ProjectTimeFormat)LocaleData.getObject(locale, "TIME_FORMAT"));
        properties.setDateOrder((DateOrder)LocaleData.getObject(locale, "DATE_ORDER"));
        properties.setAMText(LocaleData.getString(locale, "AM_TEXT"));
        properties.setPMText(LocaleData.getString(locale, "PM_TEXT"));
        properties.setDateFormat((ProjectDateFormat)LocaleData.getObject(locale, "DATE_FORMAT"));
        properties.setBarTextDateFormat((ProjectDateFormat)LocaleData.getObject(locale, "DATE_FORMAT"));
        properties.setCurrencySymbol(LocaleData.getString(locale, "CURRENCY_SYMBOL"));
        properties.setSymbolPosition((CurrencySymbolPosition)LocaleData.getObject(locale, "CURRENCY_SYMBOL_POSITION"));
        properties.setCurrencyDigits(LocaleData.getInteger(locale, "CURRENCY_DIGITS"));
        properties.setThousandsSeparator(LocaleData.getChar(locale, "CURRENCY_THOUSANDS_SEPARATOR"));
        properties.setDecimalSeparator(LocaleData.getChar(locale, "CURRENCY_DECIMAL_SEPARATOR"));
        properties.setDefaultStartTime(LocalTime.ofSecondOfDay((long)LocaleData.getInteger(locale, "DEFAULT_START_TIME").intValue() * 60L));
    }

    public static Locale[] getSupportedLocales() {
        return SUPPORTED_LOCALES;
    }
}

