/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.mpx;

import java.util.List;
import org.mpxj.Duration;
import org.mpxj.FieldType;
import org.mpxj.Rate;

final class ModelUtility {
    ModelUtility() {
    }

    public static boolean isFieldPopulated(FieldType field, Object value) {
        boolean populated;
        if (value == null) {
            return false;
        }
        switch (field.getDataType()) {
            case STRING: {
                populated = !(value instanceof String) || !((String)value).isEmpty();
                break;
            }
            case NUMERIC: 
            case CURRENCY: {
                populated = ((Number)value).doubleValue() != 0.0;
                break;
            }
            case DURATION: 
            case WORK: {
                populated = !(value instanceof Duration) || ((Duration)value).getDuration() != 0.0;
                break;
            }
            case RATE: {
                populated = ((Rate)value).getAmount() != 0.0;
                break;
            }
            case BOOLEAN: {
                populated = (Boolean)value;
                break;
            }
            case RELATION_LIST: {
                populated = !((List)value).isEmpty();
                break;
            }
            default: {
                populated = true;
            }
        }
        return populated;
    }
}

