/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.mpx;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import org.mpxj.FieldType;
import org.mpxj.MPXJException;
import org.mpxj.ProjectFile;
import org.mpxj.Resource;
import org.mpxj.mpp.UserDefinedFieldMap;
import org.mpxj.mpx.LocaleData;
import org.mpxj.mpx.MPXResourceField;
import org.mpxj.mpx.ModelUtility;
import org.mpxj.mpx.Record;

final class ResourceModel {
    private final ProjectFile m_parentFile;
    private final boolean[] m_flags = new boolean[52];
    private final int[] m_fields = new int[53];
    private int m_count;
    private String[] m_resourceNames;
    private final HashMap<String, Integer> m_resourceNumbers = new HashMap();
    private final UserDefinedFieldMap m_userDefinedFieldMap;

    ResourceModel(ProjectFile file, Locale locale, UserDefinedFieldMap userDefinedFieldMap) {
        this.m_parentFile = file;
        this.m_userDefinedFieldMap = userDefinedFieldMap;
        this.setLocale(locale);
    }

    void setLocale(Locale locale) {
        this.m_resourceNames = LocaleData.getStringArray(locale, "RESOURCE_NAMES");
        this.m_resourceNumbers.clear();
        for (int loop = 0; loop < this.m_resourceNames.length; ++loop) {
            String name = this.m_resourceNames[loop];
            if (name == null) continue;
            this.m_resourceNumbers.put(name, loop);
        }
    }

    public void update(Record record, boolean isText) throws MPXJException {
        int length = record.getLength();
        for (int i = 0; i < length; ++i) {
            if (isText) {
                this.add(this.getResourceCode(record.getString(i)));
                continue;
            }
            this.add(record.getInteger(i));
        }
    }

    public int[] getModel() {
        this.m_fields[this.m_count] = -1;
        return this.m_fields;
    }

    private void populateModel() {
        if (this.m_count != 0) {
            this.m_count = 0;
            Arrays.fill(this.m_flags, false);
        }
        for (Resource resource : this.m_parentFile.getResources()) {
            for (int loop = 0; loop < 52; ++loop) {
                Object value;
                FieldType field = MPXResourceField.getMpxjField(loop);
                field = this.m_userDefinedFieldMap == null ? field : this.m_userDefinedFieldMap.getSource(field);
                if (!ModelUtility.isFieldPopulated(field, value = resource.get(field)) || this.m_flags[loop]) continue;
                this.m_flags[loop] = true;
                this.m_fields[this.m_count] = loop;
                ++this.m_count;
            }
        }
        Arrays.sort(this.m_fields);
        System.arraycopy(this.m_fields, this.m_fields.length - this.m_count, this.m_fields, 0, this.m_count);
    }

    public String toString() {
        this.populateModel();
        char delimiter = this.m_parentFile.getProjectProperties().getMpxDelimiter();
        StringBuilder textual = new StringBuilder();
        StringBuilder numeric = new StringBuilder();
        textual.append(40);
        numeric.append(41);
        for (int loop = 0; loop < this.m_count; ++loop) {
            int number = this.m_fields[loop];
            textual.append(delimiter);
            numeric.append(delimiter);
            textual.append(this.getResourceField(number));
            numeric.append(number);
        }
        textual.append("\r\n");
        numeric.append("\r\n");
        textual.append((CharSequence)numeric);
        return textual.toString();
    }

    private void add(int field) {
        if (field < this.m_flags.length && !this.m_flags[field]) {
            this.m_flags[field] = true;
            this.m_fields[this.m_count] = field;
            ++this.m_count;
        }
    }

    private String getResourceField(int key) {
        String result = null;
        if (key > 0 && key < this.m_resourceNames.length) {
            result = this.m_resourceNames[key];
        }
        return result;
    }

    private int getResourceCode(String field) throws MPXJException {
        Integer result = this.m_resourceNumbers.get(field);
        if (result == null) {
            throw new MPXJException("Invalid resource field name " + field);
        }
        return result;
    }
}

