/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.mspdi;

import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import org.mpxj.Duration;
import org.mpxj.ProjectCalendar;
import org.mpxj.TimePeriodEntity;
import org.mpxj.TimeUnit;
import org.mpxj.TimephasedItem;
import org.mpxj.TimephasedWork;
import org.mpxj.common.AbstractTimephasedWorkNormaliser;
import org.mpxj.common.LocalDateHelper;
import org.mpxj.common.LocalDateTimeHelper;
import org.mpxj.common.LocalTimeHelper;
import org.mpxj.common.NumberHelper;

public final class MSPDITimephasedWorkNormaliser
extends AbstractTimephasedWorkNormaliser {
    public static final MSPDITimephasedWorkNormaliser INSTANCE = new MSPDITimephasedWorkNormaliser();

    private MSPDITimephasedWorkNormaliser() {
    }

    @Override
    public void normalise(ProjectCalendar calendar, TimePeriodEntity parent, List<TimephasedWork> list) {
        this.splitDays(calendar, list);
        this.mergeSameDay(calendar, list);
        this.mergeSameWork(calendar, parent, list);
        this.validateSameDay(calendar, list);
        this.convertToHours(list);
    }

    private void splitDays(ProjectCalendar calendar, List<TimephasedWork> list) {
        ArrayList<TimephasedWork> result = new ArrayList<TimephasedWork>();
        block0: for (TimephasedWork item : list) {
            Duration calendarWork = calendar.getWork(item.getStart(), item.getFinish(), TimeUnit.MINUTES);
            while (item != null) {
                LocalDateTime startDay = LocalDateTimeHelper.getDayStartDate(item.getStart());
                LocalDateTime finishDay = LocalDateTimeHelper.getDayStartDate(item.getFinish());
                if (item.getFinish().equals(finishDay)) {
                    finishDay = finishDay.minusDays(1L);
                }
                if (startDay.equals(finishDay)) {
                    result.add(item);
                    continue block0;
                }
                TimephasedWork[] split = this.splitFirstDay(calendar, item, calendarWork);
                if (split[0] != null) {
                    TimephasedWork firstDayItem = split[0];
                    result.add(firstDayItem);
                    Duration firstDayCalendarWork = calendar.getWork(firstDayItem.getStart(), firstDayItem.getFinish(), TimeUnit.MINUTES);
                    calendarWork = Duration.getInstance(calendarWork.getDuration() - firstDayCalendarWork.getDuration(), TimeUnit.MINUTES);
                }
                item = split[1];
            }
        }
        list.clear();
        list.addAll(result);
    }

    private TimephasedWork[] splitFirstDay(ProjectCalendar calendar, TimephasedWork item, Duration calendarWork) {
        TimephasedWork[] result = new TimephasedWork[2];
        LocalDateTime itemStart = item.getStart();
        LocalDateTime itemFinish = item.getFinish();
        Duration itemWork = (Duration)item.getTotalAmount();
        if (calendarWork.getDuration() != 0.0) {
            TimephasedWork split;
            double splitMinutes;
            LocalDateTime splitFinish;
            if (calendar.isWorkingDate(LocalDateHelper.getLocalDate(itemStart))) {
                splitFinish = LocalTimeHelper.setEndTime(itemStart, calendar.getFinishTime(LocalDateHelper.getLocalDate(itemStart)));
                splitMinutes = calendar.getWork(itemStart, splitFinish, TimeUnit.MINUTES).getDuration();
                splitMinutes *= itemWork.getDuration();
                splitMinutes /= calendarWork.getDuration();
                splitMinutes = NumberHelper.round(splitMinutes, 2.0);
                Duration splitWork = Duration.getInstance(splitMinutes, TimeUnit.MINUTES);
                split = new TimephasedWork();
                split.setStart(itemStart);
                split.setFinish(splitFinish);
                split.setTotalAmount(splitWork);
                result[0] = split;
            } else {
                splitFinish = itemStart;
                splitMinutes = 0.0;
            }
            LocalDateTime splitStart = calendar.getNextWorkStart(splitFinish);
            splitFinish = itemFinish;
            if (splitStart.isAfter(splitFinish)) {
                split = null;
            } else {
                splitMinutes = itemWork.getDuration() - splitMinutes;
                Duration splitWork = Duration.getInstance(splitMinutes, TimeUnit.MINUTES);
                split = new TimephasedWork();
                split.setStart(splitStart);
                split.setFinish(splitFinish);
                split.setTotalAmount(splitWork);
            }
            result[1] = split;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private void mergeSameDay(ProjectCalendar calendar, List<TimephasedWork> list) {
        ArrayList<void> result = new ArrayList<void>();
        TimephasedItem previousItem = null;
        for (TimephasedWork timephasedWork : list) {
            void var6_6;
            LocalDateTime itemStart;
            LocalDateTime itemStartDay;
            LocalDateTime previousItemStart;
            LocalDateTime previousItemStartDay;
            if (previousItem != null && (previousItemStartDay = LocalDateTimeHelper.getDayStartDate(previousItemStart = previousItem.getStart())).equals(itemStartDay = LocalDateTimeHelper.getDayStartDate(itemStart = timephasedWork.getStart()))) {
                Duration previousItemWork = (Duration)previousItem.getTotalAmount();
                Duration itemWork = (Duration)timephasedWork.getTotalAmount();
                if (previousItemWork.getDuration() != 0.0 && itemWork.getDuration() == 0.0) continue;
                result.remove(result.size() - 1);
                if (previousItemWork.getDuration() != 0.0 && itemWork.getDuration() != 0.0) {
                    double work = ((Duration)previousItem.getTotalAmount()).getDuration();
                    Duration totalWork = Duration.getInstance(work += ((Duration)timephasedWork.getTotalAmount()).getDuration(), TimeUnit.MINUTES);
                    TimephasedWork merged = new TimephasedWork();
                    merged.setStart(previousItem.getStart());
                    merged.setFinish(timephasedWork.getFinish());
                    merged.setTotalAmount(totalWork);
                    TimephasedWork timephasedWork2 = merged;
                } else if (itemWork.getDuration() == 0.0) {
                    TimephasedItem timephasedItem = previousItem;
                }
            }
            var6_6.setAmountPerDay(var6_6.getTotalAmount());
            result.add(var6_6);
            Duration calendarWork = calendar.getWork(var6_6.getStart(), var6_6.getFinish(), TimeUnit.MINUTES);
            Duration itemWork = (Duration)var6_6.getTotalAmount();
            if (calendarWork.getDuration() == 0.0 && itemWork.getDuration() == 0.0) {
                result.remove(result.size() - 1);
                continue;
            }
            previousItem = var6_6;
        }
        list.clear();
        list.addAll(result);
    }

    private void validateSameDay(ProjectCalendar calendar, List<TimephasedWork> list) {
        for (TimephasedWork item : list) {
            double totalWork = ((Duration)item.getTotalAmount()).getDuration();
            LocalDateTime itemStart = item.getStart();
            LocalTime calendarStartTime = calendar.getStartTime(LocalDateHelper.getLocalDate(itemStart));
            LocalTime itemStartTime = LocalTimeHelper.getLocalTime(itemStart);
            if (itemStartTime != null && calendarStartTime != null && (totalWork == 0.0 && !itemStartTime.equals(calendarStartTime) || itemStartTime.isBefore(calendarStartTime))) {
                itemStart = LocalTimeHelper.setTime(itemStart, calendarStartTime);
                item.setStart(itemStart);
            }
            LocalDateTime itemFinish = item.getFinish();
            LocalTime calendarFinishTime = calendar.getFinishTime(LocalDateHelper.getLocalDate(itemFinish));
            LocalTime itemFinishTime = LocalTimeHelper.getLocalTime(itemFinish);
            if (itemFinishTime == null || calendarFinishTime == null || (totalWork != 0.0 || itemFinishTime.equals(calendarFinishTime)) && (calendarFinishTime == LocalTime.MIDNIGHT || !itemFinishTime.isAfter(calendarFinishTime))) continue;
            itemFinish = LocalTimeHelper.setEndTime(itemFinish, calendarFinishTime);
            item.setFinish(itemFinish);
        }
    }
}

