/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.mspdi;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.DayOfWeek;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.mpxj.AccrueType;
import org.mpxj.AssignmentField;
import org.mpxj.Availability;
import org.mpxj.AvailabilityTable;
import org.mpxj.CostRateTable;
import org.mpxj.CostRateTableEntry;
import org.mpxj.CustomField;
import org.mpxj.CustomFieldContainer;
import org.mpxj.CustomFieldLookupTable;
import org.mpxj.CustomFieldValueDataType;
import org.mpxj.CustomFieldValueMask;
import org.mpxj.DataType;
import org.mpxj.DayType;
import org.mpxj.Duration;
import org.mpxj.EventManager;
import org.mpxj.FieldType;
import org.mpxj.FieldTypeClass;
import org.mpxj.LocalDateTimeRange;
import org.mpxj.LocalTimeRange;
import org.mpxj.ProjectCalendar;
import org.mpxj.ProjectCalendarDays;
import org.mpxj.ProjectCalendarException;
import org.mpxj.ProjectCalendarHours;
import org.mpxj.ProjectCalendarWeek;
import org.mpxj.ProjectConfig;
import org.mpxj.ProjectEntityWithUniqueID;
import org.mpxj.ProjectFile;
import org.mpxj.ProjectProperties;
import org.mpxj.Rate;
import org.mpxj.RecurringData;
import org.mpxj.Relation;
import org.mpxj.RelationType;
import org.mpxj.Resource;
import org.mpxj.ResourceAssignment;
import org.mpxj.ResourceField;
import org.mpxj.ResourceType;
import org.mpxj.ScheduleFrom;
import org.mpxj.Task;
import org.mpxj.TaskField;
import org.mpxj.TaskMode;
import org.mpxj.TimeUnit;
import org.mpxj.TimephasedCost;
import org.mpxj.TimephasedItem;
import org.mpxj.TimephasedWork;
import org.mpxj.UserDefinedField;
import org.mpxj.common.AssignmentFieldLists;
import org.mpxj.common.DayOfWeekHelper;
import org.mpxj.common.FieldLists;
import org.mpxj.common.FieldTypeHelper;
import org.mpxj.common.LocalDateHelper;
import org.mpxj.common.LocalDateTimeHelper;
import org.mpxj.common.MarshallerHelper;
import org.mpxj.common.MicrosoftProjectConstants;
import org.mpxj.common.MicrosoftProjectUniqueIDMapper;
import org.mpxj.common.NumberHelper;
import org.mpxj.common.ProjectCalendarHelper;
import org.mpxj.common.ResourceFieldLists;
import org.mpxj.common.StringHelper;
import org.mpxj.common.TaskFieldLists;
import org.mpxj.mpp.CustomFieldValueItem;
import org.mpxj.mpp.EnterpriseCustomFieldDataType;
import org.mpxj.mpp.UserDefinedFieldMap;
import org.mpxj.mspdi.DatatypeConverter;
import org.mpxj.mspdi.SaveVersion;
import org.mpxj.mspdi.schema.ObjectFactory;
import org.mpxj.mspdi.schema.Project;
import org.mpxj.mspdi.schema.TimephasedDataType;
import org.mpxj.writer.AbstractProjectWriter;

public final class MSPDIWriter
extends AbstractProjectWriter {
    private static JAXBContext CONTEXT;
    private static JAXBException CONTEXT_EXCEPTION;
    private static final int[] DAY_MASKS;
    private static final Set<String> MICROSOFT_PROJECT_FILES;
    private ObjectFactory m_factory;
    private ProjectFile m_projectFile;
    private EventManager m_eventManager;
    private Map<FieldType, Map<String, CustomFieldValueItem>> m_customFieldValueItems;
    private Map<Integer, Integer> m_resouceCalendarMap;
    private List<FieldType> m_extendedAttributes;
    private boolean m_sourceIsMicrosoftProject;
    private UserDefinedFieldMap m_userDefinedFieldMap;
    private boolean m_compatibleOutput = true;
    private boolean m_splitTimephasedAsDays = true;
    private boolean m_writeTimephasedData;
    private boolean m_generateMissingTimephasedData;
    private boolean m_sourceIsPrimavera;
    private SaveVersion m_saveVersion = SaveVersion.Project2016;
    private MicrosoftProjectUniqueIDMapper m_taskMapper;
    private MicrosoftProjectUniqueIDMapper m_resourceMapper;
    private MicrosoftProjectUniqueIDMapper m_calendarMapper;
    private MicrosoftProjectUniqueIDMapper m_assignmentMapper;
    private static final BigInteger BIGINTEGER_ZERO;
    private static final BigInteger NULL_CALENDAR_ID;
    private static final List<FieldType> MAPPING_TARGET_CUSTOM_FIELDS;
    private static final int[] TIMEPHASED_BASELINE_WORK_TYPES;
    private static final int[] TIMEPHASED_BASELINE_COST_TYPES;
    private static final Set<String> TIME_UNIT_NAMES;
    private static final BigInteger TIMEPHASED_DATA_PERIOD_YEARS;
    private static final BigInteger TIMEPHASED_DATA_PERIOD_MONTHS;
    private static final BigInteger TIMEPHASED_DATA_PERIOD_WEEKS;
    private static final BigInteger TIMEPHASED_DATA_PERIOD_DAYS;
    private static final BigInteger TIMEPHASED_DATA_PERIOD_HOURS;
    private static final BigInteger TIMEPHASED_DATA_PERIOD_MINUTES;

    public void setMicrosoftProjectCompatibleOutput(boolean flag) {
        this.m_compatibleOutput = flag;
    }

    public boolean getMicrosoftProjectCompatibleOutput() {
        return this.m_compatibleOutput;
    }

    public void setSplitTimephasedAsDays(boolean flag) {
        this.m_splitTimephasedAsDays = flag;
    }

    public boolean getSplitTimephasedAsDays() {
        return this.m_splitTimephasedAsDays;
    }

    public void setWriteTimephasedData(boolean value) {
        this.m_writeTimephasedData = value;
    }

    public boolean getWriteTimephasedData() {
        return this.m_writeTimephasedData;
    }

    public void setGenerateMissingTimephasedData(boolean value) {
        this.m_generateMissingTimephasedData = value;
    }

    public boolean getGenerateMissingTimephasedData() {
        return this.m_generateMissingTimephasedData;
    }

    public void setSaveVersion(SaveVersion version) {
        this.m_saveVersion = version;
    }

    public SaveVersion getSaveVersion() {
        return this.m_saveVersion;
    }

    @Override
    public void write(ProjectFile projectFile, OutputStream stream) throws IOException {
        try {
            if (CONTEXT == null) {
                throw CONTEXT_EXCEPTION;
            }
            this.m_projectFile = projectFile;
            this.m_eventManager = this.m_projectFile.getEventManager();
            DatatypeConverter.setContext(this.m_projectFile, false);
            Marshaller marshaller = MarshallerHelper.create(CONTEXT);
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            this.m_customFieldValueItems = new HashMap<FieldType, Map<String, CustomFieldValueItem>>();
            this.m_resouceCalendarMap = new HashMap<Integer, Integer>();
            this.m_extendedAttributes = this.getExtendedAttributesList();
            this.m_sourceIsMicrosoftProject = MICROSOFT_PROJECT_FILES.contains(this.m_projectFile.getProjectProperties().getFileType());
            this.m_sourceIsPrimavera = "Primavera".equals(this.m_projectFile.getProjectProperties().getFileApplication());
            this.m_userDefinedFieldMap = new UserDefinedFieldMap(projectFile, MAPPING_TARGET_CUSTOM_FIELDS);
            this.m_taskMapper = new MicrosoftProjectUniqueIDMapper(this.m_projectFile.getTasks());
            this.m_resourceMapper = new MicrosoftProjectUniqueIDMapper(this.m_projectFile.getResources());
            this.m_calendarMapper = new MicrosoftProjectUniqueIDMapper(this.m_projectFile.getCalendars());
            this.m_assignmentMapper = new MicrosoftProjectUniqueIDMapper(this.m_projectFile.getResourceAssignments());
            this.m_factory = new ObjectFactory();
            Project project = this.m_factory.createProject();
            this.writeProjectProperties(project);
            this.writeExtendedAttributeDefinitions(project);
            this.writeCalendars(project);
            this.writeResources(project);
            this.writeTasks(project);
            this.writeAssignments(project);
            this.writeOutlineCodes(project);
            marshaller.marshal(this.m_factory.createProject(project), stream);
        }
        catch (JAXBException ex) {
            throw new IOException(ex.toString());
        }
        finally {
            this.m_projectFile = null;
            this.m_factory = null;
            this.m_customFieldValueItems = null;
            this.m_resouceCalendarMap = null;
            this.m_taskMapper = null;
            this.m_resourceMapper = null;
            this.m_calendarMapper = null;
            this.m_assignmentMapper = null;
        }
    }

    private void writeProjectProperties(Project project) {
        String title;
        ProjectProperties properties = this.m_projectFile.getProjectProperties();
        String name = properties.getName();
        if (name == null || name.isEmpty()) {
            name = "project.xml";
        }
        if ((title = properties.getProjectTitle()) == null || title.isEmpty()) {
            if (!this.m_projectFile.getTasks().isEmpty()) {
                title = ((Task)this.m_projectFile.getTasks().get(0)).getName();
            }
            if (title == null || title.isEmpty()) {
                title = "project";
            }
        }
        project.setActualsInSync(properties.getActualsInSync());
        project.setAdminProject(properties.getAdminProject());
        project.setAuthor(properties.getAuthor());
        project.setAutoAddNewResourcesAndTasks(properties.getAutoAddNewResourcesAndTasks());
        project.setAutolink(properties.getAutolink());
        project.setBaselineCalendar(this.nullIfEmpty(properties.getBaselineCalendarName()));
        project.setBaselineForEarnedValue(NumberHelper.getBigInteger(properties.getBaselineForEarnedValue()));
        project.setCalendarUID(this.m_projectFile.getDefaultCalendar() == null ? BigInteger.ONE : NumberHelper.getBigInteger(this.m_calendarMapper.getUniqueID(this.m_projectFile.getDefaultCalendar())));
        project.setCategory(properties.getCategory());
        project.setCompany(properties.getCompany());
        project.setCreationDate(properties.getCreationDate());
        project.setCriticalSlackLimit(NumberHelper.getBigInteger(properties.getCriticalSlackLimit().convertUnits(TimeUnit.DAYS, properties).getDuration()));
        project.setCurrencyCode(properties.getCurrencyCode());
        project.setCurrencyDigits(BigInteger.valueOf(properties.getCurrencyDigits().intValue()));
        project.setCurrencySymbol(properties.getCurrencySymbol());
        project.setCurrencySymbolPosition(properties.getSymbolPosition());
        project.setCurrentDate(properties.getCurrentDate());
        project.setDaysPerMonth(NumberHelper.getBigInteger(properties.getDaysPerMonth()));
        project.setDefaultFinishTime(properties.getDefaultEndTime());
        project.setDefaultFixedCostAccrual(properties.getDefaultFixedCostAccrual());
        project.setDefaultOvertimeRate(DatatypeConverter.printRate(properties.getDefaultOvertimeRate()));
        project.setDefaultStandardRate(DatatypeConverter.printRate(properties.getDefaultStandardRate()));
        project.setDefaultStartTime(properties.getDefaultStartTime());
        project.setDefaultTaskEVMethod(DatatypeConverter.printEarnedValueMethod(properties.getDefaultTaskEarnedValueMethod()));
        project.setDefaultTaskType(properties.getDefaultTaskType());
        project.setDurationFormat(DatatypeConverter.printDurationTimeUnits(properties.getDefaultDurationUnits(), false));
        project.setEarnedValueMethod(DatatypeConverter.printEarnedValueMethod(properties.getEarnedValueMethod()));
        project.setEditableActualCosts(properties.getEditableActualCosts());
        project.setExtendedCreationDate(properties.getExtendedCreationDate());
        project.setFinishDate(properties.getFinishDate());
        project.setFiscalYearStart(properties.getFiscalYearStart());
        project.setFYStartDate(NumberHelper.getBigInteger(properties.getFiscalYearStartMonth()));
        project.setGUID(properties.getGUID());
        project.setHonorConstraints(properties.getHonorConstraints());
        project.setInsertedProjectsLikeSummary(properties.getInsertedProjectsLikeSummary());
        project.setLastSaved(properties.getLastSaved());
        project.setManager(properties.getManager());
        project.setMicrosoftProjectServerURL(properties.getMicrosoftProjectServerURL());
        project.setMinutesPerDay(NumberHelper.getBigInteger(properties.getMinutesPerDay()));
        project.setMinutesPerWeek(NumberHelper.getBigInteger(properties.getMinutesPerWeek()));
        project.setMoveCompletedEndsBack(properties.getMoveCompletedEndsBack());
        project.setMoveCompletedEndsForward(properties.getMoveCompletedEndsForward());
        project.setMoveRemainingStartsBack(properties.getMoveRemainingStartsBack());
        project.setMoveRemainingStartsForward(properties.getMoveRemainingStartsForward());
        project.setMultipleCriticalPaths(properties.getMultipleCriticalPaths());
        project.setName(StringHelper.stripControlCharacters(name));
        project.setNewTasksEffortDriven(properties.getNewTasksEffortDriven());
        project.setNewTasksEstimated(properties.getNewTasksEstimated());
        project.setNewTaskStartDate(properties.getNewTaskStartIsProjectStart() ? BigInteger.ZERO : BigInteger.ONE);
        project.setNewTasksAreManual(properties.getNewTasksAreManual());
        project.setProjectExternallyEdited(properties.getProjectExternallyEdited());
        project.setRemoveFileProperties(properties.getRemoveFileProperties());
        project.setRevision(NumberHelper.getBigInteger(properties.getRevision()));
        project.setSaveVersion(BigInteger.valueOf(this.m_saveVersion.getValue()));
        project.setScheduleFromStart(properties.getScheduleFrom() == ScheduleFrom.START);
        project.setSplitsInProgressTasks(properties.getSplitInProgressTasks());
        project.setSpreadActualCost(properties.getSpreadActualCost());
        project.setSpreadPercentComplete(properties.getSpreadPercentComplete());
        project.setStartDate(properties.getStartDate());
        project.setStatusDate(properties.getStatusDate());
        project.setSubject(properties.getSubject());
        project.setTaskUpdatesResource(properties.getUpdatingTaskStatusUpdatesResourceStatus());
        project.setTitle(title);
        project.setWeekStartDay(DatatypeConverter.printDay(properties.getWeekStartDay()));
        project.setWorkFormat(DatatypeConverter.printWorkUnits(properties.getDefaultWorkUnits()));
    }

    private void writeExtendedAttributeDefinitions(Project project) {
        Project.ExtendedAttributes attributes = this.m_factory.createProjectExtendedAttributes();
        project.setExtendedAttributes(attributes);
        List<Project.ExtendedAttributes.ExtendedAttribute> list = attributes.getExtendedAttribute();
        CustomFieldContainer customFieldContainer = this.m_projectFile.getCustomFields();
        for (FieldType fieldType : this.m_extendedAttributes) {
            CustomField field;
            boolean microsoftProjectUserDefinedField = false;
            BigInteger customFieldType = null;
            FieldType mappedFieldType = fieldType;
            if (fieldType instanceof UserDefinedField) {
                if (this.m_sourceIsMicrosoftProject) {
                    microsoftProjectUserDefinedField = true;
                    customFieldType = NumberHelper.getBigInteger(EnterpriseCustomFieldDataType.getIDFromDataType(fieldType.getDataType()));
                } else {
                    mappedFieldType = this.m_userDefinedFieldMap.generateMapping(fieldType);
                    if (mappedFieldType == null) continue;
                }
            }
            Project.ExtendedAttributes.ExtendedAttribute attribute = this.m_factory.createProjectExtendedAttributesExtendedAttribute();
            list.add(attribute);
            attribute.setFieldID(String.valueOf(FieldTypeHelper.getFieldID(mappedFieldType)));
            attribute.setFieldName(mappedFieldType.getName());
            if (microsoftProjectUserDefinedField) {
                attribute.setUserDef(Boolean.TRUE);
                attribute.setCFType(customFieldType);
            }
            if ((field = customFieldContainer.get(fieldType)) == null) continue;
            attribute.setAlias(field.getAlias());
            attribute.setLtuid(field.getLookupTable().getGUID());
        }
    }

    private void writeOutlineCodes(Project project) {
        Project.OutlineCodes outlineCodes = null;
        List allCustomFields = this.m_projectFile.getCustomFields().stream().filter(f -> !f.getLookupTable().isEmpty()).sorted().collect(Collectors.toList());
        for (CustomField field : allCustomFields) {
            if (outlineCodes == null) {
                outlineCodes = this.m_factory.createProjectOutlineCodes();
                project.setOutlineCodes(outlineCodes);
            }
            Project.OutlineCodes.OutlineCode outlineCode = this.m_factory.createProjectOutlineCodesOutlineCode();
            outlineCodes.getOutlineCode().add(outlineCode);
            this.writeOutlineCode(outlineCode, field);
        }
    }

    private void writeOutlineCode(Project.OutlineCodes.OutlineCode outlineCode, CustomField field) {
        CustomFieldLookupTable table = field.getLookupTable();
        outlineCode.setFieldID(String.valueOf(FieldTypeHelper.getFieldID(field.getFieldType())));
        outlineCode.setGuid(table.getGUID());
        outlineCode.setEnterprise(table.getEnterprise());
        outlineCode.setShowIndent(table.getShowIndent());
        outlineCode.setResourceSubstitutionEnabled(table.getResourceSubstitutionEnabled());
        outlineCode.setLeafOnly(table.getLeafOnly());
        outlineCode.setAllLevelsRequired(table.getAllLevelsRequired());
        outlineCode.setOnlyTableValuesAllowed(table.getOnlyTableValuesAllowed());
        outlineCode.setMasks(this.m_factory.createProjectOutlineCodesOutlineCodeMasks());
        if (field.getMasks().isEmpty()) {
            Object type = ((CustomFieldValueItem)table.get(0)).getType();
            if (type == null) {
                type = CustomFieldValueDataType.TEXT;
            }
            CustomFieldValueMask item = new CustomFieldValueMask(0, 1, ".", (CustomFieldValueDataType)type);
            this.writeMask(outlineCode, item);
        } else {
            for (CustomFieldValueMask item : field.getMasks()) {
                this.writeMask(outlineCode, item);
            }
        }
        Project.OutlineCodes.OutlineCode.Values values = this.m_factory.createProjectOutlineCodesOutlineCodeValues();
        outlineCode.setValues(values);
        for (CustomFieldValueItem item : table) {
            Project.OutlineCodes.OutlineCode.Values.Value value = this.m_factory.createProjectOutlineCodesOutlineCodeValuesValue();
            values.getValue().add(value);
            this.writeOutlineCodeValue(value, item);
        }
    }

    private void writeOutlineCodeValue(Project.OutlineCodes.OutlineCode.Values.Value value, CustomFieldValueItem item) {
        CustomFieldValueDataType type = item.getType();
        if (type == null) {
            type = CustomFieldValueDataType.TEXT;
        }
        value.setDescription(item.getDescription());
        value.setFieldGUID(item.getGUID());
        value.setIsCollapsed(item.getCollapsed());
        value.setParentValueID(NumberHelper.getBigInteger(item.getParentUniqueID()));
        value.setType(BigInteger.valueOf(type.getValue()));
        value.setValueID(NumberHelper.getBigInteger(item.getUniqueID()));
        value.setValue(DatatypeConverter.printOutlineCodeValue(item.getValue(), type.getDataType()));
    }

    private void writeMask(Project.OutlineCodes.OutlineCode outlineCode, CustomFieldValueMask item) {
        Project.OutlineCodes.OutlineCode.Masks.Mask mask = this.m_factory.createProjectOutlineCodesOutlineCodeMasksMask();
        outlineCode.getMasks().getMask().add(mask);
        mask.setLength(BigInteger.valueOf(item.getLength()));
        mask.setLevel(BigInteger.valueOf(item.getLevel()));
        mask.setSeparator(item.getSeparator());
        mask.setType(BigInteger.valueOf(item.getType().getMaskValue()));
    }

    private void writeCalendars(Project project) {
        Project.Calendars calendars = this.m_factory.createProjectCalendars();
        project.setCalendars(calendars);
        List<Project.Calendars.Calendar> calendar = calendars.getCalendar();
        Map<Integer, List<Resource>> resourceCalendarMap = this.m_projectFile.getResources().stream().filter(r -> r.getCalendarUniqueID() != null).collect(Collectors.groupingBy(Resource::getCalendarUniqueID));
        Set derivedCalendarSet = this.m_projectFile.getResources().stream().map(Resource::getCalendar).filter(c -> this.isValidDerivedCalendar(resourceCalendarMap, (ProjectCalendar)c)).collect(Collectors.toSet());
        List<ProjectCalendar> baseCalendars = this.m_projectFile.getCalendars().stream().filter(c -> !derivedCalendarSet.contains(c)).collect(Collectors.toList());
        baseCalendars = baseCalendars.stream().map(ProjectCalendarHelper::createTemporaryFlattenedCalendar).collect(Collectors.toList());
        baseCalendars.forEach(c -> c.getResources().forEach(r -> derivedCalendarSet.add(this.createTemporaryDerivedCalendar((ProjectCalendar)c, (Resource)r))));
        baseCalendars.sort(Comparator.comparing(c -> this.m_calendarMapper.getUniqueID((ProjectEntityWithUniqueID)c)));
        ArrayList derivedCalendars = new ArrayList(derivedCalendarSet);
        derivedCalendars.sort(Comparator.comparing(c -> this.m_calendarMapper.getUniqueID((ProjectEntityWithUniqueID)c)));
        String baselineCalendarName = this.m_projectFile.getProjectProperties().getBaselineCalendarName() == null ? "" : this.m_projectFile.getProjectProperties().getBaselineCalendarName();
        baseCalendars.stream().map(c -> this.writeCalendar((ProjectCalendar)c, true, baselineCalendarName.equals(c.getName()))).forEach(calendar::add);
        derivedCalendars.stream().map(c -> this.writeCalendar((ProjectCalendar)c, false, baselineCalendarName.equals(c.getName()))).forEach(calendar::add);
    }

    private ProjectCalendar createTemporaryDerivedCalendar(ProjectCalendar baseCalendar, Resource resource) {
        ProjectCalendar derivedCalendar = ProjectCalendarHelper.createTemporaryDerivedCalendar(baseCalendar, resource);
        this.m_resouceCalendarMap.put(this.m_resourceMapper.getUniqueID(resource), this.m_calendarMapper.getUniqueID(derivedCalendar));
        return derivedCalendar;
    }

    private boolean isValidDerivedCalendar(Map<Integer, List<Resource>> resourceCalendarMap, ProjectCalendar calendar) {
        return calendar != null && calendar.isDerived() && calendar.getDerivedCalendars().isEmpty() && resourceCalendarMap.computeIfAbsent(this.m_calendarMapper.getUniqueID(calendar), k -> Collections.emptyList()).size() == 1;
    }

    private Project.Calendars.Calendar writeCalendar(ProjectCalendar mpxjCalendar, boolean isBaseCalendar, boolean isBaselineCalendar) {
        Project.Calendars.Calendar calendar = this.m_factory.createProjectCalendarsCalendar();
        calendar.setUID(NumberHelper.getBigInteger(this.m_calendarMapper.getUniqueID(mpxjCalendar)));
        calendar.setGUID(mpxjCalendar.getGUID());
        calendar.setIsBaseCalendar(isBaseCalendar);
        calendar.setIsBaselineCalendar(isBaselineCalendar);
        ProjectCalendar base = mpxjCalendar.getParent();
        calendar.setBaseCalendarUID(base == null ? NULL_CALENDAR_ID : NumberHelper.getBigInteger(this.m_calendarMapper.getUniqueID(base)));
        calendar.setName(this.normalizeCalendarName(mpxjCalendar));
        Project.Calendars.Calendar.WeekDays days = this.m_factory.createProjectCalendarsCalendarWeekDays();
        List<Project.Calendars.Calendar.WeekDays.WeekDay> dayList = days.getWeekDay();
        for (DayOfWeek mpxjDay : DayOfWeekHelper.ORDERED_DAYS) {
            this.writeDay(mpxjCalendar, mpxjDay, dayList);
        }
        this.writeExceptions(mpxjCalendar, calendar, dayList);
        if (!dayList.isEmpty()) {
            calendar.setWeekDays(days);
        }
        this.writeWorkWeeks(calendar, mpxjCalendar);
        this.m_eventManager.fireCalendarWrittenEvent(mpxjCalendar);
        return calendar;
    }

    private String normalizeCalendarName(ProjectCalendarDays calendar) {
        String name = calendar.getName();
        if (name == null || name.isEmpty()) {
            return name;
        }
        if ((name = StringHelper.stripControlCharacters(name)).length() > 51) {
            name = name.substring(0, 51);
        }
        return name;
    }

    private void writeDay(ProjectCalendar mpxjCalendar, DayOfWeek mpxjDay, List<Project.Calendars.Calendar.WeekDays.WeekDay> dayList) {
        DayType workingFlag = mpxjCalendar.getCalendarDayType(mpxjDay);
        if (workingFlag != DayType.DEFAULT) {
            Project.Calendars.Calendar.WeekDays.WeekDay day = this.m_factory.createProjectCalendarsCalendarWeekDaysWeekDay();
            dayList.add(day);
            day.setDayType(BigInteger.valueOf(DayOfWeekHelper.getValue(mpxjDay)));
            day.setDayWorking(workingFlag == DayType.WORKING);
            if (workingFlag == DayType.WORKING) {
                Project.Calendars.Calendar.WeekDays.WeekDay.WorkingTimes times = this.m_factory.createProjectCalendarsCalendarWeekDaysWeekDayWorkingTimes();
                day.setWorkingTimes(times);
                List<Project.Calendars.Calendar.WeekDays.WeekDay.WorkingTimes.WorkingTime> timesList = times.getWorkingTime();
                ProjectCalendarHours bch = mpxjCalendar.getCalendarHours(mpxjDay);
                if (bch != null) {
                    for (LocalTimeRange range : bch) {
                        if (range == null) continue;
                        Project.Calendars.Calendar.WeekDays.WeekDay.WorkingTimes.WorkingTime time = this.m_factory.createProjectCalendarsCalendarWeekDaysWeekDayWorkingTimesWorkingTime();
                        timesList.add(time);
                        time.setFromTime(range.getStart());
                        time.setToTime(range.getEnd());
                    }
                }
            }
        }
    }

    private void writeExceptions(ProjectCalendar mpxjCalendar, Project.Calendars.Calendar calendar, List<Project.Calendars.Calendar.WeekDays.WeekDay> dayList) {
        this.writeExceptions9(mpxjCalendar, dayList);
        if (this.m_saveVersion.getValue() > SaveVersion.Project2003.getValue()) {
            this.writeExceptions12(mpxjCalendar, calendar);
        }
    }

    private void writeExceptions9(ProjectCalendar mpxjCalendar, List<Project.Calendars.Calendar.WeekDays.WeekDay> dayList) {
        List<ProjectCalendarException> exceptions = mpxjCalendar.getExpandedCalendarExceptionsWithWorkWeeks();
        for (ProjectCalendarException exception : exceptions) {
            boolean working = exception.getWorking();
            Project.Calendars.Calendar.WeekDays.WeekDay day = this.m_factory.createProjectCalendarsCalendarWeekDaysWeekDay();
            dayList.add(day);
            day.setDayType(BIGINTEGER_ZERO);
            day.setDayWorking(working);
            Project.Calendars.Calendar.WeekDays.WeekDay.TimePeriod period = this.m_factory.createProjectCalendarsCalendarWeekDaysWeekDayTimePeriod();
            day.setTimePeriod(period);
            period.setFromDate(exception.getFromDate().atStartOfDay());
            period.setToDate(LocalDateHelper.getDayEndDate(exception.getToDate()));
            if (!working) continue;
            Project.Calendars.Calendar.WeekDays.WeekDay.WorkingTimes times = this.m_factory.createProjectCalendarsCalendarWeekDaysWeekDayWorkingTimes();
            day.setWorkingTimes(times);
            List<Project.Calendars.Calendar.WeekDays.WeekDay.WorkingTimes.WorkingTime> timesList = times.getWorkingTime();
            for (LocalTimeRange range : exception) {
                Project.Calendars.Calendar.WeekDays.WeekDay.WorkingTimes.WorkingTime time = this.m_factory.createProjectCalendarsCalendarWeekDaysWeekDayWorkingTimesWorkingTime();
                timesList.add(time);
                time.setFromTime(range.getStart());
                time.setToTime(range.getEnd());
            }
        }
    }

    private void writeExceptions12(ProjectCalendar mpxjCalendar, Project.Calendars.Calendar calendar) {
        ArrayList<ProjectCalendarException> exceptions = new ArrayList<ProjectCalendarException>(mpxjCalendar.getCalendarExceptions());
        if (exceptions.isEmpty()) {
            return;
        }
        Collections.sort(exceptions);
        Project.Calendars.Calendar.Exceptions ce = this.m_factory.createProjectCalendarsCalendarExceptions();
        calendar.setExceptions(ce);
        List<Project.Calendars.Calendar.Exceptions.Exception> el = ce.getException();
        for (ProjectCalendarException exception : exceptions) {
            Project.Calendars.Calendar.Exceptions.Exception ex = this.m_factory.createProjectCalendarsCalendarExceptionsException();
            el.add(ex);
            ex.setName(StringHelper.stripControlCharacters(exception.getName()));
            boolean working = exception.getWorking();
            ex.setDayWorking(working);
            if (exception.getRecurring() == null) {
                ex.setEnteredByOccurrences(Boolean.FALSE);
                ex.setOccurrences(BigInteger.ONE);
                ex.setType(BigInteger.ONE);
            } else {
                this.populateRecurringException(exception, ex);
            }
            Project.Calendars.Calendar.Exceptions.Exception.TimePeriod period = this.m_factory.createProjectCalendarsCalendarExceptionsExceptionTimePeriod();
            ex.setTimePeriod(period);
            period.setFromDate(exception.getFromDate().atStartOfDay());
            period.setToDate(LocalDateHelper.getDayEndDate(exception.getToDate()));
            if (!working) continue;
            Project.Calendars.Calendar.Exceptions.Exception.WorkingTimes times = this.m_factory.createProjectCalendarsCalendarExceptionsExceptionWorkingTimes();
            ex.setWorkingTimes(times);
            List<Project.Calendars.Calendar.Exceptions.Exception.WorkingTimes.WorkingTime> timesList = times.getWorkingTime();
            for (LocalTimeRange range : exception) {
                Project.Calendars.Calendar.Exceptions.Exception.WorkingTimes.WorkingTime time = this.m_factory.createProjectCalendarsCalendarExceptionsExceptionWorkingTimesWorkingTime();
                timesList.add(time);
                time.setFromTime(range.getStart());
                time.setToTime(range.getEnd());
            }
        }
    }

    private void populateRecurringException(ProjectCalendarException mpxjException, Project.Calendars.Calendar.Exceptions.Exception xmlException) {
        RecurringData data = mpxjException.getRecurring();
        xmlException.setEnteredByOccurrences(Boolean.TRUE);
        xmlException.setOccurrences(NumberHelper.getBigInteger(data.getOccurrences()));
        switch (data.getRecurrenceType()) {
            case DAILY: {
                xmlException.setType(BigInteger.valueOf(7L));
                xmlException.setPeriod(NumberHelper.getBigInteger(data.getFrequency()));
                break;
            }
            case WEEKLY: {
                xmlException.setType(BigInteger.valueOf(6L));
                xmlException.setPeriod(NumberHelper.getBigInteger(data.getFrequency()));
                xmlException.setDaysOfWeek(this.getDaysOfTheWeek(data));
                break;
            }
            case MONTHLY: {
                xmlException.setPeriod(NumberHelper.getBigInteger(data.getFrequency()));
                if (data.getRelative()) {
                    xmlException.setType(BigInteger.valueOf(5L));
                    xmlException.setMonthItem(BigInteger.valueOf(DayOfWeekHelper.getValue(data.getDayOfWeek()) + 2));
                    xmlException.setMonthPosition(BigInteger.valueOf(NumberHelper.getInt(data.getDayNumber()) - 1));
                    break;
                }
                xmlException.setType(BigInteger.valueOf(4L));
                xmlException.setMonthDay(NumberHelper.getBigInteger(data.getDayNumber()));
                break;
            }
            case YEARLY: {
                xmlException.setMonth(BigInteger.valueOf(NumberHelper.getInt(data.getMonthNumber()) - 1));
                if (data.getRelative()) {
                    xmlException.setType(BigInteger.valueOf(3L));
                    xmlException.setMonthItem(BigInteger.valueOf(DayOfWeekHelper.getValue(data.getDayOfWeek()) + 2));
                    xmlException.setMonthPosition(BigInteger.valueOf(NumberHelper.getInt(data.getDayNumber()) - 1));
                    break;
                }
                xmlException.setType(BigInteger.valueOf(2L));
                xmlException.setMonthDay(NumberHelper.getBigInteger(data.getDayNumber()));
            }
        }
    }

    private BigInteger getDaysOfTheWeek(RecurringData data) {
        int value = 0;
        for (DayOfWeek day : DayOfWeek.values()) {
            if (!data.getWeeklyDay(day)) continue;
            value |= DAY_MASKS[DayOfWeekHelper.getValue(day)];
        }
        return BigInteger.valueOf(value);
    }

    private void writeWorkWeeks(Project.Calendars.Calendar xmlCalendar, ProjectCalendar mpxjCalendar) {
        List<ProjectCalendarWeek> weeks = mpxjCalendar.getWorkWeeks();
        if (!weeks.isEmpty()) {
            Project.Calendars.Calendar.WorkWeeks xmlWorkWeeks = this.m_factory.createProjectCalendarsCalendarWorkWeeks();
            xmlCalendar.setWorkWeeks(xmlWorkWeeks);
            List<Project.Calendars.Calendar.WorkWeeks.WorkWeek> xmlWorkWeekList = xmlWorkWeeks.getWorkWeek();
            for (ProjectCalendarWeek week : weeks) {
                Project.Calendars.Calendar.WorkWeeks.WorkWeek xmlWeek = this.m_factory.createProjectCalendarsCalendarWorkWeeksWorkWeek();
                xmlWorkWeekList.add(xmlWeek);
                xmlWeek.setName(this.normalizeCalendarName(week));
                Project.Calendars.Calendar.WorkWeeks.WorkWeek.TimePeriod xmlTimePeriod = this.m_factory.createProjectCalendarsCalendarWorkWeeksWorkWeekTimePeriod();
                xmlWeek.setTimePeriod(xmlTimePeriod);
                xmlTimePeriod.setFromDate(week.getDateRange().getStart().atStartOfDay());
                xmlTimePeriod.setToDate(LocalDateHelper.getDayEndDate(week.getDateRange().getEnd()));
                Project.Calendars.Calendar.WorkWeeks.WorkWeek.WeekDays xmlWeekDays = this.m_factory.createProjectCalendarsCalendarWorkWeeksWorkWeekWeekDays();
                xmlWeek.setWeekDays(xmlWeekDays);
                List<Project.Calendars.Calendar.WorkWeeks.WorkWeek.WeekDays.WeekDay> dayList = xmlWeekDays.getWeekDay();
                for (int loop = 1; loop < 8; ++loop) {
                    DayType workingFlag = week.getCalendarDayType(DayOfWeekHelper.getInstance(loop));
                    if (workingFlag == DayType.DEFAULT) continue;
                    Project.Calendars.Calendar.WorkWeeks.WorkWeek.WeekDays.WeekDay day = this.m_factory.createProjectCalendarsCalendarWorkWeeksWorkWeekWeekDaysWeekDay();
                    dayList.add(day);
                    day.setDayType(BigInteger.valueOf(loop));
                    day.setDayWorking(workingFlag == DayType.WORKING);
                    if (workingFlag != DayType.WORKING) continue;
                    Project.Calendars.Calendar.WorkWeeks.WorkWeek.WeekDays.WeekDay.WorkingTimes times = this.m_factory.createProjectCalendarsCalendarWorkWeeksWorkWeekWeekDaysWeekDayWorkingTimes();
                    day.setWorkingTimes(times);
                    List<Project.Calendars.Calendar.WorkWeeks.WorkWeek.WeekDays.WeekDay.WorkingTimes.WorkingTime> timesList = times.getWorkingTime();
                    ProjectCalendarHours bch = week.getCalendarHours(DayOfWeekHelper.getInstance(loop));
                    if (bch == null) continue;
                    for (LocalTimeRange range : bch) {
                        if (range == null) continue;
                        Project.Calendars.Calendar.WorkWeeks.WorkWeek.WeekDays.WeekDay.WorkingTimes.WorkingTime time = this.m_factory.createProjectCalendarsCalendarWorkWeeksWorkWeekWeekDaysWeekDayWorkingTimesWorkingTime();
                        timesList.add(time);
                        time.setFromTime(range.getStart());
                        time.setToTime(range.getEnd());
                    }
                }
            }
        }
    }

    private void writeResources(Project project) {
        Project.Resources resources = this.m_factory.createProjectResources();
        project.setResources(resources);
        List<Project.Resources.Resource> list = resources.getResource();
        for (Resource resource : this.m_projectFile.getResources()) {
            list.add(this.writeResource(resource));
        }
    }

    private Project.Resources.Resource writeResource(Resource mpx) {
        Project.Resources.Resource xml = this.m_factory.createProjectResourcesResource();
        ProjectCalendar cal = mpx.getCalendar();
        if (cal != null) {
            Integer calendarUniqueID = this.m_resouceCalendarMap.get(this.m_resourceMapper.getUniqueID(mpx));
            xml.setCalendarUID(NumberHelper.getBigInteger(calendarUniqueID == null ? this.m_calendarMapper.getUniqueID(cal) : calendarUniqueID));
        }
        xml.setAccrueAt(mpx.getAccrueAt());
        xml.setActiveDirectoryGUID(mpx.getActiveDirectoryGUID());
        xml.setActualCost(DatatypeConverter.printCurrency(mpx.getActualCost()));
        xml.setActualOvertimeCost(DatatypeConverter.printCurrency(mpx.getActualOvertimeCost()));
        xml.setActualOvertimeWork(DatatypeConverter.printDuration(this, mpx.getActualOvertimeWork()));
        xml.setActualOvertimeWorkProtected(DatatypeConverter.printDuration(this, mpx.getActualOvertimeWorkProtected()));
        xml.setActualWork(DatatypeConverter.printDuration(this, mpx.getActualWork()));
        xml.setActualWorkProtected(DatatypeConverter.printDuration(this, mpx.getActualWorkProtected()));
        xml.setACWP(DatatypeConverter.printCurrency(mpx.getACWP()));
        xml.setAvailableFrom(mpx.getAvailableFrom());
        xml.setAvailableTo(mpx.getAvailableTo());
        xml.setBCWS(DatatypeConverter.printCurrency(mpx.getBCWS()));
        xml.setBCWP(DatatypeConverter.printCurrency(mpx.getBCWP()));
        xml.setBookingType(mpx.getBookingType());
        xml.setIsBudget(mpx.getBudget());
        xml.setCanLevel(mpx.getCanLevel());
        xml.setCode(mpx.getCode());
        xml.setCost(DatatypeConverter.printCurrency(mpx.getCost()));
        xml.setCostCenter(mpx.getCostCenter());
        xml.setCostPerUse(DatatypeConverter.printCurrency(mpx.getCostPerUse()));
        xml.setCostVariance(DatatypeConverter.printCurrency(mpx.getCostVariance()));
        xml.setCreationDate(mpx.getCreationDate());
        xml.setCV(DatatypeConverter.printCurrency(mpx.getCV()));
        xml.setEmailAddress(mpx.getEmailAddress());
        xml.setFinish(mpx.getFinish());
        xml.setGroup(mpx.getGroup());
        xml.setGUID(mpx.getGUID());
        xml.setHyperlink(mpx.getHyperlink());
        xml.setHyperlinkAddress(mpx.getHyperlinkAddress());
        xml.setHyperlinkSubAddress(mpx.getHyperlinkSubAddress());
        xml.setID(NumberHelper.getBigInteger(mpx.getID()));
        xml.setInitials(mpx.getInitials());
        xml.setIsEnterprise(mpx.getEnterprise());
        xml.setIsGeneric(mpx.getGeneric());
        xml.setIsInactive(!mpx.getActive());
        xml.setIsNull(mpx.getNull());
        xml.setMaterialLabel(this.formatMaterialLabel(mpx));
        xml.setMaxUnits(DatatypeConverter.printUnits(mpx.getMaxUnits()));
        xml.setName(this.normalizeResourceName(mpx));
        xml.setNotes(this.nullIfEmpty(mpx.getNotes()));
        xml.setNTAccount(mpx.getNtAccount());
        xml.setOverAllocated(mpx.getOverAllocated());
        xml.setOvertimeCost(DatatypeConverter.printCurrency(mpx.getOvertimeCost()));
        xml.setOvertimeRate(DatatypeConverter.printRate(mpx.getOvertimeRate()));
        xml.setOvertimeRateFormat(DatatypeConverter.printOvertimeRateFormat(mpx, mpx.getOvertimeRate()));
        xml.setOvertimeWork(DatatypeConverter.printDuration(this, mpx.getOvertimeWork()));
        xml.setPeakUnits(DatatypeConverter.printUnits(mpx.getPeakUnits()));
        xml.setPercentWorkComplete(mpx.getPercentWorkComplete());
        xml.setPhonetics(mpx.getPhonetics());
        xml.setRegularWork(DatatypeConverter.printDuration(this, mpx.getRegularWork()));
        xml.setRemainingCost(DatatypeConverter.printCurrency(mpx.getRemainingCost()));
        xml.setRemainingOvertimeCost(DatatypeConverter.printCurrency(mpx.getRemainingOvertimeCost()));
        xml.setRemainingOvertimeWork(DatatypeConverter.printDuration(this, mpx.getRemainingOvertimeWork()));
        xml.setRemainingWork(DatatypeConverter.printDuration(this, mpx.getRemainingWork()));
        xml.setStandardRate(DatatypeConverter.printRate(mpx.getStandardRate()));
        xml.setStandardRateFormat(DatatypeConverter.printStandardRateFormat(mpx, mpx.getStandardRate()));
        xml.setStart(mpx.getStart());
        xml.setSV(DatatypeConverter.printCurrency(mpx.getSV()));
        xml.setUID(this.m_resourceMapper.getUniqueID(mpx));
        xml.setWork(DatatypeConverter.printDuration(this, mpx.getWork()));
        xml.setWorkGroup(mpx.getWorkGroup());
        xml.setWorkVariance(DatatypeConverter.printDurationInDecimalThousandthsOfMinutes(mpx.getWorkVariance()));
        if (mpx.getType() == ResourceType.COST) {
            xml.setType(ResourceType.MATERIAL);
            xml.setIsCostResource(Boolean.TRUE);
        } else {
            xml.setType(mpx.getType());
        }
        this.writeResourceExtendedAttributes(xml, mpx);
        this.writeResourceOutlineCodes(xml, mpx);
        this.writeResourceBaselines(xml, mpx);
        this.writeCostRateTables(xml, mpx);
        this.writeAvailability(xml, mpx);
        return xml;
    }

    private String normalizeResourceName(Resource resource) {
        String name = resource.getName();
        if (name == null || name.isEmpty()) {
            return name;
        }
        if ((name = StringHelper.stripControlCharacters(name)).contains(",")) {
            name = name.replace(',', ';');
        }
        if (name.contains("[")) {
            name = name.replace('[', ' ');
        }
        if (name.contains("]")) {
            name = name.replace(']', ' ');
        }
        return name;
    }

    private void writeResourceBaselines(Project.Resources.Resource xmlResource, Resource mpxjResource) {
        Duration work;
        Project.Resources.Resource.Baseline baseline = this.m_factory.createProjectResourcesResourceBaseline();
        boolean populated = false;
        Number cost = mpxjResource.getBaselineCost();
        if (cost != null && cost.intValue() != 0) {
            populated = true;
            baseline.setCost(DatatypeConverter.printCurrency(cost));
        }
        if ((work = mpxjResource.getBaselineWork()) != null && work.getDuration() != 0.0) {
            populated = true;
            baseline.setWork(DatatypeConverter.printDuration(this, work));
        }
        if (populated) {
            xmlResource.getBaseline().add(baseline);
            baseline.setNumber(BigInteger.ZERO);
        }
        for (int loop = 1; loop <= 10; ++loop) {
            baseline = this.m_factory.createProjectResourcesResourceBaseline();
            populated = false;
            cost = mpxjResource.getBaselineCost(loop);
            if (cost != null && cost.intValue() != 0) {
                populated = true;
                baseline.setCost(DatatypeConverter.printCurrency(cost));
            }
            if ((work = mpxjResource.getBaselineWork(loop)) != null && work.getDuration() != 0.0) {
                populated = true;
                baseline.setWork(DatatypeConverter.printDuration(this, work));
            }
            if (!populated) continue;
            xmlResource.getBaseline().add(baseline);
            baseline.setNumber(BigInteger.valueOf(loop));
        }
    }

    private void writeResourceExtendedAttributes(Project.Resources.Resource xml, Resource mpx) {
        List<Project.Resources.Resource.ExtendedAttribute> extendedAttributes = xml.getExtendedAttribute();
        HashSet<ResourceField> outlineCodes = new HashSet<ResourceField>(Arrays.asList(ResourceFieldLists.CUSTOM_OUTLINE_CODE));
        this.m_extendedAttributes.stream().filter(f -> f.getFieldTypeClass() == FieldTypeClass.RESOURCE && !outlineCodes.contains(f)).forEach(f -> this.writeResourceExtendedAttribute(extendedAttributes, mpx, (FieldType)f));
    }

    private void writeResourceExtendedAttribute(List<Project.Resources.Resource.ExtendedAttribute> extendedAttributes, Resource mpx, FieldType mpxFieldID) {
        FieldType mappedFieldType;
        Object value = mpx.getCachedValue(mpxFieldID);
        if (FieldTypeHelper.valueIsNotDefault(mpxFieldID, value) && (mappedFieldType = this.m_userDefinedFieldMap.getTarget(mpxFieldID)) instanceof ResourceField) {
            Project.Resources.Resource.ExtendedAttribute attrib = this.m_factory.createProjectResourcesResourceExtendedAttribute();
            extendedAttributes.add(attrib);
            attrib.setFieldID(Integer.toString(FieldTypeHelper.getFieldID(mappedFieldType)));
            attrib.setValue(DatatypeConverter.printCustomField(this, value, mappedFieldType.getDataType()));
            attrib.setDurationFormat(this.printCustomFieldDurationFormat(value));
            this.setValueGUID(attrib, mappedFieldType);
        }
    }

    private void setValueGUID(Project.Resources.Resource.ExtendedAttribute attrib, FieldType fieldType) {
        CustomFieldValueItem valueItem = this.getValueItem(fieldType, attrib.getValue());
        if (valueItem != null) {
            attrib.setValueGUID(valueItem.getGUID());
        }
    }

    private void writeResourceOutlineCodes(Project.Resources.Resource xml, Resource mpx) {
        List<Project.Resources.Resource.OutlineCode> outlineCodes = xml.getOutlineCode();
        for (ResourceField mpxFieldID : ResourceFieldLists.CUSTOM_OUTLINE_CODE) {
            Object value = mpx.getCachedValue(mpxFieldID);
            if (!FieldTypeHelper.valueIsNotDefault(mpxFieldID, value)) continue;
            Project.Resources.Resource.OutlineCode attrib = this.m_factory.createProjectResourcesResourceOutlineCode();
            outlineCodes.add(attrib);
            attrib.setFieldID(Integer.toString(FieldTypeHelper.getFieldID(mpxFieldID)));
            this.setValueID(attrib, (FieldType)mpxFieldID, DatatypeConverter.printCustomField(this, value, mpxFieldID.getDataType()));
        }
    }

    private void setValueID(Project.Resources.Resource.OutlineCode attrib, FieldType fieldType, String formattedValue) {
        CustomFieldValueItem valueItem = this.getValueItem(fieldType, formattedValue);
        if (valueItem != null) {
            attrib.setValueID(NumberHelper.getBigInteger(valueItem.getUniqueID()));
        }
    }

    private void writeCostRateTables(Project.Resources.Resource xml, Resource mpx) {
        List<Project.Resources.Resource.Rates.Rate> ratesList = null;
        for (int tableIndex = 0; tableIndex < 5; ++tableIndex) {
            CostRateTable table = mpx.getCostRateTable(tableIndex);
            if (!this.costRateTableWriteRequired(tableIndex, mpx, table)) continue;
            for (CostRateTableEntry entry : table) {
                if (!this.costRateTableEntryWriteRequired(entry)) continue;
                if (ratesList == null) {
                    Project.Resources.Resource.Rates rates = this.m_factory.createProjectResourcesResourceRates();
                    xml.setRates(rates);
                    ratesList = rates.getRate();
                }
                Project.Resources.Resource.Rates.Rate rate = this.m_factory.createProjectResourcesResourceRatesRate();
                ratesList.add(rate);
                rate.setCostPerUse(DatatypeConverter.printCurrencyMandatory(entry.getCostPerUse()));
                rate.setOvertimeRate(DatatypeConverter.printRateMandatory(entry.getOvertimeRate()));
                rate.setOvertimeRateFormat(DatatypeConverter.printTimeUnit(entry.getOvertimeRate()));
                rate.setRatesFrom(entry.getStartDate());
                rate.setRatesTo(entry.getEndDate());
                rate.setRateTable(BigInteger.valueOf(tableIndex));
                rate.setStandardRate(DatatypeConverter.printRateMandatory(entry.getStandardRate()));
                rate.setStandardRateFormat(DatatypeConverter.printTimeUnit(entry.getStandardRate()));
            }
        }
    }

    private boolean costRateTableEntryWriteRequired(CostRateTableEntry entry) {
        boolean fromDate = LocalDateTimeHelper.compare(entry.getStartDate(), LocalDateTimeHelper.START_DATE_NA) > 0;
        boolean toDate = LocalDateTimeHelper.compare(entry.getEndDate(), LocalDateTimeHelper.END_DATE_NA) > 0;
        boolean costPerUse = NumberHelper.getDouble(entry.getCostPerUse()) != 0.0;
        boolean overtimeRate = entry.getOvertimeRate() != null && entry.getOvertimeRate().getAmount() != 0.0;
        boolean standardRate = entry.getStandardRate() != null && entry.getStandardRate().getAmount() != 0.0;
        return fromDate || toDate || costPerUse || overtimeRate || standardRate;
    }

    private boolean costRateTableWriteRequired(int index, Resource resource, CostRateTable table) {
        if (table.isEmpty()) {
            return false;
        }
        if (index != 0 || table.size() > 1) {
            return true;
        }
        CostRateTableEntry entry = (CostRateTableEntry)table.get(0);
        return !Rate.equals(entry.getStandardRate(), resource.getStandardRate()) || !Rate.equals(entry.getOvertimeRate(), resource.getOvertimeRate()) || !NumberHelper.equals(entry.getCostPerUse(), resource.getCostPerUse());
    }

    private void writeAvailability(Project.Resources.Resource xml, Resource mpx) {
        AvailabilityTable table = mpx.getAvailability();
        if (table.hasDefaultDateRange()) {
            return;
        }
        Project.Resources.Resource.AvailabilityPeriods periods = this.m_factory.createProjectResourcesResourceAvailabilityPeriods();
        xml.setAvailabilityPeriods(periods);
        List<Project.Resources.Resource.AvailabilityPeriods.AvailabilityPeriod> list = periods.getAvailabilityPeriod();
        for (Availability availability : table) {
            Project.Resources.Resource.AvailabilityPeriods.AvailabilityPeriod period = this.m_factory.createProjectResourcesResourceAvailabilityPeriodsAvailabilityPeriod();
            list.add(period);
            LocalDateTimeRange range = availability.getRange();
            period.setAvailableFrom(range.getStart());
            period.setAvailableTo(range.getEnd());
            period.setAvailableUnits(DatatypeConverter.printUnits(availability.getUnits()));
        }
    }

    private void writeTasks(Project project) {
        Project.Tasks tasks = this.m_factory.createProjectTasks();
        project.setTasks(tasks);
        List<Project.Tasks.Task> list = tasks.getTask();
        int taskIdOffset = 0;
        for (Task task : this.m_projectFile.getTasks().stream().sorted(Comparator.comparing(Task::getID)).collect(Collectors.toList())) {
            if (task.getExternalTask()) {
                ++taskIdOffset;
                continue;
            }
            list.add(this.writeTask(taskIdOffset, task));
        }
    }

    private Project.Tasks.Task writeTask(int taskIdOffset, Task mpx) {
        Project.Tasks.Task xml = this.m_factory.createProjectTasksTask();
        int taskID = mpx.getID() - taskIdOffset;
        xml.setActive(mpx.getActive());
        xml.setActualCost(DatatypeConverter.printCurrency(mpx.getActualCost()));
        xml.setActualDuration(DatatypeConverter.printDuration(this, mpx.getActualDuration()));
        xml.setActualFinish(mpx.getActualFinish());
        xml.setActualOvertimeCost(DatatypeConverter.printCurrency(mpx.getActualOvertimeCost()));
        xml.setActualOvertimeWork(DatatypeConverter.printDuration(this, mpx.getActualOvertimeWork()));
        xml.setActualOvertimeWorkProtected(DatatypeConverter.printDuration(this, mpx.getActualOvertimeWorkProtected()));
        xml.setActualStart(mpx.getActualStart());
        xml.setActualWork(DatatypeConverter.printDuration(this, mpx.getActualWork()));
        xml.setActualWorkProtected(DatatypeConverter.printDuration(this, mpx.getActualWorkProtected()));
        xml.setACWP(DatatypeConverter.printCurrency(mpx.getACWP()));
        xml.setBCWP(DatatypeConverter.printCurrency(mpx.getBCWP()));
        xml.setBCWS(DatatypeConverter.printCurrency(mpx.getBCWS()));
        xml.setCalendarUID(this.getTaskCalendarID(mpx));
        xml.setConstraintDate(mpx.getConstraintDate());
        xml.setConstraintType(DatatypeConverter.printConstraintType(mpx.getConstraintType()));
        xml.setContact(mpx.getContact());
        xml.setCost(DatatypeConverter.printCurrency(mpx.getCost()));
        xml.setCreateDate(mpx.getCreateDate());
        xml.setCritical(mpx.getCritical());
        xml.setCV(DatatypeConverter.printCurrency(mpx.getCV()));
        xml.setDeadline(mpx.getDeadline());
        xml.setDuration(DatatypeConverter.printDurationMandatory(this, mpx.getDuration()));
        xml.setDurationText(mpx.getDurationText());
        xml.setDurationFormat(DatatypeConverter.printDurationTimeUnits(mpx.getDuration(), mpx.getEstimated()));
        xml.setEarlyFinish(mpx.getEarlyFinish());
        xml.setEarlyStart(mpx.getEarlyStart());
        xml.setEarnedValueMethod(DatatypeConverter.printEarnedValueMethod(mpx.getEarnedValueMethod()));
        xml.setEffortDriven(mpx.getEffortDriven());
        xml.setEstimated(mpx.getEstimated());
        xml.setExternalTask(mpx.getExternalTask());
        xml.setExternalTaskProject(mpx.getProject());
        xml.setFinish(mpx.getFinish());
        xml.setFinishSlack(DatatypeConverter.printDurationInIntegerTenthsOfMinutes(mpx.getFinishSlack()));
        xml.setFinishText(mpx.getFinishText());
        xml.setFinishVariance(DatatypeConverter.printDurationInIntegerTenthsOfMinutes(mpx.getFinishVariance()));
        xml.setFixedCost(DatatypeConverter.printCurrency(mpx.getFixedCost()));
        AccrueType fixedCostAccrual = mpx.getFixedCostAccrual();
        if (fixedCostAccrual == null) {
            fixedCostAccrual = AccrueType.PRORATED;
        }
        xml.setFixedCostAccrual(fixedCostAccrual);
        xml.setFreeSlack(DatatypeConverter.printDurationInIntegerTenthsOfMinutes(mpx.getFreeSlack()));
        xml.setGUID(mpx.getGUID());
        xml.setHideBar(mpx.getHideBar());
        xml.setIsNull(mpx.getNull());
        xml.setIsSubproject(mpx.getExternalProject());
        xml.setIsSubprojectReadOnly(mpx.getSubprojectReadOnly());
        xml.setHyperlink(mpx.getHyperlink());
        xml.setHyperlinkAddress(mpx.getHyperlinkAddress());
        xml.setHyperlinkSubAddress(mpx.getHyperlinkSubAddress());
        xml.setID(BigInteger.valueOf(taskID));
        xml.setIgnoreResourceCalendar(mpx.getIgnoreResourceCalendar());
        xml.setLateFinish(mpx.getLateFinish());
        xml.setLateStart(mpx.getLateStart());
        xml.setLevelAssignments(mpx.getLevelAssignments());
        xml.setLevelingCanSplit(mpx.getLevelingCanSplit());
        if (mpx.getLevelingDelay() == null) {
            if (mpx.getLevelingDelayFormat() != null) {
                xml.setLevelingDelayFormat(DatatypeConverter.printDurationTimeUnits(mpx.getLevelingDelayFormat(), false));
            }
        } else {
            Duration levelingDelay = mpx.getLevelingDelay();
            double tenthMinutes = 10.0 * Duration.convertUnits(levelingDelay.getDuration(), levelingDelay.getUnits(), TimeUnit.MINUTES, this.m_projectFile.getProjectProperties()).getDuration();
            xml.setLevelingDelay(BigInteger.valueOf((long)tenthMinutes));
            xml.setLevelingDelayFormat(DatatypeConverter.printDurationTimeUnits(levelingDelay, false));
        }
        xml.setManual(mpx.getTaskMode() == TaskMode.MANUALLY_SCHEDULED);
        if (mpx.getTaskMode() == TaskMode.MANUALLY_SCHEDULED) {
            xml.setManualDuration(DatatypeConverter.printDuration(this, mpx.getDuration()));
            xml.setManualFinish(mpx.getFinish());
            xml.setManualStart(mpx.getStart());
        }
        xml.setMilestone(mpx.getMilestone());
        xml.setName(StringHelper.stripControlCharacters(mpx.getName()));
        xml.setNotes(this.nullIfEmpty(mpx.getNotes()));
        xml.setOutlineLevel(NumberHelper.getBigInteger(mpx.getOutlineLevel()));
        xml.setOutlineNumber(mpx.getOutlineNumber());
        xml.setOverAllocated(mpx.getOverAllocated());
        xml.setOvertimeCost(DatatypeConverter.printCurrency(mpx.getOvertimeCost()));
        xml.setOvertimeWork(DatatypeConverter.printDuration(this, mpx.getOvertimeWork()));
        xml.setPercentComplete(mpx.getPercentageComplete());
        xml.setPercentWorkComplete(mpx.getPercentageWorkComplete());
        xml.setPhysicalPercentComplete(mpx.getPhysicalPercentComplete());
        xml.setPriority(DatatypeConverter.printPriority(mpx.getPriority()));
        xml.setRecurring(mpx.getRecurring());
        xml.setRegularWork(DatatypeConverter.printDuration(this, mpx.getRegularWork()));
        xml.setRemainingCost(DatatypeConverter.printCurrency(mpx.getRemainingCost()));
        if (mpx.getRemainingDuration() == null) {
            Duration duration = mpx.getDuration();
            if (duration != null) {
                double amount = duration.getDuration();
                amount -= amount * NumberHelper.getDouble(mpx.getPercentageComplete()) / 100.0;
                xml.setRemainingDuration(DatatypeConverter.printDuration(this, Duration.getInstance(amount, duration.getUnits())));
            }
        } else {
            xml.setRemainingDuration(DatatypeConverter.printDuration(this, mpx.getRemainingDuration()));
        }
        xml.setRemainingOvertimeCost(DatatypeConverter.printCurrency(mpx.getRemainingOvertimeCost()));
        xml.setRemainingOvertimeWork(DatatypeConverter.printDuration(this, mpx.getRemainingOvertimeWork()));
        xml.setRemainingWork(DatatypeConverter.printDuration(this, mpx.getRemainingWork()));
        xml.setResume(mpx.getResume());
        xml.setResumeValid(mpx.getResumeValid());
        xml.setRollup(mpx.getRollup());
        xml.setStart(mpx.getStart());
        xml.setStartSlack(DatatypeConverter.printDurationInIntegerTenthsOfMinutes(mpx.getStartSlack()));
        xml.setStartText(mpx.getStartText());
        xml.setStartVariance(DatatypeConverter.printDurationInIntegerTenthsOfMinutes(mpx.getStartVariance()));
        xml.setStop(mpx.getStop());
        xml.setSubprojectName(mpx.getSubprojectFile());
        xml.setSummary(mpx.hasChildTasks());
        xml.setTotalSlack(DatatypeConverter.printDurationInIntegerTenthsOfMinutes(mpx.getTotalSlack()));
        xml.setType(mpx.getType());
        xml.setUID(this.m_taskMapper.getUniqueID(mpx));
        xml.setWBS(mpx.getWBS());
        xml.setWork(DatatypeConverter.printDuration(this, mpx.getWork()));
        xml.setWorkVariance(DatatypeConverter.printDurationInDecimalThousandthsOfMinutes(mpx.getWorkVariance()));
        if (mpx.getTaskMode() == TaskMode.MANUALLY_SCHEDULED) {
            xml.setManualDuration(DatatypeConverter.printDuration(this, mpx.getManualDuration()));
        }
        this.writePredecessors(xml, mpx);
        this.writeTaskExtendedAttributes(xml, mpx);
        this.writeTaskOutlineCodes(xml, mpx);
        this.writeTaskBaselines(xml, mpx);
        return xml;
    }

    private void writeTaskBaselines(Project.Tasks.Task xmlTask, Task mpxjTask) {
        LocalDateTime date;
        Duration duration;
        Project.Tasks.Task.Baseline baseline = this.m_factory.createProjectTasksTaskBaseline();
        boolean populated = false;
        Number cost = mpxjTask.getBaselineCost();
        if (cost != null && cost.intValue() != 0) {
            populated = true;
            baseline.setCost(DatatypeConverter.printCurrency(cost));
        }
        if ((duration = mpxjTask.getBaselineDuration()) != null && duration.getDuration() != 0.0) {
            populated = true;
            baseline.setDuration(DatatypeConverter.printDuration(this, duration));
            baseline.setDurationFormat(DatatypeConverter.printDurationTimeUnits(duration, false));
        }
        if ((date = mpxjTask.getBaselineFinish()) != null) {
            populated = true;
            baseline.setFinish(date);
        }
        if ((date = mpxjTask.getBaselineStart()) != null) {
            populated = true;
            baseline.setStart(date);
        }
        if ((duration = mpxjTask.getBaselineWork()) != null && duration.getDuration() != 0.0) {
            populated = true;
            baseline.setWork(DatatypeConverter.printDuration(this, duration));
        }
        if (populated) {
            baseline.setNumber(BigInteger.ZERO);
            xmlTask.getBaseline().add(baseline);
        }
        for (int loop = 1; loop <= 10; ++loop) {
            baseline = this.m_factory.createProjectTasksTaskBaseline();
            populated = false;
            cost = mpxjTask.getBaselineCost(loop);
            if (cost != null && cost.intValue() != 0) {
                populated = true;
                baseline.setCost(DatatypeConverter.printCurrency(cost));
            }
            if ((duration = mpxjTask.getBaselineDuration(loop)) != null && duration.getDuration() != 0.0) {
                populated = true;
                baseline.setDuration(DatatypeConverter.printDuration(this, duration));
                baseline.setDurationFormat(DatatypeConverter.printDurationTimeUnits(duration, false));
            }
            if ((date = mpxjTask.getBaselineFinish(loop)) != null) {
                populated = true;
                baseline.setFinish(date);
            }
            if ((date = mpxjTask.getBaselineStart(loop)) != null) {
                populated = true;
                baseline.setStart(date);
            }
            if ((duration = mpxjTask.getBaselineWork(loop)) != null && duration.getDuration() != 0.0) {
                populated = true;
                baseline.setWork(DatatypeConverter.printDuration(this, duration));
            }
            if (!populated) continue;
            baseline.setNumber(BigInteger.valueOf(loop));
            xmlTask.getBaseline().add(baseline);
        }
    }

    private void writeTaskExtendedAttributes(Project.Tasks.Task xml, Task mpx) {
        List<Project.Tasks.Task.ExtendedAttribute> extendedAttributes = xml.getExtendedAttribute();
        HashSet<TaskField> outlineCodes = new HashSet<TaskField>(Arrays.asList(TaskFieldLists.CUSTOM_OUTLINE_CODE));
        this.m_extendedAttributes.stream().filter(f -> f.getFieldTypeClass() == FieldTypeClass.TASK && !outlineCodes.contains(f)).forEach(f -> this.writeTaskExtendedAttribute(extendedAttributes, mpx, (FieldType)f));
    }

    private void writeTaskExtendedAttribute(List<Project.Tasks.Task.ExtendedAttribute> extendedAttributes, Task mpx, FieldType mpxFieldID) {
        FieldType mappedFieldType;
        Object value = mpx.getCachedValue(mpxFieldID);
        if (FieldTypeHelper.valueIsNotDefault(mpxFieldID, value) && (mappedFieldType = this.m_userDefinedFieldMap.getTarget(mpxFieldID)) instanceof TaskField) {
            Project.Tasks.Task.ExtendedAttribute attrib = this.m_factory.createProjectTasksTaskExtendedAttribute();
            extendedAttributes.add(attrib);
            attrib.setFieldID(Integer.toString(FieldTypeHelper.getFieldID(mappedFieldType)));
            attrib.setValue(DatatypeConverter.printCustomField(this, value, mappedFieldType.getDataType()));
            attrib.setDurationFormat(this.printCustomFieldDurationFormat(value));
            this.setValueGUID(attrib, mappedFieldType);
        }
    }

    private void writeTaskOutlineCodes(Project.Tasks.Task xml, Task mpx) {
        List<Project.Tasks.Task.OutlineCode> outlineCodes = xml.getOutlineCode();
        for (TaskField mpxFieldID : TaskFieldLists.CUSTOM_OUTLINE_CODE) {
            Object value = mpx.getCachedValue(mpxFieldID);
            if (!FieldTypeHelper.valueIsNotDefault(mpxFieldID, value)) continue;
            Project.Tasks.Task.OutlineCode attrib = this.m_factory.createProjectTasksTaskOutlineCode();
            outlineCodes.add(attrib);
            attrib.setFieldID(Integer.toString(FieldTypeHelper.getFieldID(mpxFieldID)));
            this.setValueID(attrib, (FieldType)mpxFieldID, DatatypeConverter.printCustomField(this, value, mpxFieldID.getDataType()));
        }
    }

    private void setValueGUID(Project.Tasks.Task.ExtendedAttribute attrib, FieldType fieldType) {
        CustomFieldValueItem valueItem = this.getValueItem(fieldType, attrib.getValue());
        if (valueItem != null) {
            attrib.setValueGUID(valueItem.getGUID());
        }
    }

    private void setValueID(Project.Tasks.Task.OutlineCode attrib, FieldType fieldType, String formattedValue) {
        CustomFieldValueItem valueItem = this.getValueItem(fieldType, formattedValue);
        if (valueItem != null) {
            attrib.setValueID(NumberHelper.getBigInteger(valueItem.getUniqueID()));
        }
    }

    private CustomFieldValueItem getValueItem(FieldType fieldType, String formattedValue) {
        CustomFieldLookupTable items;
        CustomFieldValueItem result = null;
        CustomField field = this.m_projectFile.getCustomFields().get(fieldType);
        if (field != null && !(items = field.getLookupTable()).isEmpty()) {
            result = (CustomFieldValueItem)((Map)this.m_customFieldValueItems.getOrDefault(fieldType, this.getCustomFieldValueItemMap(fieldType, items))).get(formattedValue);
        }
        return result;
    }

    private HashMap<String, CustomFieldValueItem> getCustomFieldValueItemMap(FieldType fieldType, List<CustomFieldValueItem> items) {
        DataType dataType = fieldType.getDataType();
        HashMap<String, CustomFieldValueItem> result = new HashMap<String, CustomFieldValueItem>();
        items.forEach(item -> result.put(DatatypeConverter.printCustomField(this, item.getValue(), dataType), (CustomFieldValueItem)item));
        return result;
    }

    private BigInteger printCustomFieldDurationFormat(Object value) {
        BigInteger result = null;
        if (value instanceof Duration) {
            result = DatatypeConverter.printDurationTimeUnits(((Duration)value).getUnits(), false);
        }
        return result;
    }

    private BigInteger getTaskCalendarID(Task mpx) {
        ProjectCalendar cal = mpx.getCalendar();
        BigInteger result = cal != null ? NumberHelper.getBigInteger(this.m_calendarMapper.getUniqueID(cal)) : NULL_CALENDAR_ID;
        return result;
    }

    private void writePredecessors(Project.Tasks.Task xml, Task mpx) {
        List<Project.Tasks.Task.PredecessorLink> list = xml.getPredecessorLink();
        List<Relation> predecessors = mpx.getPredecessors();
        for (Relation rel : predecessors) {
            list.add(this.writePredecessor(rel.getPredecessorTask(), rel.getType(), rel.getLag()));
            this.m_eventManager.fireRelationWrittenEvent(rel);
        }
    }

    private Project.Tasks.Task.PredecessorLink writePredecessor(Task predecessor, RelationType type, Duration lag) {
        Project.Tasks.Task.PredecessorLink link = this.m_factory.createProjectTasksTaskPredecessorLink();
        link.setPredecessorUID(NumberHelper.getBigInteger(this.m_taskMapper.getUniqueID(predecessor)));
        link.setCrossProject(predecessor.getExternalTask());
        link.setType(BigInteger.valueOf(type.getValue()));
        if (lag != null && lag.getDuration() != 0.0) {
            double linkLag = lag.getDuration();
            if (lag.getUnits() != TimeUnit.PERCENT && lag.getUnits() != TimeUnit.ELAPSED_PERCENT) {
                linkLag = 10.0 * Duration.convertUnits(linkLag, lag.getUnits(), TimeUnit.MINUTES, this.m_projectFile.getProjectProperties()).getDuration();
            }
            link.setLinkLag(BigInteger.valueOf((long)linkLag));
            link.setLagFormat(DatatypeConverter.printDurationTimeUnits(lag.getUnits(), false));
        } else {
            link.setLinkLag(BIGINTEGER_ZERO);
            link.setLagFormat(DatatypeConverter.printDurationTimeUnits(this.m_projectFile.getProjectProperties().getDefaultDurationUnits(), false));
        }
        if (predecessor.getExternalTask()) {
            link.setCrossProjectName(predecessor.getSubprojectFile() + "\\" + predecessor.getSubprojectTaskID());
        }
        return link;
    }

    private void writeAssignments(Project project) {
        Project.Assignments assignments = this.m_factory.createProjectAssignments();
        project.setAssignments(assignments);
        List<Project.Assignments.Assignment> list = assignments.getAssignment();
        Function<ResourceAssignment, String> assignmentKey = a -> a.getTaskUniqueID() + " " + a.getResourceUniqueID();
        Map map = this.m_projectFile.getResourceAssignments().stream().collect(Collectors.toMap(assignmentKey, Function.identity(), (a1, a2) -> a1));
        this.m_projectFile.getResourceAssignments().stream().filter(a -> map.get(assignmentKey.apply((ResourceAssignment)a)) == a).forEach(a -> list.add(this.writeAssignment((ResourceAssignment)a)));
        ProjectConfig config = this.m_projectFile.getProjectConfig();
        boolean autoUniqueID = config.getAutoAssignmentUniqueID();
        if (!autoUniqueID) {
            config.setAutoAssignmentUniqueID(true);
        }
        for (Task task : this.m_projectFile.getTasks()) {
            double percentComplete = NumberHelper.getDouble(task.getPercentageComplete());
            if (percentComplete == 0.0 || !task.getResourceAssignments().isEmpty()) continue;
            ResourceAssignment dummy = new ResourceAssignment(this.m_projectFile, task);
            Duration duration = task.getDuration();
            if (duration == null) {
                duration = Duration.getInstance(0, TimeUnit.HOURS);
            }
            double durationValue = duration.getDuration();
            TimeUnit durationUnits = duration.getUnits();
            double actualWork = durationValue * percentComplete / 100.0;
            double remainingWork = durationValue - actualWork;
            if (this.m_generateMissingTimephasedData) {
                dummy.setActualStart(task.getActualStart());
            }
            dummy.setResourceUniqueID(MicrosoftProjectConstants.ASSIGNMENT_NULL_RESOURCE_ID);
            dummy.setWork(duration);
            dummy.setActualWork(Duration.getInstance(actualWork, durationUnits));
            dummy.setRemainingWork(Duration.getInstance(remainingWork, durationUnits));
            if (percentComplete == 100.0 && duration.getDuration() == 0.0) {
                dummy.setActualFinish(task.getActualStart());
            }
            list.add(this.writeAssignment(dummy));
        }
        config.setAutoAssignmentUniqueID(autoUniqueID);
    }

    private Project.Assignments.Assignment writeAssignment(ResourceAssignment mpx) {
        Project.Assignments.Assignment xml = this.m_factory.createProjectAssignmentsAssignment();
        xml.setActualCost(DatatypeConverter.printCurrency(mpx.getActualCost()));
        xml.setActualFinish(mpx.getActualFinish());
        xml.setActualOvertimeCost(DatatypeConverter.printCurrency(mpx.getActualOvertimeCost()));
        xml.setActualOvertimeWork(DatatypeConverter.printDuration(this, mpx.getActualOvertimeWork()));
        xml.setActualStart(mpx.getActualStart());
        xml.setActualWork(DatatypeConverter.printDuration(this, mpx.getActualWork()));
        xml.setACWP(DatatypeConverter.printCurrency(mpx.getACWP()));
        xml.setBCWP(DatatypeConverter.printCurrency(mpx.getBCWP()));
        xml.setBCWS(DatatypeConverter.printCurrency(mpx.getBCWS()));
        xml.setBudgetCost(DatatypeConverter.printCurrency(mpx.getBudgetCost()));
        xml.setBudgetWork(DatatypeConverter.printDuration(this, mpx.getBudgetWork()));
        xml.setCost(DatatypeConverter.printCurrency(mpx.getCost()));
        if (mpx.getCostRateTableIndex() != 0) {
            xml.setCostRateTable(BigInteger.valueOf(mpx.getCostRateTableIndex()));
        }
        xml.setCreationDate(mpx.getCreateDate());
        xml.setCV(DatatypeConverter.printCurrency(mpx.getCV()));
        xml.setDelay(DatatypeConverter.printDurationInIntegerTenthsOfMinutes(mpx.getDelay()));
        xml.setFinish(mpx.getFinish());
        xml.setGUID(mpx.getGUID());
        xml.setHasFixedRateUnits(mpx.getVariableRateUnits() == null);
        xml.setFixedMaterial(mpx.getResource() != null && mpx.getResource().getType() == ResourceType.MATERIAL);
        xml.setHyperlink(mpx.getHyperlink());
        xml.setHyperlinkAddress(mpx.getHyperlinkAddress());
        xml.setHyperlinkSubAddress(mpx.getHyperlinkSubAddress());
        xml.setLevelingDelay(DatatypeConverter.printDurationInIntegerTenthsOfMinutes(mpx.getLevelingDelay()));
        xml.setLevelingDelayFormat(DatatypeConverter.printDurationTimeUnits(mpx.getLevelingDelay(), false));
        xml.setNotes(this.nullIfEmpty(mpx.getNotes()));
        xml.setOvertimeCost(DatatypeConverter.printCurrency(mpx.getOvertimeCost()));
        xml.setOvertimeWork(DatatypeConverter.printDuration(this, mpx.getOvertimeWork()));
        xml.setPercentWorkComplete(mpx.getPercentageWorkComplete());
        xml.setRateScale(mpx.getVariableRateUnits() == null ? null : DatatypeConverter.printTimeUnit(mpx.getVariableRateUnits()));
        xml.setRegularWork(DatatypeConverter.printDuration(this, mpx.getRegularWork()));
        xml.setRemainingCost(DatatypeConverter.printCurrency(mpx.getRemainingCost()));
        xml.setRemainingOvertimeCost(DatatypeConverter.printCurrency(mpx.getRemainingOvertimeCost()));
        xml.setRemainingOvertimeWork(DatatypeConverter.printDuration(this, mpx.getRemainingOvertimeWork()));
        if (mpx.getRemainingWork() == null) {
            Duration work = mpx.getWork();
            if (work != null) {
                double amount = work.getDuration();
                amount -= amount * NumberHelper.getDouble(mpx.getPercentageWorkComplete()) / 100.0;
                xml.setRemainingWork(DatatypeConverter.printDuration(this, Duration.getInstance(amount, work.getUnits())));
            }
        } else {
            xml.setRemainingWork(DatatypeConverter.printDuration(this, mpx.getRemainingWork()));
        }
        xml.setResourceUID(mpx.getResource() == null ? BigInteger.valueOf(MicrosoftProjectConstants.ASSIGNMENT_NULL_RESOURCE_ID.intValue()) : BigInteger.valueOf(NumberHelper.getInt(this.m_resourceMapper.getUniqueID(mpx.getResource()))));
        xml.setResume(mpx.getResume());
        xml.setStart(mpx.getStart());
        xml.setStop(mpx.getStop());
        xml.setSV(DatatypeConverter.printCurrency(mpx.getSV()));
        xml.setTaskUID(NumberHelper.getBigInteger(this.m_taskMapper.getUniqueID(mpx.getTask())));
        xml.setUID(NumberHelper.getBigInteger(this.m_assignmentMapper.getUniqueID(mpx)));
        xml.setUnits(DatatypeConverter.printUnits(mpx.getUnits()));
        xml.setVAC(DatatypeConverter.printCurrency(mpx.getVAC()));
        xml.setWork(DatatypeConverter.printDuration(this, mpx.getWork()));
        xml.setWorkContour(mpx.getWorkContour());
        xml.setCostVariance(DatatypeConverter.printCurrency(mpx.getCostVariance()));
        xml.setWorkVariance(DatatypeConverter.printDurationInDecimalThousandthsOfMinutes(mpx.getWorkVariance()));
        xml.setStartVariance(DatatypeConverter.printDurationInIntegerTenthsOfMinutes(mpx.getStartVariance()));
        xml.setFinishVariance(DatatypeConverter.printDurationInIntegerTenthsOfMinutes(mpx.getFinishVariance()));
        double percentComplete = NumberHelper.getDouble(mpx.getTask().getPercentageComplete());
        if (percentComplete == 100.0 && xml.getActualFinish() == null) {
            xml.setActualFinish(mpx.getTask().getActualFinish());
        }
        this.writeAssignmentBaselines(xml, mpx);
        this.writeAssignmentExtendedAttributes(xml, mpx);
        this.writeAssignmentTimephasedData(mpx, xml);
        this.m_eventManager.fireAssignmentWrittenEvent(mpx);
        return xml;
    }

    private void writeAssignmentBaselines(Project.Assignments.Assignment xml, ResourceAssignment mpxj) {
        Duration duration;
        LocalDateTime date;
        Project.Assignments.Assignment.Baseline baseline = this.m_factory.createProjectAssignmentsAssignmentBaseline();
        boolean populated = false;
        Number cost = mpxj.getBaselineCost();
        if (cost != null && cost.intValue() != 0) {
            populated = true;
            baseline.setCost(DatatypeConverter.printCustomFieldCurrency(cost));
        }
        if ((date = mpxj.getBaselineFinish()) != null) {
            populated = true;
            baseline.setFinish(DatatypeConverter.printCustomFieldDate(date));
        }
        if ((date = mpxj.getBaselineStart()) != null) {
            populated = true;
            baseline.setStart(DatatypeConverter.printCustomFieldDate(date));
        }
        if ((duration = mpxj.getBaselineWork()) != null && duration.getDuration() != 0.0) {
            populated = true;
            baseline.setWork(DatatypeConverter.printDuration(this, duration));
        }
        if (populated) {
            baseline.setNumber("0");
            xml.getBaseline().add(baseline);
        }
        for (int loop = 1; loop <= 10; ++loop) {
            baseline = this.m_factory.createProjectAssignmentsAssignmentBaseline();
            populated = false;
            cost = mpxj.getBaselineCost(loop);
            if (cost != null && cost.intValue() != 0) {
                populated = true;
                baseline.setCost(DatatypeConverter.printCustomFieldCurrency(cost));
            }
            if ((date = mpxj.getBaselineFinish(loop)) != null) {
                populated = true;
                baseline.setFinish(DatatypeConverter.printCustomFieldDate(date));
            }
            if ((date = mpxj.getBaselineStart(loop)) != null) {
                populated = true;
                baseline.setStart(DatatypeConverter.printCustomFieldDate(date));
            }
            if ((duration = mpxj.getBaselineWork(loop)) != null && duration.getDuration() != 0.0) {
                populated = true;
                baseline.setWork(DatatypeConverter.printDuration(this, duration));
            }
            if (!populated) continue;
            baseline.setNumber(Integer.toString(loop));
            xml.getBaseline().add(baseline);
        }
    }

    private void writeAssignmentExtendedAttributes(Project.Assignments.Assignment xml, ResourceAssignment mpx) {
        List<Project.Assignments.Assignment.ExtendedAttribute> extendedAttributes = xml.getExtendedAttribute();
        this.m_extendedAttributes.stream().filter(f -> f.getFieldTypeClass() == FieldTypeClass.ASSIGNMENT).forEach(f -> this.writeAssignmentExtendedAttribute(extendedAttributes, mpx, (FieldType)f));
    }

    private void writeAssignmentExtendedAttribute(List<Project.Assignments.Assignment.ExtendedAttribute> extendedAttributes, ResourceAssignment mpx, FieldType mpxFieldID) {
        FieldType mappedFieldType;
        Object value = mpx.getCachedValue(mpxFieldID);
        if (FieldTypeHelper.valueIsNotDefault(mpxFieldID, value) && (mappedFieldType = this.m_userDefinedFieldMap.getTarget(mpxFieldID)) instanceof AssignmentField) {
            Project.Assignments.Assignment.ExtendedAttribute attrib = this.m_factory.createProjectAssignmentsAssignmentExtendedAttribute();
            extendedAttributes.add(attrib);
            attrib.setFieldID(Integer.toString(FieldTypeHelper.getFieldID(mappedFieldType)));
            attrib.setValue(DatatypeConverter.printCustomField(this, value, mappedFieldType.getDataType()));
            attrib.setDurationFormat(this.printCustomFieldDurationFormat(value));
        }
    }

    private void writeAssignmentTimephasedData(ResourceAssignment mpx, Project.Assignments.Assignment xml) {
        int index;
        if (!this.m_writeTimephasedData || this.m_sourceIsPrimavera) {
            return;
        }
        if (!mpx.getHasTimephasedData() && !this.m_generateMissingTimephasedData) {
            return;
        }
        ProjectCalendar calendar = this.getCalendar(mpx);
        List<TimephasedWork> complete = mpx.getTimephasedActualWork();
        List<TimephasedWork> planned = mpx.getTimephasedWork();
        List<TimephasedWork> completeOvertime = mpx.getTimephasedActualOvertimeWork();
        if ((planned == null || planned.isEmpty()) && this.m_generateMissingTimephasedData) {
            planned = this.generateTimephasedPlannedWork(mpx);
        }
        if ((complete == null || complete.isEmpty()) && this.m_generateMissingTimephasedData) {
            complete = this.generateTimephasedCompleteWork(mpx);
        }
        complete = this.splitCompleteWork(calendar, planned, complete);
        planned = this.splitPlannedWork(calendar, planned, complete);
        completeOvertime = this.splitDays(calendar, completeOvertime, null, null);
        BigInteger assignmentID = xml.getUID();
        List<TimephasedDataType> list = xml.getTimephasedData();
        this.writeAssignmentTimephasedWorkData(assignmentID, list, complete, 2);
        this.writeAssignmentTimephasedWorkData(assignmentID, list, planned, 1);
        this.writeAssignmentTimephasedWorkData(assignmentID, list, completeOvertime, 3);
        for (index = 0; index < TIMEPHASED_BASELINE_WORK_TYPES.length; ++index) {
            this.writeAssignmentTimephasedWorkData(assignmentID, list, this.splitDays(calendar, mpx.getTimephasedBaselineWork(index), null, null), TIMEPHASED_BASELINE_WORK_TYPES[index]);
        }
        for (index = 0; index < TIMEPHASED_BASELINE_COST_TYPES.length; ++index) {
            this.writeAssignmentTimephasedCostData(assignmentID, list, this.splitDays(calendar, mpx.getTimephasedBaselineCost(index)), TIMEPHASED_BASELINE_COST_TYPES[index]);
        }
    }

    private List<TimephasedWork> generateTimephasedPlannedWork(ResourceAssignment assignment) {
        if (assignment.getActualFinish() != null) {
            return null;
        }
        ProjectCalendar calendar = assignment.getEffectiveCalendar();
        LocalDateTime start = assignment.getActualStart() == null ? assignment.getStart() : calendar.getNextWorkStart(calendar.getDate(assignment.getActualStart(), assignment.getActualWork()));
        TimephasedWork work = new TimephasedWork();
        work.setStart(start);
        work.setFinish(assignment.getFinish());
        work.setTotalAmount(assignment.getRemainingWork());
        work.setAmountPerDay(Duration.getInstance(NumberHelper.getInt(calendar.getMinutesPerDay()), TimeUnit.MINUTES));
        return Collections.singletonList(work);
    }

    private List<TimephasedWork> generateTimephasedCompleteWork(ResourceAssignment assignment) {
        if (assignment.getActualStart() == null) {
            return null;
        }
        ProjectCalendar calendar = assignment.getEffectiveCalendar();
        LocalDateTime finish = assignment.getActualFinish() == null ? calendar.getDate(assignment.getActualStart(), assignment.getActualWork()) : assignment.getActualFinish();
        TimephasedWork work = new TimephasedWork();
        work.setStart(assignment.getActualStart());
        work.setFinish(finish);
        work.setTotalAmount(assignment.getActualWork());
        work.setAmountPerDay(Duration.getInstance(NumberHelper.getInt(calendar.getMinutesPerDay()), TimeUnit.MINUTES));
        return Collections.singletonList(work);
    }

    private List<TimephasedWork> splitCompleteWork(ProjectCalendar calendar, List<TimephasedWork> planned, List<TimephasedWork> complete) {
        if (!this.m_splitTimephasedAsDays || complete == null) {
            return complete;
        }
        TimephasedWork firstPlanned = null;
        if (planned != null && !planned.isEmpty()) {
            firstPlanned = planned.get(0);
        }
        return this.splitDays(calendar, complete, firstPlanned, null);
    }

    private List<TimephasedWork> splitPlannedWork(ProjectCalendar calendar, List<TimephasedWork> planned, List<TimephasedWork> complete) {
        if (!this.m_splitTimephasedAsDays || planned == null) {
            return planned;
        }
        TimephasedWork lastComplete = null;
        if (complete != null && !complete.isEmpty()) {
            lastComplete = complete.get(complete.size() - 1);
        }
        return this.splitDays(calendar, planned, null, lastComplete);
    }

    private ProjectCalendar getCalendar(ResourceAssignment assignment) {
        return assignment.getEffectiveCalendar();
    }

    private List<TimephasedWork> splitDays(ProjectCalendar calendar, List<TimephasedWork> list, TimephasedWork first, TimephasedWork last) {
        if (!this.m_splitTimephasedAsDays || list == null || list.isEmpty()) {
            return list;
        }
        ArrayList<TimephasedWork> result = new ArrayList<TimephasedWork>();
        for (TimephasedWork assignment : list) {
            LocalDateTime finishDay;
            LocalDateTime startDate = assignment.getStart();
            LocalDateTime finishDate = assignment.getFinish();
            LocalDateTime startDay = LocalDateTimeHelper.getDayStartDate(startDate);
            if (startDay.equals(finishDay = LocalDateTimeHelper.getDayStartDate(finishDate))) {
                LocalDateTime currentStart;
                LocalTime startTime = calendar.getStartTime(LocalDateHelper.getLocalDate(startDay));
                LocalDateTime localDateTime = currentStart = startTime == null ? null : LocalDateTime.of(startDay.toLocalDate(), startTime);
                if (currentStart != null && startDate.isAfter(currentStart)) {
                    boolean paddingRequired = true;
                    if (last != null) {
                        LocalDateTime lastFinish = last.getFinish();
                        if (lastFinish.equals(startDate)) {
                            paddingRequired = false;
                        } else {
                            LocalDateTime lastFinishDay = LocalDateTimeHelper.getDayStartDate(lastFinish);
                            if (startDay.equals(lastFinishDay)) {
                                currentStart = lastFinish;
                            }
                        }
                    }
                    if (paddingRequired) {
                        Duration zeroHours = Duration.getInstance(0, TimeUnit.HOURS);
                        TimephasedWork padding = new TimephasedWork();
                        padding.setStart(currentStart);
                        padding.setFinish(startDate);
                        padding.setTotalAmount(zeroHours);
                        padding.setAmountPerDay(zeroHours);
                        result.add(padding);
                    }
                }
                result.add(assignment);
                LocalTime finishTime = calendar.getFinishTime(LocalDateHelper.getLocalDate(startDay));
                LocalDateTime currentFinish = finishTime == null ? null : LocalDateTime.of(startDay.toLocalDate(), finishTime);
                if (currentFinish == null || !finishDate.isBefore(currentFinish)) continue;
                boolean paddingRequired = true;
                if (first != null) {
                    LocalDateTime firstStart = first.getStart();
                    if (firstStart.equals(finishDate)) {
                        paddingRequired = false;
                    } else {
                        LocalDateTime firstStartDay = LocalDateTimeHelper.getDayStartDate(firstStart);
                        if (finishDay.equals(firstStartDay)) {
                            currentFinish = firstStart;
                        }
                    }
                }
                if (!paddingRequired) continue;
                Duration zeroHours = Duration.getInstance(0, TimeUnit.HOURS);
                TimephasedWork padding = new TimephasedWork();
                padding.setStart(finishDate);
                padding.setFinish(currentFinish);
                padding.setTotalAmount(zeroHours);
                padding.setAmountPerDay(zeroHours);
                result.add(padding);
                continue;
            }
            LocalDateTime currentStart = startDate;
            boolean isWorking = calendar.isWorkingDate(LocalDateHelper.getLocalDate(currentStart));
            while (currentStart.isBefore(finishDate)) {
                if (isWorking) {
                    LocalDateTime currentFinish = LocalDateTime.of(currentStart.toLocalDate(), calendar.getFinishTime(LocalDateHelper.getLocalDate(currentStart)));
                    if (currentFinish.isAfter(finishDate)) {
                        currentFinish = finishDate;
                    }
                    TimephasedWork split = new TimephasedWork();
                    split.setStart(currentStart);
                    split.setFinish(currentFinish);
                    split.setTotalAmount(assignment.getAmountPerDay());
                    split.setAmountPerDay(assignment.getAmountPerDay());
                    result.add(split);
                }
                if (!(isWorking = calendar.isWorkingDate(LocalDateHelper.getLocalDate(currentStart = currentStart.plusDays(1L))))) continue;
                currentStart = LocalDateTime.of(currentStart.toLocalDate(), calendar.getStartTime(LocalDateHelper.getLocalDate(currentStart)));
            }
        }
        return result;
    }

    private List<TimephasedCost> splitDays(ProjectCalendar calendar, List<TimephasedCost> list) {
        if (!this.m_splitTimephasedAsDays || list == null || list.isEmpty()) {
            return list;
        }
        ArrayList<TimephasedCost> result = new ArrayList<TimephasedCost>();
        for (TimephasedCost assignment : list) {
            LocalDateTime finishDay;
            LocalDateTime startDate = assignment.getStart();
            LocalDateTime finishDate = assignment.getFinish();
            LocalDateTime startDay = LocalDateTimeHelper.getDayStartDate(startDate);
            if (startDay.equals(finishDay = LocalDateTimeHelper.getDayStartDate(finishDate))) {
                LocalDateTime currentStart;
                LocalTime startTime = calendar.getStartTime(LocalDateHelper.getLocalDate(startDay));
                LocalDateTime localDateTime = currentStart = startTime == null ? null : LocalDateTime.of(startDay.toLocalDate(), startTime);
                if (currentStart != null && startDate.isAfter(currentStart)) {
                    TimephasedCost padding = new TimephasedCost();
                    padding.setStart(currentStart);
                    padding.setFinish(startDate);
                    padding.setTotalAmount(0);
                    padding.setAmountPerDay(0);
                    result.add(padding);
                }
                result.add(assignment);
                LocalTime finishTime = calendar.getFinishTime(LocalDateHelper.getLocalDate(startDay));
                LocalDateTime currentFinish = finishTime == null ? null : LocalDateTime.of(startDay.toLocalDate(), finishTime);
                if (currentFinish == null || !finishDate.isBefore(currentFinish)) continue;
                TimephasedCost padding = new TimephasedCost();
                padding.setStart(finishDate);
                padding.setFinish(currentFinish);
                padding.setTotalAmount(0);
                padding.setAmountPerDay(0);
                result.add(padding);
                continue;
            }
            LocalDateTime currentStart = startDate;
            boolean isWorking = calendar.isWorkingDate(LocalDateHelper.getLocalDate(currentStart));
            while (currentStart.isBefore(finishDate)) {
                if (isWorking) {
                    LocalDateTime currentFinish = LocalDateTime.of(currentStart.toLocalDate(), calendar.getFinishTime(LocalDateHelper.getLocalDate(currentStart)));
                    if (currentFinish.isAfter(finishDate)) {
                        currentFinish = finishDate;
                    }
                    TimephasedCost split = new TimephasedCost();
                    split.setStart(currentStart);
                    split.setFinish(currentFinish);
                    split.setTotalAmount(assignment.getAmountPerDay());
                    split.setAmountPerDay(assignment.getAmountPerDay());
                    result.add(split);
                }
                if (!(isWorking = calendar.isWorkingDate(LocalDateHelper.getLocalDate(currentStart = currentStart.plusDays(1L))))) continue;
                currentStart = LocalDateTime.of(currentStart.toLocalDate(), calendar.getStartTime(LocalDateHelper.getLocalDate(currentStart)));
            }
        }
        return result;
    }

    private void writeAssignmentTimephasedWorkData(BigInteger assignmentID, List<TimephasedDataType> list, List<TimephasedWork> data, int type) {
        if (data == null) {
            return;
        }
        for (TimephasedWork mpx : data) {
            TimephasedDataType xml = this.m_factory.createTimephasedDataType();
            list.add(xml);
            xml.setStart(mpx.getStart());
            xml.setFinish(mpx.getFinish());
            xml.setType(BigInteger.valueOf(type));
            xml.setUID(assignmentID);
            xml.setUnit(this.timephasedDataPeriodUnit(mpx));
            xml.setValue(DatatypeConverter.printDuration(this, (Duration)mpx.getTotalAmount()));
        }
    }

    private BigInteger timephasedDataPeriodUnit(TimephasedItem<?> item) {
        long itemDuration = item.getStart().until(item.getFinish(), ChronoUnit.DAYS);
        if (itemDuration >= 364L) {
            return TIMEPHASED_DATA_PERIOD_YEARS;
        }
        if (itemDuration >= 28L) {
            return TIMEPHASED_DATA_PERIOD_MONTHS;
        }
        if (itemDuration >= 7L) {
            return TIMEPHASED_DATA_PERIOD_WEEKS;
        }
        if (itemDuration >= 1L) {
            return TIMEPHASED_DATA_PERIOD_DAYS;
        }
        itemDuration = item.getStart().until(item.getFinish(), ChronoUnit.MINUTES);
        if (itemDuration >= 60L) {
            return TIMEPHASED_DATA_PERIOD_HOURS;
        }
        return TIMEPHASED_DATA_PERIOD_MINUTES;
    }

    private void writeAssignmentTimephasedCostData(BigInteger assignmentID, List<TimephasedDataType> list, List<TimephasedCost> data, int type) {
        if (data == null) {
            return;
        }
        for (TimephasedCost mpx : data) {
            TimephasedDataType xml = this.m_factory.createTimephasedDataType();
            list.add(xml);
            BigDecimal value = DatatypeConverter.printCurrency((Number)mpx.getTotalAmount());
            xml.setStart(mpx.getStart());
            xml.setFinish(mpx.getFinish());
            xml.setType(BigInteger.valueOf(type));
            xml.setUID(assignmentID);
            xml.setUnit(this.timephasedDataPeriodUnit(mpx));
            xml.setValue(value == null ? null : value.toString());
        }
    }

    ProjectFile getProjectFile() {
        return this.m_projectFile;
    }

    private List<FieldType> getExtendedAttributesList() {
        Set set = this.m_projectFile.getCustomFields().stream().map(CustomField::getFieldType).filter(Objects::nonNull).collect(Collectors.toSet());
        set.addAll(this.m_projectFile.getUserDefinedFields());
        set.addAll(this.m_projectFile.getPopulatedFields().stream().filter(FieldLists.CUSTOM_FIELDS_SET::contains).collect(Collectors.toSet()));
        set.removeIf(f -> FieldTypeHelper.getFieldID(f) == -1);
        return set.stream().sorted(Comparator.comparing(FieldTypeHelper::getFieldID)).collect(Collectors.toList());
    }

    private String formatMaterialLabel(Resource resource) {
        if (resource.getType() != ResourceType.MATERIAL) {
            return null;
        }
        String text = resource.getMaterialLabel();
        if (text == null || text.isEmpty()) {
            return text;
        }
        int index = text.indexOf(91);
        if (index != -1) {
            text = text.replace("[", "");
        }
        if ((index = text.indexOf(93)) != -1) {
            text = text.replace("]", "");
        }
        if (TIME_UNIT_NAMES.contains(text.trim())) {
            text = text.trim() + ".";
        }
        if (text.length() > 32) {
            text = text.substring(0, 32);
        }
        return text;
    }

    private String nullIfEmpty(String value) {
        return value != null && !value.isEmpty() ? value : null;
    }

    static {
        try {
            System.setProperty("com.sun.xml.bind.v2.runtime.JAXBContextImpl.fastBoot", "true");
            CONTEXT = JAXBContext.newInstance((String)"org.mpxj.mspdi.schema", (ClassLoader)MSPDIWriter.class.getClassLoader());
        }
        catch (JAXBException ex) {
            CONTEXT_EXCEPTION = ex;
            CONTEXT = null;
        }
        DAY_MASKS = new int[]{0, 1, 2, 4, 8, 16, 32, 64};
        MICROSOFT_PROJECT_FILES = new HashSet<String>(Arrays.asList("MPP", "MPX", "MSPDI", "MPD"));
        BIGINTEGER_ZERO = BigInteger.valueOf(0L);
        NULL_CALENDAR_ID = BigInteger.valueOf(-1L);
        MAPPING_TARGET_CUSTOM_FIELDS = new ArrayList<FieldType>();
        MAPPING_TARGET_CUSTOM_FIELDS.addAll(Arrays.asList(TaskFieldLists.CUSTOM_TEXT));
        MAPPING_TARGET_CUSTOM_FIELDS.addAll(Arrays.asList(TaskFieldLists.CUSTOM_DATE));
        MAPPING_TARGET_CUSTOM_FIELDS.addAll(Arrays.asList(TaskFieldLists.CUSTOM_START));
        MAPPING_TARGET_CUSTOM_FIELDS.addAll(Arrays.asList(TaskFieldLists.CUSTOM_FINISH));
        MAPPING_TARGET_CUSTOM_FIELDS.addAll(Arrays.asList(TaskFieldLists.CUSTOM_COST));
        MAPPING_TARGET_CUSTOM_FIELDS.addAll(Arrays.asList(TaskFieldLists.CUSTOM_FLAG));
        MAPPING_TARGET_CUSTOM_FIELDS.addAll(Arrays.asList(TaskFieldLists.CUSTOM_NUMBER));
        MAPPING_TARGET_CUSTOM_FIELDS.addAll(Arrays.asList(TaskFieldLists.CUSTOM_DURATION));
        MAPPING_TARGET_CUSTOM_FIELDS.addAll(Arrays.asList(ResourceFieldLists.CUSTOM_TEXT));
        MAPPING_TARGET_CUSTOM_FIELDS.addAll(Arrays.asList(ResourceFieldLists.CUSTOM_DATE));
        MAPPING_TARGET_CUSTOM_FIELDS.addAll(Arrays.asList(ResourceFieldLists.CUSTOM_START));
        MAPPING_TARGET_CUSTOM_FIELDS.addAll(Arrays.asList(ResourceFieldLists.CUSTOM_FINISH));
        MAPPING_TARGET_CUSTOM_FIELDS.addAll(Arrays.asList(ResourceFieldLists.CUSTOM_COST));
        MAPPING_TARGET_CUSTOM_FIELDS.addAll(Arrays.asList(ResourceFieldLists.CUSTOM_FLAG));
        MAPPING_TARGET_CUSTOM_FIELDS.addAll(Arrays.asList(ResourceFieldLists.CUSTOM_NUMBER));
        MAPPING_TARGET_CUSTOM_FIELDS.addAll(Arrays.asList(ResourceFieldLists.CUSTOM_DURATION));
        MAPPING_TARGET_CUSTOM_FIELDS.addAll(Arrays.asList(AssignmentFieldLists.CUSTOM_TEXT));
        MAPPING_TARGET_CUSTOM_FIELDS.addAll(Arrays.asList(AssignmentFieldLists.CUSTOM_DATE));
        MAPPING_TARGET_CUSTOM_FIELDS.addAll(Arrays.asList(AssignmentFieldLists.CUSTOM_START));
        MAPPING_TARGET_CUSTOM_FIELDS.addAll(Arrays.asList(AssignmentFieldLists.CUSTOM_FINISH));
        MAPPING_TARGET_CUSTOM_FIELDS.addAll(Arrays.asList(AssignmentFieldLists.CUSTOM_COST));
        MAPPING_TARGET_CUSTOM_FIELDS.addAll(Arrays.asList(AssignmentFieldLists.CUSTOM_FLAG));
        MAPPING_TARGET_CUSTOM_FIELDS.addAll(Arrays.asList(AssignmentFieldLists.CUSTOM_NUMBER));
        MAPPING_TARGET_CUSTOM_FIELDS.addAll(Arrays.asList(AssignmentFieldLists.CUSTOM_DURATION));
        TIMEPHASED_BASELINE_WORK_TYPES = new int[]{4, 16, 22, 28, 34, 40, 46, 52, 58, 64, 70};
        TIMEPHASED_BASELINE_COST_TYPES = new int[]{5, 17, 23, 29, 35, 41, 47, 53, 59, 65, 71};
        TIME_UNIT_NAMES = new HashSet<String>(Arrays.stream(TimeUnit.values()).map(TimeUnit::getName).collect(Collectors.toList()));
        TIMEPHASED_DATA_PERIOD_YEARS = BigInteger.valueOf(8L);
        TIMEPHASED_DATA_PERIOD_MONTHS = BigInteger.valueOf(5L);
        TIMEPHASED_DATA_PERIOD_WEEKS = BigInteger.valueOf(3L);
        TIMEPHASED_DATA_PERIOD_DAYS = BigInteger.valueOf(2L);
        TIMEPHASED_DATA_PERIOD_HOURS = BigInteger.valueOf(1L);
        TIMEPHASED_DATA_PERIOD_MINUTES = BigInteger.valueOf(0L);
    }
}

