/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.opc;

import java.util.List;
import org.mpxj.opc.ExportRequestBaseline;
import org.mpxj.opc.ExportRequestProject;
import org.mpxj.opc.OpcProject;
import org.mpxj.opc.OpcProjectBaseline;

class ExportRequest {
    private final OpcProject m_project;
    private final boolean m_exportCompressedFile;
    private final ExportRequestProject m_projectInfo = new ExportRequestProject();

    public ExportRequest(OpcProject project, List<OpcProjectBaseline> baselines, boolean compressed) {
        this.m_project = project;
        this.m_projectInfo.setProjectId(project.getProjectId());
        this.m_projectInfo.setBaselineProjectInfo((ExportRequestBaseline[])baselines.stream().map(b -> new ExportRequestBaseline(b.getProjectBaselineId())).toArray(ExportRequestBaseline[]::new));
        this.m_exportCompressedFile = compressed;
    }

    public boolean getExportCompressedFile() {
        return this.m_exportCompressedFile;
    }

    public long getWorkspaceId() {
        return this.m_project.getWorkspaceId();
    }

    public ExportRequestProject[] getProjectsInfo() {
        return new ExportRequestProject[]{this.m_projectInfo};
    }
}

