/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.opc;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import org.apache.commons.codec.binary.Base64;
import org.mpxj.MPXJException;
import org.mpxj.ProjectFile;
import org.mpxj.common.InputStreamHelper;
import org.mpxj.opc.ExportRequest;
import org.mpxj.opc.JobStatus;
import org.mpxj.opc.OpcAuthenticationException;
import org.mpxj.opc.OpcException;
import org.mpxj.opc.OpcExportJobTimeoutException;
import org.mpxj.opc.OpcExportType;
import org.mpxj.opc.OpcProject;
import org.mpxj.opc.OpcProjectBaseline;
import org.mpxj.opc.TokenResponse;
import org.mpxj.opc.Workspace;
import org.mpxj.reader.UniversalProjectReader;

public class OpcReader {
    private final String m_host;
    private final String m_user;
    private final String m_password;
    private final ObjectMapper m_mapper;
    private int m_exportPollCount = 15;
    private long m_exportPollInterval = 1000L;
    private TokenResponse m_tokenResponse = TokenResponse.DEFAULT_TOKEN;

    public OpcReader(String host, String user, String password) {
        this.m_host = host;
        this.m_user = user;
        this.m_password = password;
        this.m_mapper = new ObjectMapper();
        this.m_mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public long getExportPollInterval() {
        return this.m_exportPollInterval;
    }

    public void setExportPollInterval(long exportPollInterval) {
        this.m_exportPollInterval = exportPollInterval;
    }

    public int getExportPollCount() {
        return this.m_exportPollCount;
    }

    public void setExportPollCount(int exportPollCount) {
        this.m_exportPollCount = exportPollCount;
    }

    public List<OpcProject> getProjects() {
        this.authenticate();
        return this.getWorkspaces().stream().flatMap(w -> this.getProjectsInWorkspace((Workspace)w).stream()).collect(Collectors.toList());
    }

    public List<OpcProjectBaseline> getProjectBaselines(OpcProject project) {
        this.authenticate();
        HttpURLConnection connection = this.performGetRequest("action/baseline/project/" + project.getProjectId());
        int code = this.getResponseCode(connection);
        if (code == 204) {
            return Collections.emptyList();
        }
        if (code != 200) {
            throw new OpcException(this.getExceptionMessage(connection, code, "List project baselines request failed"));
        }
        return this.readValue(connection, new TypeReference<List<OpcProjectBaseline>>(){});
    }

    public void exportProject(OpcProject project, String filename, OpcExportType type, boolean compressed) throws IOException {
        this.exportProject(project, Collections.emptyList(), filename, type, compressed);
    }

    public void exportProject(OpcProject project, List<OpcProjectBaseline> baselines, String filename, OpcExportType type, boolean compressed) throws IOException {
        try (OutputStream os = Files.newOutputStream(Paths.get(filename, new String[0]), new OpenOption[0]);){
            this.exportProject(project, baselines, os, type, compressed);
        }
    }

    public void exportProject(OpcProject project, File file, OpcExportType type, boolean compressed) throws IOException {
        this.exportProject(project, Collections.emptyList(), file, type, compressed);
    }

    public void exportProject(OpcProject project, List<OpcProjectBaseline> baselines, File file, OpcExportType type, boolean compressed) throws IOException {
        try (OutputStream os = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            this.exportProject(project, baselines, os, type, compressed);
        }
    }

    public void exportProject(OpcProject project, OutputStream stream, OpcExportType type, boolean compressed) throws IOException {
        this.exportProject(project, Collections.emptyList(), stream, type, compressed);
    }

    public void exportProject(OpcProject project, List<OpcProjectBaseline> baselines, OutputStream stream, OpcExportType type, boolean compressed) throws IOException {
        InputStreamHelper.writeInputStreamToOutputStream(this.getInputStreamForProject(project, baselines, type, compressed), stream);
    }

    public ProjectFile readProject(OpcProject project) throws MPXJException {
        return this.readProject(project, Collections.emptyList());
    }

    public ProjectFile readProject(OpcProject project, List<OpcProjectBaseline> baselines) throws MPXJException {
        return new UniversalProjectReader().read(this.getInputStreamForProject(project, baselines, OpcExportType.XML, false));
    }

    private InputStream getInputStreamForProject(OpcProject project, List<OpcProjectBaseline> baselines, OpcExportType type, boolean compressed) {
        this.authenticate();
        long jobId = this.startExportJob(project, baselines, type, compressed);
        this.waitForExportJob(jobId);
        return this.downloadProject(jobId);
    }

    private boolean jobIsComplete(JobStatus status) {
        return status != null && "COMPLETED".equals(status.getJobStatus());
    }

    private long startExportJob(OpcProject project, List<OpcProjectBaseline> baselines, OpcExportType type, boolean compressed) {
        ExportRequest exportRequest;
        String path = type == OpcExportType.XML ? "action/exportP6xml" : "action/exportP6xer";
        HttpURLConnection connection = this.performPostRequest(path, exportRequest = new ExportRequest(project, baselines, compressed));
        int code = this.getResponseCode(connection);
        if (code != 201) {
            throw new OpcException(this.getExceptionMessage(connection, code, "Export project request failed"));
        }
        JobStatus status = this.readValue(connection, JobStatus.class);
        return status.getJobId();
    }

    private void waitForExportJob(long jobId) {
        String path = "action/jobStatus/" + jobId;
        JobStatus jobStatus = null;
        for (long retryCount = 1L; retryCount < (long)this.m_exportPollCount; ++retryCount) {
            try {
                Thread.sleep(retryCount * this.m_exportPollInterval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            HttpURLConnection connection = this.performGetRequest(path);
            int code = this.getResponseCode(connection);
            if (code != 200) {
                throw new OpcException(this.getExceptionMessage(connection, code, "Export job status request failed"));
            }
            jobStatus = this.readValue(connection, JobStatus.class);
            if (this.jobIsComplete(jobStatus)) break;
        }
        if (!this.jobIsComplete(jobStatus)) {
            throw new OpcExportJobTimeoutException();
        }
    }

    private InputStream downloadProject(long jobId) {
        HttpURLConnection connection = this.performGetRequest("action/download/job/" + jobId, "*/*");
        int code = this.getResponseCode(connection);
        if (code != 200) {
            throw new OpcException(this.getExceptionMessage(connection, code, "Export download request failed"));
        }
        return this.getInputStream(connection);
    }

    private List<Workspace> getWorkspaces() {
        HttpURLConnection connection = this.performGetRequest("workspace");
        int code = this.getResponseCode(connection);
        if (code == 204) {
            return Collections.emptyList();
        }
        if (code != 200) {
            throw new OpcException(this.getExceptionMessage(connection, code, "List workspaces request failed"));
        }
        return this.readValue(connection, new TypeReference<List<Workspace>>(){});
    }

    private List<OpcProject> getProjectsInWorkspace(Workspace workspace) {
        HttpURLConnection connection = this.performGetRequest("project/workspace/" + workspace.getWorkspaceId());
        int code = this.getResponseCode(connection);
        if (code == 204) {
            return Collections.emptyList();
        }
        if (code != 200) {
            throw new OpcException(this.getExceptionMessage(connection, code, "List projects in workspace request failed"));
        }
        return this.readValue(connection, new TypeReference<List<OpcProject>>(){});
    }

    private void authenticate() {
        if (this.m_tokenResponse.valid()) {
            return;
        }
        try {
            URL url = new URL("https://" + this.m_host + "/primediscovery/apitoken/request?scope=http://" + this.m_host + "/api");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Accept", "application/json");
            connection.setRequestProperty("Accept-Encoding", "gzip");
            String auth = this.m_user + ":" + this.m_password;
            byte[] encodedAuth = Base64.encodeBase64((byte[])auth.getBytes(StandardCharsets.UTF_8));
            String authHeaderValue = "Basic " + new String(encodedAuth);
            connection.setRequestProperty("Authorization", authHeaderValue);
            connection.connect();
            int code = connection.getResponseCode();
            if (code != 200) {
                throw new OpcAuthenticationException(this.getExceptionMessage(connection, code, "Authentication request failed"));
            }
            this.m_tokenResponse = (TokenResponse)this.m_mapper.readValue(this.getInputStream(connection), TokenResponse.class);
        }
        catch (Exception ex) {
            throw new OpcAuthenticationException(ex);
        }
    }

    private HttpURLConnection performGetRequest(String path) {
        return this.performGetRequest(path, "application/json");
    }

    private HttpURLConnection performGetRequest(String path, String accept) {
        try {
            HttpURLConnection connection = this.createConnection(path, accept);
            connection.setRequestMethod("GET");
            connection.connect();
            return connection;
        }
        catch (IOException ex) {
            throw new OpcException(ex);
        }
    }

    private HttpURLConnection performPostRequest(String path, Object body) {
        try {
            HttpURLConnection connection = this.createConnection(path, "application/json");
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setDoOutput(true);
            this.m_mapper.writeValue(connection.getOutputStream(), body);
            connection.connect();
            return connection;
        }
        catch (IOException ex) {
            throw new OpcException(ex);
        }
    }

    private HttpURLConnection createConnection(String path, String accept) throws IOException {
        URL url = new URL("https://" + this.m_host + "/api/restapi/" + path);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Accept", accept);
        connection.setRequestProperty("Accept-Encoding", "gzip");
        connection.setRequestProperty("Version", "3");
        connection.setRequestProperty("Authorization", "Bearer " + this.m_tokenResponse.getAccessToken());
        this.m_tokenResponse.getRequestHeaders().forEach(connection::setRequestProperty);
        return connection;
    }

    private InputStream getInputStream(HttpURLConnection connection) {
        try {
            if ("gzip".equals(connection.getContentEncoding())) {
                return new GZIPInputStream(connection.getInputStream());
            }
            return connection.getInputStream();
        }
        catch (IOException ex) {
            throw new OpcException(ex);
        }
    }

    private int getResponseCode(HttpURLConnection connection) {
        try {
            return connection.getResponseCode();
        }
        catch (IOException ex) {
            throw new OpcException(ex);
        }
    }

    private <T> T readValue(HttpURLConnection connection, TypeReference<T> valueTypeRef) {
        try {
            return (T)this.m_mapper.readValue(this.getInputStream(connection), valueTypeRef);
        }
        catch (IOException ex) {
            throw new OpcException(ex);
        }
    }

    private <T> T readValue(HttpURLConnection connection, Class<T> clazz) {
        try {
            return (T)this.m_mapper.readValue(this.getInputStream(connection), clazz);
        }
        catch (IOException ex) {
            throw new OpcException(ex);
        }
    }

    private String getExceptionMessage(HttpURLConnection connection, int code, String message) {
        String responseBody = "";
        try {
            InputStream stream = connection.getErrorStream();
            if (stream == null) {
                stream = connection.getInputStream();
            }
            try (BufferedReader br = new BufferedReader(new InputStreamReader(stream));){
                responseBody = br.lines().collect(Collectors.joining(System.lineSeparator()));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return message + "\nresponseCode=" + code + "\nresponseBody=" + responseBody;
    }
}

