/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.openplan;

import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.mpxj.openplan.OpenPlanException;

abstract class AbstractReader {
    private final InputStream m_is;

    public AbstractReader(DirectoryEntry dir, String name) {
        try {
            this.m_is = new DocumentInputStream((DocumentEntry)dir.getEntry(name));
        }
        catch (IOException e) {
            throw new OpenPlanException(e);
        }
    }

    protected int getInt() {
        try {
            int result = 0;
            for (int shiftBy = 0; shiftBy < 32; shiftBy += 8) {
                result |= (this.m_is.read() & 0xFF) << shiftBy;
            }
            return result;
        }
        catch (IOException ex) {
            throw new OpenPlanException(ex);
        }
    }

    protected int getShort() {
        try {
            int result = 0;
            for (int shiftBy = 0; shiftBy < 16; shiftBy += 8) {
                result |= (this.m_is.read() & 0xFF) << shiftBy;
            }
            return result;
        }
        catch (IOException ex) {
            throw new OpenPlanException(ex);
        }
    }

    protected int getByte() {
        try {
            return this.m_is.read();
        }
        catch (IOException ex) {
            throw new OpenPlanException(ex);
        }
    }

    protected String getString() {
        try {
            byte[] bytes;
            int length = this.getByte();
            if (length <= 0) {
                return null;
            }
            if (length == 255) {
                length = this.getShort();
            }
            if (this.m_is.read(bytes = new byte[length]) != length) {
                throw new OpenPlanException("Failed to read expected number of bytes");
            }
            return new String(bytes);
        }
        catch (IOException ex) {
            throw new OpenPlanException(ex);
        }
    }
}

