/*
 * Decompiled with CFR 0.152.
 */
package org.mpxj.openplan;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.mpxj.ActivityCode;
import org.mpxj.ActivityCodeValue;
import org.mpxj.ProjectFile;
import org.mpxj.openplan.Code;
import org.mpxj.openplan.CodeValue;
import org.mpxj.openplan.Row;
import org.mpxj.openplan.TableReader;

class ActivityCodeReader {
    private final ProjectFile m_file;
    private final DirectoryEntry m_root;
    private final Map<String, Map<String, ActivityCodeValue>> m_codeMap = new HashMap<String, Map<String, ActivityCodeValue>>();

    public ActivityCodeReader(DirectoryEntry root, ProjectFile file) {
        this.m_root = root;
        this.m_file = file;
    }

    public void read(Map<String, Code> map) {
        int codeSequence = 1;
        List<Row> rows = new TableReader(this.m_root, "SCA").read();
        for (Row row : rows) {
            Code code;
            if (!"ACT".equals(row.getString("TABLE_TYPE")) || (code = map.get(row.getString("COD_ID"))) == null) continue;
            ActivityCode ac = new ActivityCode.Builder(this.m_file).name(code.getPromptText()).sequenceNumber(codeSequence++).build();
            HashMap<String, ActivityCodeValue> valueMap = new HashMap<String, ActivityCodeValue>();
            int valueSequence = 1;
            for (CodeValue value : code.getValues()) {
                ActivityCodeValue acv = new ActivityCodeValue.Builder(this.m_file).activityCode(ac).name(value.getID()).description(value.getDescription()).sequenceNumber(valueSequence++).build();
                ac.addValue(acv);
                valueMap.put(value.getUniqueID(), acv);
            }
            this.m_codeMap.put(row.getString("SCA_ID"), valueMap);
            this.m_file.getActivityCodes().add(ac);
        }
    }

    public Map<String, Map<String, ActivityCodeValue>> getCodeMap() {
        return this.m_codeMap;
    }
}

